/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;
import com.android.internal.widget.EditableInputConnection;
import java.util.ArrayList;

public class WebTextView
extends AutoCompleteTextView {
    public static final String LOGTAG = "webtextview";
    public WebView mWebView;
    public boolean mSingle;
    public int mWidthSpec;
    public int mHeightSpec;
    public int mNodePointer;
    public boolean mGotEnterDown;
    public int mMaxLength;
    public String mPreChange;
    public Drawable mBackground;
    public float mDragStartX;
    public float mDragStartY;
    public long mDragStartTime;
    public boolean mDragSent;
    public boolean mScrolled;
    public boolean mFromWebKit;
    public boolean mFromFocusChange;
    public boolean mFromSetInputType;
    public boolean mGotTouchDown;
    public boolean mHasPerformedLongClick;
    public boolean mInSetTextAndKeepSelection;
    public char[] mCharacter = new char[1];
    public static final InputFilter[] NO_FILTERS = new InputFilter[0];

    public WebTextView(Context context, WebView webView) {
        super(context, null, 16843449);
        this.mWebView = webView;
        this.mMaxLength = -1;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.isSystem()) {
            return super.dispatchKeyEvent(event);
        }
        boolean down = event.getAction() != 1;
        int keyCode = event.getKeyCode();
        boolean isArrowKey = false;
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                if (!this.mWebView.nativeCursorMatchesFocus()) {
                    return down ? this.mWebView.onKeyDown(keyCode, event) : this.mWebView.onKeyUp(keyCode, event);
                }
                isArrowKey = true;
            }
        }
        if (61 == keyCode) {
            if (down) {
                this.onEditorAction(5);
            }
            return true;
        }
        Editable text = this.getText();
        int oldLength = text.length();
        if (67 == keyCode && 0 == oldLength) {
            this.sendDomEvent(event);
            return true;
        }
        if (this.mSingle && 66 == keyCode) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(event);
            }
            if (!down) {
                InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.sendDomEvent(new KeyEvent(0, keyCode));
                this.sendDomEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }
        if (23 == keyCode) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(event);
            }
            if (!this.mWebView.nativeCursorMatchesFocus()) {
                return down ? this.mWebView.onKeyDown(keyCode, event) : this.mWebView.onKeyUp(keyCode, event);
            }
            if (!down) {
                this.mWebView.centerKeyPressOnTextField();
            }
            return super.dispatchKeyEvent(event);
        }
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
        }
        int oldStart = Selection.getSelectionStart(text);
        int oldEnd = Selection.getSelectionEnd(text);
        boolean maxedOut = this.mMaxLength != -1 && oldLength == this.mMaxLength;
        String oldText = maxedOut && oldEnd != oldStart ? text.toString() : "";
        if (super.dispatchKeyEvent(event)) {
            if (66 == keyCode) {
                this.mGotEnterDown = true;
            }
            if (maxedOut && !isArrowKey && keyCode != 67) {
                if (oldEnd == oldStart) {
                    return true;
                }
                if (!oldText.equals(this.getText().toString())) {
                    Editable span = this.getText();
                    int newStart = Selection.getSelectionStart(span);
                    int newEnd = Selection.getSelectionEnd(span);
                    this.mWebView.replaceTextfieldText(0, oldLength, span.toString(), newStart, newEnd);
                    return true;
                }
            }
            return true;
        }
        if (this.mGotEnterDown && !down) {
            return true;
        }
        if (isArrowKey) {
            this.mWebView.resetTrackballTime();
            return down ? this.mWebView.onKeyDown(keyCode, event) : this.mWebView.onKeyUp(keyCode, event);
        }
        return false;
    }

    public boolean isSameTextField(int ptr) {
        return ptr == this.mNodePointer;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection connection = super.onCreateInputConnection(outAttrs);
        if (this.mWebView != null) {
            outAttrs.fieldName = this.mWebView.nativeFocusCandidateName() + "\\" + this.mWebView.getUrl();
        }
        return connection;
    }

    public void onDraw(Canvas canvas) {
        if (this.mWebView == null || !this.mWebView.nativeFocusCandidateIsPassword() || !this.isSameTextField(this.mWebView.nativeFocusCandidatePointer())) {
            this.setInPassword(false);
        } else {
            super.onDraw(canvas);
        }
    }

    public void onEditorAction(int actionCode) {
        switch (actionCode) {
            case 5: {
                if (!this.mWebView.nativeMoveCursorToNextTextInput()) break;
                this.mWebView.setFocusControllerInactive();
                this.mWebView.rebuildWebTextView();
                this.setDefaultSelection();
                this.mWebView.invalidate();
                break;
            }
            case 6: {
                super.onEditorAction(actionCode);
                break;
            }
            case 2: 
            case 3: {
                InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.sendDomEvent(new KeyEvent(0, 66));
                this.sendDomEvent(new KeyEvent(1, 66));
            }
        }
    }

    public void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        this.mFromFocusChange = true;
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        this.mFromFocusChange = false;
    }

    public void onSelectionChanged(int selStart, int selEnd) {
        if (this.mInSetTextAndKeepSelection) {
            return;
        }
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null && imm.isActive(this)) {
            Editable sp = this.getText();
            int candStart = EditableInputConnection.getComposingSpanStart(sp);
            int candEnd = EditableInputConnection.getComposingSpanEnd(sp);
            imm.updateSelection(this, selStart, selEnd, candStart, candEnd);
        }
        if (!(this.mFromWebKit || this.mFromFocusChange || this.mFromSetInputType || this.mWebView == null)) {
            this.mWebView.setSelection(selStart, selEnd);
        }
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        int charactersFromKeyEvents;
        super.onTextChanged(s, start, before, count);
        String postChange = ((Object)s).toString();
        if (this.mPreChange == null || this.mPreChange.equals(postChange) || this.mMaxLength > -1 && this.mPreChange.length() > this.mMaxLength && this.mPreChange.substring(0, this.mMaxLength).equals(postChange)) {
            return;
        }
        this.mPreChange = postChange;
        if (0 == count) {
            if (before > 0) {
                this.mWebView.deleteSelection(start, start + before);
                this.updateCachedTextfield();
            }
            return;
        }
        TextUtils.getChars(s, start + count - 1, start + count, this.mCharacter, 0);
        KeyCharacterMap kmap = KeyCharacterMap.load(0);
        KeyEvent[] events = kmap.getEvents(this.mCharacter);
        boolean cannotUseKeyEvents = null == events;
        int n = charactersFromKeyEvents = cannotUseKeyEvents ? 0 : 1;
        if (count > 1 || cannotUseKeyEvents) {
            String replace = ((Object)s.subSequence(start, start + count - charactersFromKeyEvents)).toString();
            this.mWebView.replaceTextfieldText(start, start + before, replace, start + count - charactersFromKeyEvents, start + count - charactersFromKeyEvents);
        } else if (!this.mInSetTextAndKeepSelection) {
            this.mWebView.setSelection(start, start + before);
        }
        if (!cannotUseKeyEvents) {
            int length = events.length;
            for (int i = 0; i < length; ++i) {
                if (KeyEvent.isModifierKey(events[i].getKeyCode())) continue;
                this.sendDomEvent(events[i]);
            }
        }
        this.updateCachedTextfield();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                super.onTouchEvent(event);
                this.mDragStartX = event.getX();
                this.mDragStartY = event.getY();
                this.mDragStartTime = event.getEventTime();
                this.mDragSent = false;
                this.mScrolled = false;
                this.mGotTouchDown = true;
                this.mHasPerformedLongClick = false;
                break;
            }
            case 2: {
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                int slop = ViewConfiguration.get(this.mContext).getScaledTouchSlop();
                Editable buffer = this.getText();
                int initialScrollX = Touch.getInitialScrollX(this, buffer);
                int initialScrollY = Touch.getInitialScrollY(this, buffer);
                super.onTouchEvent(event);
                int dx = Math.abs(this.mScrollX - initialScrollX);
                int dy = Math.abs(this.mScrollY - initialScrollY);
                int smallerSlop = slop / 2;
                if (dx > smallerSlop || dy > smallerSlop) {
                    if (this.mWebView != null) {
                        float maxScrollX = Touch.getMaxScrollX(this, this.getLayout(), this.mScrollY);
                        this.mWebView.scrollFocusedTextInput(maxScrollX > 0.0f ? (float)this.mScrollX / maxScrollX : 0.0f, this.mScrollY);
                    }
                    this.mScrolled = true;
                    this.cancelLongPress();
                    return true;
                }
                if (Math.abs((float)((int)event.getX()) - this.mDragStartX) < (float)slop && Math.abs((float)((int)event.getY()) - this.mDragStartY) < (float)slop) {
                    return true;
                }
                if (this.mWebView != null) {
                    boolean scrolled;
                    if (!this.mDragSent) {
                        this.mWebView.initiateTextFieldDrag(this.mDragStartX, this.mDragStartY, this.mDragStartTime);
                        this.mDragSent = true;
                    }
                    if (scrolled = this.mWebView.textFieldDrag(event)) {
                        this.mScrolled = true;
                        this.cancelLongPress();
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 3: {
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                if (!this.mScrolled) {
                    this.cancelLongPress();
                    if (this.mGotTouchDown && this.mWebView != null) {
                        this.mWebView.touchUpOnTextField(event);
                    }
                }
                if (this.mWebView != null && this.mDragSent) {
                    this.mWebView.onTouchEvent(event);
                }
                this.mGotTouchDown = false;
                break;
            }
        }
        return true;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.isPopupShowing()) {
            return super.onTrackballEvent(event);
        }
        if (event.getAction() != 2) {
            return false;
        }
        if (!this.mWebView.nativeCursorMatchesFocus()) {
            return this.mWebView.onTrackballEvent(event);
        }
        Editable text = this.getText();
        MovementMethod move = this.getMovementMethod();
        return move != null && this.getLayout() != null && move.onTrackballEvent(this, text, event);
    }

    public boolean performLongClick() {
        this.mHasPerformedLongClick = true;
        return super.performLongClick();
    }

    public void remove() {
        InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
        this.mWebView.removeView(this);
        this.mWebView.requestFocus();
    }

    public void bringIntoView() {
        if (this.getLayout() != null) {
            this.bringPointIntoView(Selection.getSelectionEnd(this.getText()));
        }
    }

    public void sendDomEvent(KeyEvent event) {
        this.mWebView.passToJavaScript(this.getText().toString(), event);
    }

    public void setAdapterCustom(AutoCompleteAdapter adapter) {
        if (adapter != null) {
            this.setInputType(this.getInputType() | 0x10000);
            adapter.setTextView(this);
        }
        super.setAdapter(adapter);
    }

    public void setDefaultSelection() {
        int selection;
        Editable text = this.getText();
        int n = selection = this.mSingle ? text.length() : 0;
        if (Selection.getSelectionStart(text) == selection && Selection.getSelectionEnd(text) == selection) {
            if (this.mWebView != null) {
                this.mWebView.setSelection(selection, selection);
            }
        } else {
            Selection.setSelection(text, selection, selection);
        }
    }

    public void setInPassword(boolean inPassword) {
        if (inPassword) {
            this.setInputType(129);
            this.createBackground();
        }
        this.setWillNotDraw(!inPassword);
        this.setBackgroundDrawable(inPassword ? this.mBackground : null);
        this.setCursorVisible(inPassword);
    }

    public void createBackground() {
        if (this.mBackground != null) {
            return;
        }
        this.mBackground = new OutlineDrawable(null);
        this.setGravity(16);
        TextPaint paint = this.getPaint();
        int flags = paint.getFlags() | 0x80 | 1;
        paint.setFlags(flags);
        this.setTextColor(-16777216);
    }

    public void setInputType(int type) {
        this.mFromSetInputType = true;
        super.setInputType(type);
        this.mFromSetInputType = false;
    }

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
        if (-1 == maxLength) {
            this.setFilters(NO_FILTERS);
        } else {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        }
    }

    public void setNodePointer(int ptr) {
        this.mNodePointer = ptr;
    }

    public void setRect(int x, int y, int width, int height) {
        AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)this.getLayoutParams();
        if (null == lp) {
            lp = new AbsoluteLayout.LayoutParams(width, height, x, y);
        } else {
            lp.x = x;
            lp.y = y;
            lp.width = width;
            lp.height = height;
        }
        if (this.getParent() == null) {
            this.mWebView.addView(this, lp);
        } else {
            this.setLayoutParams(lp);
        }
        this.mWidthSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        this.mHeightSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
    }

    public void setSelectionFromWebKit(int start, int end) {
        if (start < 0 || end < 0) {
            return;
        }
        Editable text = this.getText();
        int length = text.length();
        if (start > length || end > length) {
            return;
        }
        this.mFromWebKit = true;
        Selection.setSelection(text, start, end);
        this.mFromWebKit = false;
    }

    public void setTextAndKeepSelection(String text) {
        this.mPreChange = text.toString();
        Editable edit = this.getText();
        int selStart = Selection.getSelectionStart(edit);
        int selEnd = Selection.getSelectionEnd(edit);
        this.mInSetTextAndKeepSelection = true;
        edit.replace(0, edit.length(), text);
        int newLength = edit.length();
        if (selStart > newLength) {
            selStart = newLength;
        }
        if (selEnd > newLength) {
            selEnd = newLength;
        }
        Selection.setSelection(edit, selStart, selEnd);
        this.mInSetTextAndKeepSelection = false;
        this.updateCachedTextfield();
    }

    public void setType(int type) {
        if (this.mWebView == null) {
            return;
        }
        boolean single = true;
        boolean inPassword = false;
        int maxLength = -1;
        int inputType = 1;
        if (this.mWebView.nativeFocusCandidateHasNextTextfield()) {
            inputType |= 0xA0;
        }
        int imeOptions = -1879048192;
        switch (type) {
            case 0: {
                imeOptions |= 2;
                break;
            }
            case 1: {
                single = false;
                inputType = 180225;
                imeOptions |= 1;
                break;
            }
            case 2: {
                inPassword = true;
                imeOptions |= 2;
                break;
            }
            case 3: {
                imeOptions |= 3;
                break;
            }
            case 4: {
                imeOptions |= 2;
                break;
            }
            case 5: {
                inputType |= 2;
                imeOptions |= 5;
                break;
            }
            case 6: {
                inputType |= 3;
                imeOptions |= 5;
                break;
            }
            case 7: {
                imeOptions |= 2;
                break;
            }
            default: {
                imeOptions |= 2;
            }
        }
        this.setHint(null);
        if (single) {
            String name;
            this.mWebView.requestLabel(this.mWebView.nativeFocusCandidateFramePointer(), this.mNodePointer);
            maxLength = this.mWebView.nativeFocusCandidateMaxLength();
            if (type != 2 && (name = this.mWebView.nativeFocusCandidateName()) != null && name.length() > 0) {
                this.mWebView.requestFormData(name, this.mNodePointer);
            }
        }
        this.mSingle = single;
        this.setMaxLength(maxLength);
        this.setHorizontallyScrolling(single);
        this.setInputType(inputType);
        this.setImeOptions(imeOptions);
        this.setInPassword(inPassword);
        AutoCompleteAdapter adapter = null;
        this.setAdapterCustom(adapter);
    }

    public void updateCachedTextfield() {
        this.mWebView.updateCachedTextfield(this.getText().toString());
    }

    public boolean requestRectangleOnScreen(Rect rectangle) {
        if (!this.mWebView.inAnimateZoom()) {
            return super.requestRectangleOnScreen(rectangle);
        }
        return false;
    }

    public static class 1 {
    }

    public static class OutlineDrawable
    extends Drawable {
        public OutlineDrawable() {
        }

        public void draw(Canvas canvas) {
            Rect bounds = this.getBounds();
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(-1);
            canvas.drawRect(bounds, paint);
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(-16777216);
            canvas.drawRect(bounds, paint);
        }

        public int getOpacity() {
            return -1;
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public /* synthetic */ OutlineDrawable(1 x0) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutoCompleteAdapter
    extends ArrayAdapter<String> {
        public TextView mTextView;

        public AutoCompleteAdapter(Context context, ArrayList<String> entries) {
            super(context, 17367131, entries);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView tv = (TextView)super.getView(position, convertView, parent);
            if (tv != null && this.mTextView != null) {
                tv.setTextSize(this.mTextView.getTextSize());
            }
            return tv;
        }

        public void setTextView(TextView tv) {
            this.mTextView = tv;
        }
    }
}

