/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.RemoteViews;
import android.widget.TextView;
import java.text.SimpleDateFormat;
import java.util.Date;

@RemoteViews.RemoteView
public class DateTimeView
extends TextView {
    public static final String TAG = "DateTimeView";
    public static final long TWELVE_HOURS_IN_MINUTES = 720L;
    public static final long TWENTY_FOUR_HOURS_IN_MILLIS = 86400000L;
    public static final int SHOW_TIME = 0;
    public static final int SHOW_MONTH_DAY_YEAR = 1;
    public Date mTime;
    public long mTimeMillis;
    public int mLastDisplay = -1;
    public java.text.DateFormat mLastFormat;
    public boolean mAttachedToWindow;
    public long mUpdateTimeMillis;
    public BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.TIME_TICK".equals(action) && System.currentTimeMillis() < DateTimeView.this.mUpdateTimeMillis) {
                return;
            }
            DateTimeView.this.mLastFormat = null;
            DateTimeView.this.update();
        }
    };
    public ContentObserver mContentObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            DateTimeView.this.mLastFormat = null;
            DateTimeView.this.update();
        }
    };

    public DateTimeView(Context context) {
        super(context);
    }

    public DateTimeView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onAttachedToWindow() {
        super.onDetachedFromWindow();
        this.registerReceivers();
        this.mAttachedToWindow = true;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unregisterReceivers();
        this.mAttachedToWindow = false;
    }

    @RemotableViewMethod
    public void setTime(long time) {
        Time t = new Time();
        t.set(time);
        t.second = 0;
        this.mTimeMillis = t.toMillis(false);
        this.mTime = new Date(t.year - 1900, t.month, t.monthDay, t.hour, t.minute, 0);
        this.update();
    }

    public void update() {
        java.text.DateFormat format;
        if (this.mTime == null) {
            return;
        }
        long start = System.nanoTime();
        Date time = this.mTime;
        Time t = new Time();
        t.set(this.mTimeMillis);
        t.second = 0;
        t.hour -= 12;
        long twelveHoursBefore = t.toMillis(false);
        t.hour += 12;
        long twelveHoursAfter = t.toMillis(false);
        t.hour = 0;
        t.minute = 0;
        long midnightBefore = t.toMillis(false);
        ++t.monthDay;
        long midnightAfter = t.toMillis(false);
        long nowMillis = System.currentTimeMillis();
        t.set(nowMillis);
        t.second = 0;
        nowMillis = t.normalize(false);
        int display = nowMillis >= midnightBefore && nowMillis < midnightAfter || nowMillis >= twelveHoursBefore && nowMillis < twelveHoursAfter ? 0 : 1;
        if (display == this.mLastDisplay && this.mLastFormat != null) {
            format = this.mLastFormat;
        } else {
            switch (display) {
                case 0: {
                    format = this.getTimeFormat();
                    break;
                }
                case 1: {
                    format = this.getDateFormat();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown display value: " + display);
                }
            }
            this.mLastFormat = format;
        }
        String text = format.format(this.mTime);
        this.setText(text);
        this.mUpdateTimeMillis = display == 0 ? (twelveHoursAfter > midnightAfter ? twelveHoursAfter : midnightAfter) : (this.mTimeMillis < nowMillis ? 0L : (twelveHoursBefore < midnightBefore ? twelveHoursBefore : midnightBefore));
        long finish = System.nanoTime();
    }

    public java.text.DateFormat getTimeFormat() {
        Context context = this.getContext();
        int res = DateFormat.is24HourFormat(context) ? 17039472 : 17039471;
        String format = context.getString(res);
        return new SimpleDateFormat(format);
    }

    public java.text.DateFormat getDateFormat() {
        String format = Settings.System.getString(this.getContext().getContentResolver(), "date_format");
        if (format == null || "".equals(format)) {
            return java.text.DateFormat.getDateInstance(3);
        }
        try {
            return new SimpleDateFormat(format);
        }
        catch (IllegalArgumentException e) {
            return java.text.DateFormat.getDateInstance(3);
        }
    }

    public void registerReceivers() {
        Context context = this.getContext();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.TIME_TICK");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        context.registerReceiver(this.mBroadcastReceiver, filter);
        Uri uri = Settings.System.getUriFor("date_format");
        context.getContentResolver().registerContentObserver(uri, true, this.mContentObserver);
    }

    public void unregisterReceivers() {
        Context context = this.getContext();
        context.unregisterReceiver(this.mBroadcastReceiver);
        context.getContentResolver().unregisterContentObserver(this.mContentObserver);
    }
}

