/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class LinearLayout
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    @ViewDebug.ExportedProperty
    public boolean mBaselineAligned = true;
    @ViewDebug.ExportedProperty
    public int mBaselineAlignedChildIndex = -1;
    @ViewDebug.ExportedProperty
    public int mBaselineChildTop = 0;
    @ViewDebug.ExportedProperty
    public int mOrientation;
    @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=-1, to="NONE"), @ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=48, to="TOP"), @ViewDebug.IntToString(from=80, to="BOTTOM"), @ViewDebug.IntToString(from=3, to="LEFT"), @ViewDebug.IntToString(from=5, to="RIGHT"), @ViewDebug.IntToString(from=16, to="CENTER_VERTICAL"), @ViewDebug.IntToString(from=112, to="FILL_VERTICAL"), @ViewDebug.IntToString(from=1, to="CENTER_HORIZONTAL"), @ViewDebug.IntToString(from=7, to="FILL_HORIZONTAL"), @ViewDebug.IntToString(from=17, to="CENTER"), @ViewDebug.IntToString(from=119, to="FILL")})
    public int mGravity = 51;
    @ViewDebug.ExportedProperty
    public int mTotalLength;
    @ViewDebug.ExportedProperty
    public float mWeightSum;
    @ViewDebug.ExportedProperty
    public boolean mUseLargestChild;
    public int[] mMaxAscent;
    public int[] mMaxDescent;
    public static final int VERTICAL_GRAVITY_COUNT = 4;
    public static final int INDEX_CENTER_VERTICAL = 0;
    public static final int INDEX_TOP = 1;
    public static final int INDEX_BOTTOM = 2;
    public static final int INDEX_FILL = 3;

    public LinearLayout(Context context) {
        super(context);
    }

    public LinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        boolean baselineAligned;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LinearLayout);
        int index = a.getInt(1, -1);
        if (index >= 0) {
            this.setOrientation(index);
        }
        if ((index = a.getInt(0, -1)) >= 0) {
            this.setGravity(index);
        }
        if (!(baselineAligned = a.getBoolean(2, true))) {
            this.setBaselineAligned(baselineAligned);
        }
        this.mWeightSum = a.getFloat(4, -1.0f);
        this.mBaselineAlignedChildIndex = a.getInt(3, -1);
        this.mUseLargestChild = a.getBoolean(5, false);
        a.recycle();
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    @RemotableViewMethod
    public void setBaselineAligned(boolean baselineAligned) {
        this.mBaselineAligned = baselineAligned;
    }

    public int getBaseline() {
        int majorGravity;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        if (this.getChildCount() <= this.mBaselineAlignedChildIndex) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        View child = this.getChildAt(this.mBaselineAlignedChildIndex);
        int childBaseline = child.getBaseline();
        if (childBaseline == -1) {
            if (this.mBaselineAlignedChildIndex == 0) {
                return -1;
            }
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
        }
        int childTop = this.mBaselineChildTop;
        if (this.mOrientation == 1 && (majorGravity = this.mGravity & 0x70) != 48) {
            switch (majorGravity) {
                case 80: {
                    childTop = this.mBottom - this.mTop - this.mPaddingBottom - this.mTotalLength;
                    break;
                }
                case 16: {
                    childTop += (this.mBottom - this.mTop - this.mPaddingTop - this.mPaddingBottom - this.mTotalLength) / 2;
                }
            }
        }
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return childTop + lp.topMargin + childBaseline;
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    @RemotableViewMethod
    public void setBaselineAlignedChildIndex(int i) {
        if (i < 0 || i >= this.getChildCount()) {
            throw new IllegalArgumentException("base aligned child index out of range (0, " + this.getChildCount() + ")");
        }
        this.mBaselineAlignedChildIndex = i;
    }

    public View getVirtualChildAt(int index) {
        return this.getChildAt(index);
    }

    public int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    @RemotableViewMethod
    public void setWeightSum(float weightSum) {
        this.mWeightSum = Math.max(0.0f, weightSum);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOrientation == 1) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int totalLength;
        LayoutParams lp;
        View child;
        int i;
        this.mTotalLength = 0;
        int maxWidth = 0;
        int alternativeMaxWidth = 0;
        int weightedMaxWidth = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean matchWidth = false;
        int baselineChildIndex = this.mBaselineAlignedChildIndex;
        boolean useLargestChild = this.mUseLargestChild;
        int largestChildHeight = Integer.MIN_VALUE;
        for (i = 0; i < count; ++i) {
            child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            if (heightMode == 0x40000000 && lp.height == 0 && lp.weight > 0.0f) {
                totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + lp.topMargin + lp.bottomMargin);
            } else {
                int oldHeight = Integer.MIN_VALUE;
                if (lp.height == 0 && lp.weight > 0.0f) {
                    oldHeight = 0;
                    lp.height = -2;
                }
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, 0, heightMeasureSpec, totalWeight == 0.0f ? this.mTotalLength : 0);
                if (oldHeight != Integer.MIN_VALUE) {
                    lp.height = oldHeight;
                }
                int childHeight = child.getMeasuredHeight();
                int totalLength2 = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength2, totalLength2 + childHeight + lp.topMargin + lp.bottomMargin + this.getNextLocationOffset(child));
                if (useLargestChild) {
                    largestChildHeight = Math.max(childHeight, largestChildHeight);
                }
            }
            if (baselineChildIndex >= 0 && baselineChildIndex == i + 1) {
                this.mBaselineChildTop = this.mTotalLength;
            }
            if (i < baselineChildIndex && lp.weight > 0.0f) {
                throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
            }
            boolean matchWidthLocally = false;
            if (widthMode != 0x40000000 && lp.width == -1) {
                matchWidth = true;
                matchWidthLocally = true;
            }
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            boolean bl = allFillParent = allFillParent && lp.width == -1;
            if (lp.weight > 0.0f) {
                weightedMaxWidth = Math.max(weightedMaxWidth, matchWidthLocally ? margin : measuredWidth);
            } else {
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (useLargestChild && heightMode == Integer.MIN_VALUE) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LayoutParams)child.getLayoutParams();
                totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildHeight + lp.topMargin + lp.bottomMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.mPaddingTop + this.mPaddingBottom;
        int heightSize = this.mTotalLength;
        heightSize = Math.max(heightSize, this.getSuggestedMinimumHeight());
        int delta = (heightSize = LinearLayout.resolveSize(heightSize, heightMeasureSpec)) - this.mTotalLength;
        if (delta != 0 && totalWeight > 0.0f) {
            float weightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                View child2 = this.getVirtualChildAt(i2);
                if (child2.getVisibility() == 8) continue;
                LayoutParams lp2 = (LayoutParams)child2.getLayoutParams();
                float childExtra = lp2.weight;
                if (childExtra > 0.0f) {
                    int share = (int)(childExtra * (float)delta / weightSum);
                    weightSum -= childExtra;
                    delta -= share;
                    int childWidthMeasureSpec = LinearLayout.getChildMeasureSpec(widthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp2.leftMargin + lp2.rightMargin, lp2.width);
                    if (lp2.height != 0 || heightMode != 0x40000000) {
                        int childHeight = child2.getMeasuredHeight() + share;
                        if (childHeight < 0) {
                            childHeight = 0;
                        }
                        child2.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec(childHeight, 0x40000000));
                    } else {
                        child2.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec(share > 0 ? share : 0, 0x40000000));
                    }
                }
                int margin = lp2.leftMargin + lp2.rightMargin;
                int measuredWidth = child2.getMeasuredWidth() + margin;
                maxWidth = Math.max(maxWidth, measuredWidth);
                boolean matchWidthLocally = widthMode != 0x40000000 && lp2.width == -1;
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
                allFillParent = allFillParent && lp2.width == -1;
                int totalLength3 = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength3, totalLength3 + child2.getMeasuredHeight() + lp2.topMargin + lp2.bottomMargin + this.getNextLocationOffset(child2));
            }
            this.mTotalLength += this.mPaddingTop + this.mPaddingBottom;
        } else {
            alternativeMaxWidth = Math.max(alternativeMaxWidth, weightedMaxWidth);
        }
        if (!allFillParent && widthMode != 0x40000000) {
            maxWidth = alternativeMaxWidth;
        }
        maxWidth += this.mPaddingLeft + this.mPaddingRight;
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(LinearLayout.resolveSize(maxWidth, widthMeasureSpec), heightSize);
        if (matchWidth) {
            this.forceUniformWidth(count, heightMeasureSpec);
        }
    }

    public void forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    public void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int totalLength;
        LayoutParams lp;
        int i;
        this.mTotalLength = 0;
        int maxHeight = 0;
        int alternativeMaxHeight = 0;
        int weightedMaxHeight = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean matchHeight = false;
        if (this.mMaxAscent == null || this.mMaxDescent == null) {
            this.mMaxAscent = new int[4];
            this.mMaxDescent = new int[4];
        }
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        maxAscent[3] = -1;
        maxAscent[2] = -1;
        maxAscent[1] = -1;
        maxAscent[0] = -1;
        maxDescent[3] = -1;
        maxDescent[2] = -1;
        maxDescent[1] = -1;
        maxDescent[0] = -1;
        boolean baselineAligned = this.mBaselineAligned;
        boolean useLargestChild = this.mUseLargestChild;
        boolean isExactly = widthMode == 0x40000000;
        int largestChildWidth = Integer.MIN_VALUE;
        for (i = 0; i < count; ++i) {
            int childBaseline;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            if (widthMode == 0x40000000 && lp.width == 0 && lp.weight > 0.0f) {
                if (isExactly) {
                    this.mTotalLength += lp.leftMargin + lp.rightMargin;
                } else {
                    totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + lp.leftMargin + lp.rightMargin);
                }
                if (baselineAligned) {
                    int freeSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
                    child.measure(freeSpec, freeSpec);
                }
            } else {
                int oldWidth = Integer.MIN_VALUE;
                if (lp.width == 0 && lp.weight > 0.0f) {
                    oldWidth = 0;
                    lp.width = -2;
                }
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, totalWeight == 0.0f ? this.mTotalLength : 0, heightMeasureSpec, 0);
                if (oldWidth != Integer.MIN_VALUE) {
                    lp.width = oldWidth;
                }
                int childWidth = child.getMeasuredWidth();
                if (isExactly) {
                    this.mTotalLength += childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength2 = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength2, totalLength2 + childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
                }
                if (useLargestChild) {
                    largestChildWidth = Math.max(childWidth, largestChildWidth);
                }
            }
            boolean matchHeightLocally = false;
            if (heightMode != 0x40000000 && lp.height == -1) {
                matchHeight = true;
                matchHeightLocally = true;
            }
            int margin = lp.topMargin + lp.bottomMargin;
            int childHeight = child.getMeasuredHeight() + margin;
            if (baselineAligned && (childBaseline = child.getBaseline()) != -1) {
                int gravity = (lp.gravity < 0 ? this.mGravity : lp.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            maxHeight = Math.max(maxHeight, childHeight);
            boolean bl = allFillParent = allFillParent && lp.height == -1;
            if (lp.weight > 0.0f) {
                weightedMaxHeight = Math.max(weightedMaxHeight, matchHeightLocally ? margin : childHeight);
            } else {
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
            int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
            int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
            maxHeight = Math.max(maxHeight, ascent + descent);
        }
        if (useLargestChild && widthMode == Integer.MIN_VALUE) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                View child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LayoutParams)child.getLayoutParams();
                if (isExactly) {
                    this.mTotalLength += largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                    continue;
                }
                totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.mPaddingLeft + this.mPaddingRight;
        int widthSize = this.mTotalLength;
        widthSize = Math.max(widthSize, this.getSuggestedMinimumWidth());
        int delta = (widthSize = LinearLayout.resolveSize(widthSize, widthMeasureSpec)) - this.mTotalLength;
        if (delta != 0 && totalWeight > 0.0f) {
            float weightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            maxAscent[3] = -1;
            maxAscent[2] = -1;
            maxAscent[1] = -1;
            maxAscent[0] = -1;
            maxDescent[3] = -1;
            maxDescent[2] = -1;
            maxDescent[1] = -1;
            maxDescent[0] = -1;
            maxHeight = -1;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                int childBaseline;
                View child = this.getVirtualChildAt(i2);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp2 = (LayoutParams)child.getLayoutParams();
                float childExtra = lp2.weight;
                if (childExtra > 0.0f) {
                    int share = (int)(childExtra * (float)delta / weightSum);
                    weightSum -= childExtra;
                    delta -= share;
                    int childHeightMeasureSpec = LinearLayout.getChildMeasureSpec(heightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp2.topMargin + lp2.bottomMargin, lp2.height);
                    if (lp2.width != 0 || widthMode != 0x40000000) {
                        int childWidth = child.getMeasuredWidth() + share;
                        if (childWidth < 0) {
                            childWidth = 0;
                        }
                        child.measure(View.MeasureSpec.makeMeasureSpec(childWidth, 0x40000000), childHeightMeasureSpec);
                    } else {
                        child.measure(View.MeasureSpec.makeMeasureSpec(share > 0 ? share : 0, 0x40000000), childHeightMeasureSpec);
                    }
                }
                if (isExactly) {
                    this.mTotalLength += child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength3 = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength3, totalLength3 + child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child));
                }
                boolean matchHeightLocally = heightMode != 0x40000000 && lp2.height == -1;
                int margin = lp2.topMargin + lp2.bottomMargin;
                int childHeight = child.getMeasuredHeight() + margin;
                maxHeight = Math.max(maxHeight, childHeight);
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
                boolean bl = allFillParent = allFillParent && lp2.height == -1;
                if (!baselineAligned || (childBaseline = child.getBaseline()) == -1) continue;
                int gravity = (lp2.gravity < 0 ? this.mGravity : lp2.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            this.mTotalLength += this.mPaddingLeft + this.mPaddingRight;
            if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
                int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
                int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
                maxHeight = Math.max(maxHeight, ascent + descent);
            }
        } else {
            alternativeMaxHeight = Math.max(alternativeMaxHeight, weightedMaxHeight);
        }
        if (!allFillParent && heightMode != 0x40000000) {
            maxHeight = alternativeMaxHeight;
        }
        maxHeight += this.mPaddingTop + this.mPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(widthSize, LinearLayout.resolveSize(maxHeight, heightMeasureSpec));
        if (matchHeight) {
            this.forceUniformHeight(count, widthMeasureSpec);
        }
    }

    public void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    public int getChildrenSkipCount(View child, int index) {
        return 0;
    }

    public int measureNullChild(int childIndex) {
        return 0;
    }

    public void measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        this.measureChildWithMargins(child, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    public int getLocationOffset(View child) {
        return 0;
    }

    public int getNextLocationOffset(View child) {
        return 0;
    }

    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mOrientation == 1) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
    }

    public void layoutVertical() {
        int paddingLeft = this.mPaddingLeft;
        int childTop = this.mPaddingTop;
        int width = this.mRight - this.mLeft;
        int childRight = width - this.mPaddingRight;
        int childSpace = width - paddingLeft - this.mPaddingRight;
        int count = this.getVirtualChildCount();
        int majorGravity = this.mGravity & 0x70;
        int minorGravity = this.mGravity & 7;
        if (majorGravity != 48) {
            switch (majorGravity) {
                case 80: {
                    childTop = this.mBottom - this.mTop + this.mPaddingTop - this.mTotalLength;
                    break;
                }
                case 16: {
                    childTop += (this.mBottom - this.mTop - this.mTotalLength) / 2;
                }
            }
        }
        for (int i = 0; i < count; ++i) {
            int childLeft;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                childTop += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            switch (gravity & 7) {
                case 3: {
                    childLeft = paddingLeft + lp.leftMargin;
                    break;
                }
                case 1: {
                    childLeft = paddingLeft + (childSpace - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = childRight - childWidth - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = paddingLeft;
                }
            }
            this.setChildFrame(child, childLeft, (childTop += lp.topMargin) + this.getLocationOffset(child), childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, i);
        }
    }

    public void layoutHorizontal() {
        int paddingTop = this.mPaddingTop;
        int childLeft = this.mPaddingLeft;
        int height = this.mBottom - this.mTop;
        int childBottom = height - this.mPaddingBottom;
        int childSpace = height - paddingTop - this.mPaddingBottom;
        int count = this.getVirtualChildCount();
        int majorGravity = this.mGravity & 7;
        int minorGravity = this.mGravity & 0x70;
        boolean baselineAligned = this.mBaselineAligned;
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        if (majorGravity != 3) {
            switch (majorGravity) {
                case 5: {
                    childLeft = this.mRight - this.mLeft + this.mPaddingLeft - this.mTotalLength;
                    break;
                }
                case 1: {
                    childLeft += (this.mRight - this.mLeft - this.mTotalLength) / 2;
                }
            }
        }
        for (int i = 0; i < count; ++i) {
            int childTop;
            int gravity;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                childLeft += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childBaseline = -1;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (baselineAligned && lp.height != -1) {
                childBaseline = child.getBaseline();
            }
            if ((gravity = lp.gravity) < 0) {
                gravity = minorGravity;
            }
            switch (gravity & 0x70) {
                case 48: {
                    childTop = paddingTop + lp.topMargin;
                    if (childBaseline == -1) break;
                    childTop += maxAscent[1] - childBaseline;
                    break;
                }
                case 16: {
                    childTop = paddingTop + (childSpace - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = childBottom - childHeight - lp.bottomMargin;
                    if (childBaseline == -1) break;
                    int descent = child.getMeasuredHeight() - childBaseline;
                    childTop -= maxDescent[2] - descent;
                    break;
                }
                default: {
                    childTop = paddingTop;
                }
            }
            this.setChildFrame(child, (childLeft += lp.leftMargin) + this.getLocationOffset(child), childTop, childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, i);
        }
    }

    public void setChildFrame(View child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.requestLayout();
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @RemotableViewMethod
    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 3;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 7;
        if ((this.mGravity & 7) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFFF8 | gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -2);
        }
        if (this.mOrientation == 1) {
            return new LayoutParams(-1, -2);
        }
        return null;
    }

    public LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty
        public float weight;
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=-1, to="NONE"), @ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=48, to="TOP"), @ViewDebug.IntToString(from=80, to="BOTTOM"), @ViewDebug.IntToString(from=3, to="LEFT"), @ViewDebug.IntToString(from=5, to="RIGHT"), @ViewDebug.IntToString(from=16, to="CENTER_VERTICAL"), @ViewDebug.IntToString(from=112, to="FILL_VERTICAL"), @ViewDebug.IntToString(from=1, to="CENTER_HORIZONTAL"), @ViewDebug.IntToString(from=7, to="FILL_HORIZONTAL"), @ViewDebug.IntToString(from=17, to="CENTER"), @ViewDebug.IntToString(from=119, to="FILL")})
        public int gravity = -1;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.LinearLayout_Layout);
            this.weight = a.getFloat(3, 0.0f);
            this.gravity = a.getInt(0, -1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.weight = 0.0f;
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height);
            this.weight = weight;
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public String debug(String output) {
            return output + "LinearLayout.LayoutParams={width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " weight=" + this.weight + "}";
        }
    }
}

