/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.RemoteViews;
import android.widget.ViewAnimator;
import com.android.internal.R;

@RemoteViews.RemoteView
public class ViewFlipper
extends ViewAnimator {
    public static final String TAG = "ViewFlipper";
    public static final boolean LOGD = false;
    public static final int DEFAULT_INTERVAL = 3000;
    public int mFlipInterval = 3000;
    public boolean mAutoStart = false;
    public boolean mRunning = false;
    public boolean mStarted = false;
    public boolean mVisible = false;
    public boolean mUserPresent = true;
    public final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(action)) {
                ViewFlipper.this.mUserPresent = false;
                ViewFlipper.this.updateRunning();
            } else if ("android.intent.action.USER_PRESENT".equals(action)) {
                ViewFlipper.this.mUserPresent = true;
                ViewFlipper.this.updateRunning();
            }
        }
    };
    public final int FLIP_MSG = 1;
    public final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1 && ViewFlipper.this.mRunning) {
                ViewFlipper.this.showNext();
                msg = this.obtainMessage(1);
                this.sendMessageDelayed(msg, ViewFlipper.this.mFlipInterval);
            }
        }
    };

    public ViewFlipper(Context context) {
        super(context);
    }

    public ViewFlipper(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewFlipper);
        this.mFlipInterval = a.getInt(0, 3000);
        this.mAutoStart = a.getBoolean(1, false);
        a.recycle();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.getContext().registerReceiver(this.mReceiver, filter);
        if (this.mAutoStart) {
            this.startFlipping();
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.getContext().unregisterReceiver(this.mReceiver);
        this.updateRunning();
    }

    public void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.updateRunning();
    }

    @RemotableViewMethod
    public void setFlipInterval(int milliseconds) {
        this.mFlipInterval = milliseconds;
    }

    public void startFlipping() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stopFlipping() {
        this.mStarted = false;
        this.updateRunning();
    }

    public void updateRunning() {
        boolean running;
        boolean bl = running = this.mVisible && this.mStarted && this.mUserPresent;
        if (running != this.mRunning) {
            if (running) {
                this.showOnly(this.mWhichChild);
                Message msg = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(msg, this.mFlipInterval);
            } else {
                this.mHandler.removeMessages(1);
            }
            this.mRunning = running;
        }
    }

    public boolean isFlipping() {
        return this.mStarted;
    }

    public void setAutoStart(boolean autoStart) {
        this.mAutoStart = autoStart;
    }

    public boolean isAutoStart() {
        return this.mAutoStart;
    }
}

