/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.content.Context;
import android.content.res.Configuration;
import android.net.wifi.WifiManager;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.PhoneBase;
import java.util.Arrays;

public class MccTable {
    public static final String[] TZ_STRINGS = new String[]{"", "Africa/Johannesburg", "Asia/Beijing", "Asia/Singapore", "Asia/Tokyo", "Australia/Sydney", "Europe/Amsterdam", "Europe/Berlin", "Europe/Dublin", "Europe/London", "Europe/Madrid", "Europe/Paris", "Europe/Prague", "Europe/Rome", "Europe/Vienna", "Europe/Warsaw", "Europe/Zurich", "Pacific/Auckland"};
    public static final String[] LANG_STRINGS = new String[]{"", "cs", "de", "en", "es", "fr", "it", "ja", "nl", "zh"};
    public static final short[] MCC_CODES = new short[]{202, 204, 206, 208, 212, 213, 214, 216, 218, 219, 220, 222, 225, 226, 228, 230, 231, 232, 234, 235, 238, 240, 242, 244, 246, 247, 248, 250, 255, 257, 259, 260, 262, 266, 268, 270, 272, 274, 276, 278, 280, 282, 283, 284, 286, 288, 289, 290, 292, 293, 294, 295, 297, 302, 308, 310, 311, 312, 313, 314, 315, 316, 330, 332, 334, 338, 340, 342, 344, 346, 348, 350, 352, 354, 356, 358, 360, 362, 363, 364, 365, 366, 368, 370, 372, 374, 376, 400, 401, 402, 404, 405, 410, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 434, 436, 437, 438, 440, 441, 450, 452, 454, 455, 456, 457, 460, 461, 466, 467, 470, 472, 502, 505, 510, 514, 515, 520, 525, 528, 530, 534, 535, 536, 537, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 657, 702, 704, 706, 708, 710, 712, 714, 716, 722, 724, 730, 732, 734, 736, 738, 740, 742, 744, 746, 748, 750};
    public static final int[] IND_CODES = new int[]{1735525376, 1852599400, 1650787328, 1718748341, 1835205632, 1633944576, 1702036644, 1752499200, 1650525184, 1752302592, 1920140288, 1769211094, 1986069718, 1919878144, 1667761410, 1668967617, 1936393216, 1635020002, 1734503571, 1734503571, 1684734976, 1936000000, 1852769280, 1718158336, 1819542528, 1819673600, 1701118976, 1920271360, 1969292288, 1652098048, 1835271168, 1886127344, 1684368498, 1734935552, 0x70740400, 1819608064, 1768227971, 1769145344, 1634468864, 1836319744, 1668875264, 1734673408, 1634534400, 1650918400, 1953629184, 1718551552, 1734673408, 1735132160, 1936524288, 1936458752, 1835729920, 1818821632, 1835336704, 1667325440, 1886192640, 1970494979, 1970494979, 1970494979, 1970494979, 1970494979, 1970494979, 1970494979, 1886520320, 1986593792, 1836582400, 1785529856, 1735394304, 0x62620600, 1634141696, 1803093504, 0x76670600, 1651311616, 1734607872, 1836254208, 1802372096, 1818428416, 1986200576, 1852572672, 1635189760, 1651704832, 1634272768, 1684866048, 1668613120, 1684997120, 1752433664, 0x74740400, 1952646144, 1635386368, 1803158528, 1651770368, 1768817664, 1768817664, 1886061568, 1634075648, 1818952704, 1835860992, 1818362880, 1785660416, 1937310720, 1769014272, 1802961920, 1935737856, 2036663296, 1869415424, 1886585856, 1634010112, 1768686592, 1650983936, 1902183424, 1835926528, 1852834816, 1634010112, 1634010112, 1769079808, 1970930688, 1953104896, 1801913344, 1953301504, 1785754695, 1785754695, 1802634240, 1986921472, 1751843840, 1835992064, 1801978880, 1818297344, 1668181033, 1668181033, 0x74770400, 1802503168, 1650721792, 1836450816, 1836647424, 1635081299, 1768162304, 1953235968, 1885864960, 1952973824, 1936153651, 1651377152, 1853490451, 1836057600, 1735721984, 1852965888, 1885799424, 1953432576, 1935803392, 1987380224, 1718223872, 2003174400, 1634927616, 1802044416, 1851982848, 1885733888, 1667957760, 2004026368, 1718420480, 1835533312, 0x70770400, 1701250048, 1685718016, 1835074560, 1953367040, 1819870208, 1735197696, 1936589824, 1836188672, 1835795456, 1735263232, 1667826688, 1650852864, 1852113920, 1952908288, 1651115008, 1836385280, 1819411456, 1936458752, 1734870016, 1852244992, 1952711680, 1667630080, 1668088832, 1668678656, 1936983040, 1735459840, 1734411264, 1667695616, 1667695616, 1634665472, 1735853056, 1935868928, 1935934464, 1920402432, 1702102016, 1936655360, 1684669440, 1801782272, 1954153472, 1969685504, 1651049472, 1836712960, 2053964800, 1835467776, 1919222784, 2054620160, 1851851776, 1836516352, 1819476992, 1651966976, 1937376256, 1802306560, 2053178387, 1701970944, 1652163584, 1735656448, 1937114112, 1752040960, 1852376064, 1668416512, 1885406208, 1885668352, 1634862592, 1651639296, 1668023296, 1668220416, 1986331648, 1651442688, 1735984128, 1700987904, 1734738944, 1886979072, 1936851968, 1970865152, 1718289408};
    public static final String LOG_TAG = "MccTable";

    public static String defaultTimeZoneForMcc(int mcc) {
        int index = Arrays.binarySearch(MCC_CODES, (short)mcc);
        if (index < 0) {
            return null;
        }
        int indCode = IND_CODES[index];
        int tzInd = indCode >>> 4 & 0x1F;
        String tz = TZ_STRINGS[tzInd];
        if (tz == "") {
            return null;
        }
        return tz;
    }

    public static String countryCodeForMcc(int mcc) {
        int index = Arrays.binarySearch(MCC_CODES, (short)mcc);
        if (index < 0) {
            return "";
        }
        int indCode = IND_CODES[index];
        byte[] iso = new byte[]{(byte)(indCode >>> 24 & 0xFF), (byte)(indCode >>> 16 & 0xFF)};
        return new String(iso);
    }

    public static String defaultLanguageForMcc(int mcc) {
        int index = Arrays.binarySearch(MCC_CODES, (short)mcc);
        if (index < 0) {
            return null;
        }
        int indCode = IND_CODES[index];
        int langInd = indCode & 0xF;
        String lang = LANG_STRINGS[langInd];
        if (lang == "") {
            return null;
        }
        return lang;
    }

    public static int smallestDigitsMccForMnc(int mcc) {
        int index = Arrays.binarySearch(MCC_CODES, (short)mcc);
        if (index < 0) {
            return 2;
        }
        int indCode = IND_CODES[index];
        int smDig = indCode >>> 9 & 3;
        return smDig;
    }

    public static int wifiChannelsForMcc(int mcc) {
        int index = Arrays.binarySearch(MCC_CODES, (short)mcc);
        if (index < 0) {
            return 0;
        }
        int indCode = IND_CODES[index];
        int wifi = indCode >>> 11 & 0xF;
        return wifi;
    }

    public static void updateMccMncConfiguration(PhoneBase phone, String mccmnc) {
        if (!TextUtils.isEmpty(mccmnc)) {
            int mnc;
            int mcc;
            try {
                mcc = Integer.parseInt(mccmnc.substring(0, 3));
                mnc = Integer.parseInt(mccmnc.substring(3));
            }
            catch (NumberFormatException e) {
                Log.e(LOG_TAG, "Error parsing IMSI");
                return;
            }
            Log.d(LOG_TAG, "updateMccMncConfiguration: mcc=" + mcc + ", mnc=" + mnc);
            if (mcc != 0) {
                MccTable.setTimezoneFromMccIfNeeded(phone, mcc);
                MccTable.setLocaleFromMccIfNeeded(phone, mcc);
                MccTable.setWifiChannelsFromMcc(phone, mcc);
            }
            try {
                Configuration config = ActivityManagerNative.getDefault().getConfiguration();
                if (mcc != 0) {
                    config.mcc = mcc;
                }
                if (mnc != 0) {
                    config.mnc = mnc;
                }
                ActivityManagerNative.getDefault().updateConfiguration(config);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Can't update configuration", e);
            }
        }
    }

    public static void setTimezoneFromMccIfNeeded(PhoneBase phone, int mcc) {
        String zoneId;
        String timezone = SystemProperties.get("persist.sys.timezone");
        if ((timezone == null || timezone.length() == 0) && (zoneId = MccTable.defaultTimeZoneForMcc(mcc)) != null && zoneId.length() > 0) {
            Context context = phone.getContext();
            AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
            alarm.setTimeZone(zoneId);
            Log.d(LOG_TAG, "timezone set to " + zoneId);
        }
    }

    public static void setLocaleFromMccIfNeeded(PhoneBase phone, int mcc) {
        String language = MccTable.defaultLanguageForMcc(mcc);
        String country = MccTable.countryCodeForMcc(mcc);
        Log.d(LOG_TAG, "locale set to " + language + "_" + country);
        phone.setSystemLocale(language, country);
    }

    public static void setWifiChannelsFromMcc(PhoneBase phone, int mcc) {
        int wifiChannels = MccTable.wifiChannelsForMcc(mcc);
        if (wifiChannels != 0) {
            Context context = phone.getContext();
            Log.d(LOG_TAG, "WIFI_NUM_ALLOWED_CHANNELS set to " + wifiChannels);
            WifiManager wM = (WifiManager)context.getSystemService("wifi");
            wM.setNumAllowedChannels(wifiChannels, true);
        }
    }
}

