/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedTextRequest;
import com.android.internal.view.IInputContextCallback;

public interface IInputContext
extends IInterface {
    public void getTextBeforeCursor(int var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void getTextAfterCursor(int var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void getCursorCapsMode(int var1, int var2, IInputContextCallback var3) throws RemoteException;

    public void getExtractedText(ExtractedTextRequest var1, int var2, int var3, IInputContextCallback var4) throws RemoteException;

    public void deleteSurroundingText(int var1, int var2) throws RemoteException;

    public void setComposingText(CharSequence var1, int var2) throws RemoteException;

    public void finishComposingText() throws RemoteException;

    public void commitText(CharSequence var1, int var2) throws RemoteException;

    public void commitCompletion(CompletionInfo var1) throws RemoteException;

    public void setSelection(int var1, int var2) throws RemoteException;

    public void performEditorAction(int var1) throws RemoteException;

    public void performContextMenuAction(int var1) throws RemoteException;

    public void beginBatchEdit() throws RemoteException;

    public void endBatchEdit() throws RemoteException;

    public void reportFullscreenMode(boolean var1) throws RemoteException;

    public void sendKeyEvent(KeyEvent var1) throws RemoteException;

    public void clearMetaKeyStates(int var1) throws RemoteException;

    public void performPrivateCommand(String var1, Bundle var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputContext {
        public static final String DESCRIPTOR = "com.android.internal.view.IInputContext";
        public static final int TRANSACTION_getTextBeforeCursor = 1;
        public static final int TRANSACTION_getTextAfterCursor = 2;
        public static final int TRANSACTION_getCursorCapsMode = 3;
        public static final int TRANSACTION_getExtractedText = 4;
        public static final int TRANSACTION_deleteSurroundingText = 5;
        public static final int TRANSACTION_setComposingText = 6;
        public static final int TRANSACTION_finishComposingText = 7;
        public static final int TRANSACTION_commitText = 8;
        public static final int TRANSACTION_commitCompletion = 9;
        public static final int TRANSACTION_setSelection = 10;
        public static final int TRANSACTION_performEditorAction = 11;
        public static final int TRANSACTION_performContextMenuAction = 12;
        public static final int TRANSACTION_beginBatchEdit = 13;
        public static final int TRANSACTION_endBatchEdit = 14;
        public static final int TRANSACTION_reportFullscreenMode = 15;
        public static final int TRANSACTION_sendKeyEvent = 16;
        public static final int TRANSACTION_clearMetaKeyStates = 17;
        public static final int TRANSACTION_performPrivateCommand = 18;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputContext asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputContext) {
                return (IInputContext)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IInputContextCallback _arg3 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getTextBeforeCursor(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IInputContextCallback _arg3 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getTextAfterCursor(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IInputContextCallback _arg2 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getCursorCapsMode(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    ExtractedTextRequest _arg0 = 0 != data.readInt() ? ExtractedTextRequest.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IInputContextCallback _arg3 = IInputContextCallback.Stub.asInterface(data.readStrongBinder());
                    this.getExtractedText(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.deleteSurroundingText(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    CharSequence _arg0 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.setComposingText(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    this.finishComposingText();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    CharSequence _arg0 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.commitText(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    CompletionInfo _arg0 = 0 != data.readInt() ? CompletionInfo.CREATOR.createFromParcel(data) : null;
                    this.commitCompletion(_arg0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setSelection(_arg0, _arg1);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.performEditorAction(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.performContextMenuAction(_arg0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    this.beginBatchEdit();
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    this.endBatchEdit();
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    this.reportFullscreenMode(_arg0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    KeyEvent _arg0 = 0 != data.readInt() ? KeyEvent.CREATOR.createFromParcel(data) : null;
                    this.sendKeyEvent(_arg0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.clearMetaKeyStates(_arg0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.performPrivateCommand(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static class Proxy
        implements IInputContext {
            public IBinder mRemote;

            public Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void getTextBeforeCursor(int length, int flags, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(length);
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(1, _data, null, 1);
                    Object var7_6 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void getTextAfterCursor(int length, int flags, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(length);
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(2, _data, null, 1);
                    Object var7_6 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void getCursorCapsMode(int reqModes, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reqModes);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(3, _data, null, 1);
                    Object var6_5 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void getExtractedText(ExtractedTextRequest request, int flags, int seq, IInputContextCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(4, _data, null, 1);
                    Object var7_6 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void deleteSurroundingText(int leftLength, int rightLength) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(leftLength);
                    _data.writeInt(rightLength);
                    this.mRemote.transact(5, _data, null, 1);
                    Object var5_4 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setComposingText(CharSequence text, int newCursorPosition) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    this.mRemote.transact(6, _data, null, 1);
                    Object var5_4 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finishComposingText() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, _data, null, 1);
                    Object var3_2 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commitText(CharSequence text, int newCursorPosition) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    this.mRemote.transact(8, _data, null, 1);
                    Object var5_4 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commitCompletion(CompletionInfo completion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (completion != null) {
                        _data.writeInt(1);
                        completion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(9, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setSelection(int start, int end) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(start);
                    _data.writeInt(end);
                    this.mRemote.transact(10, _data, null, 1);
                    Object var5_4 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performEditorAction(int actionCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(actionCode);
                    this.mRemote.transact(11, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performContextMenuAction(int id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    this.mRemote.transact(12, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beginBatchEdit() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, _data, null, 1);
                    Object var3_2 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void endBatchEdit() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, _data, null, 1);
                    Object var3_2 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reportFullscreenMode(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    this.mRemote.transact(15, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sendKeyEvent(KeyEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(16, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clearMetaKeyStates(int states) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(states);
                    this.mRemote.transact(17, _data, null, 1);
                    Object var4_3 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performPrivateCommand(String action, Bundle data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(action);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(18, _data, null, 1);
                    Object var5_4 = null;
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _data.recycle();
                    throw throwable;
                }
            }
        }
    }
}

