/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import java.util.ArrayList;

public class PointerLocationView
extends View {
    public final ViewConfiguration mVC;
    public final Paint mTextPaint;
    public final Paint mTextBackgroundPaint;
    public final Paint mTextLevelPaint;
    public final Paint mPaint;
    public final Paint mTargetPaint;
    public final Paint mPathPaint;
    public final Paint.FontMetricsInt mTextMetrics = new Paint.FontMetricsInt();
    public int mHeaderBottom;
    public boolean mCurDown;
    public int mCurNumPointers;
    public int mMaxNumPointers;
    public final ArrayList<PointerState> mPointers = new ArrayList();
    public boolean mPrintCoords = true;

    public PointerLocationView(Context c) {
        super(c);
        this.setFocusable(true);
        this.mVC = ViewConfiguration.get(c);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(10.0f * this.getResources().getDisplayMetrics().density);
        this.mTextPaint.setARGB(255, 0, 0, 0);
        this.mTextBackgroundPaint = new Paint();
        this.mTextBackgroundPaint.setAntiAlias(false);
        this.mTextBackgroundPaint.setARGB(128, 255, 255, 255);
        this.mTextLevelPaint = new Paint();
        this.mTextLevelPaint.setAntiAlias(false);
        this.mTextLevelPaint.setARGB(192, 255, 0, 0);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setARGB(255, 255, 255, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f);
        this.mTargetPaint = new Paint();
        this.mTargetPaint.setAntiAlias(false);
        this.mTargetPaint.setARGB(255, 0, 0, 192);
        this.mPathPaint = new Paint();
        this.mPathPaint.setAntiAlias(false);
        this.mPathPaint.setARGB(255, 0, 96, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(1.0f);
        PointerState ps = new PointerState();
        ps.mVelocity = VelocityTracker.obtain();
        this.mPointers.add(ps);
    }

    public void setPrintCoords(boolean state) {
        this.mPrintCoords = state;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mTextPaint.getFontMetricsInt(this.mTextMetrics);
        this.mHeaderBottom = -this.mTextMetrics.ascent + this.mTextMetrics.descent + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDraw(Canvas canvas) {
        ArrayList<PointerState> arrayList = this.mPointers;
        synchronized (arrayList) {
            int p;
            int w = this.getWidth();
            int itemW = w / 7;
            int base = -this.mTextMetrics.ascent + 1;
            int bottom = this.mHeaderBottom;
            int NP = this.mPointers.size();
            if (NP > 0) {
                PointerState ps = this.mPointers.get(0);
                canvas.drawRect(0.0f, 0.0f, itemW - 1, bottom, this.mTextBackgroundPaint);
                canvas.drawText("P: " + this.mCurNumPointers + " / " + this.mMaxNumPointers, 1.0f, base, this.mTextPaint);
                int N = ps.mXs.size();
                if (this.mCurDown && ps.mCurDown || N == 0) {
                    canvas.drawRect(itemW, 0.0f, itemW * 2 - 1, bottom, this.mTextBackgroundPaint);
                    canvas.drawText("X: " + ps.mCurX, 1 + itemW, base, this.mTextPaint);
                    canvas.drawRect(itemW * 2, 0.0f, itemW * 3 - 1, bottom, this.mTextBackgroundPaint);
                    canvas.drawText("Y: " + ps.mCurY, 1 + itemW * 2, base, this.mTextPaint);
                } else {
                    float dx = ((Float)ps.mXs.get(N - 1)).floatValue() - ((Float)ps.mXs.get(0)).floatValue();
                    float dy = ((Float)ps.mYs.get(N - 1)).floatValue() - ((Float)ps.mYs.get(0)).floatValue();
                    canvas.drawRect(itemW, 0.0f, itemW * 2 - 1, bottom, Math.abs(dx) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
                    canvas.drawText("dX: " + String.format("%.1f", Float.valueOf(dx)), 1 + itemW, base, this.mTextPaint);
                    canvas.drawRect(itemW * 2, 0.0f, itemW * 3 - 1, bottom, Math.abs(dy) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
                    canvas.drawText("dY: " + String.format("%.1f", Float.valueOf(dy)), 1 + itemW * 2, base, this.mTextPaint);
                }
                canvas.drawRect(itemW * 3, 0.0f, itemW * 4 - 1, bottom, this.mTextBackgroundPaint);
                int velocity = ps.mVelocity == null ? 0 : (int)(ps.mVelocity.getXVelocity() * 1000.0f);
                canvas.drawText("Xv: " + velocity, 1 + itemW * 3, base, this.mTextPaint);
                canvas.drawRect(itemW * 4, 0.0f, itemW * 5 - 1, bottom, this.mTextBackgroundPaint);
                velocity = ps.mVelocity == null ? 0 : (int)(ps.mVelocity.getYVelocity() * 1000.0f);
                canvas.drawText("Yv: " + velocity, 1 + itemW * 4, base, this.mTextPaint);
                canvas.drawRect(itemW * 5, 0.0f, itemW * 6 - 1, bottom, this.mTextBackgroundPaint);
                canvas.drawRect(itemW * 5, 0.0f, (float)(itemW * 5) + ps.mCurPressure * (float)itemW - 1.0f, bottom, this.mTextLevelPaint);
                canvas.drawText("Prs: " + String.format("%.2f", Float.valueOf(ps.mCurPressure)), 1 + itemW * 5, base, this.mTextPaint);
                canvas.drawRect(itemW * 6, 0.0f, w, bottom, this.mTextBackgroundPaint);
                canvas.drawRect(itemW * 6, 0.0f, (float)(itemW * 6) + ps.mCurSize * (float)itemW - 1.0f, bottom, this.mTextLevelPaint);
                canvas.drawText("Size: " + String.format("%.2f", Float.valueOf(ps.mCurSize)), 1 + itemW * 6, base, this.mTextPaint);
            }
            for (p = 0; p < NP; ++p) {
                PointerState ps = this.mPointers.get(p);
                if (!this.mCurDown || !ps.mCurDown) continue;
                canvas.drawLine(0.0f, ps.mCurY, this.getWidth(), ps.mCurY, this.mTargetPaint);
                canvas.drawLine(ps.mCurX, 0.0f, ps.mCurX, this.getHeight(), this.mTargetPaint);
                int pressureLevel = (int)(ps.mCurPressure * 255.0f);
                this.mPaint.setARGB(255, pressureLevel, 128, 255 - pressureLevel);
                canvas.drawPoint(ps.mCurX, ps.mCurY, this.mPaint);
                canvas.drawCircle(ps.mCurX, ps.mCurY, ps.mCurWidth, this.mPaint);
            }
            for (p = 0; p < NP; ++p) {
                PointerState ps = this.mPointers.get(p);
                int N = ps.mXs.size();
                float lastX = 0.0f;
                float lastY = 0.0f;
                boolean haveLast = false;
                boolean drawn = false;
                this.mPaint.setARGB(255, 128, 255, 255);
                for (int i = 0; i < N; ++i) {
                    float x = ((Float)ps.mXs.get(i)).floatValue();
                    float y = ((Float)ps.mYs.get(i)).floatValue();
                    if (Float.isNaN(x)) {
                        haveLast = false;
                        continue;
                    }
                    if (haveLast) {
                        canvas.drawLine(lastX, lastY, x, y, this.mPathPaint);
                        canvas.drawPoint(lastX, lastY, this.mPaint);
                        drawn = true;
                    }
                    lastX = x;
                    lastY = y;
                    haveLast = true;
                }
                if (!drawn) continue;
                if (ps.mVelocity != null) {
                    this.mPaint.setARGB(255, 255, 64, 128);
                    float xVel = ps.mVelocity.getXVelocity() * 16.0f;
                    float yVel = ps.mVelocity.getYVelocity() * 16.0f;
                    canvas.drawLine(lastX, lastY, lastX + xVel, lastY + yVel, this.mPaint);
                    continue;
                }
                canvas.drawPoint(lastX, lastY, this.mPaint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTouchEvent(MotionEvent event) {
        ArrayList<PointerState> arrayList = this.mPointers;
        synchronized (arrayList) {
            PointerState ps;
            int i;
            int action = event.getAction();
            int NP = this.mPointers.size();
            if (action == 0) {
                for (int p = 0; p < NP; ++p) {
                    PointerState ps2 = this.mPointers.get(p);
                    ps2.mXs.clear();
                    ps2.mYs.clear();
                    ps2.mVelocity = VelocityTracker.obtain();
                    ps2.mCurDown = false;
                }
                this.mPointers.get(0).mCurDown = true;
                this.mMaxNumPointers = 0;
                if (this.mPrintCoords) {
                    Log.i("Pointer", "Pointer 1: DOWN");
                }
            }
            if ((action & 0xFF) == 5) {
                PointerState ps3;
                int index = (action & 0xFF00) >> 8;
                int id2 = event.getPointerId(index);
                while (NP <= id2) {
                    ps3 = new PointerState();
                    ps3.mVelocity = VelocityTracker.obtain();
                    this.mPointers.add(ps3);
                    ++NP;
                }
                ps3 = this.mPointers.get(id2);
                ps3.mVelocity = VelocityTracker.obtain();
                ps3.mCurDown = true;
                if (this.mPrintCoords) {
                    Log.i("Pointer", "Pointer " + (id2 + 1) + ": DOWN");
                }
            }
            int NI = event.getPointerCount();
            this.mCurDown = action != 1 && action != 3;
            int n = this.mCurNumPointers = this.mCurDown ? NI : 0;
            if (this.mMaxNumPointers < this.mCurNumPointers) {
                this.mMaxNumPointers = this.mCurNumPointers;
            }
            for (i = 0; i < NI; ++i) {
                int id3 = event.getPointerId(i);
                ps = this.mPointers.get(id3);
                ps.mVelocity.addMovement(event);
                ps.mVelocity.computeCurrentVelocity(1);
                int N = event.getHistorySize();
                for (int j = 0; j < N; ++j) {
                    if (this.mPrintCoords) {
                        Log.i("Pointer", "Pointer " + (id3 + 1) + ": (" + event.getHistoricalX(i, j) + ", " + event.getHistoricalY(i, j) + ")" + " Prs=" + event.getHistoricalPressure(i, j) + " Size=" + event.getHistoricalSize(i, j));
                    }
                    ps.mXs.add(Float.valueOf(event.getHistoricalX(i, j)));
                    ps.mYs.add(Float.valueOf(event.getHistoricalY(i, j)));
                }
                if (this.mPrintCoords) {
                    Log.i("Pointer", "Pointer " + (id3 + 1) + ": (" + event.getX(i) + ", " + event.getY(i) + ")" + " Prs=" + event.getPressure(i) + " Size=" + event.getSize(i));
                }
                ps.mXs.add(Float.valueOf(event.getX(i)));
                ps.mYs.add(Float.valueOf(event.getY(i)));
                ps.mCurX = (int)event.getX(i);
                ps.mCurY = (int)event.getY(i);
                ps.mCurPressure = event.getPressure(i);
                ps.mCurSize = event.getSize(i);
                ps.mCurWidth = (int)(ps.mCurSize * (float)(this.getWidth() / 3));
            }
            if ((action & 0xFF) == 6) {
                int index = (action & 0xFF00) >> 8;
                int id4 = event.getPointerId(index);
                ps = this.mPointers.get(id4);
                ps.mXs.add(Float.valueOf(Float.NaN));
                ps.mYs.add(Float.valueOf(Float.NaN));
                ps.mCurDown = false;
                if (this.mPrintCoords) {
                    Log.i("Pointer", "Pointer " + (id4 + 1) + ": UP");
                }
            }
            if (action == 1) {
                for (i = 0; i < NI; ++i) {
                    int id5 = event.getPointerId(i);
                    ps = this.mPointers.get(id5);
                    if (!ps.mCurDown) continue;
                    ps.mCurDown = false;
                    if (!this.mPrintCoords) continue;
                    Log.i("Pointer", "Pointer " + (id5 + 1) + ": UP");
                }
            }
            this.postInvalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.addTouchEvent(event);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        Log.i("Pointer", "Trackball: " + event);
        return super.onTrackballEvent(event);
    }

    public static class PointerState {
        public final ArrayList<Float> mXs = new ArrayList();
        public final ArrayList<Float> mYs = new ArrayList();
        public boolean mCurDown;
        public int mCurX;
        public int mCurY;
        public float mCurPressure;
        public float mCurSize;
        public int mCurWidth;
        public VelocityTracker mVelocity;
    }
}

