/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.Bitmap_Delegate;
import android.graphics.Paint_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Region_Delegate;
import android.graphics.Shader_Delegate;
import android.graphics.Xfermode_Delegate;
import com.android.layoutlib.bridge.Bridge;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class GcSnapshot {
    private final GcSnapshot mPrevious;
    private final int mFlags;
    private final ArrayList<Layer> mLayers = new ArrayList();
    private AffineTransform mTransform = null;
    private Area mClip = null;
    private final Layer mLocalLayer;
    private final Paint_Delegate mLocalLayerPaint;
    private final Rect mLayerBounds;

    public static GcSnapshot createDefaultSnapshot(Bitmap_Delegate bitmap) {
        GcSnapshot snapshot = new GcSnapshot();
        if (bitmap != null) {
            snapshot.setBitmap(bitmap);
        }
        return snapshot;
    }

    public GcSnapshot save(int flags) {
        return new GcSnapshot(this, null, null, flags);
    }

    public GcSnapshot saveLayer(RectF layerBounds, Paint_Delegate paint, int flags) {
        return new GcSnapshot(this, layerBounds, paint, flags);
    }

    private GcSnapshot() {
        this.mPrevious = null;
        this.mFlags = 0;
        this.mLocalLayer = null;
        this.mLocalLayerPaint = null;
        this.mLayerBounds = null;
    }

    private GcSnapshot(GcSnapshot previous, RectF layerBounds, Paint_Delegate paint, int flags) {
        assert (previous != null);
        this.mPrevious = previous;
        this.mFlags = flags;
        for (Layer layer : this.mPrevious.mLayers) {
            this.mLayers.add(layer.makeCopy());
        }
        if (layerBounds != null) {
            AffineTransform matrix = this.mLayers.get(0).getGraphics().getTransform();
            RectF rect2 = new RectF();
            this.mapRect(matrix, rect2, layerBounds);
            this.mLayerBounds = new Rect();
            rect2.round(this.mLayerBounds);
            Layer baseLayer = this.mLayers.get(0);
            BufferedImage layerImage = new BufferedImage(baseLayer.getImage().getWidth(), baseLayer.getImage().getHeight(), (this.mFlags & 4) != 0 ? 2 : 1);
            Graphics2D layerGraphics = layerImage.createGraphics();
            AffineTransform currentMtx = baseLayer.getGraphics().getTransform();
            layerGraphics.setTransform(currentMtx);
            this.mLocalLayer = new Layer(layerGraphics, layerImage, flags);
            this.mLayers.add(this.mLocalLayer);
            Shape currentClip = baseLayer.getGraphics().getClip();
            this.mLocalLayer.setClip(currentClip);
            if ((this.mFlags & 0x10) == 0) {
                int w = this.mLayerBounds.width();
                int h = this.mLayerBounds.height();
                for (int i = 0; i < this.mLayers.size() - 1; ++i) {
                    Layer layer = this.mLayers.get(i);
                    BufferedImage image = new BufferedImage(w, h, 2);
                    Graphics2D graphics = image.createGraphics();
                    graphics.drawImage(layer.getImage(), 0, 0, w, h, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, null);
                    graphics.dispose();
                    layer.setOriginalCopy(image);
                }
            }
        } else {
            this.mLocalLayer = null;
            this.mLayerBounds = null;
        }
        this.mLocalLayerPaint = paint;
    }

    public void dispose() {
        for (Layer layer : this.mLayers) {
            layer.getGraphics().dispose();
        }
        if (this.mPrevious != null) {
            this.mPrevious.dispose();
        }
    }

    public GcSnapshot restore() {
        return this.doRestore();
    }

    public GcSnapshot restoreTo(int saveCount) {
        return this.doRestoreTo(this.size(), saveCount);
    }

    public int size() {
        if (this.mPrevious != null) {
            return this.mPrevious.size() + 1;
        }
        return 1;
    }

    public void setBitmap(Bitmap_Delegate bitmap) {
        Graphics2D graphics2D = bitmap.getImage().createGraphics();
        Layer baseLayer = new Layer(graphics2D, bitmap);
        graphics2D.setTransform(this.getTransform());
        this.mTransform = null;
        baseLayer.setClip(this.getClip());
        this.mClip = null;
        this.mLayers.clear();
        this.mLayers.add(baseLayer);
    }

    public void translate(float dx, float dy) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().translate(dx, dy);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.translate(dx, dy);
        }
    }

    public void rotate(double radians) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().rotate(radians);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.rotate(radians);
        }
    }

    public void scale(float sx, float sy) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().scale(sx, sy);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.scale(sx, sy);
        }
    }

    public AffineTransform getTransform() {
        if (this.mLayers.size() > 0) {
            return this.mLayers.get(0).getGraphics().getTransform();
        }
        if (this.mTransform == null) {
            this.mTransform = new AffineTransform();
        }
        return this.mTransform;
    }

    public void setTransform(AffineTransform transform) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().setTransform(transform);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.setTransform(transform);
        }
    }

    public boolean clip(Shape shape, int regionOp) {
        if (regionOp == Region.Op.INTERSECT.nativeInt && this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.clip(shape);
            }
            Shape currentClip = this.getClip();
            return currentClip != null && !currentClip.getBounds().isEmpty();
        }
        Area area = null;
        area = regionOp == Region.Op.REPLACE.nativeInt ? new Area(shape) : Region_Delegate.combineShapes(this.getClip(), shape, regionOp);
        assert (area != null);
        if (this.mLayers.size() > 0) {
            Shape currentClip;
            if (area != null) {
                for (Layer layer : this.mLayers) {
                    layer.setClip(area);
                }
            }
            return (currentClip = this.getClip()) != null && !currentClip.getBounds().isEmpty();
        }
        this.mClip = area != null ? area : new Area();
        return !this.mClip.getBounds().isEmpty();
    }

    public boolean clipRect(float left, float top, float right, float bottom, int regionOp) {
        return this.clip(new Rectangle2D.Float(left, top, right - left, bottom - top), regionOp);
    }

    public Shape getClip() {
        if (this.mLayers.size() > 0) {
            return this.mLayers.get(0).getGraphics().getClip();
        }
        return this.mClip;
    }

    private GcSnapshot doRestoreTo(int size, int saveCount) {
        if (size <= saveCount) {
            return this;
        }
        GcSnapshot previous = this.doRestore();
        if (size == saveCount + 1) {
            return previous;
        }
        return previous.doRestoreTo(size - 1, saveCount);
    }

    public void draw(Drawable drawable2) {
        this.draw(drawable2, null, false, false);
    }

    public void draw(Drawable drawable2, Paint_Delegate paint, boolean compositeOnly, boolean forceSrcMode) {
        if (this.mLayers.size() == 1) {
            this.drawInLayer(this.mLayers.get(0), drawable2, paint, compositeOnly, forceSrcMode);
        } else {
            int flags;
            int i = this.mLayers.size() - 1;
            do {
                Layer layer = this.mLayers.get(i);
                this.drawInLayer(layer, drawable2, paint, compositeOnly, forceSrcMode);
                flags = layer.getFlags();
            } while (--i >= 0 && (flags & 0x10) == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawInLayer(Layer layer, Drawable drawable2, Paint_Delegate paint, boolean compositeOnly, boolean forceSrcMode) {
        Graphics2D configuredGraphics2D;
        Graphics2D originalGraphics = layer.getGraphics();
        Graphics2D graphics2D = configuredGraphics2D = paint != null ? this.createCustomGraphics(originalGraphics, paint, compositeOnly, forceSrcMode) : (Graphics2D)originalGraphics.create();
        if (configuredGraphics2D != null) {
            try {
                drawable2.draw(configuredGraphics2D, paint);
            }
            finally {
                configuredGraphics2D.dispose();
            }
        }
    }

    private GcSnapshot doRestore() {
        if (this.mPrevious != null) {
            if (this.mLocalLayer != null) {
                int flags;
                int i = this.mLayers.size() - 1;
                do {
                    Layer dstLayer = this.mLayers.get(i - 1);
                    this.restoreLayer(dstLayer);
                    flags = dstLayer.getFlags();
                } while (--i > 0 && (flags & 0x10) == 0);
            }
            if ((this.mFlags & 1) == 0) {
                AffineTransform mtx = this.getTransform();
                for (Layer layer : this.mPrevious.mLayers) {
                    layer.getGraphics().setTransform(mtx);
                }
            }
            if ((this.mFlags & 2) == 0) {
                Shape clip = this.getClip();
                for (Layer layer : this.mPrevious.mLayers) {
                    layer.setClip(clip);
                }
            }
        }
        for (Layer layer : this.mLayers) {
            layer.getGraphics().dispose();
        }
        return this.mPrevious;
    }

    private void restoreLayer(Layer dstLayer) {
        Graphics2D g;
        Graphics2D baseGfx = dstLayer.getImage().createGraphics();
        BufferedImage originalCopy = dstLayer.getOriginalCopy();
        if (originalCopy != null) {
            g = (Graphics2D)baseGfx.create();
            g.setComposite(AlphaComposite.Src);
            g.drawImage(originalCopy, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, 0, 0, this.mLayerBounds.width(), this.mLayerBounds.height(), null);
            g.dispose();
        }
        if ((g = this.createCustomGraphics(baseGfx, this.mLocalLayerPaint, true, false)) != null) {
            g.drawImage(this.mLocalLayer.getImage(), this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, null);
            g.dispose();
        }
        baseGfx.dispose();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Graphics2D createCustomGraphics(Graphics2D original, Paint_Delegate paint, boolean compositeOnly, boolean forceSrcMode) {
        int alpha;
        Graphics2D g = (Graphics2D)original.create();
        if (paint.isAntiAliased()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        boolean customShader = false;
        if (!compositeOnly) {
            Shader_Delegate shaderDelegate = paint.getShader();
            if (shaderDelegate != null) {
                if (shaderDelegate.isSupported()) {
                    if (!shaderDelegate.isValid()) {
                        g.dispose();
                        return null;
                    }
                    Paint shaderPaint = shaderDelegate.getJavaPaint();
                    assert (shaderPaint != null);
                    if (shaderPaint != null) {
                        g.setPaint(shaderPaint);
                        customShader = true;
                    }
                } else {
                    Bridge.getLog().fidelityWarning("shader", shaderDelegate.getSupportMessage(), null, null);
                }
            }
            if (!customShader) {
                g.setColor(new Color(paint.getColor(), true));
            }
            g.setStroke(paint.getJavaStroke());
        }
        int n = alpha = compositeOnly || customShader ? paint.getAlpha() : 255;
        if (forceSrcMode) {
            g.setComposite(AlphaComposite.getInstance(2, (float)alpha / 255.0f));
            return g;
        }
        boolean customXfermode = false;
        Xfermode_Delegate xfermodeDelegate = paint.getXfermode();
        if (xfermodeDelegate != null) {
            if (xfermodeDelegate.isSupported()) {
                Composite composite = xfermodeDelegate.getComposite(alpha);
                assert (composite != null);
                if (composite != null) {
                    g.setComposite(composite);
                    customXfermode = true;
                }
            } else {
                Bridge.getLog().fidelityWarning("xfermode", xfermodeDelegate.getSupportMessage(), null, null);
            }
        }
        if (customXfermode) return g;
        if (alpha == 255) return g;
        g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
        return g;
    }

    private void mapRect(AffineTransform matrix, RectF dst, RectF src) {
        float[] corners = new float[]{src.left, src.top, src.right, src.top, src.right, src.bottom, src.left, src.bottom};
        matrix.transform(corners, 0, corners, 0, 4);
        dst.left = Math.min(Math.min(corners[0], corners[2]), Math.min(corners[4], corners[6]));
        dst.right = Math.max(Math.max(corners[0], corners[2]), Math.max(corners[4], corners[6]));
        dst.top = Math.min(Math.min(corners[1], corners[3]), Math.min(corners[5], corners[7]));
        dst.bottom = Math.max(Math.max(corners[1], corners[3]), Math.max(corners[5], corners[7]));
    }

    private static class Layer {
        private final Graphics2D mGraphics;
        private final Bitmap_Delegate mBitmap;
        private final BufferedImage mImage;
        private final int mFlags;
        private BufferedImage mOriginalCopy;

        Layer(Graphics2D graphics, Bitmap_Delegate bitmap) {
            this.mGraphics = graphics;
            this.mBitmap = bitmap;
            this.mImage = this.mBitmap.getImage();
            this.mFlags = 0;
        }

        Layer(Graphics2D graphics, BufferedImage image, int flags) {
            this.mGraphics = graphics;
            this.mBitmap = null;
            this.mImage = image;
            this.mFlags = flags;
        }

        Graphics2D getGraphics() {
            return this.mGraphics;
        }

        BufferedImage getImage() {
            return this.mImage;
        }

        int getFlags() {
            return this.mFlags;
        }

        Layer makeCopy() {
            if (this.mBitmap != null) {
                return new Layer((Graphics2D)this.mGraphics.create(), this.mBitmap);
            }
            return new Layer((Graphics2D)this.mGraphics.create(), this.mImage, this.mFlags);
        }

        void setOriginalCopy(BufferedImage image) {
            this.mOriginalCopy = image;
        }

        BufferedImage getOriginalCopy() {
            return this.mOriginalCopy;
        }

        void setClip(Shape clipShape) {
            this.mGraphics.setClip(null);
            this.mGraphics.clip(clipShape);
        }

        public void clip(Shape shape) {
            this.mGraphics.clip(shape);
        }
    }

    public static interface Drawable {
        public void draw(Graphics2D var1, Paint_Delegate var2);
    }
}

