/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gles_jni;

import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.google.android.gles_jni.EGLContextImpl;
import com.google.android.gles_jni.EGLDisplayImpl;
import com.google.android.gles_jni.EGLSurfaceImpl;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EGLImpl
implements EGL10 {
    public EGLContextImpl mContext = new EGLContextImpl(-1);
    public EGLDisplayImpl mDisplay = new EGLDisplayImpl(-1);
    public EGLSurfaceImpl mSurface = new EGLSurfaceImpl(-1);

    public boolean eglInitialize(EGLDisplay eGLDisplay, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglInitialize(Ljavax/microedition/khronos/egl/EGLDisplay;[I)Z", true, this) != 0;
    }

    public boolean eglQueryContext(EGLDisplay eGLDisplay, EGLContext eGLContext, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglQueryContext(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLContext;I[I)Z", true, this) != 0;
    }

    public boolean eglQuerySurface(EGLDisplay eGLDisplay, EGLSurface eGLSurface, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglQuerySurface(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;I[I)Z", true, this) != 0;
    }

    public boolean eglChooseConfig(EGLDisplay eGLDisplay, int[] nArray, EGLConfig[] eGLConfigArray, int n, int[] nArray2) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglChooseConfig(Ljavax/microedition/khronos/egl/EGLDisplay;[I[Ljavax/microedition/khronos/egl/EGLConfig;I[I)Z", true, this) != 0;
    }

    public boolean eglGetConfigAttrib(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglGetConfigAttrib(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;I[I)Z", true, this) != 0;
    }

    public boolean eglGetConfigs(EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray, int n, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglGetConfigs(Ljavax/microedition/khronos/egl/EGLDisplay;[Ljavax/microedition/khronos/egl/EGLConfig;I[I)Z", true, this) != 0;
    }

    public int eglGetError() {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglGetError()I", true, this);
    }

    public boolean eglDestroyContext(EGLDisplay eGLDisplay, EGLContext eGLContext) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglDestroyContext(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLContext;)Z", true, this) != 0;
    }

    public boolean eglDestroySurface(EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglDestroySurface(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;)Z", true, this) != 0;
    }

    public boolean eglMakeCurrent(EGLDisplay eGLDisplay, EGLSurface eGLSurface, EGLSurface eGLSurface2, EGLContext eGLContext) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglMakeCurrent(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;Ljavax/microedition/khronos/egl/EGLSurface;Ljavax/microedition/khronos/egl/EGLContext;)Z", true, this) != 0;
    }

    public String eglQueryString(EGLDisplay eGLDisplay, int n) {
        return (String)OverrideMethod.invokeA("com.google.android.gles_jni.EGLImpl#eglQueryString(Ljavax/microedition/khronos/egl/EGLDisplay;I)Ljava/lang/String;", true, this);
    }

    public boolean eglSwapBuffers(EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglSwapBuffers(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;)Z", true, this) != 0;
    }

    public boolean eglTerminate(EGLDisplay eGLDisplay) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglTerminate(Ljavax/microedition/khronos/egl/EGLDisplay;)Z", true, this) != 0;
    }

    public boolean eglCopyBuffers(EGLDisplay eGLDisplay, EGLSurface eGLSurface, Object object) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglCopyBuffers(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLSurface;Ljava/lang/Object;)Z", true, this) != 0;
    }

    public boolean eglWaitGL() {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglWaitGL()Z", true, this) != 0;
    }

    public boolean eglWaitNative(int n, Object object) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#eglWaitNative(ILjava/lang/Object;)Z", true, this) != 0;
    }

    public EGLContext eglCreateContext(EGLDisplay display, EGLConfig config, EGLContext share_context, int[] attrib_list) {
        int eglContextId = this._eglCreateContext(display, config, share_context, attrib_list);
        if (eglContextId == 0) {
            return EGL10.EGL_NO_CONTEXT;
        }
        return new EGLContextImpl(eglContextId);
    }

    public EGLSurface eglCreatePbufferSurface(EGLDisplay display, EGLConfig config, int[] attrib_list) {
        int eglSurfaceId = this._eglCreatePbufferSurface(display, config, attrib_list);
        if (eglSurfaceId == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(eglSurfaceId);
    }

    public EGLSurface eglCreatePixmapSurface(EGLDisplay display, EGLConfig config, Object native_pixmap, int[] attrib_list) {
        EGLSurfaceImpl sur = new EGLSurfaceImpl();
        this._eglCreatePixmapSurface(sur, display, config, native_pixmap, attrib_list);
        if (sur.mEGLSurface == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return sur;
    }

    public EGLSurface eglCreateWindowSurface(EGLDisplay display, EGLConfig config, Object native_window, int[] attrib_list) {
        Surface sur;
        if (native_window instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)native_window;
            sur = surfaceView.getHolder().getSurface();
        } else if (native_window instanceof SurfaceHolder) {
            SurfaceHolder holder = (SurfaceHolder)native_window;
            sur = holder.getSurface();
        } else {
            throw new UnsupportedOperationException("eglCreateWindowSurface() can only be called with an instance of SurfaceView or SurfaceHolder at the moment, this will be fixed later.");
        }
        int eglSurfaceId = this._eglCreateWindowSurface(display, config, sur, attrib_list);
        if (eglSurfaceId == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(eglSurfaceId);
    }

    public synchronized EGLDisplay eglGetDisplay(Object native_display) {
        int value = this._eglGetDisplay(native_display);
        if (value == 0) {
            return EGL10.EGL_NO_DISPLAY;
        }
        if (this.mDisplay.mEGLDisplay != value) {
            this.mDisplay = new EGLDisplayImpl(value);
        }
        return this.mDisplay;
    }

    public synchronized EGLContext eglGetCurrentContext() {
        int value = this._eglGetCurrentContext();
        if (value == 0) {
            return EGL10.EGL_NO_CONTEXT;
        }
        if (this.mContext.mEGLContext != value) {
            this.mContext = new EGLContextImpl(value);
        }
        return this.mContext;
    }

    public synchronized EGLDisplay eglGetCurrentDisplay() {
        int value = this._eglGetCurrentDisplay();
        if (value == 0) {
            return EGL10.EGL_NO_DISPLAY;
        }
        if (this.mDisplay.mEGLDisplay != value) {
            this.mDisplay = new EGLDisplayImpl(value);
        }
        return this.mDisplay;
    }

    public synchronized EGLSurface eglGetCurrentSurface(int readdraw) {
        int value = this._eglGetCurrentSurface(readdraw);
        if (value == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        if (this.mSurface.mEGLSurface != value) {
            this.mSurface = new EGLSurfaceImpl(value);
        }
        return this.mSurface;
    }

    public int _eglCreateContext(EGLDisplay eGLDisplay, EGLConfig eGLConfig, EGLContext eGLContext, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#_eglCreateContext(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;Ljavax/microedition/khronos/egl/EGLContext;[I)I", true, this);
    }

    public int _eglCreatePbufferSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#_eglCreatePbufferSurface(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;[I)I", true, this);
    }

    public void _eglCreatePixmapSurface(EGLSurface eGLSurface, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        OverrideMethod.invokeV("com.google.android.gles_jni.EGLImpl#_eglCreatePixmapSurface(Ljavax/microedition/khronos/egl/EGLSurface;Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;Ljava/lang/Object;[I)V", true, this);
    }

    public int _eglCreateWindowSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#_eglCreateWindowSurface(Ljavax/microedition/khronos/egl/EGLDisplay;Ljavax/microedition/khronos/egl/EGLConfig;Ljava/lang/Object;[I)I", true, this);
    }

    public int _eglGetDisplay(Object object) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#_eglGetDisplay(Ljava/lang/Object;)I", true, this);
    }

    public int _eglGetCurrentContext() {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#_eglGetCurrentContext()I", true, this);
    }

    public int _eglGetCurrentDisplay() {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#_eglGetCurrentDisplay()I", true, this);
    }

    public int _eglGetCurrentSurface(int n) {
        return OverrideMethod.invokeI("com.google.android.gles_jni.EGLImpl#_eglGetCurrentSurface(I)I", true, this);
    }

    public static void _nativeClassInit() {
        OverrideMethod.invokeV("com.google.android.gles_jni.EGLImpl#_nativeClassInit()V", true, null);
    }

    static {
        EGLImpl._nativeClassInit();
    }
}

