/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.util.Arrays;
import org.apache.harmony.security.internal.nls.Messages;

public class ObjectIdentifier {
    public final int[] oid;
    public String soid;

    public ObjectIdentifier(int[] oid) {
        ObjectIdentifier.validate(oid);
        this.oid = oid;
    }

    public ObjectIdentifier(String strOid) {
        this.oid = ObjectIdentifier.toIntArray(strOid);
        this.soid = strOid;
    }

    public int[] getOid() {
        return this.oid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.oid, ((ObjectIdentifier)o).oid);
    }

    public String toString() {
        if (this.soid == null) {
            this.soid = ObjectIdentifier.toString(this.oid);
        }
        return this.soid;
    }

    public int hashCode() {
        int intHash = 0;
        for (int i = 0; i < this.oid.length && i < 4; ++i) {
            intHash += this.oid[i] << 8 * i;
        }
        return intHash & Integer.MAX_VALUE;
    }

    public static void validate(int[] oid) {
        if (oid == null) {
            throw new IllegalArgumentException(Messages.getString("security.98"));
        }
        if (oid.length < 2) {
            throw new IllegalArgumentException(Messages.getString("security.99"));
        }
        if (oid[0] > 2) {
            throw new IllegalArgumentException(Messages.getString("security.9A"));
        }
        if (oid[0] != 2 && oid[1] > 39) {
            throw new IllegalArgumentException(Messages.getString("security.9B"));
        }
        for (int i = 0; i < oid.length; ++i) {
            if (oid[i] >= 0) continue;
            throw new IllegalArgumentException(Messages.getString("security.9C"));
        }
    }

    public static String toString(int[] oid) {
        StringBuilder sb = new StringBuilder(3 * oid.length);
        for (int i = 0; i < oid.length - 1; ++i) {
            sb.append(oid[i]);
            sb.append('.');
        }
        sb.append(oid[oid.length - 1]);
        return sb.toString();
    }

    public static int[] toIntArray(String str) {
        return ObjectIdentifier.toIntArray(str, true);
    }

    public static boolean isOID(String str) {
        return ObjectIdentifier.toIntArray(str, false) != null;
    }

    public static int[] toIntArray(String str, boolean shouldThrow) {
        char c;
        if (str == null) {
            if (!shouldThrow) {
                return null;
            }
            throw new IllegalArgumentException(Messages.getString("security.9D"));
        }
        int length = str.length();
        if (length == 0) {
            if (!shouldThrow) {
                return null;
            }
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        int count = 1;
        boolean wasDot = true;
        for (int i = 0; i < length; ++i) {
            c = str.charAt(i);
            if (c == '.') {
                if (wasDot) {
                    if (!shouldThrow) {
                        return null;
                    }
                    throw new IllegalArgumentException(Messages.getString("security.9E"));
                }
                wasDot = true;
                ++count;
                continue;
            }
            if (c >= '0' && c <= '9') {
                wasDot = false;
                continue;
            }
            if (!shouldThrow) {
                return null;
            }
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        if (wasDot) {
            if (!shouldThrow) {
                return null;
            }
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        if (count < 2) {
            if (!shouldThrow) {
                return null;
            }
            throw new IllegalArgumentException(Messages.getString("security.99"));
        }
        int[] oid = new int[count];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            c = str.charAt(i);
            if (c == '.') {
                ++j;
                continue;
            }
            oid[j] = oid[j] * 10 + c - 48;
        }
        if (oid[0] > 2) {
            if (!shouldThrow) {
                return null;
            }
            throw new IllegalArgumentException(Messages.getString("security.9A"));
        }
        if (oid[0] != 2 && oid[1] > 39) {
            if (!shouldThrow) {
                return null;
            }
            throw new IllegalArgumentException(Messages.getString("security.9B"));
        }
        return oid;
    }
}

