/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.harmony.xnet.provider.jsse.CertificateMessage;
import org.apache.harmony.xnet.provider.jsse.CertificateRequest;
import org.apache.harmony.xnet.provider.jsse.CertificateVerify;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.ClientHello;
import org.apache.harmony.xnet.provider.jsse.ClientKeyExchange;
import org.apache.harmony.xnet.provider.jsse.ClientSessionContext;
import org.apache.harmony.xnet.provider.jsse.DelegatedTask;
import org.apache.harmony.xnet.provider.jsse.DigitalSignature;
import org.apache.harmony.xnet.provider.jsse.Finished;
import org.apache.harmony.xnet.provider.jsse.HandshakeProtocol;
import org.apache.harmony.xnet.provider.jsse.ProtocolVersion;
import org.apache.harmony.xnet.provider.jsse.SSLSessionImpl;
import org.apache.harmony.xnet.provider.jsse.SSLv3Constants;
import org.apache.harmony.xnet.provider.jsse.ServerHello;
import org.apache.harmony.xnet.provider.jsse.ServerHelloDone;
import org.apache.harmony.xnet.provider.jsse.ServerKeyExchange;

public class ClientHandshakeImpl
extends HandshakeProtocol {
    public ClientHandshakeImpl(Object owner) {
        super(owner);
    }

    public void start() {
        if (this.session == null) {
            this.session = this.findSessionToResume();
        } else {
            if (this.clientHello != null && this.status != 3) {
                return;
            }
            if (!this.session.isValid()) {
                this.session = null;
            }
        }
        if (this.session != null) {
            this.isResuming = true;
        } else if (this.parameters.getEnableSessionCreation()) {
            this.isResuming = false;
            this.session = new SSLSessionImpl(this.parameters.getSecureRandom());
            this.session.setPeer(this.engineOwner.getPeerHost(), this.engineOwner.getPeerPort());
            this.session.protocol = ProtocolVersion.getLatestVersion(this.parameters.getEnabledProtocols());
            this.recordProtocol.setVersion(this.session.protocol.version);
        } else {
            this.fatalAlert((byte)40, "SSL Session may not be created ");
        }
        this.startSession();
    }

    public void renegotiateNewSession() {
        if (this.parameters.getEnableSessionCreation()) {
            this.isResuming = false;
            this.session = new SSLSessionImpl(this.parameters.getSecureRandom());
            this.session.setPeer(this.engineOwner.getPeerHost(), this.engineOwner.getPeerPort());
            this.session.protocol = ProtocolVersion.getLatestVersion(this.parameters.getEnabledProtocols());
            this.recordProtocol.setVersion(this.session.protocol.version);
            this.startSession();
        } else {
            this.status = 2;
            this.sendWarningAlert((byte)100);
        }
    }

    public void startSession() {
        CipherSuite[] cipher_suites = this.isResuming ? new CipherSuite[]{this.session.cipherSuite} : this.parameters.getEnabledCipherSuitesMember();
        this.clientHello = new ClientHello(this.parameters.getSecureRandom(), this.session.protocol.version, this.session.id, cipher_suites);
        this.session.clientRandom = this.clientHello.random;
        this.send(this.clientHello);
        this.status = 1;
    }

    /*
     * Unable to fully structure code
     */
    public void unwrap(byte[] bytes) {
        if (this.delegatedTaskErr != null) {
            e = this.delegatedTaskErr;
            this.delegatedTaskErr = null;
            this.fatalAlert((byte)40, "Error in delegated task", e);
        }
        this.io_stream.append(bytes);
        block11: while (this.io_stream.available() > 0) {
            this.io_stream.mark();
            try {
                handshakeType = this.io_stream.read();
                length = this.io_stream.readUint24();
                if (this.io_stream.available() < length) {
                    this.io_stream.reset();
                    return;
                }
                switch (handshakeType) {
                    case 0: {
                        this.io_stream.removeFromMarkedPosition();
                        if (this.clientHello != null) {
                            if (this.clientFinished == null) continue block11;
                            if (this.serverFinished == null) break;
                        }
                        if (this.session.isValid()) {
                            this.session = (SSLSessionImpl)this.session.clone();
                            this.isResuming = true;
                            this.startSession();
                            break;
                        }
                        this.renegotiateNewSession();
                        break;
                    }
                    case 2: {
                        if (this.clientHello == null || this.serverHello != null) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.serverHello = new ServerHello(this.io_stream, length);
                        servProt = ProtocolVersion.getByVersion(this.serverHello.server_version);
                        enabled = this.parameters.getEnabledProtocols();
                        for (i = 0; i < enabled.length; ++i) {
                            if (!servProt.equals(ProtocolVersion.getByName(enabled[i]))) {
                                continue;
                            }
                            ** GOTO lbl39
                        }
                        this.fatalAlert((byte)40, "Bad server hello protocol version");
lbl39:
                        // 2 sources

                        if (this.serverHello.compression_method != 0) {
                            this.fatalAlert((byte)40, "Bad server hello compression method");
                        }
                        enabledSuites = this.parameters.getEnabledCipherSuitesMember();
                        for (i = 0; i < enabledSuites.length; ++i) {
                            if (!this.serverHello.cipher_suite.equals(enabledSuites[i])) {
                                continue;
                            }
                            ** GOTO lbl47
                        }
                        this.fatalAlert((byte)40, "Bad server hello cipher suite");
lbl47:
                        // 2 sources

                        if (this.isResuming) {
                            if (this.serverHello.session_id.length == 0) {
                                this.isResuming = false;
                            } else if (!Arrays.equals(this.serverHello.session_id, this.clientHello.session_id)) {
                                this.isResuming = false;
                            } else if (!this.session.protocol.equals(servProt)) {
                                this.fatalAlert((byte)40, "Bad server hello protocol version");
                            } else if (!this.session.cipherSuite.equals(this.serverHello.cipher_suite)) {
                                this.fatalAlert((byte)40, "Bad server hello cipher suite");
                            }
                            if (this.serverHello.server_version[1] == 1) {
                                this.computerReferenceVerifyDataTLS("server finished");
                            } else {
                                this.computerReferenceVerifyDataSSLv3(SSLv3Constants.server);
                            }
                        }
                        this.session.protocol = servProt;
                        this.recordProtocol.setVersion(this.session.protocol.version);
                        this.session.cipherSuite = this.serverHello.cipher_suite;
                        this.session.id = (byte[])this.serverHello.session_id.clone();
                        this.session.serverRandom = this.serverHello.random;
                        break;
                    }
                    case 11: {
                        if (this.serverHello == null || this.serverKeyExchange != null || this.serverCert != null || this.isResuming) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.serverCert = new CertificateMessage(this.io_stream, length);
                        break;
                    }
                    case 12: {
                        if (this.serverHello == null || this.serverKeyExchange != null || this.isResuming) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.serverKeyExchange = new ServerKeyExchange(this.io_stream, length, this.session.cipherSuite.keyExchange);
                        break;
                    }
                    case 13: {
                        if (this.serverCert == null || this.certificateRequest != null || this.session.cipherSuite.isAnonymous() || this.isResuming) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.certificateRequest = new CertificateRequest(this.io_stream, length);
                        break;
                    }
                    case 14: {
                        if (this.serverHello == null || this.serverHelloDone != null || this.isResuming) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.serverHelloDone = new ServerHelloDone(this.io_stream, length);
                        if (this.nonBlocking) {
                            this.delegatedTasks.add(new DelegatedTask(new PrivilegedExceptionAction<Void>(){

                                @Override
                                public Void run() throws Exception {
                                    ClientHandshakeImpl.this.processServerHelloDone();
                                    return null;
                                }
                            }, this, AccessController.getContext()));
                            return;
                        }
                        this.processServerHelloDone();
                        break;
                    }
                    case 20: {
                        if (!this.changeCipherSpecReceived) {
                            this.unexpectedMessage();
                            return;
                        }
                        this.serverFinished = new Finished(this.io_stream, length);
                        this.verifyFinished(this.serverFinished.getData());
                        this.session.lastAccessedTime = System.currentTimeMillis();
                        this.session.context = this.parameters.getClientSessionContext();
                        this.parameters.getClientSessionContext().putSession(this.session);
                        if (this.isResuming) {
                            this.sendChangeCipherSpec();
                            break;
                        }
                        this.session.lastAccessedTime = System.currentTimeMillis();
                        this.status = 3;
                        break;
                    }
                    default: {
                        this.unexpectedMessage();
                        return;
                    }
                }
            }
            catch (IOException e) {
                this.io_stream.reset();
                return;
            }
        }
    }

    public void unwrapSSLv2(byte[] bytes) {
        this.unexpectedMessage();
    }

    public void makeFinished() {
        byte[] verify_data;
        if (this.serverHello.server_version[1] == 1) {
            verify_data = new byte[12];
            this.computerVerifyDataTLS("client finished", verify_data);
        } else {
            verify_data = new byte[36];
            this.computerVerifyDataSSLv3(SSLv3Constants.client, verify_data);
        }
        this.clientFinished = new Finished(verify_data);
        this.send(this.clientFinished);
        if (this.isResuming) {
            this.session.lastAccessedTime = System.currentTimeMillis();
            this.status = 3;
        } else {
            if (this.serverHello.server_version[1] == 1) {
                this.computerReferenceVerifyDataTLS("server finished");
            } else {
                this.computerReferenceVerifyDataSSLv3(SSLv3Constants.server);
            }
            this.status = 1;
        }
    }

    public void processServerHelloDone() {
        PrivateKey clientKey = null;
        if (this.serverCert != null) {
            if (this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_DH_anon || this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_DH_anon_EXPORT) {
                this.unexpectedMessage();
                return;
            }
            this.verifyServerCert();
        } else if (this.session.cipherSuite.keyExchange != CipherSuite.KeyExchange_DH_anon && this.session.cipherSuite.keyExchange != CipherSuite.KeyExchange_DH_anon_EXPORT) {
            this.unexpectedMessage();
            return;
        }
        if (this.certificateRequest != null) {
            X509Certificate[] certs = null;
            String clientAlias = ((X509ExtendedKeyManager)this.parameters.getKeyManager()).chooseClientAlias(this.certificateRequest.getTypesAsString(), this.certificateRequest.certificate_authorities, null);
            if (clientAlias != null) {
                X509ExtendedKeyManager km = (X509ExtendedKeyManager)this.parameters.getKeyManager();
                certs = km.getCertificateChain(clientAlias);
                clientKey = km.getPrivateKey(clientAlias);
            }
            this.session.localCertificates = certs;
            this.clientCert = new CertificateMessage(certs);
            this.send(this.clientCert);
        }
        if (this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_RSA || this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_RSA_EXPORT) {
            Cipher c;
            try {
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                if (this.serverKeyExchange != null) {
                    c.init(1, this.serverKeyExchange.getRSAPublicKey());
                } else {
                    c.init(1, this.serverCert.certs[0]);
                }
            }
            catch (Exception e) {
                this.fatalAlert((byte)80, "Unexpected exception", e);
                return;
            }
            this.preMasterSecret = new byte[48];
            this.parameters.getSecureRandom().nextBytes(this.preMasterSecret);
            System.arraycopy(this.clientHello.client_version, 0, this.preMasterSecret, 0, 2);
            try {
                this.clientKeyExchange = new ClientKeyExchange(c.doFinal(this.preMasterSecret), this.serverHello.server_version[1] == 1);
            }
            catch (Exception e) {
                this.fatalAlert((byte)80, "Unexpected exception", e);
                return;
            }
        }
        KeyAgreement agreement = null;
        try {
            DHParameterSpec spec;
            PublicKey serverPublic;
            KeyFactory kf = null;
            try {
                kf = KeyFactory.getInstance("DH");
            }
            catch (NoSuchAlgorithmException e) {
                kf = KeyFactory.getInstance("DiffieHellman");
            }
            try {
                agreement = KeyAgreement.getInstance("DH");
            }
            catch (NoSuchAlgorithmException ee) {
                agreement = KeyAgreement.getInstance("DiffieHellman");
            }
            KeyPairGenerator kpg = null;
            try {
                kpg = KeyPairGenerator.getInstance("DH");
            }
            catch (NoSuchAlgorithmException e) {
                kpg = KeyPairGenerator.getInstance("DiffieHellman");
            }
            if (this.serverKeyExchange != null) {
                serverPublic = kf.generatePublic(new DHPublicKeySpec(this.serverKeyExchange.par3, this.serverKeyExchange.par1, this.serverKeyExchange.par2));
                spec = new DHParameterSpec(this.serverKeyExchange.par1, this.serverKeyExchange.par2);
            } else {
                serverPublic = this.serverCert.certs[0].getPublicKey();
                spec = ((DHPublicKey)serverPublic).getParams();
            }
            kpg.initialize(spec);
            KeyPair kp = kpg.generateKeyPair();
            Key key = kp.getPublic();
            if (this.clientCert != null && this.serverCert != null && (this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_DHE_RSA || this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_DHE_DSS)) {
                PublicKey client_pk = this.clientCert.certs[0].getPublicKey();
                PublicKey server_pk = this.serverCert.certs[0].getPublicKey();
                if (client_pk instanceof DHKey && server_pk instanceof DHKey && ((DHKey)((Object)client_pk)).getParams().getG().equals(((DHKey)((Object)server_pk)).getParams().getG()) && ((DHKey)((Object)client_pk)).getParams().getP().equals(((DHKey)((Object)server_pk)).getParams().getG())) {
                    this.clientKeyExchange = new ClientKeyExchange();
                }
            } else {
                this.clientKeyExchange = new ClientKeyExchange(((DHPublicKey)key).getY());
            }
            key = kp.getPrivate();
            agreement.init(key);
            agreement.doPhase(serverPublic, true);
            this.preMasterSecret = agreement.generateSecret();
        }
        catch (Exception e) {
            this.fatalAlert((byte)80, "Unexpected exception", e);
            return;
        }
        if (this.clientKeyExchange != null) {
            this.send(this.clientKeyExchange);
        }
        this.computerMasterSecret();
        if (this.clientCert != null && !this.clientKeyExchange.isEmpty()) {
            DigitalSignature ds = new DigitalSignature(this.session.cipherSuite.keyExchange);
            ds.init(clientKey);
            if (this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_RSA_EXPORT || this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_RSA || this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_DHE_RSA || this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_DHE_RSA_EXPORT) {
                ds.setMD5(this.io_stream.getDigestMD5());
                ds.setSHA(this.io_stream.getDigestSHA());
            } else if (this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_DHE_DSS || this.session.cipherSuite.keyExchange == CipherSuite.KeyExchange_DHE_DSS_EXPORT) {
                ds.setSHA(this.io_stream.getDigestSHA());
            }
            this.certificateVerify = new CertificateVerify(ds.sign());
            this.send(this.certificateVerify);
        }
        this.sendChangeCipherSpec();
    }

    public void verifyServerCert() {
        String authType = null;
        switch (this.session.cipherSuite.keyExchange) {
            case 1: {
                authType = "RSA";
                break;
            }
            case 2: {
                if (this.serverKeyExchange != null) {
                    authType = "RSA_EXPORT";
                    break;
                }
                authType = "RSA";
                break;
            }
            case 3: 
            case 4: {
                authType = "DHE_DSS";
                break;
            }
            case 5: 
            case 6: {
                authType = "DHE_RSA";
                break;
            }
            case 7: 
            case 11: {
                authType = "DH_DSS";
                break;
            }
            case 8: 
            case 12: {
                authType = "DH_RSA";
                break;
            }
            case 9: 
            case 10: {
                return;
            }
        }
        try {
            this.parameters.getTrustManager().checkServerTrusted(this.serverCert.certs, authType);
        }
        catch (CertificateException e) {
            this.fatalAlert((byte)42, "Not trusted server certificate", e);
            return;
        }
        this.session.peerCertificates = this.serverCert.certs;
    }

    public void receiveChangeCipherSpec() {
        if (this.isResuming) {
            if (this.serverHello == null) {
                this.unexpectedMessage();
            }
        } else if (this.clientFinished == null) {
            this.unexpectedMessage();
        }
        this.changeCipherSpecReceived = true;
    }

    public SSLSessionImpl findSessionToResume() {
        String host = null;
        int port = -1;
        if (this.engineOwner != null) {
            host = this.engineOwner.getPeerHost();
            port = this.engineOwner.getPeerPort();
        }
        if (host == null || port == -1) {
            return null;
        }
        ClientSessionContext context = this.parameters.getClientSessionContext();
        SSLSessionImpl session = (SSLSessionImpl)context.getSession(host, port);
        if (session != null) {
            session = (SSLSessionImpl)session.clone();
        }
        return session;
    }
}

