/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERUniversalString
extends DERObject
implements DERString {
    public static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public byte[] string;

    public static DERUniversalString getInstance(Object obj) {
        if (obj == null || obj instanceof DERUniversalString) {
            return (DERUniversalString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERUniversalString(((ASN1OctetString)obj).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERUniversalString.getInstance(obj.getObject());
    }

    public DERUniversalString(byte[] string2) {
        this.string = string2;
    }

    public String getString() {
        StringBuffer buf = new StringBuffer("#");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] string2 = bOut.toByteArray();
        for (int i = 0; i != string2.length; ++i) {
            buf.append(table[(string2[i] >>> 4) % 15]);
            buf.append(table[string2[i] & 0xF]);
        }
        return buf.toString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    public void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(28, this.getOctets());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)o).getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

