/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import com.android.ant.SingleDependencyTask;
import com.android.ant.TaskHelper;
import com.android.sdklib.internal.build.SymbolLoader;
import com.android.sdklib.internal.build.SymbolWriter;
import com.android.xml.AndroidXPathFactory;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;
import org.xml.sax.InputSource;

public final class AaptExecTask
extends SingleDependencyTask {
    private String mExecutable;
    private String mCommand;
    private boolean mForce = true;
    private boolean mDebug = false;
    private boolean mVerbose = false;
    private boolean mUseCrunchCache = false;
    private int mVersionCode = 0;
    private String mVersionName;
    private String mManifestFile;
    private String mManifestPackage;
    private String mOriginalManifestPackage;
    private ArrayList<Path> mResources;
    private String mAssets;
    private String mAndroidJar;
    private String mApkFolder;
    private String mApkName;
    private String mResourceFilter;
    private String mRFolder;
    private final ArrayList<NoCompress> mNoCompressList = new ArrayList();
    private String mLibraryResFolderPathRefid;
    private String mLibraryPackagesRefid;
    private String mLibraryRFileRefid;
    private boolean mNonConstantId;
    private String mIgnoreAssets;
    private String mBinFolder;
    private String mProguardFile;
    private static final SingleDependencyTask.InputPathFactory sPathFactory = new SingleDependencyTask.InputPathFactory(){

        @Override
        public InputPath createPath(File file, Set<String> set) {
            return new ResFolderInputPath(file, set);
        }
    };

    public void setExecutable(Path path) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", path);
    }

    public void setCommand(String string) {
        this.mCommand = string;
    }

    public void setForce(boolean bl) {
        this.mForce = bl;
    }

    public void setVerbose(boolean bl) {
        this.mVerbose = bl;
    }

    public void setNoCrunch(boolean bl) {
        this.mUseCrunchCache = bl;
    }

    public void setNonConstantId(boolean bl) {
        this.mNonConstantId = bl;
    }

    public void setIgnoreAssets(String string) {
        this.mIgnoreAssets = string;
    }

    public void setVersioncode(String string) {
        if (string.length() > 0) {
            try {
                this.mVersionCode = Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(String.format("WARNING: Ignoring invalid version code value '%s'.", string));
            }
        }
    }

    public void setVersionname(String string) {
        this.mVersionName = string;
    }

    public void setDebug(boolean bl) {
        this.mDebug = bl;
    }

    public void setManifest(Path path) {
        this.mManifestFile = TaskHelper.checkSinglePath("manifest", path);
    }

    public void setManifestpackage(String string) {
        if (string != null && string.length() != 0) {
            this.mManifestPackage = string;
        }
    }

    public void setOriginalManifestPackage(String string) {
        this.mOriginalManifestPackage = string;
    }

    @Deprecated
    public void setResources(Path path) {
        System.out.println("WARNNG: Using deprecated 'resources' attribute in AaptExecLoopTask.Use nested element(s) <res path=\"value\" /> instead.");
        if (this.mResources == null) {
            this.mResources = new ArrayList();
        }
        this.mResources.add(new Path(this.getProject(), path.toString()));
    }

    public void setAssets(Path path) {
        this.mAssets = TaskHelper.checkSinglePath("assets", path);
    }

    public void setAndroidjar(Path path) {
        this.mAndroidJar = TaskHelper.checkSinglePath("androidjar", path);
    }

    @Deprecated
    public void setOutfolder(Path path) {
        System.out.println("WARNNG: Using deprecated 'outfolder' attribute in AaptExecLoopTask.Use 'apkfolder' (path) instead.");
        this.mApkFolder = TaskHelper.checkSinglePath("outfolder", path);
    }

    public void setApkfolder(Path path) {
        this.mApkFolder = TaskHelper.checkSinglePath("apkfolder", path);
    }

    public void setResourcefilename(String string) {
        this.mApkName = string;
    }

    public void setRfolder(Path path) {
        this.mRFolder = TaskHelper.checkSinglePath("rfolder", path);
    }

    public void setresourcefilter(String string) {
        if (string != null && string.length() > 0) {
            this.mResourceFilter = string;
        }
    }

    public void setLibraryResFolderPathRefid(String string) {
        this.mLibraryResFolderPathRefid = string;
    }

    public void setLibraryPackagesRefid(String string) {
        this.mLibraryPackagesRefid = string;
    }

    public void setLibraryRFileRefid(String string) {
        this.mLibraryRFileRefid = string;
    }

    public void setBinFolder(Path path) {
        this.mBinFolder = TaskHelper.checkSinglePath("binFolder", path);
    }

    public void setProguardFile(Path path) {
        this.mProguardFile = TaskHelper.checkSinglePath("proguardFile", path);
    }

    public Object createNocompress() {
        NoCompress noCompress = new NoCompress();
        this.mNoCompressList.add(noCompress);
        return noCompress;
    }

    public Object createRes() {
        if (this.mResources == null) {
            this.mResources = new ArrayList();
        }
        Path path = new Path(this.getProject());
        this.mResources.add(path);
        return path;
    }

    protected String getExecTaskName() {
        return "aapt";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        void var9_26;
        Serializable serializable;
        Object object;
        if (this.mLibraryResFolderPathRefid == null) {
            throw new BuildException("Missing attribute libraryResFolderPathRefid");
        }
        if (this.mLibraryPackagesRefid == null) {
            throw new BuildException("Missing attribute libraryPackagesRefid");
        }
        if (this.mLibraryRFileRefid == null) {
            throw new BuildException("Missing attribute libraryRFileRefid");
        }
        Project project = this.getProject();
        String string = null;
        Path path = null;
        if (!this.mNonConstantId && this.mRFolder != null && new File(this.mRFolder).isDirectory()) {
            string = project.getProperty(this.mLibraryPackagesRefid);
            Object object2 = project.getReference(this.mLibraryRFileRefid);
            if ((string == null || object2 == null) && object2 != string) {
                throw new BuildException(String.format("Both %1$s and %2$s should resolve to valid values.", this.mLibraryPackagesRefid, this.mLibraryRFileRefid));
            }
            if (object2 instanceof Path) {
                path = (Path)object2;
            } else if (object2 != null) {
                throw new BuildException("attribute libraryRFileRefid must reference a Path object.");
            }
        }
        boolean bl = this.mRFolder != null && new File(this.mRFolder).isDirectory();
        Object object3 = project.getReference(this.mLibraryResFolderPathRefid);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Path path2 : this.mResources) {
            for (String string2 : path2.list()) {
                arrayList.add(new File(string2));
            }
        }
        if (object3 instanceof Path) {
            void var9_16;
            object = ((Path)object3).list();
            int n = ((String[])object).length;
            boolean bl2 = false;
            while (var9_16 < n) {
                String string3 = object[var9_16];
                arrayList.add(new File(string3));
                ++var9_16;
            }
        }
        if (bl) {
            object = AaptExecTask.getInputPaths(arrayList, Collections.singleton("xml"), sPathFactory);
            if (this.mManifestFile != null) {
                object.add(new InputPath(new File(this.mManifestFile)));
            }
            if (this.initDependencies(this.mRFolder + File.separator + "R.java.d", (List<InputPath>)object) && !this.dependenciesHaveChanged()) {
                System.out.println("No changed resources. R.java and Manifest.java untouched.");
                return;
            }
            System.out.println("Generating resource IDs...");
        } else {
            File file;
            object = AaptExecTask.getInputPaths(arrayList, null, sPathFactory);
            if (this.mManifestFile != null) {
                object.add(new InputPath(new File(this.mManifestFile)));
            }
            if (this.mAssets != null && (file = new File(this.mAssets)).isDirectory()) {
                object.add(new InputPath(file));
            }
            String string4 = this.mApkFolder + File.separator + this.mApkName;
            if (this.initDependencies(string4 = string4 + ".d", (List<InputPath>)object) && !this.dependenciesHaveChanged()) {
                System.out.println("No changed resources or assets. " + this.mApkName + " remains untouched");
                return;
            }
            if (this.mResourceFilter == null) {
                System.out.println("Creating full resource package...");
            } else {
                System.out.println(String.format("Creating resource package with filter: (%1$s)...", this.mResourceFilter));
            }
        }
        object = new ExecTask();
        object.setExecutable(this.mExecutable);
        object.setFailonerror(true);
        object.setTaskName(this.getExecTaskName());
        object.createArg().setValue(this.mCommand);
        if (this.mUseCrunchCache) {
            object.createArg().setValue("--no-crunch");
        }
        if (this.mNonConstantId) {
            object.createArg().setValue("--non-constant-id");
        }
        if (this.mForce) {
            object.createArg().setValue("-f");
        }
        if (this.mVerbose) {
            object.createArg().setValue("-v");
        }
        if (this.mDebug) {
            object.createArg().setValue("--debug-mode");
        }
        if (bl) {
            object.createArg().setValue("-m");
        }
        if (this.mResourceFilter != null && this.mResourceFilter.length() > 0) {
            object.createArg().setValue("-c");
            object.createArg().setValue(this.mResourceFilter);
        }
        boolean bl3 = false;
        for (NoCompress noCompress : this.mNoCompressList) {
            if (noCompress.mExtension != null) continue;
            object.createArg().setValue("-0");
            object.createArg().setValue("");
            bl3 = true;
            break;
        }
        if (!bl3) {
            for (NoCompress noCompress : this.mNoCompressList) {
                object.createArg().setValue("-0");
                object.createArg().setValue(noCompress.mExtension);
            }
        }
        if (this.mNonConstantId || string != null && string.length() > 0) {
            if (this.mBinFolder == null) {
                throw new BuildException("Missing attribute binFolder when compiling libraries or projects with libraries.");
            }
            object.createArg().setValue("--output-text-symbols");
            object.createArg().setValue(this.mBinFolder);
        }
        if (object3 != null) {
            object.createArg().setValue("--auto-add-overlay");
        }
        if (this.mVersionCode != 0) {
            object.createArg().setValue("--version-code");
            object.createArg().setValue(Integer.toString(this.mVersionCode));
        }
        if (this.mVersionName != null && this.mVersionName.length() > 0) {
            object.createArg().setValue("--version-name");
            object.createArg().setValue(this.mVersionName);
        }
        if (this.mManifestFile != null && this.mManifestFile.length() > 0) {
            object.createArg().setValue("-M");
            object.createArg().setValue(this.mManifestFile);
        }
        if (this.mManifestPackage != null) {
            object.createArg().setValue("--rename-manifest-package");
            object.createArg().setValue(this.mManifestPackage);
        }
        if (this.mResources.size() > 0) {
            for (Path path3 : this.mResources) {
                for (String string5 : path3.list()) {
                    serializable = new File(string5);
                    if (!((File)serializable).isDirectory()) continue;
                    object.createArg().setValue("-S");
                    object.createArg().setValue(string5);
                }
            }
        }
        if (object3 instanceof Path) {
            for (String string6 : ((Path)object3).list()) {
                File file = new File(string6);
                if (!file.isDirectory()) continue;
                object.createArg().setValue("-S");
                object.createArg().setValue(string6);
            }
        }
        if (this.mAssets != null && new File(this.mAssets).isDirectory()) {
            object.createArg().setValue("-A");
            object.createArg().setValue(this.mAssets);
        }
        if (this.mAndroidJar != null) {
            object.createArg().setValue("-I");
            object.createArg().setValue(this.mAndroidJar);
        }
        Object var9_24 = null;
        if (this.mApkName != null) {
            String string7 = this.mApkName;
        }
        if (var9_26 != null) {
            File file = new File(this.mApkFolder, (String)var9_26);
            object.createArg().setValue("-F");
            object.createArg().setValue(file.getAbsolutePath());
        }
        if (bl) {
            object.createArg().setValue("-J");
            object.createArg().setValue(this.mRFolder);
        }
        if (this.mIgnoreAssets != null && this.mIgnoreAssets.length() > 0) {
            object.createArg().setValue("--ignore-assets");
            object.createArg().setValue(this.mIgnoreAssets);
        }
        object.createArg().setValue("--generate-dependencies");
        if (this.mProguardFile != null && this.mProguardFile.length() > 0) {
            object.createArg().setValue("-G");
            object.createArg().setValue(this.mProguardFile);
        }
        object.setProject(project);
        object.setOwningTarget(this.getOwningTarget());
        object.execute();
        try {
            String string8;
            String[] stringArray;
            String[] stringArray2;
            if (this.mNonConstantId) return;
            if (string == null) return;
            if (string.isEmpty()) return;
            File file = new File(this.mBinFolder, "R.txt");
            if (!file.isFile()) return;
            SymbolLoader symbolLoader = new SymbolLoader(file);
            symbolLoader.load();
            if (string.startsWith(";")) {
                string = string.substring(1).trim();
            }
            if ((stringArray2 = string.split(";")).length != (stringArray = path.list()).length) {
                throw new BuildException(String.format("%1$s and %2$s must contain the same number of items.", this.mLibraryPackagesRefid, this.mLibraryRFileRefid));
            }
            if (this.mOriginalManifestPackage == null) {
                this.mOriginalManifestPackage = this.getPackageName(this.mManifestFile);
            }
            if (stringArray2.length == 1) {
                if (this.mOriginalManifestPackage.equals(stringArray2[0])) return;
                this.createRClass(symbolLoader, stringArray[0], stringArray2[0]);
                return;
            }
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)stringArray2.length);
            serializable = Sets.newHashSet();
            for (int i = 0; i < stringArray2.length; ++i) {
                String string9 = stringArray2[i];
                if (this.mOriginalManifestPackage.equals(string9)) continue;
                string8 = (String)hashMap.get(string9);
                if (string8 != null) {
                    serializable.add(string9);
                    continue;
                }
                hashMap.put(string9, stringArray[i]);
            }
            if (serializable.size() > 0) {
                if (serializable.size() == 1 && hashMap.size() == 1 && ((String)serializable.iterator().next()).equals(hashMap.keySet().iterator().next())) {
                    SymbolWriter symbolWriter = new SymbolWriter(this.mRFolder, (String)serializable.iterator().next(), symbolLoader, symbolLoader);
                    symbolWriter.write();
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The following packages have been found to be used by two or more libraries:");
                Iterator iterator = serializable.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        stringBuilder.append("\nNo libraries must share the same package, unless all libraries share the same packages.");
                        throw new BuildException(stringBuilder.toString());
                    }
                    string8 = (String)iterator.next();
                    stringBuilder.append("\n\t").append(string8);
                }
            }
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.createRClass(symbolLoader, (String)entry.getValue(), (String)entry.getKey());
            }
            return;
        }
        catch (Exception exception) {
            BuildException buildException;
            File file = new File(this.mRFolder, "R.java.d");
            file.delete();
            if (exception instanceof BuildException) {
                buildException = (BuildException)exception;
                throw buildException;
            }
            buildException = new BuildException((Throwable)exception);
            throw buildException;
        }
    }

    private void createRClass(SymbolLoader symbolLoader, String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isFile()) {
            SymbolLoader symbolLoader2 = new SymbolLoader(file);
            symbolLoader2.load();
            SymbolWriter symbolWriter = new SymbolWriter(this.mRFolder, string2, symbolLoader2, symbolLoader);
            symbolWriter.write();
        }
    }

    private String getPackageName(String string) {
        XPath xPath = AndroidXPathFactory.newXPath();
        try {
            String string2 = xPath.evaluate("/manifest/@package", new InputSource(new FileInputStream(string)));
            return string2;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new BuildException((Throwable)xPathExpressionException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException((Throwable)fileNotFoundException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResFolderInputPath
    extends InputPath {
        public ResFolderInputPath(File file, Set<String> set) {
            super(file, set);
        }

        @Override
        public boolean ignores(File file) {
            String string = file.getName();
            char c = string.charAt(0);
            if (c == '.' || c == '_' && file.isDirectory() || string.charAt(string.length() - 1) == '~') {
                return true;
            }
            if ("CVS".equals(string) || "thumbs.db".equalsIgnoreCase(string) || "picasa.ini".equalsIgnoreCase(string)) {
                return true;
            }
            String string2 = ResFolderInputPath.getExtension(string);
            return "scc".equalsIgnoreCase(string2);
        }
    }

    public static final class NoCompress {
        String mExtension;

        public void setExtension(String string) {
            this.mExtension = string;
        }
    }
}

