/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.SdkConstants;
import com.android.ant.TaskHelper;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.DeweyDecimal;

public class CheckEnvTask
extends Task {
    private static final String ANT_MIN_VERSION = "1.8.0";

    public void execute() {
        DeweyDecimal deweyDecimal = new DeweyDecimal(ANT_MIN_VERSION);
        Project project = this.getProject();
        DeweyDecimal deweyDecimal2 = this.getAntVersion(project);
        if (deweyDecimal.isGreaterThan(deweyDecimal2)) {
            throw new BuildException("The Android Ant-based build system requires Ant 1.8.0 or later. Current version is " + deweyDecimal2);
        }
        File file = TaskHelper.getSdkLocation(project);
        File file2 = new File(file, "platform-tools");
        if (!file2.isDirectory()) {
            throw new BuildException(String.format("SDK Platform Tools component is missing. Please install it with the SDK Manager (%1$s%2$c%3$s)", "tools", Character.valueOf(File.separatorChar), SdkConstants.androidCmdName()));
        }
        DeweyDecimal deweyDecimal3 = TaskHelper.getToolsRevision(file);
        if (deweyDecimal3 != null) {
            System.out.println("Android SDK Tools Revision " + deweyDecimal3);
            System.out.println("Installed at " + file.getAbsolutePath());
        }
    }

    private DeweyDecimal getAntVersion(Project project) {
        char[] cArray = project.getProperty("ant.version").toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isDigit(cArray[i])) {
                stringBuilder.append(cArray[i]);
                bl = true;
            }
            if (cArray[i] == '.' && bl) {
                stringBuilder.append(cArray[i]);
            }
            if (Character.isLetter(cArray[i]) && bl) break;
        }
        return new DeweyDecimal(stringBuilder.toString());
    }
}

