/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraph {
    private static final boolean DEBUG = false;
    private Set<File> mTargets = Collections.emptySet();
    private Set<File> mPrereqs = this.mTargets;
    private File mFirstPrereq = null;
    private boolean mMissingDepFile = false;
    private long mDepFileLastModified;
    private final List<InputPath> mNewInputs;

    public DependencyGraph(String string, List<InputPath> list) {
        this.mNewInputs = list;
        this.parseDependencyFile(string);
    }

    public boolean dependenciesHaveChanged(boolean bl) {
        if (this.mMissingDepFile) {
            System.out.println("No Dependency File Found");
            return true;
        }
        if (this.missingTargetFile()) {
            if (bl) {
                System.out.println("Found Deleted Target File");
            }
            return true;
        }
        long l = this.getOutputLastModified();
        DependencyStatus dependencyStatus = this.checkInputs(l);
        switch (dependencyStatus) {
            case ERROR: {
                throw new BuildException();
            }
            case NEW_FILE: {
                if (bl) {
                    System.out.println("Found new input file");
                }
                return true;
            }
            case UPDATED_FILE: {
                if (bl) {
                    System.out.println("Found modified input file");
                }
                return true;
            }
        }
        dependencyStatus = this.checkPrereqFiles(l);
        switch (dependencyStatus) {
            case ERROR: {
                throw new BuildException();
            }
            case MISSING_FILE: {
                if (bl) {
                    System.out.println("Found deleted input file");
                }
                return true;
            }
            case UPDATED_FILE: {
                if (bl) {
                    System.out.println("Found modified input file");
                }
                return true;
            }
        }
        return false;
    }

    public Set<File> getTargets() {
        return Collections.unmodifiableSet(this.mTargets);
    }

    public File getFirstPrereq() {
        return this.mFirstPrereq;
    }

    /*
     * WARNING - void declaration
     */
    private void parseDependencyFile(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            this.mMissingDepFile = true;
            return;
        }
        this.mDepFileLastModified = file.lastModified();
        List<String> list = DependencyGraph.readFile(file);
        if (list == null) {
            System.err.println("ERROR: Couldn't read " + string);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            void object2;
            String string3 = string2.trim();
            if (string3.endsWith("\\")) {
                String string4 = string3.substring(0, string3.length() - 1);
            }
            stringBuilder.append((String)object2);
        }
        String[] stringArray = stringBuilder.toString().split(":");
        String[] stringArray2 = stringArray[0].trim().split(" ");
        String[] stringArray3 = new String[]{};
        if (stringArray.length < 1) {
            System.err.println("Warning! Dependency file does not list any prerequisites after ':' ");
        } else {
            stringArray3 = stringArray[1].trim().split(" ");
        }
        this.mTargets = new HashSet<File>(stringArray2.length);
        for (String string5 : stringArray2) {
            if (string5.length() <= 0) continue;
            this.mTargets.add(new File(string5));
        }
        this.mPrereqs = new HashSet<File>(stringArray3.length);
        for (String string5 : stringArray3) {
            if (string5.length() <= 0) continue;
            File file2 = new File(string5);
            if (this.mFirstPrereq == null) {
                this.mFirstPrereq = file2;
            }
            this.mPrereqs.add(file2);
        }
    }

    private DependencyStatus checkInputs(long l) {
        if (this.mNewInputs != null) {
            for (InputPath inputPath : this.mNewInputs) {
                DependencyStatus dependencyStatus;
                File file = inputPath.getFile();
                if (!(file.isDirectory() ? (dependencyStatus = this.checkInputFolder(file, inputPath, l)) != DependencyStatus.NONE : file.isFile() && (dependencyStatus = this.checkInputFile(file, inputPath, l)) != DependencyStatus.NONE)) continue;
                return dependencyStatus;
            }
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkInputFolder(File file, InputPath inputPath, long l) {
        if (inputPath.ignores(file)) {
            return DependencyStatus.NONE;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            System.err.println("ERROR " + file.toString() + " is not a dir or can't be read");
            return DependencyStatus.ERROR;
        }
        for (File file2 : fileArray) {
            DependencyStatus dependencyStatus;
            if (!(file2.isDirectory() ? (dependencyStatus = this.checkInputFolder(file2, inputPath, l)) != DependencyStatus.NONE : file2.isFile() && (dependencyStatus = this.checkInputFile(file2, inputPath, l)) != DependencyStatus.NONE)) continue;
            return dependencyStatus;
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkInputFile(File file, InputPath inputPath, long l) {
        if (inputPath.ignores(file)) {
            return DependencyStatus.NONE;
        }
        if (!this.mPrereqs.remove(file)) {
            return DependencyStatus.NEW_FILE;
        }
        if (inputPath.checksForModification(file) && file.lastModified() > l) {
            return DependencyStatus.UPDATED_FILE;
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkPrereqFiles(long l) {
        for (File file : this.mPrereqs) {
            if (!file.exists()) {
                return DependencyStatus.MISSING_FILE;
            }
            if (this.mNewInputs != null) {
                String string = file.getAbsolutePath();
                for (InputPath inputPath : this.mNewInputs) {
                    File file2 = inputPath.getFile();
                    if (!(file2.isDirectory() ? string.startsWith(file2.getAbsolutePath()) && inputPath.checksForModification(file) && file.lastModified() > l : file.equals(file2) && inputPath.checksForModification(file) && file.lastModified() > l)) continue;
                    return DependencyStatus.UPDATED_FILE;
                }
                continue;
            }
            if (file.lastModified() <= l) continue;
            return DependencyStatus.UPDATED_FILE;
        }
        return DependencyStatus.NONE;
    }

    private boolean missingTargetFile() {
        for (File file : this.mTargets) {
            if (file.exists()) continue;
            return true;
        }
        return false;
    }

    private long getOutputLastModified() {
        long l = Long.MAX_VALUE;
        if (this.mTargets.size() == 0) {
            l = this.mDepFileLastModified;
        } else {
            for (File file : this.mTargets) {
                if (file.lastModified() >= l) continue;
                l = file.lastModified();
            }
        }
        return l;
    }

    private static List<String> readFile(File file) {
        try {
            return Files.readLines((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DependencyStatus {
        NONE,
        NEW_FILE,
        UPDATED_FILE,
        MISSING_FILE,
        ERROR;

    }
}

