/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.Nullable;
import com.android.ant.TaskHelper;
import com.android.io.FolderWrapper;
import com.android.io.IAbstractFolder;
import com.android.sdklib.build.JarListSanitizer;
import com.android.sdklib.internal.project.IPropertySource;
import com.android.sdklib.internal.project.ProjectProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyHelper {
    private final boolean mVerbose;
    private final File mProjectFolder;
    private final IPropertySource mProperties;
    private final List<File> mLibraries = new ArrayList<File>();

    public static List<File> sanitizePaths(File file, IPropertySource iPropertySource, List<File> list) {
        File file2;
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < list.size()) {
            file2 = list.get(n);
            if (file2.isFile() && !file2.getName().equals("classes.jar")) {
                ++n;
                continue;
            }
            arrayList.add(file2);
            list.remove(n);
        }
        File file3 = new File(file, DependencyHelper.getOutDir(iPropertySource));
        file2 = new JarListSanitizer(file3);
        try {
            arrayList.addAll(file2.sanitize(list));
        }
        catch (JarListSanitizer.DifferentLibException differentLibException) {
            String[] stringArray;
            for (String string : stringArray = differentLibException.getDetails()) {
                System.err.println(string);
            }
            throw new BuildException(differentLibException.getMessage(), (Throwable)differentLibException);
        }
        catch (JarListSanitizer.Sha1Exception sha1Exception) {
            throw new BuildException("Failed to compute sha1 for " + sha1Exception.getJarFile().getAbsolutePath(), (Throwable)sha1Exception);
        }
        return arrayList;
    }

    public DependencyHelper(File file, boolean bl) {
        this.mProjectFolder = file;
        this.mVerbose = bl;
        this.mProperties = TaskHelper.getProperties(file.getAbsolutePath());
        this.init(file);
    }

    public DependencyHelper(File file, IPropertySource iPropertySource, boolean bl) {
        this.mProjectFolder = file;
        this.mProperties = iPropertySource;
        this.mVerbose = bl;
        this.init(file);
    }

    private void init(File file) {
        List<File> list = this.getDirectDependencies(file, this.mProperties);
        this.resolveFullLibraryDependencies(list, this.mLibraries);
    }

    public List<File> getLibraries() {
        return this.mLibraries;
    }

    public int getLibraryCount() {
        return this.mLibraries.size();
    }

    public String getProperty(String string) {
        return this.mProperties.getProperty(string);
    }

    public void processLibraries(@Nullable LibraryProcessor libraryProcessor) {
        for (File file : this.mLibraries) {
            String string = file.getAbsolutePath();
            if (this.mVerbose) {
                System.out.println(string);
            }
            if (libraryProcessor == null) continue;
            libraryProcessor.processLibrary(string);
        }
    }

    public List<File> sanitizePaths(List<File> list) {
        return DependencyHelper.sanitizePaths(this.mProjectFolder, this.mProperties, list);
    }

    public String getOutDir() {
        return DependencyHelper.getOutDir(this.mProperties);
    }

    private List<File> getDirectDependencies(File file, IPropertySource iPropertySource) {
        String string;
        String string2;
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 1;
        while ((string2 = iPropertySource.getProperty(string = "android.library.reference." + Integer.toString(n++))) != null) {
            try {
                File file2 = new File(file, string2).getCanonicalFile();
                File file3 = new File(file2, ProjectProperties.PropertyType.PROJECT.getFilename());
                if (!file3.isFile()) {
                    throw new BuildException(String.format("%1$s resolve to a path with no %2$s file for project %3$s", string2, ProjectProperties.PropertyType.PROJECT.getFilename(), file.getAbsolutePath()));
                }
                if (arrayList.contains(file2)) continue;
                if (this.mVerbose) {
                    System.out.println(String.format("%1$s: %2$s => %3$s", file.getAbsolutePath(), string2, file2.getAbsolutePath()));
                }
                arrayList.add(file2);
            }
            catch (IOException iOException) {
                throw new BuildException("Failed to resolve library path: " + string2, (Throwable)iOException);
            }
        }
        return arrayList;
    }

    private void resolveFullLibraryDependencies(List<File> list, List<File> list2) {
        for (int i = list.size() - 1; i >= 0; --i) {
            File file = list.get(i);
            ProjectProperties projectProperties = ProjectProperties.load((IAbstractFolder)new FolderWrapper(file), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
            List<File> list3 = this.getDirectDependencies(file, (IPropertySource)projectProperties);
            this.resolveFullLibraryDependencies(list3, list2);
            if (list2.contains(file)) continue;
            list2.add(0, file);
        }
    }

    private static String getOutDir(IPropertySource iPropertySource) {
        String string = iPropertySource.getProperty("out.dir");
        if (string == null) {
            return "bin";
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JarProcessor
    extends AdvancedLibraryProcessor {
        private final List<File> mJars = new ArrayList<File>();
        private final FilenameFilter mFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase(Locale.US).endsWith(".jar");
            }
        };

        public List<File> getJars() {
            return this.mJars;
        }

        public FilenameFilter getFilter() {
            return this.mFilter;
        }

        @Override
        public void processLibrary(String string, IPropertySource iPropertySource) {
            this.mJars.add(new File(string + "/" + "bin" + "/" + "classes.jar"));
            File file = new File(string, "libs");
            File[] fileArray = file.listFiles(this.mFilter);
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    this.mJars.add(file2);
                }
            }
        }
    }

    public static abstract class AdvancedLibraryProcessor
    implements LibraryProcessor {
        public abstract void processLibrary(String var1, IPropertySource var2);

        public final void processLibrary(String string) {
            ProjectProperties projectProperties = TaskHelper.getProperties(string);
            this.processLibrary(string, (IPropertySource)projectProperties);
        }
    }

    protected static interface LibraryProcessor {
        public void processLibrary(String var1);
    }
}

