/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.ant.TaskHelper;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.utils.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class GetUiTargetTask
extends Task {
    private String mCompileClassPathOut;

    public void setCompileClassPathOut(String string) {
        this.mCompileClassPathOut = string;
    }

    public void execute() throws BuildException {
        if (this.mCompileClassPathOut == null) {
            throw new BuildException("Missing attribute compileClassPathOut");
        }
        Project project = this.getProject();
        File file = TaskHelper.getSdkLocation(project);
        String string = project.getProperty("target");
        if (string == null) {
            throw new BuildException("Android Target is not set.");
        }
        final ArrayList arrayList = new ArrayList();
        SdkManager sdkManager = SdkManager.createManager((String)file.getPath(), (ILogger)new ILogger(){

            public void error(Throwable throwable, String string, Object ... objectArray) {
                if (string != null) {
                    arrayList.add(String.format("Error: " + string, objectArray));
                }
                if (throwable != null) {
                    arrayList.add("Error: " + throwable.getMessage());
                }
            }

            public void info(@NonNull String string, Object ... objectArray) {
                arrayList.add(String.format(string, objectArray));
            }

            public void verbose(@NonNull String string, Object ... objectArray) {
                this.info(string, objectArray);
            }

            public void warning(@NonNull String string, Object ... objectArray) {
                arrayList.add(String.format("Warning: " + string, objectArray));
            }
        });
        if (sdkManager == null) {
            for (String string2 : arrayList) {
                System.out.println(string2);
            }
            throw new BuildException("Failed to parse SDK content.");
        }
        IAndroidTarget iAndroidTarget = sdkManager.getTargetFromHashString(string);
        if (iAndroidTarget == null) {
            throw new BuildException(String.format("Unable to resolve project target '%s'", string));
        }
        System.out.println("Project Target:   " + iAndroidTarget.getName());
        if (!iAndroidTarget.isPlatform()) {
            System.out.println("Vendor:           " + iAndroidTarget.getVendor());
            System.out.println("Platform Version: " + iAndroidTarget.getVersionName());
        }
        System.out.println("API level:        " + iAndroidTarget.getVersion().getApiString());
        if (iAndroidTarget.getVersion().getApiLevel() < 16) {
            throw new BuildException("UI Automator requires API 16");
        }
        String string3 = iAndroidTarget.getPath(1);
        String string4 = iAndroidTarget.getPath(27);
        Path path = new Path(project);
        Path.PathElement pathElement = path.createPathElement();
        pathElement.setPath(string3);
        pathElement = path.createPathElement();
        pathElement.setPath(string4);
        IAndroidTarget.IOptionalLibrary[] iOptionalLibraryArray = iAndroidTarget.getOptionalLibraries();
        if (iOptionalLibraryArray != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (IAndroidTarget.IOptionalLibrary iOptionalLibrary : iOptionalLibraryArray) {
                String string5 = iOptionalLibrary.getJarPath();
                if (hashSet.contains(string5)) continue;
                hashSet.add(string5);
                pathElement = path.createPathElement();
                pathElement.setPath(string5);
            }
        }
        project.addReference(this.mCompileClassPathOut, (Object)path);
    }
}

