/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.MultiFilesTask;
import com.android.ant.TaskHelper;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public class RenderScriptTask
extends MultiFilesTask {
    private static final Set<String> EXTENSIONS = Sets.newHashSetWithExpectedSize((int)2);
    private String mExecutable;
    private Path mIncludePath;
    private String mGenFolder;
    private String mResFolder;
    private final List<Path> mPaths = new ArrayList<Path>();
    private int mTargetApi = 0;
    private OptLevel mOptLevel;
    private boolean mDebug = false;

    public void setExecutable(Path path) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", path);
    }

    public void setIncludePathRefId(String string) {
        Object object = this.getProject().getReference(string);
        if (object instanceof Path) {
            this.mIncludePath = (Path)object;
        } else if (object != null) {
            throw new BuildException(string + " is expected to reference a Path object.");
        }
    }

    public void setGenFolder(Path path) {
        this.mGenFolder = TaskHelper.checkSinglePath("genFolder", path);
    }

    public void setResFolder(Path path) {
        this.mResFolder = TaskHelper.checkSinglePath("resFolder", path);
    }

    public void setTargetApi(String string) {
        try {
            this.mTargetApi = Integer.parseInt(string);
            if (this.mTargetApi <= 0) {
                throw new BuildException("targetApi attribute value must be >= 1");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("targetApi attribute value must be an integer", (Throwable)numberFormatException);
        }
    }

    public void setOptLevel(OptLevel optLevel) {
        this.mOptLevel = optLevel;
    }

    public void setBuildType(String string) {
        super.setBuildType(string);
        this.mDebug = Boolean.valueOf(string);
    }

    public Path createSource() {
        Path path = new Path(this.getProject());
        this.mPaths.add(path);
        return path;
    }

    public void execute() throws BuildException {
        if (this.mExecutable == null) {
            throw new BuildException("RenderScriptTask's 'executable' is required.");
        }
        if (this.mIncludePath == null) {
            throw new BuildException("RenderScriptTask's 'includePath' is required.");
        }
        if (this.mGenFolder == null) {
            throw new BuildException("RenderScriptTask's 'genFolder' is required.");
        }
        if (this.mResFolder == null) {
            throw new BuildException("RenderScriptTask's 'resFolder' is required.");
        }
        if (this.mTargetApi == 0) {
            throw new BuildException("RenderScriptTask's 'targetApi' is required.");
        }
        this.processFiles(new RenderScriptProcessor(this.mTargetApi), this.mPaths, this.mGenFolder);
    }

    static {
        EXTENSIONS.add("rs");
        EXTENSIONS.add("fs");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RenderScriptProcessor
    implements MultiFilesTask.SourceProcessor {
        private final String mTargetApiStr;

        public RenderScriptProcessor(int n) {
            this.mTargetApiStr = Integer.toString(RenderScriptTask.this.mTargetApi < 11 ? 11 : RenderScriptTask.this.mTargetApi);
        }

        @Override
        public Set<String> getSourceFileExtensions() {
            return EXTENSIONS;
        }

        @Override
        public void process(String string, String string2, List<String> list, Project project) {
            File file = new File(RenderScriptTask.this.mExecutable);
            String string3 = file.getName();
            ExecTask execTask = new ExecTask();
            execTask.setTaskName(string3);
            execTask.setProject(project);
            execTask.setOwningTarget(RenderScriptTask.this.getOwningTarget());
            execTask.setExecutable(RenderScriptTask.this.mExecutable);
            execTask.setFailonerror(true);
            for (String string4 : RenderScriptTask.this.mIncludePath.list()) {
                File file2 = new File(string4);
                if (file2.isDirectory()) {
                    execTask.createArg().setValue("-I");
                    execTask.createArg().setValue(string4);
                    continue;
                }
                System.out.println(String.format("WARNING: RenderScript include directory '%s' does not exist!", file2.getAbsolutePath()));
            }
            if (RenderScriptTask.this.mDebug) {
                execTask.createArg().setValue("-g");
            }
            execTask.createArg().setValue("-O");
            execTask.createArg().setValue(Integer.toString(RenderScriptTask.this.mOptLevel.ordinal()));
            execTask.createArg().setValue("-target-api");
            execTask.createArg().setValue(this.mTargetApiStr);
            execTask.createArg().setValue("-d");
            execTask.createArg().setValue(this.getDependencyFolder(string, string2));
            execTask.createArg().setValue("-MD");
            execTask.createArg().setValue("-p");
            execTask.createArg().setValue(RenderScriptTask.this.mGenFolder);
            execTask.createArg().setValue("-o");
            execTask.createArg().setValue(RenderScriptTask.this.mResFolder);
            execTask.createArg().setValue(string);
            execTask.execute();
        }

        @Override
        public void displayMessage(MultiFilesTask.DisplayType displayType, int n) {
            switch (displayType) {
                case FOUND: {
                    System.out.println(String.format("Found %1$d RenderScript files.", n));
                    break;
                }
                case COMPILING: {
                    if (n > 0) {
                        System.out.println(String.format("Compiling %1$d RenderScript files with -target-api %2$d", n, RenderScriptTask.this.mTargetApi));
                        System.out.println(String.format("Optimization Level: %1$d", RenderScriptTask.this.mOptLevel.ordinal()));
                        break;
                    }
                    System.out.println("No RenderScript files to compile.");
                    break;
                }
                case REMOVE_OUTPUT: {
                    System.out.println(String.format("Found %1$d obsolete output files to remove.", n));
                    break;
                }
                case REMOVE_DEP: {
                    System.out.println(String.format("Found %1$d obsolete dependency files to remove.", n));
                }
            }
        }

        private String getDependencyFolder(String string, String string2) {
            String string3 = string.substring(string2.length());
            if (string3.charAt(0) == '/') {
                string3 = string3.substring(1);
            }
            return new File(RenderScriptTask.this.mGenFolder, string3).getParent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptLevel {
        O0,
        O1,
        O2,
        O3;

    }
}

