/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.BuildTypedTask;
import com.android.ant.DependencyGraph;
import com.android.ant.InputPath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleDependencyTask
extends BuildTypedTask {
    private DependencyGraph mDependencies;
    private static final InputPathFactory sDefaultFactory = new InputPathFactory(){

        @Override
        public InputPath createPath(File file, Set<String> set) {
            return new InputPath(file, set);
        }
    };

    protected abstract String getExecTaskName();

    protected static List<InputPath> getInputPaths(List<File> list, Set<String> set, InputPathFactory inputPathFactory) {
        ArrayList<InputPath> arrayList = new ArrayList<InputPath>(list.size());
        if (inputPathFactory == null) {
            inputPathFactory = sDefaultFactory;
        }
        for (File file : list) {
            arrayList.add(inputPathFactory.createPath(file, set));
        }
        return arrayList;
    }

    protected boolean initDependencies(String string, List<InputPath> list) {
        if (this.hasBuildTypeChanged()) {
            return true;
        }
        File file = new File(string);
        if (file.exists()) {
            this.mDependencies = new DependencyGraph(string, list);
            return true;
        }
        return false;
    }

    protected boolean dependenciesHaveChanged() {
        if (this.hasBuildTypeChanged()) {
            if (!this.isNewBuild()) {
                String string = this.getExecTaskName();
                if (string == null) {
                    System.out.println("Current build type is different than previous build: forced task run.");
                } else {
                    System.out.println("Current build type is different than previous build: forced " + string + " run.");
                }
            }
            return true;
        }
        assert (this.mDependencies != null) : "Dependencies have not been initialized";
        return this.mDependencies.dependenciesHaveChanged(true);
    }

    protected void generateDependencyFile(String string, List<InputPath> list, String string2) {
        File file = new File(string);
        try {
            PrintStream printStream = new PrintStream(file);
            printStream.print(string2);
            printStream.println(" : \\");
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                InputPath inputPath = list.get(i);
                File file2 = inputPath.getFile();
                if (file2.isDirectory()) {
                    this.writeContent(printStream, file2, inputPath);
                    continue;
                }
                printStream.print(file2.getAbsolutePath());
                printStream.println(" \\");
            }
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            new BuildException((Throwable)fileNotFoundException);
        }
    }

    private void writeContent(PrintStream printStream, File file, InputPath inputPath) {
        if (inputPath.ignores(file)) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.writeContent(printStream, file2, inputPath);
                    continue;
                }
                if (inputPath.ignores(file2)) continue;
                printStream.print(file2.getAbsolutePath());
                printStream.println(" \\");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InputPathFactory {
        public InputPath createPath(File var1, Set<String> var2);
    }
}

