/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.SingleInputOutputTask;
import com.android.ant.TaskHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public class ZipAlignTask
extends SingleInputOutputTask {
    private String mExecutable;
    private int mAlign = 4;
    private boolean mVerbose = false;

    public void setExecutable(Path path) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", path);
    }

    public void setAlign(int n) {
        this.mAlign = n;
    }

    public void setVerbose(boolean bl) {
        this.mVerbose = bl;
    }

    public void createOutput() throws BuildException {
        if (this.mExecutable == null) {
            throw new BuildException("Missing attribute executable");
        }
        System.out.println("Running zip align on final apk...");
        this.doZipAlign();
    }

    private void doZipAlign() {
        ExecTask execTask = new ExecTask();
        execTask.setExecutable(this.mExecutable);
        execTask.setFailonerror(true);
        execTask.setProject(this.getProject());
        execTask.setOwningTarget(this.getOwningTarget());
        execTask.setTaskName("zip-align");
        execTask.createArg().setValue("-f");
        if (this.mVerbose) {
            execTask.createArg().setValue("-v");
        }
        execTask.createArg().setValue(Integer.toString(this.mAlign));
        execTask.createArg().setValue(this.getInput());
        execTask.createArg().setValue(this.getOutput());
        execTask.execute();
    }
}

