/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.adb;

import com.android.SdkConstants;
import com.android.chimpchat.adb.AdbChimpDevice;
import com.android.chimpchat.core.IChimpBackend;
import com.android.chimpchat.core.IChimpDevice;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AdbBackend
implements IChimpBackend {
    private static Logger LOG = Logger.getLogger(AdbBackend.class.getCanonicalName());
    private static final int CONNECTION_ITERATION_TIMEOUT_MS = 200;
    private final List<IChimpDevice> devices = Lists.newArrayList();
    private final AndroidDebugBridge bridge;
    private final boolean initAdb;

    public AdbBackend() {
        this(null, false);
    }

    public AdbBackend(String string, boolean bl) {
        boolean bl2 = this.initAdb = !bl;
        if (string == null) {
            string = this.findAdb();
        }
        if (this.initAdb) {
            AndroidDebugBridge.init((boolean)false);
        }
        this.bridge = AndroidDebugBridge.createBridge((String)string, (boolean)true);
    }

    private String findAdb() {
        String string = System.getProperty("com.android.monkeyrunner.bindir");
        if (string != null && string.length() != 0) {
            File file = new File(new File(string).getParent(), "platform-tools");
            if (file.isDirectory()) {
                return file.getAbsolutePath() + File.separator + SdkConstants.FN_ADB;
            }
            return string + File.separator + SdkConstants.FN_ADB;
        }
        return SdkConstants.FN_ADB;
    }

    private IDevice findAttachedDevice(String string) {
        Pattern pattern = Pattern.compile(string);
        for (IDevice iDevice : this.bridge.getDevices()) {
            String string2 = iDevice.getSerialNumber();
            if (!pattern.matcher(string2).matches()) continue;
            return iDevice;
        }
        return null;
    }

    public IChimpDevice waitForConnection() {
        return this.waitForConnection(Integer.MAX_VALUE, ".*");
    }

    public IChimpDevice waitForConnection(long l, String string) {
        do {
            IDevice iDevice;
            if ((iDevice = this.findAttachedDevice(string)) != null && iDevice.getState() == IDevice.DeviceState.ONLINE) {
                AdbChimpDevice adbChimpDevice = new AdbChimpDevice(iDevice);
                this.devices.add(adbChimpDevice);
                return adbChimpDevice;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.SEVERE, "Error sleeping", interruptedException);
            }
        } while ((l -= 200L) > 0L);
        return null;
    }

    public void shutdown() {
        for (IChimpDevice iChimpDevice : this.devices) {
            iChimpDevice.dispose();
        }
        if (this.initAdb) {
            AndroidDebugBridge.terminate();
        }
    }
}

