/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.adb;

public class LinearInterpolator {
    private final int steps;

    public LinearInterpolator(int n) {
        this.steps = n;
    }

    private static float lerp(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public void interpolate(Point point, Point point2, Callback callback) {
        int n = Math.abs(point2.getX() - point.getX());
        int n2 = Math.abs(point2.getY() - point.getY());
        float f = (float)(1.0 / (double)this.steps);
        callback.start(point);
        for (int i = 1; i < this.steps; ++i) {
            float f2 = LinearInterpolator.lerp(point.getX(), point2.getX(), f * (float)i);
            float f3 = LinearInterpolator.lerp(point.getY(), point2.getY(), f * (float)i);
            callback.step(new Point(Math.round(f2), Math.round(f3)));
        }
        callback.end(point2);
    }

    public static interface Callback {
        public void start(Point var1);

        public void end(Point var1);

        public void step(Point var1);
    }

    public static class Point {
        private final int x;
        private final int y;

        public Point(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }

        public boolean equals(Object object) {
            if (object instanceof Point) {
                Point point = (Point)object;
                return this.x == point.x && this.y == point.y;
            }
            return false;
        }

        public int hashCode() {
            return 1125274389 + this.x + this.y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

