/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.core;

import com.android.chimpchat.core.IChimpImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public abstract class ChimpImageBase
implements IChimpImage {
    private static Logger LOG = Logger.getLogger(ChimpImageBase.class.getCanonicalName());
    private WeakReference<BufferedImage> cachedBufferedImage = null;

    public abstract BufferedImage createBufferedImage();

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage;
        if (this.cachedBufferedImage != null && (bufferedImage = (BufferedImage)this.cachedBufferedImage.get()) != null) {
            return bufferedImage;
        }
        bufferedImage = this.createBufferedImage();
        this.cachedBufferedImage = new WeakReference<BufferedImage>(bufferedImage);
        return bufferedImage;
    }

    public byte[] convertToBytes(String string) {
        BufferedImage bufferedImage = this.convertSnapshot();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return new byte[0];
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToFile(String string, String string2) {
        if (string2 != null) {
            return this.writeToFileHelper(string, string2);
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return this.writeToFileHelper(string, "png");
        }
        String string3 = string.substring(n + 1);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(string3);
        if (!iterator.hasNext()) {
            return this.writeToFileHelper(string, "png");
        }
        ImageWriter imageWriter = iterator.next();
        BufferedImage bufferedImage = this.convertSnapshot();
        try {
            File file = new File(string);
            file.delete();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
            imageWriter.setOutput(imageOutputStream);
            try {
                imageWriter.write(bufferedImage);
            }
            finally {
                imageWriter.dispose();
                imageOutputStream.flush();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public int getPixel(int n, int n2) {
        BufferedImage bufferedImage = this.getBufferedImage();
        return bufferedImage.getRGB(n, n2);
    }

    private BufferedImage convertSnapshot() {
        BufferedImage bufferedImage = this.getBufferedImage();
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private boolean writeToFileHelper(String string, String string2) {
        BufferedImage bufferedImage = this.convertSnapshot();
        try {
            ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean sameAs(IChimpImage iChimpImage, double d) {
        BufferedImage bufferedImage = iChimpImage.getBufferedImage();
        BufferedImage bufferedImage2 = this.getBufferedImage();
        if (bufferedImage.getWidth() != bufferedImage2.getWidth()) {
            return false;
        }
        if (bufferedImage.getHeight() != bufferedImage2.getHeight()) {
            return false;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (bufferedImage2.getRGB(j, i) == bufferedImage.getRGB(j, i)) continue;
                ++n3;
            }
        }
        double d2 = n2 * n;
        double d3 = (double)n3 / d2;
        return d <= 1.0 - d3;
    }

    public static IChimpImage loadImageFromFile(String string) {
        File file = new File(string);
        if (file.exists() && file.canRead()) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new File(string));
                if (bufferedImage == null) {
                    LOG.log(Level.WARNING, "Cannot decode file %s", string);
                    return null;
                }
                return new BufferedImageChimpImage(bufferedImage);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Exception trying to decode image", iOException);
                return null;
            }
        }
        LOG.log(Level.WARNING, "Cannot read file %s", string);
        return null;
    }

    public IChimpImage getSubImage(int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = this.getBufferedImage();
        return new BufferedImageChimpImage(bufferedImage.getSubimage(n, n2, n3, n4));
    }

    private static class BufferedImageChimpImage
    extends ChimpImageBase {
        private final BufferedImage image;

        public BufferedImageChimpImage(BufferedImage bufferedImage) {
            this.image = bufferedImage;
        }

        public BufferedImage createBufferedImage() {
            return this.image;
        }
    }
}

