/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.hierarchyviewer;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.hierarchyviewerlib.device.DeviceBridge;
import com.android.hierarchyviewerlib.device.ViewNode;
import com.android.hierarchyviewerlib.device.Window;
import org.eclipse.swt.graphics.Point;

public class HierarchyViewer {
    public static final String TAG = "hierarchyviewer";
    private IDevice mDevice;

    public HierarchyViewer(IDevice iDevice) {
        this.mDevice = iDevice;
        this.setupViewServer();
    }

    private void setupViewServer() {
        DeviceBridge.setupDeviceForward((IDevice)this.mDevice);
        if (!DeviceBridge.isViewServerRunning((IDevice)this.mDevice) && !DeviceBridge.startViewServer((IDevice)this.mDevice)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!DeviceBridge.startViewServer((IDevice)this.mDevice)) {
                Log.e((String)TAG, (String)("Unable to debug device " + this.mDevice));
                throw new RuntimeException("Could not connect to the view server");
            }
            return;
        }
        DeviceBridge.loadViewServerInfo((IDevice)this.mDevice);
    }

    public ViewNode findViewById(String string) {
        ViewNode viewNode = DeviceBridge.loadWindowData((Window)new Window(this.mDevice, "", -1));
        if (viewNode == null) {
            throw new RuntimeException("Could not dump view");
        }
        return this.findViewById(string, viewNode);
    }

    public ViewNode findViewById(String string, ViewNode viewNode) {
        if (viewNode.id.equals(string)) {
            return viewNode;
        }
        for (ViewNode viewNode2 : viewNode.children) {
            ViewNode viewNode3 = this.findViewById(string, viewNode2);
            if (viewNode3 == null) continue;
            return viewNode3;
        }
        return null;
    }

    public String getFocusedWindowName() {
        Window[] windowArray;
        int n = DeviceBridge.getFocusedWindow((IDevice)this.mDevice);
        for (Window window : windowArray = DeviceBridge.loadWindows((IDevice)this.mDevice)) {
            if (window.getHashCode() != n) continue;
            return window.getTitle();
        }
        return null;
    }

    public static Point getAbsolutePositionOfView(ViewNode viewNode) {
        int n = viewNode.left;
        int n2 = viewNode.top;
        ViewNode viewNode2 = viewNode.parent;
        while (viewNode2 != null) {
            n += viewNode2.left - viewNode2.scrollX;
            n2 += viewNode2.top - viewNode2.scrollY;
            viewNode2 = viewNode2.parent;
        }
        return new Point(n, n2);
    }

    public static Point getAbsoluteCenterOfView(ViewNode viewNode) {
        Point point = HierarchyViewer.getAbsolutePositionOfView(viewNode);
        return new Point(point.x + viewNode.width / 2, point.y + viewNode.height / 2);
    }

    public boolean visible(ViewNode viewNode) {
        boolean bl = viewNode != null && viewNode.namedProperties.containsKey("getVisibility()") && "VISIBLE".equalsIgnoreCase(((ViewNode.Property)viewNode.namedProperties.get((Object)"getVisibility()")).value);
        return bl;
    }

    public String getText(ViewNode viewNode) {
        if (viewNode == null) {
            throw new RuntimeException("Node not found");
        }
        ViewNode.Property property = (ViewNode.Property)viewNode.namedProperties.get("text:mText");
        if (property == null && (property = (ViewNode.Property)viewNode.namedProperties.get("mText")) == null) {
            throw new RuntimeException("No text property on node");
        }
        return property.value;
    }
}

