/*
 * Decompiled with CFR 0.152.
 */
package com.android.io;

import com.android.io.FolderWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public class FileWrapper
extends File
implements IAbstractFile {
    private static final long serialVersionUID = 1L;

    public FileWrapper(File file) {
        super(file.getAbsolutePath());
    }

    public FileWrapper(File file, String string) {
        super(file, string);
    }

    public FileWrapper(String string) {
        super(string);
    }

    public FileWrapper(String string, String string2) {
        super(string, string2);
    }

    public FileWrapper(URI uRI) {
        super(uRI);
    }

    public InputStream getContents() throws StreamException {
        try {
            return new FileInputStream(this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new StreamException(fileNotFoundException, this, StreamException.Error.FILENOTFOUND);
        }
    }

    public void setContents(InputStream inputStream) throws StreamException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new StreamException(iOException, this);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new StreamException(iOException, this);
                }
            }
        }
    }

    public OutputStream getOutputStream() throws StreamException {
        try {
            return new FileOutputStream(this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new StreamException(fileNotFoundException, this);
        }
    }

    public IAbstractFile.PreferredWriteMode getPreferredWriteMode() {
        return IAbstractFile.PreferredWriteMode.OUTPUTSTREAM;
    }

    public String getOsLocation() {
        return this.getAbsolutePath();
    }

    public boolean exists() {
        return this.isFile();
    }

    public long getModificationStamp() {
        return this.lastModified();
    }

    public IAbstractFolder getParentFolder() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new FolderWrapper(string);
    }
}

