/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import java.text.NumberFormat;
import java.text.ParseException;

public class SdkUtils {
    private static String sLineSeparator;

    public static boolean endsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
    }

    public static boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        return SdkUtils.endsWith(charSequence, charSequence.length(), charSequence2);
    }

    public static boolean endsWith(CharSequence charSequence, int n, CharSequence charSequence2) {
        if (n < charSequence2.length()) {
            return false;
        }
        int n2 = n - 1;
        for (int i = charSequence2.length() - 1; i >= 0; --i) {
            if (charSequence.charAt(n2) != charSequence2.charAt(i)) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static boolean startsWith(String string, int n, String string2) {
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    public static String stripWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean hasUpperCaseCharacter(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static String getLineSeparator() {
        if (sLineSeparator == null) {
            sLineSeparator = System.getProperty("line.separator");
        }
        return sLineSeparator;
    }

    @NonNull
    public static String wrap(@NonNull String string, int n, @Nullable String string2) {
        if (string2 == null) {
            string2 = "";
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = string.indexOf(10, n3);
            if (n5 != -1 && n5 - n3 < n) {
                n4 = n5 + 1;
            } else {
                n5 = Math.min(n3 + n, n2);
                if (n5 - n3 < n) {
                    n4 = n2;
                } else {
                    int n6 = string.lastIndexOf(32, n5);
                    if (n6 > n3) {
                        n5 = n6;
                        n4 = n6 + 1;
                    } else {
                        n4 = n5 + 1;
                    }
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string2);
            } else {
                n -= string2.length();
            }
            stringBuilder.append(string.substring(n3, n5));
            stringBuilder.append('\n');
            n3 = n4;
        }
        return stringBuilder.toString();
    }

    public static int parseLocalizedInt(@NonNull String string) throws ParseException {
        if (string.isEmpty()) {
            return 0;
        }
        return NumberFormat.getIntegerInstance().parse(string).intValue();
    }

    public static int parseLocalizedInt(@NonNull String string, int n) {
        try {
            return SdkUtils.parseLocalizedInt(string);
        }
        catch (ParseException parseException) {
            return n;
        }
    }

    public static double parseLocalizedDouble(@NonNull String string) throws ParseException {
        if (string.isEmpty()) {
            return 0.0;
        }
        return NumberFormat.getNumberInstance().parse(string).doubleValue();
    }

    public static double parseLocalizedDouble(@NonNull String string, double d) {
        try {
            return SdkUtils.parseLocalizedDouble(string);
        }
        catch (ParseException parseException) {
            return d;
        }
    }
}

