/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.google.common.base.Splitter;
import java.util.HashSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    @NonNull
    public static String lookupNamespacePrefix(@NonNull Node node, @NonNull String string) {
        String string2 = "http://schemas.android.com/apk/res/android".equals(string) ? "android" : "app";
        return XmlUtils.lookupNamespacePrefix(node, string, string2, true);
    }

    @NonNull
    public static String lookupNamespacePrefix(@NonNull Node node, @NonNull String string, boolean bl) {
        String string2 = "http://schemas.android.com/apk/res/android".equals(string) ? "android" : "app";
        return XmlUtils.lookupNamespacePrefix(node, string, string2, bl);
    }

    public static String lookupNamespacePrefix(@Nullable Node node, @Nullable String string, @Nullable String string2, boolean bl) {
        Object object;
        if (string == null) {
            return null;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return "xmlns";
        }
        HashSet<String> hashSet = new HashSet<String>();
        Document document = node == null ? null : node.getOwnerDocument();
        String string3 = null;
        try {
            String string4 = string3 = document != null ? document.lookupPrefix(string) : null;
            if (string3 != null) {
                return string3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        while (node != null && node.getNodeType() == 1) {
            object = node.getAttributes();
            for (int i = object.getLength() - 1; i >= 0; --i) {
                Node node2 = object.item(i);
                if (!"xmlns".equals(node2.getPrefix())) continue;
                String string5 = node2.getNodeValue();
                string3 = node2.getLocalName();
                if (string.equals(string5)) {
                    return string3;
                }
                hashSet.add(string3);
            }
            node = node.getParentNode();
        }
        if (string2 == null) {
            return null;
        }
        object = string2;
        String string6 = object;
        int n = 1;
        while (hashSet.contains(object)) {
            object = string6 + Integer.toString(n);
            ++n;
        }
        if (document != null) {
            for (node = document.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
            if (node != null && bl) {
                Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)object);
                attr.setValue(string);
                node.getAttributes().setNamedItemNS(attr);
            }
        }
        return object;
    }

    @NonNull
    public static String toXmlAttributeValue(@NonNull String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\'' && c != '<' && c != '&') continue;
            StringBuilder stringBuilder = new StringBuilder(2 * string.length());
            XmlUtils.appendXmlAttributeValue(stringBuilder, string);
            return stringBuilder.toString();
        }
        return string;
    }

    @NonNull
    public static String toXmlTextValue(@NonNull String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '<' && c != '&') continue;
            StringBuilder stringBuilder = new StringBuilder(2 * string.length());
            XmlUtils.appendXmlTextValue(stringBuilder, string);
            return stringBuilder.toString();
        }
        return string;
    }

    public static void appendXmlAttributeValue(@NonNull StringBuilder stringBuilder, @NonNull String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("&apos;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            stringBuilder.append(c);
        }
    }

    public static void appendXmlTextValue(@NonNull StringBuilder stringBuilder, @NonNull String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            stringBuilder.append(c);
        }
    }

    public static String toXml(Node node, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        XmlUtils.append(stringBuilder, node, 0, bl);
        return stringBuilder.toString();
    }

    private static void indent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("    ");
        }
    }

    private static void append(@NonNull StringBuilder stringBuilder, @NonNull Node node, int n, boolean bl) {
        short s = node.getNodeType();
        switch (s) {
            case 9: 
            case 11: {
                stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                NodeList nodeList = node.getChildNodes();
                int n2 = nodeList.getLength();
                for (int i = 0; i < n2; ++i) {
                    XmlUtils.append(stringBuilder, nodeList.item(i), n, bl);
                }
                break;
            }
            case 3: 
            case 8: {
                if (s == 8) {
                    if (!bl) {
                        XmlUtils.indent(stringBuilder, n);
                    }
                    stringBuilder.append("<!--");
                    if (!bl) {
                        stringBuilder.append('\n');
                    }
                }
                String string = node.getNodeValue();
                if (!bl) {
                    string = string.trim();
                    for (String string2 : Splitter.on((char)'\n').split((CharSequence)string)) {
                        XmlUtils.indent(stringBuilder, n + 1);
                        stringBuilder.append(XmlUtils.toXmlTextValue(string2));
                        stringBuilder.append('\n');
                    }
                } else {
                    stringBuilder.append(XmlUtils.toXmlTextValue(string));
                }
                if (s != 8) break;
                if (!bl) {
                    XmlUtils.indent(stringBuilder, n);
                }
                stringBuilder.append("-->");
                if (bl) break;
                stringBuilder.append('\n');
                break;
            }
            case 1: {
                Node node2;
                int n3;
                if (!bl) {
                    XmlUtils.indent(stringBuilder, n);
                }
                stringBuilder.append('<');
                Element element = (Element)node;
                stringBuilder.append(element.getTagName());
                NamedNodeMap namedNodeMap = element.getAttributes();
                NodeList nodeList = element.getChildNodes();
                int n4 = nodeList.getLength();
                int n5 = namedNodeMap.getLength();
                if (n5 > 0) {
                    for (n3 = 0; n3 < n5; ++n3) {
                        node2 = namedNodeMap.item(n3);
                        stringBuilder.append(' ');
                        stringBuilder.append(node2.getNodeName());
                        stringBuilder.append('=').append('\"');
                        stringBuilder.append(XmlUtils.toXmlAttributeValue(node2.getNodeValue()));
                        stringBuilder.append('\"');
                    }
                }
                if (n4 == 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append('>');
                if (!bl) {
                    stringBuilder.append('\n');
                }
                if (n4 <= 0) break;
                for (n3 = 0; n3 < n4; ++n3) {
                    node2 = nodeList.item(n3);
                    XmlUtils.append(stringBuilder, node2, n + 1, bl);
                }
                if (!bl) {
                    if (stringBuilder.charAt(stringBuilder.length() - 1) != '\n') {
                        stringBuilder.append('\n');
                    }
                    XmlUtils.indent(stringBuilder, n);
                }
                stringBuilder.append('<').append('/');
                stringBuilder.append(element.getTagName());
                stringBuilder.append('>');
                if (bl) break;
                stringBuilder.append('\n');
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported node type " + s + ": not yet implemented");
            }
        }
    }
}

