/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Device;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

final class AdbHelper {
    static final int WAIT_TIME = 5;
    static final String DEFAULT_ENCODING = "ISO-8859-1";

    private AdbHelper() {
    }

    public static SocketChannel open(InetSocketAddress inetSocketAddress, Device device, int n) throws IOException, TimeoutException, AdbCommandRejectedException {
        SocketChannel socketChannel = SocketChannel.open(inetSocketAddress);
        try {
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            byte[] byArray = AdbHelper.createAdbForwardRequest(null, n);
            AdbHelper.write(socketChannel, byArray);
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                throw new AdbCommandRejectedException(adbResponse.message);
            }
            socketChannel.configureBlocking(true);
        }
        catch (TimeoutException timeoutException) {
            socketChannel.close();
            throw timeoutException;
        }
        catch (IOException iOException) {
            socketChannel.close();
            throw iOException;
        }
        return socketChannel;
    }

    public static SocketChannel createPassThroughConnection(InetSocketAddress inetSocketAddress, Device device, int n) throws TimeoutException, AdbCommandRejectedException, IOException {
        SocketChannel socketChannel = SocketChannel.open(inetSocketAddress);
        try {
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            byte[] byArray = AdbHelper.createJdwpForwardRequest(n);
            AdbHelper.write(socketChannel, byArray);
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                throw new AdbCommandRejectedException(adbResponse.message);
            }
            socketChannel.configureBlocking(true);
        }
        catch (TimeoutException timeoutException) {
            socketChannel.close();
            throw timeoutException;
        }
        catch (IOException iOException) {
            socketChannel.close();
            throw iOException;
        }
        return socketChannel;
    }

    private static byte[] createAdbForwardRequest(String string, int n) {
        String string2 = string == null ? "tcp:" + n : "tcp:" + n + ":" + string;
        return AdbHelper.formAdbRequest(string2);
    }

    private static byte[] createJdwpForwardRequest(int n) {
        String string = String.format("jdwp:%1$d", n);
        return AdbHelper.formAdbRequest(string);
    }

    static byte[] formAdbRequest(String string) {
        byte[] byArray;
        String string2 = String.format("%04X%s", string.length(), string);
        try {
            byArray = string2.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        assert (byArray.length == string.length() + 4);
        return byArray;
    }

    static AdbResponse readAdbResponse(SocketChannel socketChannel, boolean bl) throws TimeoutException, IOException {
        AdbResponse adbResponse;
        block6: {
            adbResponse = new AdbResponse();
            byte[] byArray = new byte[4];
            AdbHelper.read(socketChannel, byArray);
            if (AdbHelper.isOkay(byArray)) {
                adbResponse.okay = true;
            } else {
                bl = true;
                adbResponse.okay = false;
            }
            try {
                int n;
                if (!bl) break block6;
                byte[] byArray2 = new byte[4];
                AdbHelper.read(socketChannel, byArray2);
                String string = AdbHelper.replyToString(byArray2);
                try {
                    n = Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    Log.w("ddms", "Expected digits, got '" + string + "': " + byArray2[0] + " " + byArray2[1] + " " + byArray2[2] + " " + byArray2[3]);
                    Log.w("ddms", "reply was " + AdbHelper.replyToString(byArray));
                    break block6;
                }
                byte[] byArray3 = new byte[n];
                AdbHelper.read(socketChannel, byArray3);
                adbResponse.message = AdbHelper.replyToString(byArray3);
                Log.v("ddms", "Got reply '" + AdbHelper.replyToString(byArray) + "', diag='" + adbResponse.message + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return adbResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RawImage getFrameBuffer(InetSocketAddress inetSocketAddress, Device device) throws TimeoutException, AdbCommandRejectedException, IOException {
        RawImage rawImage = new RawImage();
        byte[] byArray = AdbHelper.formAdbRequest("framebuffer:");
        byte[] byArray2 = new byte[]{0};
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            AdbHelper.write(socketChannel, byArray);
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                throw new AdbCommandRejectedException(adbResponse.message);
            }
            byte[] byArray3 = new byte[4];
            AdbHelper.read(socketChannel, byArray3);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n = byteBuffer.getInt();
            int n2 = RawImage.getHeaderSize(n);
            byArray3 = new byte[n2 * 4];
            AdbHelper.read(socketChannel, byArray3);
            byteBuffer = ByteBuffer.wrap(byArray3);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (!rawImage.readHeader(n, byteBuffer)) {
                Log.e("Screenshot", "Unsupported protocol: " + n);
                RawImage rawImage2 = null;
                return rawImage2;
            }
            Log.d("ddms", "image params: bpp=" + rawImage.bpp + ", size=" + rawImage.size + ", width=" + rawImage.width + ", height=" + rawImage.height);
            AdbHelper.write(socketChannel, byArray2);
            byArray3 = new byte[rawImage.size];
            AdbHelper.read(socketChannel, byArray3);
            rawImage.data = byArray3;
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
        return rawImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void executeRemoteCommand(InetSocketAddress inetSocketAddress, String string, IDevice iDevice, IShellOutputReceiver iShellOutputReceiver, int n) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Log.v("ddms", "execute: running " + string);
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, iDevice);
            byte[] byArray = AdbHelper.formAdbRequest("shell:" + string);
            AdbHelper.write(socketChannel, byArray);
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                Log.e("ddms", "ADB rejected shell command (" + string + "): " + adbResponse.message);
                throw new AdbCommandRejectedException(adbResponse.message);
            }
            byte[] byArray2 = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            int n2 = 0;
            while (true) {
                if (iShellOutputReceiver != null && iShellOutputReceiver.isCancelled()) {
                    Log.v("ddms", "execute: cancelled");
                    break;
                }
                int n3 = socketChannel.read(byteBuffer);
                if (n3 < 0) {
                    iShellOutputReceiver.flush();
                    Log.v("ddms", "execute '" + string + "' on '" + iDevice + "' : EOF hit. Read: " + n3);
                    break;
                }
                if (n3 == 0) {
                    try {
                        int n4 = 25;
                        if (n > 0 && (n2 += n4) > n) {
                            throw new ShellCommandUnresponsiveException();
                        }
                        Thread.sleep(n4);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                n2 = 0;
                if (iShellOutputReceiver != null) {
                    iShellOutputReceiver.addOutput(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.position());
                }
                byteBuffer.rewind();
            }
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
            Log.v("ddms", "execute: returning");
        }
    }

    public static void runEventLogService(InetSocketAddress inetSocketAddress, Device device, LogReceiver logReceiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runLogService(inetSocketAddress, device, "events", logReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLogService(InetSocketAddress inetSocketAddress, Device device, String string, LogReceiver logReceiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            byte[] byArray = AdbHelper.formAdbRequest("log:" + string);
            AdbHelper.write(socketChannel, byArray);
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                throw new AdbCommandRejectedException(adbResponse.message);
            }
            byte[] byArray2 = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            while (logReceiver == null || !logReceiver.isCancelled()) {
                int n = socketChannel.read(byteBuffer);
                if (n < 0) {
                    break;
                }
                if (n == 0) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (logReceiver != null) {
                    logReceiver.parseNewData(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.position());
                }
                byteBuffer.rewind();
            }
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createForward(InetSocketAddress inetSocketAddress, Device device, String string, String string2) throws TimeoutException, AdbCommandRejectedException, IOException {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            byte[] byArray = AdbHelper.formAdbRequest(String.format("host-serial:%1$s:forward:%2$s;%3$s", device.getSerialNumber(), string, string2));
            AdbHelper.write(socketChannel, byArray);
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                Log.w("create-forward", "Error creating forward: " + adbResponse.message);
                throw new AdbCommandRejectedException(adbResponse.message);
            }
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeForward(InetSocketAddress inetSocketAddress, Device device, String string, String string2) throws TimeoutException, AdbCommandRejectedException, IOException {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            byte[] byArray = AdbHelper.formAdbRequest(String.format("host-serial:%1$s:killforward:%2$s;%3$s", device.getSerialNumber(), string, string2));
            AdbHelper.write(socketChannel, byArray);
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                Log.w("remove-forward", "Error creating forward: " + adbResponse.message);
                throw new AdbCommandRejectedException(adbResponse.message);
            }
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
    }

    static boolean isOkay(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 75 && byArray[2] == 65 && byArray[3] == 89;
    }

    static String replyToString(byte[] byArray) {
        String string;
        try {
            string = new String(byArray, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            string = "";
        }
        return string;
    }

    static void read(SocketChannel socketChannel, byte[] byArray) throws TimeoutException, IOException {
        AdbHelper.read(socketChannel, byArray, -1, DdmPreferences.getTimeOut());
    }

    static void read(SocketChannel socketChannel, byte[] byArray, int n, int n2) throws TimeoutException, IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n != -1 ? n : byArray.length);
        int n3 = 0;
        while (byteBuffer.position() != byteBuffer.limit()) {
            int n4 = socketChannel.read(byteBuffer);
            if (n4 < 0) {
                Log.d("ddms", "read: channel EOF");
                throw new IOException("EOF");
            }
            if (n4 == 0) {
                if (n2 != 0 && n3 * 5 > n2) {
                    Log.d("ddms", "read: timeout");
                    throw new TimeoutException();
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n3;
                continue;
            }
            n3 = 0;
        }
    }

    static void write(SocketChannel socketChannel, byte[] byArray) throws TimeoutException, IOException {
        AdbHelper.write(socketChannel, byArray, -1, DdmPreferences.getTimeOut());
    }

    static void write(SocketChannel socketChannel, byte[] byArray, int n, int n2) throws TimeoutException, IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n != -1 ? n : byArray.length);
        int n3 = 0;
        while (byteBuffer.position() != byteBuffer.limit()) {
            int n4 = socketChannel.write(byteBuffer);
            if (n4 < 0) {
                Log.d("ddms", "write: channel EOF");
                throw new IOException("channel EOF");
            }
            if (n4 == 0) {
                if (n2 != 0 && n3 * 5 > n2) {
                    Log.d("ddms", "write: timeout");
                    throw new TimeoutException();
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n3;
                continue;
            }
            n3 = 0;
        }
    }

    static void setDevice(SocketChannel socketChannel, IDevice iDevice) throws TimeoutException, AdbCommandRejectedException, IOException {
        if (iDevice != null) {
            String string = "host:transport:" + iDevice.getSerialNumber();
            byte[] byArray = AdbHelper.formAdbRequest(string);
            AdbHelper.write(socketChannel, byArray);
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                throw new AdbCommandRejectedException(adbResponse.message, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reboot(String string, InetSocketAddress inetSocketAddress, Device device) throws TimeoutException, AdbCommandRejectedException, IOException {
        byte[] byArray = string == null ? AdbHelper.formAdbRequest("reboot:") : AdbHelper.formAdbRequest("reboot:" + string);
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            AdbHelper.write(socketChannel, byArray);
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
    }

    static class AdbResponse {
        public boolean okay;
        public String message = "";
    }
}

