/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.IStackTraceInfo;
import java.util.Comparator;
import java.util.Locale;

public class AllocationInfo
implements IStackTraceInfo {
    private final String mAllocatedClass;
    private final int mAllocNumber;
    private final int mAllocationSize;
    private final short mThreadId;
    private final StackTraceElement[] mStackTrace;

    AllocationInfo(int n, String string, int n2, short s, StackTraceElement[] stackTraceElementArray) {
        this.mAllocNumber = n;
        this.mAllocatedClass = string;
        this.mAllocationSize = n2;
        this.mThreadId = s;
        this.mStackTrace = stackTraceElementArray;
    }

    public int getAllocNumber() {
        return this.mAllocNumber;
    }

    public String getAllocatedClass() {
        return this.mAllocatedClass;
    }

    public int getSize() {
        return this.mAllocationSize;
    }

    public short getThreadId() {
        return this.mThreadId;
    }

    public StackTraceElement[] getStackTrace() {
        return this.mStackTrace;
    }

    public int compareTo(AllocationInfo allocationInfo) {
        return allocationInfo.mAllocationSize - this.mAllocationSize;
    }

    public String getFirstTraceClassName() {
        if (this.mStackTrace.length > 0) {
            return this.mStackTrace[0].getClassName();
        }
        return null;
    }

    public String getFirstTraceMethodName() {
        if (this.mStackTrace.length > 0) {
            return this.mStackTrace[0].getMethodName();
        }
        return null;
    }

    public boolean filter(String string, boolean bl, Locale locale) {
        if (this.mAllocatedClass.toLowerCase(locale).contains(string)) {
            return true;
        }
        if (this.mStackTrace.length > 0) {
            int n = bl ? this.mStackTrace.length : 1;
            for (int i = 0; i < n; ++i) {
                if (this.mStackTrace[i].getClassName().toLowerCase(locale).contains(string)) {
                    return true;
                }
                if (!this.mStackTrace[i].getMethodName().toLowerCase(locale).contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AllocationSorter
    implements Comparator<AllocationInfo> {
        private SortMode mSortMode = SortMode.SIZE;
        private boolean mDescending = true;

        public void setSortMode(SortMode sortMode) {
            if (this.mSortMode == sortMode) {
                this.mDescending = !this.mDescending;
            } else {
                this.mSortMode = sortMode;
            }
        }

        public SortMode getSortMode() {
            return this.mSortMode;
        }

        public boolean isDescending() {
            return this.mDescending;
        }

        @Override
        public int compare(AllocationInfo allocationInfo, AllocationInfo allocationInfo2) {
            int n = 0;
            switch (this.mSortMode) {
                case NUMBER: {
                    n = allocationInfo.mAllocNumber - allocationInfo2.mAllocNumber;
                    break;
                }
                case SIZE: {
                    break;
                }
                case CLASS: {
                    n = allocationInfo.mAllocatedClass.compareTo(allocationInfo2.mAllocatedClass);
                    break;
                }
                case THREAD: {
                    n = allocationInfo.mThreadId - allocationInfo2.mThreadId;
                    break;
                }
                case IN_CLASS: {
                    String string = allocationInfo.getFirstTraceClassName();
                    String string2 = allocationInfo2.getFirstTraceClassName();
                    n = this.compareOptionalString(string, string2);
                    break;
                }
                case IN_METHOD: {
                    String string = allocationInfo.getFirstTraceMethodName();
                    String string3 = allocationInfo2.getFirstTraceMethodName();
                    n = this.compareOptionalString(string, string3);
                }
            }
            if (n == 0) {
                n = allocationInfo.mAllocationSize - allocationInfo2.mAllocationSize;
            }
            if (this.mDescending) {
                n = -n;
            }
            return n;
        }

        private int compareOptionalString(String string, String string2) {
            if (string != null) {
                if (string2 == null) {
                    return -1;
                }
                return string.compareTo(string2);
            }
            if (string2 == null) {
                return 0;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortMode {
        NUMBER,
        SIZE,
        CLASS,
        THREAD,
        IN_CLASS,
        IN_METHOD;

    }
}

