/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Debugger;
import com.android.ddmlib.Device;
import com.android.ddmlib.HandleExit;
import com.android.ddmlib.HandleHeap;
import com.android.ddmlib.HandleHello;
import com.android.ddmlib.HandleNativeHeap;
import com.android.ddmlib.HandleProfiling;
import com.android.ddmlib.HandleThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import com.android.ddmlib.OpenGlTraceChunkHandler;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;

public class Client {
    private static final int SERVER_PROTOCOL_VERSION = 1;
    public static final int CHANGE_NAME = 1;
    public static final int CHANGE_DEBUGGER_STATUS = 2;
    public static final int CHANGE_PORT = 4;
    public static final int CHANGE_THREAD_MODE = 8;
    public static final int CHANGE_THREAD_DATA = 16;
    public static final int CHANGE_HEAP_MODE = 32;
    public static final int CHANGE_HEAP_DATA = 64;
    public static final int CHANGE_NATIVE_HEAP_DATA = 128;
    public static final int CHANGE_THREAD_STACKTRACE = 256;
    public static final int CHANGE_HEAP_ALLOCATIONS = 512;
    public static final int CHANGE_HEAP_ALLOCATION_STATUS = 1024;
    public static final int CHANGE_METHOD_PROFILING_STATUS = 2048;
    public static final int CHANGE_INFO = 7;
    private SocketChannel mChan;
    private Debugger mDebugger;
    private int mDebuggerListenPort;
    private HashMap<Integer, ChunkHandler> mOutstandingReqs;
    private ClientData mClientData;
    private boolean mThreadUpdateEnabled;
    private boolean mHeapUpdateEnabled;
    private static final int INITIAL_BUF_SIZE = 2048;
    private static final int MAX_BUF_SIZE = 0xC800000;
    private ByteBuffer mReadBuffer;
    private static final int WRITE_BUF_SIZE = 256;
    private ByteBuffer mWriteBuffer;
    private Device mDevice;
    private int mConnState;
    private static final int ST_INIT = 1;
    private static final int ST_NOT_JDWP = 2;
    private static final int ST_AWAIT_SHAKE = 10;
    private static final int ST_NEED_DDM_PKT = 11;
    private static final int ST_NOT_DDM = 12;
    private static final int ST_READY = 13;
    private static final int ST_ERROR = 20;
    private static final int ST_DISCONNECTED = 21;

    Client(Device device, SocketChannel socketChannel, int n) {
        this.mDevice = device;
        this.mChan = socketChannel;
        this.mReadBuffer = ByteBuffer.allocate(2048);
        this.mWriteBuffer = ByteBuffer.allocate(256);
        this.mOutstandingReqs = new HashMap();
        this.mConnState = 1;
        this.mClientData = new ClientData(n);
        this.mThreadUpdateEnabled = DdmPreferences.getInitialThreadUpdate();
        this.mHeapUpdateEnabled = DdmPreferences.getInitialHeapUpdate();
    }

    public String toString() {
        return "[Client pid: " + this.mClientData.getPid() + "]";
    }

    public IDevice getDevice() {
        return this.mDevice;
    }

    Device getDeviceImpl() {
        return this.mDevice;
    }

    public int getDebuggerListenPort() {
        return this.mDebuggerListenPort;
    }

    public boolean isDdmAware() {
        switch (this.mConnState) {
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: {
                return false;
            }
            case 13: {
                return true;
            }
        }
        assert (false);
        return false;
    }

    public boolean isDebuggerAttached() {
        return this.mDebugger.isDebuggerAttached();
    }

    Debugger getDebugger() {
        return this.mDebugger;
    }

    public ClientData getClientData() {
        return this.mClientData;
    }

    public void executeGarbageCollector() {
        try {
            HandleHeap.sendHPGC(this);
        }
        catch (IOException iOException) {
            Log.w("ddms", "Send of HPGC message failed");
        }
    }

    public void dumpHprof() {
        boolean bl = this.mClientData.hasFeature("hprof-heap-dump-streaming");
        try {
            if (bl) {
                HandleHeap.sendHPDS(this);
            } else {
                String string = "/sdcard/" + this.mClientData.getClientDescription().replaceAll("\\:.*", "") + ".hprof";
                HandleHeap.sendHPDU(this, string);
            }
        }
        catch (IOException iOException) {
            Log.w("ddms", "Send of HPDU message failed");
        }
    }

    public void toggleMethodProfiling() {
        boolean bl = this.mClientData.hasFeature("method-trace-profiling-streaming");
        try {
            if (this.mClientData.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.ON) {
                if (bl) {
                    HandleProfiling.sendMPSE(this);
                } else {
                    HandleProfiling.sendMPRE(this);
                }
            } else {
                int n = DdmPreferences.getProfilerBufferSizeMb() * 1024 * 1024;
                if (bl) {
                    HandleProfiling.sendMPSS(this, n, 0);
                } else {
                    String string = "/sdcard/" + this.mClientData.getClientDescription().replaceAll("\\:.*", "") + ".trace";
                    HandleProfiling.sendMPRS(this, string, n, 0);
                }
            }
        }
        catch (IOException iOException) {
            Log.w("ddms", "Toggle method profiling failed");
        }
    }

    public boolean startOpenGlTracing() {
        boolean bl = this.mClientData.hasFeature("opengl-tracing");
        if (!bl) {
            return false;
        }
        try {
            OpenGlTraceChunkHandler.sendStartGlTracing(this);
            return true;
        }
        catch (IOException iOException) {
            Log.w("ddms", "Start OpenGL Tracing failed");
            return false;
        }
    }

    public boolean stopOpenGlTracing() {
        boolean bl = this.mClientData.hasFeature("opengl-tracing");
        if (!bl) {
            return false;
        }
        try {
            OpenGlTraceChunkHandler.sendStopGlTracing(this);
            return true;
        }
        catch (IOException iOException) {
            Log.w("ddms", "Stop OpenGL Tracing failed");
            return false;
        }
    }

    public void requestMethodProfilingStatus() {
        try {
            HandleHeap.sendREAQ(this);
        }
        catch (IOException iOException) {
            Log.e("ddmlib", iOException);
        }
    }

    public void setThreadUpdateEnabled(boolean bl) {
        this.mThreadUpdateEnabled = bl;
        if (!bl) {
            this.mClientData.clearThreads();
        }
        try {
            HandleThread.sendTHEN(this, bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.update(8);
    }

    public boolean isThreadUpdateEnabled() {
        return this.mThreadUpdateEnabled;
    }

    public void requestThreadUpdate() {
        HandleThread.requestThreadUpdate(this);
    }

    public void requestThreadStackTrace(int n) {
        HandleThread.requestThreadStackCallRefresh(this, n);
    }

    public void setHeapUpdateEnabled(boolean bl) {
        this.mHeapUpdateEnabled = bl;
        try {
            HandleHeap.sendHPIF(this, bl ? 3 : 0);
            HandleHeap.sendHPSG(this, bl ? 1 : 0, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.update(32);
    }

    public boolean isHeapUpdateEnabled() {
        return this.mHeapUpdateEnabled;
    }

    public boolean requestNativeHeapInformation() {
        try {
            HandleNativeHeap.sendNHGT(this);
            return true;
        }
        catch (IOException iOException) {
            Log.e("ddmlib", iOException);
            return false;
        }
    }

    public void enableAllocationTracker(boolean bl) {
        try {
            HandleHeap.sendREAE(this, bl);
        }
        catch (IOException iOException) {
            Log.e("ddmlib", iOException);
        }
    }

    public void requestAllocationStatus() {
        try {
            HandleHeap.sendREAQ(this);
        }
        catch (IOException iOException) {
            Log.e("ddmlib", iOException);
        }
    }

    public void requestAllocationDetails() {
        try {
            HandleHeap.sendREAL(this);
        }
        catch (IOException iOException) {
            Log.e("ddmlib", iOException);
        }
    }

    public void kill() {
        try {
            HandleExit.sendEXIT(this, 1);
        }
        catch (IOException iOException) {
            Log.w("ddms", "Send of EXIT message failed");
        }
    }

    void register(Selector selector) throws IOException {
        if (this.mChan != null) {
            this.mChan.register(selector, 1, this);
        }
    }

    public void setAsSelectedClient() {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (monitorThread != null) {
            monitorThread.setSelectedClient(this);
        }
    }

    public boolean isSelectedClient() {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (monitorThread != null) {
            return monitorThread.getSelectedClient() == this;
        }
        return false;
    }

    void listenForDebugger(int n) throws IOException {
        this.mDebuggerListenPort = n;
        this.mDebugger = new Debugger(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendHandshake() {
        assert (this.mWriteBuffer.position() == 0);
        try {
            JdwpPacket.putHandshake(this.mWriteBuffer);
            int n = this.mWriteBuffer.position();
            this.mWriteBuffer.flip();
            if (this.mChan.write(this.mWriteBuffer) != n) {
                throw new IOException("partial handshake write");
            }
        }
        catch (IOException iOException) {
            Log.e("ddms-client", "IO error during handshake: " + iOException.getMessage());
            this.mConnState = 20;
            this.close(true);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mWriteBuffer.clear();
        }
        this.mConnState = 10;
        return true;
    }

    void sendAndConsume(JdwpPacket jdwpPacket) throws IOException {
        this.sendAndConsume(jdwpPacket, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAndConsume(JdwpPacket jdwpPacket, ChunkHandler chunkHandler) throws IOException {
        if (this.mChan == null) {
            Log.v("ddms", "Not sending packet -- client is closed");
            return;
        }
        if (chunkHandler != null) {
            this.addRequestId(jdwpPacket.getId(), chunkHandler);
        }
        SocketChannel socketChannel = this.mChan;
        synchronized (socketChannel) {
            try {
                jdwpPacket.writeAndConsume(this.mChan);
            }
            catch (IOException iOException) {
                this.removeRequestId(jdwpPacket.getId());
                throw iOException;
            }
        }
    }

    void forwardPacketToDebugger(JdwpPacket jdwpPacket) throws IOException {
        Debugger debugger = this.mDebugger;
        if (debugger == null) {
            Log.d("ddms", "Discarding packet");
            jdwpPacket.consume();
        } else {
            debugger.sendAndConsume(jdwpPacket);
        }
    }

    void read() throws IOException, BufferOverflowException {
        int n;
        if (this.mReadBuffer.position() == this.mReadBuffer.capacity()) {
            if (this.mReadBuffer.capacity() * 2 > 0xC800000) {
                Log.e("ddms", "Exceeded MAX_BUF_SIZE!");
                throw new BufferOverflowException();
            }
            Log.d("ddms", "Expanding read buffer to " + this.mReadBuffer.capacity() * 2);
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.mReadBuffer.capacity() * 2);
            this.mReadBuffer.position(0);
            byteBuffer.put(this.mReadBuffer);
            this.mReadBuffer = byteBuffer;
        }
        if ((n = this.mChan.read(this.mReadBuffer)) < 0) {
            throw new IOException("read failed");
        }
        Log.v("ddms", "Read " + n + " bytes from " + this);
    }

    JdwpPacket getJdwpPacket() throws IOException {
        if (this.mConnState == 10) {
            int n = JdwpPacket.findHandshake(this.mReadBuffer);
            switch (n) {
                case 1: {
                    Log.d("ddms", "Good handshake from client, sending HELO to " + this.mClientData.getPid());
                    JdwpPacket.consumeHandshake(this.mReadBuffer);
                    this.mConnState = 11;
                    HandleHello.sendHelloCommands(this, 1);
                    return this.getJdwpPacket();
                }
                case 3: {
                    Log.d("ddms", "Bad handshake from client");
                    if (MonitorThread.getInstance().getRetryOnBadHandshake()) {
                        this.mDevice.getMonitor().addClientToDropAndReopen(this, -1);
                        break;
                    }
                    this.mConnState = 2;
                    this.close(true);
                    break;
                }
                case 2: {
                    Log.d("ddms", "No handshake from client yet.");
                    break;
                }
                default: {
                    Log.e("ddms", "Unknown packet while waiting for client handshake");
                }
            }
            return null;
        }
        if (this.mConnState == 11 || this.mConnState == 12 || this.mConnState == 13) {
            if (this.mReadBuffer.position() != 0) {
                Log.v("ddms", "Checking " + this.mReadBuffer.position() + " bytes");
            }
            return JdwpPacket.findPacket(this.mReadBuffer);
        }
        Log.e("ddms", "Receiving data in state = " + this.mConnState);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequestId(int n, ChunkHandler chunkHandler) {
        HashMap<Integer, ChunkHandler> hashMap = this.mOutstandingReqs;
        synchronized (hashMap) {
            Log.v("ddms", "Adding req 0x" + Integer.toHexString(n) + " to set");
            this.mOutstandingReqs.put(n, chunkHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRequestId(int n) {
        HashMap<Integer, ChunkHandler> hashMap = this.mOutstandingReqs;
        synchronized (hashMap) {
            Log.v("ddms", "Removing req 0x" + Integer.toHexString(n) + " from set");
            this.mOutstandingReqs.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChunkHandler isResponseToUs(int n) {
        HashMap<Integer, ChunkHandler> hashMap = this.mOutstandingReqs;
        synchronized (hashMap) {
            ChunkHandler chunkHandler = this.mOutstandingReqs.get(n);
            if (chunkHandler != null) {
                Log.v("ddms", "Found 0x" + Integer.toHexString(n) + " in request set - " + chunkHandler);
                return chunkHandler;
            }
        }
        return null;
    }

    void packetFailed(JdwpPacket jdwpPacket) {
        if (this.mConnState == 11) {
            Log.d("ddms", "Marking " + this + " as non-DDM client");
            this.mConnState = 12;
        } else if (this.mConnState != 12) {
            Log.w("ddms", "WEIRD: got JDWP failure packet on DDM req");
        }
    }

    synchronized boolean ddmSeen() {
        if (this.mConnState == 11) {
            this.mConnState = 13;
            return false;
        }
        if (this.mConnState != 13) {
            Log.w("ddms", "WEIRD: in ddmSeen with state=" + this.mConnState);
        }
        return true;
    }

    void close(boolean bl) {
        Log.d("ddms", "Closing " + this.toString());
        this.mOutstandingReqs.clear();
        try {
            if (this.mChan != null) {
                this.mChan.close();
                this.mChan = null;
            }
            if (this.mDebugger != null) {
                this.mDebugger.close();
                this.mDebugger = null;
            }
        }
        catch (IOException iOException) {
            Log.w("ddms", "failed to close " + this);
        }
        this.mDevice.removeClient(this, bl);
    }

    public boolean isValid() {
        return this.mChan != null;
    }

    void update(int n) {
        this.mDevice.update(this, n);
    }
}

