/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.IShellOutputReceiver;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.CountDownLatch;

public class CollectingOutputReceiver
implements IShellOutputReceiver {
    private CountDownLatch mCompletionLatch;
    private StringBuffer mOutputBuffer = new StringBuffer();
    private boolean mIsCanceled = false;

    public CollectingOutputReceiver() {
    }

    public CollectingOutputReceiver(CountDownLatch countDownLatch) {
        this.mCompletionLatch = countDownLatch;
    }

    public String getOutput() {
        return this.mOutputBuffer.toString();
    }

    public boolean isCancelled() {
        return this.mIsCanceled;
    }

    public void cancel() {
        this.mIsCanceled = true;
    }

    public void addOutput(byte[] byArray, int n, int n2) {
        if (!this.isCancelled()) {
            String string = null;
            try {
                string = new String(byArray, n, n2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = new String(byArray, n, n2);
            }
            this.mOutputBuffer.append(string);
        }
    }

    public void flush() {
        if (this.mCompletionLatch != null) {
            this.mCompletionLatch.countDown();
        }
    }
}

