/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Device
implements IDevice {
    private static final String DEVICE_MODEL_PROPERTY = "ro.product.model";
    private static final String DEVICE_MANUFACTURER_PROPERTY = "ro.product.manufacturer";
    private static final int INSTALL_TIMEOUT = 120000;
    private static final int BATTERY_TIMEOUT = 2000;
    private static final int GETPROP_TIMEOUT = 2000;
    static final String RE_EMULATOR_SN = "emulator-(\\d+)";
    private String mSerialNumber = null;
    private String mAvdName = null;
    private IDevice.DeviceState mState = null;
    private final Map<String, String> mProperties = new HashMap<String, String>();
    private final Map<String, String> mMountPoints = new HashMap<String, String>();
    private final ArrayList<Client> mClients = new ArrayList();
    private DeviceMonitor mMonitor;
    private static final String LOG_TAG = "Device";
    private static final char SEPARATOR = '-';
    private SocketChannel mSocketChannel;
    private boolean mArePropertiesSet = false;
    private Integer mLastBatteryLevel = null;
    private long mLastBatteryCheckTime = 0L;
    private String mName;

    @Override
    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    @Override
    public String getAvdName() {
        return this.mAvdName;
    }

    void setAvdName(String string) {
        if (!this.isEmulator()) {
            throw new IllegalArgumentException("Cannot set the AVD name of the device is not an emulator");
        }
        this.mAvdName = string;
    }

    @Override
    public String getName() {
        if (this.mName == null) {
            this.mName = this.constructName();
        }
        return this.mName;
    }

    private String constructName() {
        if (this.isEmulator()) {
            String string = this.getAvdName();
            if (string != null) {
                return String.format("%s [%s]", string, this.getSerialNumber());
            }
            return this.getSerialNumber();
        }
        String string = this.cleanupStringForDisplay(this.getProperty(DEVICE_MANUFACTURER_PROPERTY));
        String string2 = this.cleanupStringForDisplay(this.getProperty(DEVICE_MODEL_PROPERTY));
        StringBuilder stringBuilder = new StringBuilder(20);
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append('-');
        }
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append('-');
        }
        stringBuilder.append(this.getSerialNumber());
        return stringBuilder.toString();
    }

    private String cleanupStringForDisplay(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.mState;
    }

    void setState(IDevice.DeviceState deviceState) {
        this.mState = deviceState;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.mProperties);
    }

    @Override
    public int getPropertyCount() {
        return this.mProperties.size();
    }

    @Override
    public String getProperty(String string) {
        return this.mProperties.get(string);
    }

    @Override
    public boolean arePropertiesSet() {
        return this.mArePropertiesSet;
    }

    @Override
    public String getPropertyCacheOrSync(String string) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (this.mArePropertiesSet) {
            return this.getProperty(string);
        }
        return this.getPropertySync(string);
    }

    @Override
    public String getPropertySync(String string) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        CollectingOutputReceiver collectingOutputReceiver = new CollectingOutputReceiver();
        this.executeShellCommand(String.format("getprop '%s'", string), collectingOutputReceiver, 2000);
        String string2 = collectingOutputReceiver.getOutput().trim();
        if (string2.isEmpty()) {
            return null;
        }
        return string2;
    }

    @Override
    public String getMountPoint(String string) {
        return this.mMountPoints.get(string);
    }

    public String toString() {
        return this.mSerialNumber;
    }

    @Override
    public boolean isOnline() {
        return this.mState == IDevice.DeviceState.ONLINE;
    }

    @Override
    public boolean isEmulator() {
        return this.mSerialNumber.matches(RE_EMULATOR_SN);
    }

    @Override
    public boolean isOffline() {
        return this.mState == IDevice.DeviceState.OFFLINE;
    }

    @Override
    public boolean isBootLoader() {
        return this.mState == IDevice.DeviceState.BOOTLOADER;
    }

    @Override
    public boolean hasClients() {
        return this.mClients.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client[] getClients() {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            return this.mClients.toArray(new Client[this.mClients.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(String string) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client client : this.mClients) {
                if (!string.equals(client.getClientData().getClientDescription())) continue;
                return client;
            }
        }
        return null;
    }

    @Override
    public SyncService getSyncService() throws TimeoutException, AdbCommandRejectedException, IOException {
        SyncService syncService = new SyncService(AndroidDebugBridge.getSocketAddress(), this);
        if (syncService.openSync()) {
            return syncService;
        }
        return null;
    }

    @Override
    public FileListingService getFileListingService() {
        return new FileListingService(this);
    }

    @Override
    public RawImage getScreenshot() throws TimeoutException, AdbCommandRejectedException, IOException {
        return AdbHelper.getFrameBuffer(AndroidDebugBridge.getSocketAddress(), this);
    }

    @Override
    public void executeShellCommand(String string, IShellOutputReceiver iShellOutputReceiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), string, this, iShellOutputReceiver, DdmPreferences.getTimeOut());
    }

    @Override
    public void executeShellCommand(String string, IShellOutputReceiver iShellOutputReceiver, int n) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), string, this, iShellOutputReceiver, n);
    }

    @Override
    public void runEventLogService(LogReceiver logReceiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runEventLogService(AndroidDebugBridge.getSocketAddress(), this, logReceiver);
    }

    @Override
    public void runLogService(String string, LogReceiver logReceiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runLogService(AndroidDebugBridge.getSocketAddress(), this, string, logReceiver);
    }

    @Override
    public void createForward(int n, int n2) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.createForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", n), String.format("tcp:%d", n2));
    }

    @Override
    public void createForward(int n, String string, IDevice.DeviceUnixSocketNamespace deviceUnixSocketNamespace) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.createForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", n), String.format("%s:%s", deviceUnixSocketNamespace.getType(), string));
    }

    @Override
    public void removeForward(int n, int n2) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.removeForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", n), String.format("tcp:%d", n2));
    }

    @Override
    public void removeForward(int n, String string, IDevice.DeviceUnixSocketNamespace deviceUnixSocketNamespace) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.removeForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", n), String.format("%s:%s", deviceUnixSocketNamespace.getType(), string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientName(int n) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client client : this.mClients) {
                if (client.getClientData().getPid() != n) continue;
                return client.getClientData().getClientDescription();
            }
        }
        return null;
    }

    Device(DeviceMonitor deviceMonitor, String string, IDevice.DeviceState deviceState) {
        this.mMonitor = deviceMonitor;
        this.mSerialNumber = string;
        this.mState = deviceState;
    }

    DeviceMonitor getMonitor() {
        return this.mMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClient(Client client) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.add(client);
        }
    }

    List<Client> getClientList() {
        return this.mClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasClient(int n) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client client : this.mClients) {
                if (client.getClientData().getPid() != n) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientList() {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.clear();
        }
    }

    void setClientMonitoringSocket(SocketChannel socketChannel) {
        this.mSocketChannel = socketChannel;
    }

    SocketChannel getClientMonitoringSocket() {
        return this.mSocketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(Client client, boolean bl) {
        this.mMonitor.addPortToAvailableList(client.getDebuggerListenPort());
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.remove(client);
        }
        if (bl) {
            this.mMonitor.getServer().deviceChanged(this, 2);
        }
    }

    void update(int n) {
        if ((n & 4) != 0) {
            this.mArePropertiesSet = true;
        }
        this.mMonitor.getServer().deviceChanged(this, n);
    }

    void update(Client client, int n) {
        this.mMonitor.getServer().clientChanged(client, n);
    }

    void addProperty(String string, String string2) {
        this.mProperties.put(string, string2);
    }

    void setMountingPoint(String string, String string2) {
        this.mMountPoints.put(string, string2);
    }

    @Override
    public void pushFile(String string, String string2) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        block9: {
            SyncService syncService = null;
            try {
                String string3 = this.getFileName(string);
                Log.d(string3, String.format("Uploading %1$s onto device '%2$s'", string3, this.getSerialNumber()));
                syncService = this.getSyncService();
                if (syncService != null) {
                    String string4 = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
                    Log.d(LOG_TAG, string4);
                    syncService.pushFile(string, string2, SyncService.getNullProgressMonitor());
                    break block9;
                }
                throw new IOException("Unable to open sync connection!");
            }
            catch (TimeoutException timeoutException) {
                Log.e(LOG_TAG, "Error during Sync: timeout.");
                throw timeoutException;
            }
            catch (SyncException syncException) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", syncException.getMessage()));
                throw syncException;
            }
            catch (IOException iOException) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", iOException.getMessage()));
                throw iOException;
            }
            finally {
                if (syncService != null) {
                    syncService.close();
                }
            }
        }
    }

    @Override
    public void pullFile(String string, String string2) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        block9: {
            SyncService syncService = null;
            try {
                String string3 = this.getFileName(string);
                Log.d(string3, String.format("Downloading %1$s from device '%2$s'", string3, this.getSerialNumber()));
                syncService = this.getSyncService();
                if (syncService != null) {
                    String string4 = String.format("Downloding file from device '%1$s'", this.getSerialNumber());
                    Log.d(LOG_TAG, string4);
                    syncService.pullFile(string, string2, SyncService.getNullProgressMonitor());
                    break block9;
                }
                throw new IOException("Unable to open sync connection!");
            }
            catch (TimeoutException timeoutException) {
                Log.e(LOG_TAG, "Error during Sync: timeout.");
                throw timeoutException;
            }
            catch (SyncException syncException) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", syncException.getMessage()));
                throw syncException;
            }
            catch (IOException iOException) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", iOException.getMessage()));
                throw iOException;
            }
            finally {
                if (syncService != null) {
                    syncService.close();
                }
            }
        }
    }

    @Override
    public String installPackage(String string, boolean bl, String ... stringArray) throws InstallException {
        try {
            String string2 = this.syncPackageToDevice(string);
            String string3 = this.installRemotePackage(string2, bl, stringArray);
            this.removeRemotePackage(string2);
            return string3;
        }
        catch (IOException iOException) {
            throw new InstallException(iOException);
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            throw new InstallException(adbCommandRejectedException);
        }
        catch (TimeoutException timeoutException) {
            throw new InstallException(timeoutException);
        }
        catch (SyncException syncException) {
            throw new InstallException(syncException);
        }
    }

    @Override
    public String syncPackageToDevice(String string) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        SyncService syncService = null;
        try {
            String string2 = this.getFileName(string);
            String string3 = String.format("/data/local/tmp/%1$s", string2);
            Log.d(string2, String.format("Uploading %1$s onto device '%2$s'", string2, this.getSerialNumber()));
            syncService = this.getSyncService();
            if (syncService == null) {
                throw new IOException("Unable to open sync connection!");
            }
            String string4 = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
            Log.d(LOG_TAG, string4);
            syncService.pushFile(string, string3, SyncService.getNullProgressMonitor());
            string4 = string3;
            return string4;
        }
        catch (TimeoutException timeoutException) {
            Log.e(LOG_TAG, "Error during Sync: timeout.");
            throw timeoutException;
        }
        catch (SyncException syncException) {
            Log.e(LOG_TAG, String.format("Error during Sync: %1$s", syncException.getMessage()));
            throw syncException;
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, String.format("Error during Sync: %1$s", iOException.getMessage()));
            throw iOException;
        }
        finally {
            if (syncService != null) {
                syncService.close();
            }
        }
    }

    private String getFileName(String string) {
        return new File(string).getName();
    }

    @Override
    public String installRemotePackage(String string, boolean bl, String ... stringArray) throws InstallException {
        try {
            InstallReceiver installReceiver = new InstallReceiver();
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append("-r ");
            }
            for (String string2 : stringArray) {
                stringBuilder.append(string2);
                stringBuilder.append(' ');
            }
            String string3 = String.format("pm install %1$s \"%2$s\"", stringBuilder.toString(), string);
            this.executeShellCommand(string3, installReceiver, 120000);
            return installReceiver.getErrorMessage();
        }
        catch (TimeoutException timeoutException) {
            throw new InstallException(timeoutException);
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            throw new InstallException(adbCommandRejectedException);
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            throw new InstallException(shellCommandUnresponsiveException);
        }
        catch (IOException iOException) {
            throw new InstallException(iOException);
        }
    }

    @Override
    public void removeRemotePackage(String string) throws InstallException {
        try {
            this.executeShellCommand("rm " + string, new NullOutputReceiver(), 120000);
        }
        catch (IOException iOException) {
            throw new InstallException(iOException);
        }
        catch (TimeoutException timeoutException) {
            throw new InstallException(timeoutException);
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            throw new InstallException(adbCommandRejectedException);
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            throw new InstallException(shellCommandUnresponsiveException);
        }
    }

    @Override
    public String uninstallPackage(String string) throws InstallException {
        try {
            InstallReceiver installReceiver = new InstallReceiver();
            this.executeShellCommand("pm uninstall " + string, installReceiver, 120000);
            return installReceiver.getErrorMessage();
        }
        catch (TimeoutException timeoutException) {
            throw new InstallException(timeoutException);
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            throw new InstallException(adbCommandRejectedException);
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            throw new InstallException(shellCommandUnresponsiveException);
        }
        catch (IOException iOException) {
            throw new InstallException(iOException);
        }
    }

    @Override
    public void reboot(String string) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.reboot(string, AndroidDebugBridge.getSocketAddress(), this);
    }

    @Override
    public Integer getBatteryLevel() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        return this.getBatteryLevel(300000L);
    }

    @Override
    public Integer getBatteryLevel(long l) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        if (this.mLastBatteryLevel != null && this.mLastBatteryCheckTime > System.currentTimeMillis() - l) {
            return this.mLastBatteryLevel;
        }
        BatteryReceiver batteryReceiver = new BatteryReceiver();
        this.executeShellCommand("dumpsys battery", batteryReceiver, 2000);
        this.mLastBatteryLevel = batteryReceiver.getBatteryLevel();
        this.mLastBatteryCheckTime = System.currentTimeMillis();
        return this.mLastBatteryLevel;
    }

    private static final class BatteryReceiver
    extends MultiLineReceiver {
        private static final Pattern BATTERY_LEVEL = Pattern.compile("\\s*level: (\\d+)");
        private static final Pattern SCALE = Pattern.compile("\\s*scale: (\\d+)");
        private Integer mBatteryLevel = null;
        private Integer mBatteryScale = null;

        private BatteryReceiver() {
        }

        public Integer getBatteryLevel() {
            if (this.mBatteryLevel != null && this.mBatteryScale != null) {
                return this.mBatteryLevel * 100 / this.mBatteryScale;
            }
            return null;
        }

        public void processNewLines(String[] stringArray) {
            for (String string : stringArray) {
                Matcher matcher;
                Matcher matcher2 = BATTERY_LEVEL.matcher(string);
                if (matcher2.matches()) {
                    try {
                        this.mBatteryLevel = Integer.parseInt(matcher2.group(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w(Device.LOG_TAG, String.format("Failed to parse %s as an integer", matcher2.group(1)));
                    }
                }
                if (!(matcher = SCALE.matcher(string)).matches()) continue;
                try {
                    this.mBatteryScale = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    Log.w(Device.LOG_TAG, String.format("Failed to parse %s as an integer", matcher2.group(1)));
                }
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }

    private static final class InstallReceiver
    extends MultiLineReceiver {
        private static final String SUCCESS_OUTPUT = "Success";
        private static final Pattern FAILURE_PATTERN = Pattern.compile("Failure\\s+\\[(.*)\\]");
        private String mErrorMessage = null;

        public void processNewLines(String[] stringArray) {
            for (String string : stringArray) {
                if (string.length() <= 0) continue;
                if (string.startsWith(SUCCESS_OUTPUT)) {
                    this.mErrorMessage = null;
                    continue;
                }
                Matcher matcher = FAILURE_PATTERN.matcher(string);
                if (!matcher.matches()) continue;
                this.mErrorMessage = matcher.group(1);
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }
}

