/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Device;
import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GetPropReceiver
extends MultiLineReceiver {
    static final String GETPROP_COMMAND = "getprop";
    private static final Pattern GETPROP_PATTERN = Pattern.compile("^\\[([^]]+)\\]\\:\\s*\\[(.*)\\]$");
    private Device mDevice = null;

    public GetPropReceiver(Device device) {
        this.mDevice = device;
    }

    public void processNewLines(String[] stringArray) {
        for (String string : stringArray) {
            Matcher matcher;
            if (string.length() == 0 || string.startsWith("#") || !(matcher = GETPROP_PATTERN.matcher(string)).matches()) continue;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string2.length() <= 0) continue;
            this.mDevice.addProperty(string2, string3);
        }
    }

    public boolean isCancelled() {
        return false;
    }

    public void done() {
        this.mDevice.update(4);
    }
}

