/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

final class HandleAppName
extends ChunkHandler {
    public static final int CHUNK_APNM = ChunkHandler.type("APNM");
    private static final HandleAppName mInst = new HandleAppName();

    private HandleAppName() {
    }

    public static void register(MonitorThread monitorThread) {
        monitorThread.registerChunkHandler(CHUNK_APNM, mInst);
    }

    public void clientReady(Client client) throws IOException {
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        Log.d("ddm-appname", "handling " + ChunkHandler.name(n));
        if (n == CHUNK_APNM) {
            assert (!bl);
            HandleAppName.handleAPNM(client, byteBuffer);
        } else {
            this.handleUnknownChunk(client, n, byteBuffer, bl, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAPNM(Client client, ByteBuffer byteBuffer) {
        ClientData clientData;
        int n = byteBuffer.getInt();
        String string = HandleAppName.getString(byteBuffer, n);
        int n2 = -1;
        boolean bl = false;
        if (byteBuffer.hasRemaining()) {
            try {
                n2 = byteBuffer.getInt();
                bl = true;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                int n3 = 8 + n * 2;
                Log.e("ddm-appname", "Insufficient data in APNM chunk to retrieve user id.");
                Log.e("ddm-appname", "Actual chunk length: " + byteBuffer.capacity());
                Log.e("ddm-appname", "Expected chunk length: " + n3);
            }
        }
        Log.d("ddm-appname", "APNM: app='" + string + "'");
        ClientData clientData2 = clientData = client.getClientData();
        synchronized (clientData2) {
            clientData.setClientDescription(string);
            if (bl) {
                clientData.setUserId(n2);
            }
        }
        client = HandleAppName.checkDebuggerPortForAppName(client, string);
        if (client != null) {
            client.update(1);
        }
    }
}

