/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.nio.ByteBuffer;

final class HandleProfiling
extends ChunkHandler {
    public static final int CHUNK_MPRS = HandleProfiling.type("MPRS");
    public static final int CHUNK_MPRE = HandleProfiling.type("MPRE");
    public static final int CHUNK_MPSS = HandleProfiling.type("MPSS");
    public static final int CHUNK_MPSE = HandleProfiling.type("MPSE");
    public static final int CHUNK_MPRQ = HandleProfiling.type("MPRQ");
    public static final int CHUNK_FAIL = HandleProfiling.type("FAIL");
    private static final HandleProfiling mInst = new HandleProfiling();

    private HandleProfiling() {
    }

    public static void register(MonitorThread monitorThread) {
        monitorThread.registerChunkHandler(CHUNK_MPRE, mInst);
        monitorThread.registerChunkHandler(CHUNK_MPSE, mInst);
        monitorThread.registerChunkHandler(CHUNK_MPRQ, mInst);
    }

    public void clientReady(Client client) throws IOException {
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        Log.d("ddm-prof", "handling " + ChunkHandler.name(n));
        if (n == CHUNK_MPRE) {
            this.handleMPRE(client, byteBuffer);
        } else if (n == CHUNK_MPSE) {
            this.handleMPSE(client, byteBuffer);
        } else if (n == CHUNK_MPRQ) {
            this.handleMPRQ(client, byteBuffer);
        } else if (n == CHUNK_FAIL) {
            this.handleFAIL(client, byteBuffer);
        } else {
            this.handleUnknownChunk(client, n, byteBuffer, bl, n2);
        }
    }

    public static void sendMPRS(Client client, String string, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = HandleProfiling.allocBuffer(12 + string.length() * 2);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleProfiling.getChunkDataBuf(byteBuffer);
        byteBuffer2.putInt(n);
        byteBuffer2.putInt(n2);
        byteBuffer2.putInt(string.length());
        HandleProfiling.putString(byteBuffer2, string);
        HandleProfiling.finishChunkPacket(jdwpPacket, CHUNK_MPRS, byteBuffer2.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRS) + " '" + string + "', size=" + n + ", flags=" + n2);
        client.sendAndConsume(jdwpPacket, mInst);
        client.getClientData().setPendingMethodProfiling(string);
        HandleProfiling.sendMPRQ(client);
    }

    public static void sendMPRE(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleProfiling.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleProfiling.getChunkDataBuf(byteBuffer);
        HandleProfiling.finishChunkPacket(jdwpPacket, CHUNK_MPRE, byteBuffer2.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRE));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleMPRE(Client client, ByteBuffer byteBuffer) {
        String string = client.getClientData().getPendingMethodProfiling();
        client.getClientData().setPendingMethodProfiling(null);
        byte by = byteBuffer.get();
        ClientData.IMethodProfilingHandler iMethodProfilingHandler = ClientData.getMethodProfilingHandler();
        if (iMethodProfilingHandler != null) {
            if (by == 0) {
                iMethodProfilingHandler.onSuccess(string, client);
                Log.d("ddm-prof", "Method profiling has finished");
            } else {
                iMethodProfilingHandler.onEndFailure(client, null);
                Log.w("ddm-prof", "Method profiling has failed (check device log)");
            }
        }
        client.getClientData().setMethodProfilingStatus(ClientData.MethodProfilingStatus.OFF);
        client.update(2048);
    }

    public static void sendMPSS(Client client, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = HandleProfiling.allocBuffer(8);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleProfiling.getChunkDataBuf(byteBuffer);
        byteBuffer2.putInt(n);
        byteBuffer2.putInt(n2);
        HandleProfiling.finishChunkPacket(jdwpPacket, CHUNK_MPSS, byteBuffer2.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPSS) + "', size=" + n + ", flags=" + n2);
        client.sendAndConsume(jdwpPacket, mInst);
        HandleProfiling.sendMPRQ(client);
    }

    public static void sendMPSE(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleProfiling.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleProfiling.getChunkDataBuf(byteBuffer);
        HandleProfiling.finishChunkPacket(jdwpPacket, CHUNK_MPSE, byteBuffer2.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPSE));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleMPSE(Client client, ByteBuffer byteBuffer) {
        ClientData.IMethodProfilingHandler iMethodProfilingHandler = ClientData.getMethodProfilingHandler();
        if (iMethodProfilingHandler != null) {
            byte[] byArray = new byte[byteBuffer.capacity()];
            byteBuffer.get(byArray, 0, byArray.length);
            Log.d("ddm-prof", "got trace file, size: " + byArray.length + " bytes");
            iMethodProfilingHandler.onSuccess(byArray, client);
        }
        client.getClientData().setMethodProfilingStatus(ClientData.MethodProfilingStatus.OFF);
        client.update(2048);
    }

    public static void sendMPRQ(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleProfiling.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleProfiling.getChunkDataBuf(byteBuffer);
        HandleProfiling.finishChunkPacket(jdwpPacket, CHUNK_MPRQ, byteBuffer2.position());
        Log.d("ddm-prof", "Sending " + HandleProfiling.name(CHUNK_MPRQ));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleMPRQ(Client client, ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 0) {
            client.getClientData().setMethodProfilingStatus(ClientData.MethodProfilingStatus.OFF);
            Log.d("ddm-prof", "Method profiling is not running");
        } else {
            client.getClientData().setMethodProfilingStatus(ClientData.MethodProfilingStatus.ON);
            Log.d("ddm-prof", "Method profiling is running");
        }
        client.update(2048);
    }

    private void handleFAIL(Client client, ByteBuffer byteBuffer) {
        ClientData.IMethodProfilingHandler iMethodProfilingHandler;
        Object object;
        byteBuffer.getInt();
        int n = byteBuffer.getInt() * 2;
        String string = null;
        if (n > 0) {
            object = new byte[n];
            byteBuffer.get((byte[])object, 0, n);
            string = new String((byte[])object);
        }
        if ((object = (Object)client.getClientData().getPendingMethodProfiling()) != null) {
            client.getClientData().setPendingMethodProfiling(null);
            iMethodProfilingHandler = ClientData.getMethodProfilingHandler();
            if (iMethodProfilingHandler != null) {
                iMethodProfilingHandler.onStartFailure(client, string);
            }
        } else {
            iMethodProfilingHandler = ClientData.getMethodProfilingHandler();
            if (iMethodProfilingHandler != null) {
                iMethodProfilingHandler.onEndFailure(client, string);
            }
        }
        try {
            HandleProfiling.sendMPRQ(client);
        }
        catch (IOException iOException) {
            Log.e("HandleProfiling", iOException);
        }
    }
}

