/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Debugger;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MonitorThread
extends Thread {
    private static final int CLIENT_READY = 2;
    private static final int CLIENT_DISCONNECTED = 3;
    private volatile boolean mQuit = false;
    private ArrayList<Client> mClientList = new ArrayList();
    private Selector mSelector;
    private HashMap<Integer, ChunkHandler> mHandlerMap = new HashMap();
    private ServerSocketChannel mDebugSelectedChan;
    private int mNewDebugSelectedPort = DdmPreferences.getSelectedDebugPort();
    private int mDebugSelectedPort = -1;
    private Client mSelectedClient = null;
    private static MonitorThread mInstance;

    private MonitorThread() {
        super("Monitor");
    }

    static MonitorThread createInstance() {
        mInstance = new MonitorThread();
        return mInstance;
    }

    static MonitorThread getInstance() {
        return mInstance;
    }

    synchronized void setDebugSelectedPort(int n) throws IllegalStateException {
        if (mInstance == null) {
            return;
        }
        if (!AndroidDebugBridge.getClientSupport()) {
            return;
        }
        if (this.mDebugSelectedChan != null) {
            Log.d("ddms", "Changing debug-selected port to " + n);
            this.mNewDebugSelectedPort = n;
            this.wakeup();
        } else {
            this.mNewDebugSelectedPort = n;
        }
    }

    synchronized void setSelectedClient(Client client) {
        if (mInstance == null) {
            return;
        }
        if (this.mSelectedClient != client) {
            Client client2 = this.mSelectedClient;
            this.mSelectedClient = client;
            if (client2 != null) {
                client2.update(4);
            }
            if (this.mSelectedClient != null) {
                this.mSelectedClient.update(4);
            }
        }
    }

    Client getSelectedClient() {
        return this.mSelectedClient;
    }

    boolean getRetryOnBadHandshake() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Client[] getClients() {
        ArrayList<Client> arrayList = this.mClientList;
        synchronized (arrayList) {
            return this.mClientList.toArray(new Client[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerChunkHandler(int n, ChunkHandler chunkHandler) {
        if (mInstance == null) {
            return;
        }
        HashMap<Integer, ChunkHandler> hashMap = this.mHandlerMap;
        synchronized (hashMap) {
            if (this.mHandlerMap.get(n) == null) {
                this.mHandlerMap.put(n, chunkHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Log.d("ddms", "Monitor is up");
        try {
            this.mSelector = Selector.open();
        }
        catch (IOException iOException) {
            Log.logAndDisplay(Log.LogLevel.ERROR, "ddms", "Failed to initialize Monitor Thread: " + iOException.getMessage());
            return;
        }
        while (!this.mQuit) {
            try {
                int n;
                ArrayList<Client> arrayList = this.mClientList;
                synchronized (arrayList) {
                }
                try {
                    if (AndroidDebugBridge.getClientSupport() && (this.mDebugSelectedChan == null || this.mNewDebugSelectedPort != this.mDebugSelectedPort) && this.mNewDebugSelectedPort != -1 && this.reopenDebugSelectedPort()) {
                        this.mDebugSelectedPort = this.mNewDebugSelectedPort;
                    }
                }
                catch (IOException iOException) {
                    Log.e("ddms", "Failed to reopen debug port for Selected Client to: " + this.mNewDebugSelectedPort);
                    Log.e("ddms", iOException);
                    this.mNewDebugSelectedPort = this.mDebugSelectedPort;
                }
                try {
                    n = this.mSelector.select();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                catch (CancelledKeyException cancelledKeyException) {
                    continue;
                }
                if (n == 0) continue;
                Set<SelectionKey> set = this.mSelector.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    try {
                        if (selectionKey.attachment() instanceof Client) {
                            this.processClientActivity(selectionKey);
                            continue;
                        }
                        if (selectionKey.attachment() instanceof Debugger) {
                            this.processDebuggerActivity(selectionKey);
                            continue;
                        }
                        if (selectionKey.attachment() instanceof MonitorThread) {
                            this.processDebugSelectedActivity(selectionKey);
                            continue;
                        }
                        Log.e("ddms", "unknown activity key");
                    }
                    catch (Exception exception) {
                        Log.e("ddms", "Exception during activity from Selector.");
                        Log.e("ddms", exception);
                    }
                }
            }
            catch (Exception exception) {
                Log.e("ddms", "Exception MonitorThread.run()");
                Log.e("ddms", exception);
            }
        }
    }

    int getDebugSelectedPort() {
        return this.mDebugSelectedPort;
    }

    private void processClientActivity(SelectionKey selectionKey) {
        Client client = (Client)selectionKey.attachment();
        try {
            if (!selectionKey.isReadable() || !selectionKey.isValid()) {
                Log.d("ddms", "Invalid key from " + client + ". Dropping client.");
                this.dropClient(client, true);
                return;
            }
            client.read();
            JdwpPacket jdwpPacket = client.getJdwpPacket();
            while (jdwpPacket != null) {
                if (jdwpPacket.isDdmPacket()) {
                    assert (!jdwpPacket.isReply());
                    this.callHandler(client, jdwpPacket, null);
                    jdwpPacket.consume();
                } else if (jdwpPacket.isReply() && client.isResponseToUs(jdwpPacket.getId()) != null) {
                    ChunkHandler chunkHandler = client.isResponseToUs(jdwpPacket.getId());
                    if (jdwpPacket.isError()) {
                        client.packetFailed(jdwpPacket);
                    } else if (jdwpPacket.isEmpty()) {
                        Log.d("ddms", "Got empty reply for 0x" + Integer.toHexString(jdwpPacket.getId()) + " from " + client);
                    } else {
                        this.callHandler(client, jdwpPacket, chunkHandler);
                    }
                    jdwpPacket.consume();
                    client.removeRequestId(jdwpPacket.getId());
                } else {
                    Log.v("ddms", "Forwarding client " + (jdwpPacket.isReply() ? "reply" : "event") + " 0x" + Integer.toHexString(jdwpPacket.getId()) + " to " + client.getDebugger());
                    client.forwardPacketToDebugger(jdwpPacket);
                }
                jdwpPacket = client.getJdwpPacket();
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.dropClient(client, true);
        }
        catch (IOException iOException) {
            this.dropClient(client, true);
        }
        catch (Exception exception) {
            Log.e("ddms", exception);
            this.dropClient(client, true);
            if (exception instanceof BufferOverflowException) {
                Log.w("ddms", "Client data packet exceeded maximum buffer size " + client);
            }
            Log.e("ddms", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHandler(Client client, JdwpPacket jdwpPacket, ChunkHandler chunkHandler) {
        Object object;
        if (!client.ddmSeen()) {
            this.broadcast(2, client);
        }
        ByteBuffer byteBuffer = jdwpPacket.getPayload();
        boolean bl = true;
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        if (chunkHandler == null) {
            object = this.mHandlerMap;
            synchronized (object) {
                chunkHandler = this.mHandlerMap.get(n);
                bl = false;
            }
        }
        if (chunkHandler == null) {
            Log.w("ddms", "Received unsupported chunk type " + ChunkHandler.name(n) + " (len=" + n2 + ")");
        } else {
            Log.d("ddms", "Calling handler for " + ChunkHandler.name(n) + " [" + chunkHandler + "] (len=" + n2 + ")");
            object = byteBuffer.slice();
            ByteBuffer byteBuffer2 = ((ByteBuffer)object).asReadOnlyBuffer();
            byteBuffer2.order(ChunkHandler.CHUNK_ORDER);
            ArrayList<Client> arrayList = this.mClientList;
            synchronized (arrayList) {
                chunkHandler.handleChunk(client, n, byteBuffer2, bl, jdwpPacket.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void dropClient(Client client, boolean bl) {
        if (mInstance == null) {
            return;
        }
        ArrayList<Client> arrayList = this.mClientList;
        synchronized (arrayList) {
            if (!this.mClientList.remove(client)) {
                return;
            }
        }
        client.close(bl);
        this.broadcast(3, client);
        this.wakeup();
    }

    synchronized void dropClients(Collection<? extends Client> collection, boolean bl) {
        for (Client client : collection) {
            this.dropClient(client, bl);
        }
    }

    private void processDebuggerActivity(SelectionKey selectionKey) {
        Debugger debugger = (Debugger)selectionKey.attachment();
        try {
            if (selectionKey.isAcceptable()) {
                try {
                    this.acceptNewDebugger(debugger, null);
                }
                catch (IOException iOException) {
                    Log.w("ddms", "debugger accept() failed");
                    iOException.printStackTrace();
                }
            } else if (selectionKey.isReadable()) {
                this.processDebuggerData(selectionKey);
            } else {
                Log.d("ddm-debugger", "key in unknown state");
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptNewDebugger(Debugger debugger, ServerSocketChannel serverSocketChannel) throws IOException {
        ArrayList<Client> arrayList = this.mClientList;
        synchronized (arrayList) {
            SocketChannel socketChannel = serverSocketChannel == null ? debugger.accept() : debugger.accept(serverSocketChannel);
            if (socketChannel != null) {
                socketChannel.socket().setTcpNoDelay(true);
                this.wakeup();
                try {
                    socketChannel.register(this.mSelector, 1, debugger);
                }
                catch (IOException iOException) {
                    debugger.closeData();
                    throw iOException;
                }
                catch (RuntimeException runtimeException) {
                    debugger.closeData();
                    throw runtimeException;
                }
            } else {
                Log.w("ddms", "ignoring duplicate debugger");
            }
        }
    }

    private void processDebuggerData(SelectionKey selectionKey) {
        Debugger debugger = (Debugger)selectionKey.attachment();
        try {
            debugger.read();
            JdwpPacket jdwpPacket = debugger.getJdwpPacket();
            while (jdwpPacket != null) {
                Log.v("ddms", "Forwarding dbg req 0x" + Integer.toHexString(jdwpPacket.getId()) + " to " + debugger.getClient());
                debugger.forwardPacketToClient(jdwpPacket);
                jdwpPacket = debugger.getJdwpPacket();
            }
        }
        catch (IOException iOException) {
            Log.d("ddms", "Closing connection to debugger " + debugger);
            debugger.closeData();
            Client client = debugger.getClient();
            if (client.isDdmAware()) {
                Log.d("ddms", " (recycling client connection as well)");
                client.getDeviceImpl().getMonitor().addClientToDropAndReopen(client, -1);
            }
            Log.d("ddms", " (recycling client connection as well)");
            client.getDeviceImpl().getMonitor().addClientToDropAndReopen(client, -1);
        }
    }

    private void wakeup() {
        this.mSelector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void quit() {
        this.mQuit = true;
        this.wakeup();
        Log.d("ddms", "Waiting for Monitor thread");
        try {
            this.join();
            ArrayList<Client> arrayList = this.mClientList;
            synchronized (arrayList) {
                for (Client client : this.mClientList) {
                    client.close(false);
                    this.broadcast(3, client);
                }
                this.mClientList.clear();
            }
            if (this.mDebugSelectedChan != null) {
                this.mDebugSelectedChan.close();
                this.mDebugSelectedChan.socket().close();
                this.mDebugSelectedChan = null;
            }
            this.mSelector.close();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        mInstance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addClient(Client client) {
        if (mInstance == null) {
            return;
        }
        Log.d("ddms", "Adding new client " + client);
        ArrayList<Client> arrayList = this.mClientList;
        synchronized (arrayList) {
            this.mClientList.add(client);
            try {
                this.wakeup();
                client.register(this.mSelector);
                Debugger debugger = client.getDebugger();
                if (debugger != null) {
                    debugger.registerListener(this.mSelector);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(int n, Client client) {
        HashSet<ChunkHandler> hashSet;
        Log.d("ddms", "broadcast " + n + ": " + client);
        HashMap<Integer, ChunkHandler> hashMap = this.mHandlerMap;
        synchronized (hashMap) {
            Collection<ChunkHandler> object = this.mHandlerMap.values();
            hashSet = new HashSet<ChunkHandler>(object);
        }
        block9: for (ChunkHandler chunkHandler : hashSet) {
            switch (n) {
                case 2: {
                    try {
                        chunkHandler.clientReady(client);
                        continue block9;
                    }
                    catch (IOException iOException) {
                        Log.w("ddms", "Got exception while broadcasting 'ready'");
                        return;
                    }
                }
                case 3: {
                    chunkHandler.clientDisconnected(client);
                    continue block9;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    private boolean reopenDebugSelectedPort() throws IOException {
        Log.d("ddms", "reopen debug-selected port: " + this.mNewDebugSelectedPort);
        if (this.mDebugSelectedChan != null) {
            this.mDebugSelectedChan.close();
        }
        this.mDebugSelectedChan = ServerSocketChannel.open();
        this.mDebugSelectedChan.configureBlocking(false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName("localhost"), this.mNewDebugSelectedPort);
        this.mDebugSelectedChan.socket().setReuseAddress(true);
        try {
            this.mDebugSelectedChan.socket().bind(inetSocketAddress);
            if (this.mSelectedClient != null) {
                this.mSelectedClient.update(4);
            }
            this.mDebugSelectedChan.register(this.mSelector, 16, this);
            return true;
        }
        catch (BindException bindException) {
            this.displayDebugSelectedBindError(this.mNewDebugSelectedPort);
            this.mDebugSelectedChan = null;
            this.mNewDebugSelectedPort = -1;
            return false;
        }
    }

    private void processDebugSelectedActivity(SelectionKey selectionKey) {
        Object object;
        assert (selectionKey.isAcceptable());
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
        if (this.mSelectedClient != null && (object = this.mSelectedClient.getDebugger()) != null) {
            Log.d("ddms", "Accepting connection on 'debug selected' port");
            try {
                this.acceptNewDebugger((Debugger)object, serverSocketChannel);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        Log.w("ddms", "Connection on 'debug selected' port, but none selected");
        try {
            object = serverSocketChannel.accept();
            ((AbstractInterruptibleChannel)object).close();
        }
        catch (IOException iOException) {
        }
        catch (NotYetBoundException notYetBoundException) {
            this.displayDebugSelectedBindError(this.mDebugSelectedPort);
        }
    }

    private void displayDebugSelectedBindError(int n) {
        String string = String.format("Could not open Selected VM debug port (%1$d). Make sure you do not have another instance of DDMS or of the eclipse plugin running. If it's being used by something else, choose a new port number in the preferences.", n);
        Log.logAndDisplay(Log.LogLevel.ERROR, "ddms", string);
    }
}

