/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import java.nio.ByteBuffer;

public final class RawImage {
    public int version;
    public int bpp;
    public int size;
    public int width;
    public int height;
    public int red_offset;
    public int red_length;
    public int blue_offset;
    public int blue_length;
    public int green_offset;
    public int green_length;
    public int alpha_offset;
    public int alpha_length;
    public byte[] data;

    public boolean readHeader(int n, ByteBuffer byteBuffer) {
        this.version = n;
        if (n == 16) {
            this.bpp = 16;
            this.size = byteBuffer.getInt();
            this.width = byteBuffer.getInt();
            this.height = byteBuffer.getInt();
            this.red_offset = 11;
            this.red_length = 5;
            this.green_offset = 5;
            this.green_length = 6;
            this.blue_offset = 0;
            this.blue_length = 5;
            this.alpha_offset = 0;
            this.alpha_length = 0;
        } else if (n == 1) {
            this.bpp = byteBuffer.getInt();
            this.size = byteBuffer.getInt();
            this.width = byteBuffer.getInt();
            this.height = byteBuffer.getInt();
            this.red_offset = byteBuffer.getInt();
            this.red_length = byteBuffer.getInt();
            this.blue_offset = byteBuffer.getInt();
            this.blue_length = byteBuffer.getInt();
            this.green_offset = byteBuffer.getInt();
            this.green_length = byteBuffer.getInt();
            this.alpha_offset = byteBuffer.getInt();
            this.alpha_length = byteBuffer.getInt();
        } else {
            return false;
        }
        return true;
    }

    public int getRedMask() {
        return this.getMask(this.red_length, this.red_offset);
    }

    public int getGreenMask() {
        return this.getMask(this.green_length, this.green_offset);
    }

    public int getBlueMask() {
        return this.getMask(this.blue_length, this.blue_offset);
    }

    public static int getHeaderSize(int n) {
        switch (n) {
            case 16: {
                return 3;
            }
            case 1: {
                return 12;
            }
        }
        return 0;
    }

    public RawImage getRotated() {
        RawImage rawImage = new RawImage();
        rawImage.version = this.version;
        rawImage.bpp = this.bpp;
        rawImage.size = this.size;
        rawImage.red_offset = this.red_offset;
        rawImage.red_length = this.red_length;
        rawImage.blue_offset = this.blue_offset;
        rawImage.blue_length = this.blue_length;
        rawImage.green_offset = this.green_offset;
        rawImage.green_length = this.green_length;
        rawImage.alpha_offset = this.alpha_offset;
        rawImage.alpha_length = this.alpha_length;
        rawImage.width = this.height;
        rawImage.height = this.width;
        int n = this.data.length;
        rawImage.data = new byte[n];
        int n2 = this.bpp >> 3;
        int n3 = this.width;
        int n4 = this.height;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                System.arraycopy(this.data, (i * n3 + j) * n2, rawImage.data, ((n3 - j - 1) * n4 + i) * n2, n2);
            }
        }
        return rawImage;
    }

    public int getARGB(int n) {
        int n2;
        if (this.bpp == 16) {
            n2 = this.data[n] & 0xFF;
            n2 |= this.data[n + 1] << 8 & 0xFF00;
        } else if (this.bpp == 32) {
            n2 = this.data[n] & 0xFF;
            n2 |= (this.data[n + 1] & 0xFF) << 8;
            n2 |= (this.data[n + 2] & 0xFF) << 16;
            n2 |= (this.data[n + 3] & 0xFF) << 24;
        } else {
            throw new UnsupportedOperationException("RawImage.getARGB(int) only works in 16 and 32 bit mode.");
        }
        int n3 = (n2 >>> this.red_offset & RawImage.getMask(this.red_length)) << 8 - this.red_length;
        int n4 = (n2 >>> this.green_offset & RawImage.getMask(this.green_length)) << 8 - this.green_length;
        int n5 = (n2 >>> this.blue_offset & RawImage.getMask(this.blue_length)) << 8 - this.blue_length;
        int n6 = this.alpha_length == 0 ? 255 : (n2 >>> this.alpha_offset & RawImage.getMask(this.alpha_length)) << 8 - this.alpha_length;
        return n6 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    private int getMask(int n, int n2) {
        int n3 = RawImage.getMask(n) << n2;
        if (this.bpp == 32) {
            return Integer.reverseBytes(n3);
        }
        return n3;
    }

    private static int getMask(int n) {
        return (1 << n) - 1;
    }
}

