/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationResultParser
extends MultiLineReceiver {
    private static final Set<String> KNOWN_KEYS = new HashSet<String>();
    private final Collection<ITestRunListener> mTestListeners;
    private final String mTestRunName;
    private TestResult mCurrentTestResult = null;
    private TestResult mLastTestResult = null;
    private String mCurrentKey = null;
    private StringBuilder mCurrentValue = null;
    private boolean mTestStartReported = false;
    private boolean mTestRunFinished = false;
    private boolean mTestRunFailReported = false;
    private long mTestTime = 0L;
    private boolean mIsCancelled = false;
    private int mNumTestsRun = 0;
    private int mNumTestsExpected = 0;
    private boolean mInInstrumentationResultKey = false;
    private Map<String, String> mInstrumentationResultBundle = new HashMap<String, String>();
    private Map<String, String> mTestMetrics = new HashMap<String, String>();
    private static final String LOG_TAG = "InstrumentationResultParser";
    static final String NO_TEST_RESULTS_MSG = "No test results";
    static final String INCOMPLETE_TEST_ERR_MSG_PREFIX = "Test failed to run to completion";
    static final String INCOMPLETE_TEST_ERR_MSG_POSTFIX = "Check device logcat for details";
    static final String INCOMPLETE_RUN_ERR_MSG_PREFIX = "Test run failed to complete";

    public InstrumentationResultParser(String string, Collection<ITestRunListener> collection) {
        this.mTestRunName = string;
        this.mTestListeners = new ArrayList<ITestRunListener>(collection);
    }

    public InstrumentationResultParser(String string, ITestRunListener iTestRunListener) {
        this(string, Collections.singletonList(iTestRunListener));
    }

    @Override
    public void processNewLines(String[] stringArray) {
        for (String string : stringArray) {
            this.parse(string);
            Log.v(LOG_TAG, string);
        }
    }

    private void parse(String string) {
        if (string.startsWith("INSTRUMENTATION_STATUS_CODE: ")) {
            this.submitCurrentKeyValue();
            this.mInInstrumentationResultKey = false;
            this.parseStatusCode(string);
        } else if (string.startsWith("INSTRUMENTATION_STATUS: ")) {
            this.submitCurrentKeyValue();
            this.mInInstrumentationResultKey = false;
            this.parseKey(string, "INSTRUMENTATION_STATUS: ".length());
        } else if (string.startsWith("INSTRUMENTATION_RESULT: ")) {
            this.submitCurrentKeyValue();
            this.mInInstrumentationResultKey = true;
            this.parseKey(string, "INSTRUMENTATION_RESULT: ".length());
        } else if (string.startsWith("INSTRUMENTATION_FAILED: ") || string.startsWith("INSTRUMENTATION_CODE: ")) {
            this.submitCurrentKeyValue();
            this.mInInstrumentationResultKey = false;
            this.mTestRunFinished = true;
        } else if (string.startsWith("Time: ")) {
            this.parseTime(string);
        } else if (this.mCurrentValue != null) {
            this.mCurrentValue.append("\r\n");
            this.mCurrentValue.append(string);
        } else if (string.trim().length() > 0) {
            Log.d(LOG_TAG, "unrecognized line " + string);
        }
    }

    private void submitCurrentKeyValue() {
        if (this.mCurrentKey != null && this.mCurrentValue != null) {
            String string = this.mCurrentValue.toString();
            if (this.mInInstrumentationResultKey) {
                if (!KNOWN_KEYS.contains(this.mCurrentKey)) {
                    this.mInstrumentationResultBundle.put(this.mCurrentKey, string);
                } else if (this.mCurrentKey.equals("shortMsg")) {
                    this.handleTestRunFailed(String.format("Instrumentation run failed due to '%1$s'", string));
                }
            } else {
                TestResult testResult = this.getCurrentTestInfo();
                if (this.mCurrentKey.equals("class")) {
                    testResult.mTestClass = string.trim();
                } else if (this.mCurrentKey.equals("test")) {
                    testResult.mTestName = string.trim();
                } else if (this.mCurrentKey.equals("numtests")) {
                    try {
                        testResult.mNumTests = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w(LOG_TAG, "Unexpected integer number of tests, received " + string);
                    }
                } else if (this.mCurrentKey.equals("Error")) {
                    this.handleTestRunFailed(string);
                } else if (this.mCurrentKey.equals("stack")) {
                    testResult.mStackTrace = string;
                } else if (!KNOWN_KEYS.contains(this.mCurrentKey)) {
                    this.mTestMetrics.put(this.mCurrentKey, string);
                }
            }
            this.mCurrentKey = null;
            this.mCurrentValue = null;
        }
    }

    private Map<String, String> getAndResetTestMetrics() {
        Map<String, String> map = this.mTestMetrics;
        this.mTestMetrics = new HashMap<String, String>();
        return map;
    }

    private TestResult getCurrentTestInfo() {
        if (this.mCurrentTestResult == null) {
            this.mCurrentTestResult = new TestResult();
        }
        return this.mCurrentTestResult;
    }

    private void clearCurrentTestInfo() {
        this.mLastTestResult = this.mCurrentTestResult;
        this.mCurrentTestResult = null;
    }

    private void parseKey(String string, int n) {
        int n2 = string.indexOf(61, n);
        if (n2 != -1) {
            this.mCurrentKey = string.substring(n, n2).trim();
            this.parseValue(string, n2 + 1);
        }
    }

    private void parseValue(String string, int n) {
        this.mCurrentValue = new StringBuilder();
        this.mCurrentValue.append(string.substring(n));
    }

    private void parseStatusCode(String string) {
        String string2 = string.substring("INSTRUMENTATION_STATUS_CODE: ".length()).trim();
        TestResult testResult = this.getCurrentTestInfo();
        testResult.mCode = -1;
        try {
            testResult.mCode = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Log.w(LOG_TAG, "Expected integer status code, received: " + string2);
            testResult.mCode = -1;
        }
        if (testResult.mCode != 2) {
            this.reportResult(testResult);
            this.clearCurrentTestInfo();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    public void cancel() {
        this.mIsCancelled = true;
    }

    private void reportResult(TestResult testResult) {
        if (!testResult.isComplete()) {
            Log.w(LOG_TAG, "invalid instrumentation status bundle " + testResult.toString());
            return;
        }
        this.reportTestRunStarted(testResult);
        TestIdentifier testIdentifier = new TestIdentifier(testResult.mTestClass, testResult.mTestName);
        switch (testResult.mCode) {
            case 1: {
                for (ITestRunListener iTestRunListener : this.mTestListeners) {
                    iTestRunListener.testStarted(testIdentifier);
                }
                break;
            }
            case -2: {
                Map<String, String> map = this.getAndResetTestMetrics();
                for (ITestRunListener iTestRunListener : this.mTestListeners) {
                    iTestRunListener.testFailed(ITestRunListener.TestFailure.FAILURE, testIdentifier, this.getTrace(testResult));
                    iTestRunListener.testEnded(testIdentifier, map);
                }
                ++this.mNumTestsRun;
                break;
            }
            case -1: {
                Map<String, String> map = this.getAndResetTestMetrics();
                for (ITestRunListener iTestRunListener : this.mTestListeners) {
                    iTestRunListener.testFailed(ITestRunListener.TestFailure.ERROR, testIdentifier, this.getTrace(testResult));
                    iTestRunListener.testEnded(testIdentifier, map);
                }
                ++this.mNumTestsRun;
                break;
            }
            case 0: {
                Map<String, String> map = this.getAndResetTestMetrics();
                for (ITestRunListener iTestRunListener : this.mTestListeners) {
                    iTestRunListener.testEnded(testIdentifier, map);
                }
                ++this.mNumTestsRun;
                break;
            }
            default: {
                Map<String, String> map = this.getAndResetTestMetrics();
                Log.e(LOG_TAG, "Unknown status code received: " + testResult.mCode);
                for (ITestRunListener iTestRunListener : this.mTestListeners) {
                    iTestRunListener.testEnded(testIdentifier, map);
                }
                ++this.mNumTestsRun;
            }
        }
    }

    private void reportTestRunStarted(TestResult testResult) {
        if (!this.mTestStartReported && testResult.mNumTests != null) {
            for (ITestRunListener iTestRunListener : this.mTestListeners) {
                iTestRunListener.testRunStarted(this.mTestRunName, testResult.mNumTests);
            }
            this.mNumTestsExpected = testResult.mNumTests;
            this.mTestStartReported = true;
        }
    }

    private String getTrace(TestResult testResult) {
        if (testResult.mStackTrace != null) {
            return testResult.mStackTrace;
        }
        Log.e(LOG_TAG, "Could not find stack trace for failed test ");
        return new Throwable("Unknown failure").toString();
    }

    private void parseTime(String string) {
        Pattern pattern = Pattern.compile(String.format("%s\\s*([\\d\\.]+)", "Time: "));
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                float f = Float.parseFloat(string2);
                this.mTestTime = (long)(f * 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                Log.w(LOG_TAG, String.format("Unexpected time format %1$s", string));
            }
        } else {
            Log.w(LOG_TAG, String.format("Unexpected time format %1$s", string));
        }
    }

    public void handleTestRunFailed(String string) {
        string = string == null ? "Unknown error" : string;
        Log.i(LOG_TAG, String.format("test run failed: '%1$s'", string));
        if (this.mLastTestResult != null && this.mLastTestResult.isComplete() && 1 == this.mLastTestResult.mCode) {
            TestIdentifier testIdentifier = new TestIdentifier(this.mLastTestResult.mTestClass, this.mLastTestResult.mTestName);
            for (ITestRunListener iTestRunListener : this.mTestListeners) {
                iTestRunListener.testFailed(ITestRunListener.TestFailure.ERROR, testIdentifier, String.format("%1$s. Reason: '%2$s'. %3$s", INCOMPLETE_TEST_ERR_MSG_PREFIX, string, INCOMPLETE_TEST_ERR_MSG_POSTFIX));
                iTestRunListener.testEnded(testIdentifier, this.getAndResetTestMetrics());
            }
        }
        for (ITestRunListener iTestRunListener : this.mTestListeners) {
            if (!this.mTestStartReported) {
                iTestRunListener.testRunStarted(this.mTestRunName, 0);
            }
            iTestRunListener.testRunFailed(string);
            iTestRunListener.testRunEnded(this.mTestTime, this.mInstrumentationResultBundle);
        }
        this.mTestStartReported = true;
        this.mTestRunFailReported = true;
    }

    @Override
    public void done() {
        super.done();
        if (!this.mTestRunFailReported) {
            this.handleOutputDone();
        }
    }

    private void handleOutputDone() {
        if (!this.mTestStartReported && !this.mTestRunFinished) {
            this.handleTestRunFailed(NO_TEST_RESULTS_MSG);
        } else if (this.mNumTestsExpected > this.mNumTestsRun) {
            String string = String.format("%1$s. Expected %2$d tests, received %3$d", INCOMPLETE_RUN_ERR_MSG_PREFIX, this.mNumTestsExpected, this.mNumTestsRun);
            this.handleTestRunFailed(string);
        } else {
            for (ITestRunListener iTestRunListener : this.mTestListeners) {
                if (!this.mTestStartReported) {
                    iTestRunListener.testRunStarted(this.mTestRunName, 0);
                }
                iTestRunListener.testRunEnded(this.mTestTime, this.mInstrumentationResultBundle);
            }
        }
    }

    static {
        KNOWN_KEYS.add("test");
        KNOWN_KEYS.add("class");
        KNOWN_KEYS.add("stack");
        KNOWN_KEYS.add("numtests");
        KNOWN_KEYS.add("Error");
        KNOWN_KEYS.add("shortMsg");
        KNOWN_KEYS.add("stream");
        KNOWN_KEYS.add("id");
        KNOWN_KEYS.add("current");
    }

    private static class TestResult {
        private Integer mCode = null;
        private String mTestName = null;
        private String mTestClass = null;
        private String mStackTrace = null;
        private Integer mNumTests = null;

        private TestResult() {
        }

        boolean isComplete() {
            return this.mCode != null && this.mTestName != null && this.mTestClass != null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mTestClass != null) {
                stringBuilder.append(this.mTestClass);
                stringBuilder.append('#');
            }
            if (this.mTestName != null) {
                stringBuilder.append(this.mTestName);
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            return "unknown result";
        }
    }

    private static class Prefixes {
        private static final String STATUS = "INSTRUMENTATION_STATUS: ";
        private static final String STATUS_CODE = "INSTRUMENTATION_STATUS_CODE: ";
        private static final String STATUS_FAILED = "INSTRUMENTATION_FAILED: ";
        private static final String CODE = "INSTRUMENTATION_CODE: ";
        private static final String RESULT = "INSTRUMENTATION_RESULT: ";
        private static final String TIME_REPORT = "Time: ";

        private Prefixes() {
        }
    }

    private static class StatusCodes {
        private static final int FAILURE = -2;
        private static final int START = 1;
        private static final int ERROR = -1;
        private static final int OK = 0;
        private static final int IN_PROGRESS = 2;

        private StatusCodes() {
        }
    }

    private static class StatusKeys {
        private static final String TEST = "test";
        private static final String CLASS = "class";
        private static final String STACK = "stack";
        private static final String NUMTESTS = "numtests";
        private static final String ERROR = "Error";
        private static final String SHORTMSG = "shortMsg";

        private StatusKeys() {
        }
    }
}

