/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DebugPortManager;
import com.android.ddmlib.Log;
import com.android.ddms.DebugPortProvider;
import com.android.ddms.PrefsDialog;
import com.android.ddms.UIThread;
import com.android.sdkstats.SdkStatsService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Main {
    public static String sRevision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        RuntimeMXBean runtimeMXBean;
        if (Main.isMac()) {
            runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            System.setProperty("JAVA_STARTED_ON_FIRST_THREAD_" + runtimeMXBean.getName().split("@")[0], "1");
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        PrefsDialog.init();
        Log.d((String)"ddms", (String)"Initializing");
        Display.setAppName((String)"DDMS");
        runtimeMXBean = new Shell(Display.getDefault());
        SdkStatsService sdkStatsService = new SdkStatsService();
        sdkStatsService.checkUserPermissionForPing((Shell)runtimeMXBean);
        if (stringArray.length >= 3 && stringArray[0].equals("ping")) {
            sdkStatsService.ping(stringArray);
            return;
        }
        if (stringArray.length > 0) {
            Log.e((String)"ddms", (String)("Unknown argument: " + stringArray[0]));
            System.exit(1);
        }
        if ((string = System.getProperty("com.android.ddms.bindir")) == null) {
            string = System.getenv("com.android.ddms.bindir");
        }
        Main.ping(sdkStatsService, string);
        sdkStatsService = null;
        DebugPortManager.setProvider((DebugPortManager.IDebugPortProvider)DebugPortProvider.getInstance());
        UIThread uIThread = UIThread.getInstance();
        try {
            uIThread.runUI(string);
        }
        finally {
            PrefsDialog.save();
            AndroidDebugBridge.terminate();
        }
        Log.d((String)"ddms", (String)"Bye");
        System.exit(0);
    }

    static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ping(SdkStatsService sdkStatsService, String string) {
        Properties properties = new Properties();
        try {
            File file = string != null && string.length() > 0 ? new File(string, "source.properties") : new File("source.properties");
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            sRevision = properties.getProperty("Pkg.Revision");
            if (sRevision != null && sRevision.length() > 0) {
                sdkStatsService.ping("ddms", sRevision);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"ddms", (String)"shutting down due to uncaught exception");
            Log.e((String)"ddms", (Throwable)throwable);
            System.exit(1);
        }
    }
}

