/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.DdmConstants;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.ddms.UIThread;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.PortFieldEditor;
import com.android.sdkstats.DdmsPreferenceStore;
import com.android.sdkstats.SdkStatsPermissionDialog;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class PrefsDialog {
    public static final String SHELL_X = "shellX";
    public static final String SHELL_Y = "shellY";
    public static final String SHELL_WIDTH = "shellWidth";
    public static final String SHELL_HEIGHT = "shellHeight";
    public static final String EXPLORER_SHELL_X = "explorerShellX";
    public static final String EXPLORER_SHELL_Y = "explorerShellY";
    public static final String EXPLORER_SHELL_WIDTH = "explorerShellWidth";
    public static final String EXPLORER_SHELL_HEIGHT = "explorerShellHeight";
    public static final String SHOW_NATIVE_HEAP = "native";
    public static final String LOGCAT_COLUMN_MODE = "ddmsLogColumnMode";
    public static final String LOGCAT_FONT = "ddmsLogFont";
    public static final String LOGCAT_COLUMN_MODE_AUTO = "auto";
    public static final String LOGCAT_COLUMN_MODE_MANUAL = "manual";
    private static final String PREFS_DEBUG_PORT_BASE = "adbDebugBasePort";
    private static final String PREFS_SELECTED_DEBUG_PORT = "debugSelectedPort";
    private static final String PREFS_DEFAULT_THREAD_UPDATE = "defaultThreadUpdateEnabled";
    private static final String PREFS_DEFAULT_HEAP_UPDATE = "defaultHeapUpdateEnabled";
    private static final String PREFS_THREAD_REFRESH_INTERVAL = "threadStatusInterval";
    private static final String PREFS_LOG_LEVEL = "ddmsLogLevel";
    private static final String PREFS_TIMEOUT = "timeOut";
    private static final String PREFS_PROFILER_BUFFER_SIZE_MB = "profilerBufferSizeMb";
    private static final String PREFS_USE_ADBHOST = "useAdbHost";
    private static final String PREFS_ADBHOST_VALUE = "adbHostValue";
    private static DdmsPreferenceStore mStore = new DdmsPreferenceStore();

    private PrefsDialog() {
    }

    @Deprecated
    public static PreferenceStore getStore() {
        return mStore.getPreferenceStore();
    }

    @Deprecated
    public static void save() {
        try {
            mStore.getPreferenceStore().save();
        }
        catch (IOException iOException) {
            Log.w((String)"ddms", (String)("Failed saving prefs file: " + iOException.getMessage()));
        }
    }

    public static void init() {
        PreferenceStore preferenceStore = mStore.getPreferenceStore();
        if (preferenceStore == null) {
            Log.e((String)"ddms", (String)"failed to access both the user HOME directory and the system wide temp folder. Quitting.");
            System.exit(1);
        }
        PrefsDialog.setDefaults(System.getProperty("user.home"));
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)new ChangeListener());
        DdmPreferences.setDebugPortBase((int)preferenceStore.getInt(PREFS_DEBUG_PORT_BASE));
        DdmPreferences.setSelectedDebugPort((int)preferenceStore.getInt(PREFS_SELECTED_DEBUG_PORT));
        DdmPreferences.setLogLevel((String)preferenceStore.getString(PREFS_LOG_LEVEL));
        DdmPreferences.setInitialThreadUpdate((boolean)preferenceStore.getBoolean(PREFS_DEFAULT_THREAD_UPDATE));
        DdmPreferences.setInitialHeapUpdate((boolean)preferenceStore.getBoolean(PREFS_DEFAULT_HEAP_UPDATE));
        DdmPreferences.setTimeOut((int)preferenceStore.getInt(PREFS_TIMEOUT));
        DdmPreferences.setProfilerBufferSizeMb((int)preferenceStore.getInt(PREFS_PROFILER_BUFFER_SIZE_MB));
        DdmPreferences.setUseAdbHost((boolean)preferenceStore.getBoolean(PREFS_USE_ADBHOST));
        DdmPreferences.setAdbHostValue((String)preferenceStore.getString(PREFS_ADBHOST_VALUE));
        String string = System.getenv("ANDROID_PRODUCT_OUT");
        DdmUiPreferences.setSymbolsLocation((String)(string + File.separator + "symbols"));
        DdmUiPreferences.setAddr2LineLocation((String)"arm-linux-androideabi-addr2line");
        String string2 = System.getProperty("com.android.ddms.bindir");
        string2 = string2 != null && string2.length() != 0 ? string2 + File.separator + DdmConstants.FN_TRACEVIEW : DdmConstants.FN_TRACEVIEW;
        DdmUiPreferences.setTraceviewLocation((String)string2);
        DdmUiPreferences.setStore((IPreferenceStore)preferenceStore);
        DdmUiPreferences.setThreadRefreshInterval((int)preferenceStore.getInt(PREFS_THREAD_REFRESH_INTERVAL));
    }

    private static void setDefaults(String string) {
        PreferenceStore preferenceStore = mStore.getPreferenceStore();
        preferenceStore.setDefault(PREFS_DEBUG_PORT_BASE, 8600);
        preferenceStore.setDefault(PREFS_SELECTED_DEBUG_PORT, 8700);
        preferenceStore.setDefault(PREFS_USE_ADBHOST, false);
        preferenceStore.setDefault(PREFS_ADBHOST_VALUE, "127.0.0.1");
        preferenceStore.setDefault(PREFS_DEFAULT_THREAD_UPDATE, true);
        preferenceStore.setDefault(PREFS_DEFAULT_HEAP_UPDATE, false);
        preferenceStore.setDefault(PREFS_THREAD_REFRESH_INTERVAL, 4);
        preferenceStore.setDefault("textSaveDir", string);
        preferenceStore.setDefault("imageSaveDir", string);
        preferenceStore.setDefault(PREFS_LOG_LEVEL, "info");
        preferenceStore.setDefault(PREFS_TIMEOUT, 5000);
        preferenceStore.setDefault(PREFS_PROFILER_BUFFER_SIZE_MB, 8);
        FontData fontData = new FontData("Courier", 10, 0);
        preferenceStore.setDefault("textOutputFont", fontData.toString());
        preferenceStore.setDefault(SHELL_X, 100);
        preferenceStore.setDefault(SHELL_Y, 100);
        preferenceStore.setDefault(SHELL_WIDTH, 800);
        preferenceStore.setDefault(SHELL_HEIGHT, 600);
        preferenceStore.setDefault(EXPLORER_SHELL_X, 50);
        preferenceStore.setDefault(EXPLORER_SHELL_Y, 50);
        preferenceStore.setDefault(SHOW_NATIVE_HEAP, false);
    }

    public static void run(Shell shell) {
        PreferenceStore preferenceStore = mStore.getPreferenceStore();
        assert (preferenceStore != null);
        PreferenceManager preferenceManager = new PreferenceManager();
        PreferenceNode preferenceNode = new PreferenceNode("debugger", (IPreferencePage)new DebuggerPrefs());
        preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
        PreferenceNode preferenceNode2 = new PreferenceNode("panel", (IPreferencePage)new PanelPrefs());
        preferenceManager.addToRoot((IPreferenceNode)preferenceNode2);
        preferenceNode = new PreferenceNode("LogCat", (IPreferencePage)new LogCatPrefs());
        preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
        preferenceNode = new PreferenceNode("misc", (IPreferencePage)new MiscPrefs());
        preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
        preferenceNode = new PreferenceNode("stats", (IPreferencePage)new UsageStatsPrefs());
        preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
        PreferenceDialog preferenceDialog = new PreferenceDialog(shell, preferenceManager);
        preferenceDialog.setPreferenceStore((IPreferenceStore)preferenceStore);
        try {
            preferenceDialog.open();
        }
        catch (Throwable throwable) {
            Log.e((String)"ddms", (Throwable)throwable);
        }
        try {
            preferenceStore.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class UsageStatsPrefs
    extends PreferencePage {
        private BooleanFieldEditor mOptInCheckbox;
        private Composite mTop;

        public UsageStatsPrefs() {
            this.setTitle("Usage Stats");
        }

        protected Control createContents(Composite composite) {
            this.mTop = new Composite(composite, 0);
            this.mTop.setLayout((Layout)new GridLayout(1, false));
            this.mTop.setLayoutData((Object)new GridData(1808));
            Label label = new Label(this.mTop, 64);
            label.setLayoutData((Object)new GridData(768));
            label.setText("By choosing to send certain usage statistics to Google, you can help us improve the Android SDK. These usage statistics lets us measure things like active usage of the SDK, and let us know things like which versions of the SDK are in use and which tools are the most popular with developers. This limited data is not associated with personal information about you, and is examined on an aggregate basis, and is maintained in accordance with the Google Privacy Policy.");
            Link link = new Link(this.mTop, 64);
            link.setText("<a href=\"http://www.google.com/intl/en/privacy.html\">Google Privacy Policy</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SdkStatsPermissionDialog.openUrl((String)selectionEvent.text);
                }
            });
            this.mOptInCheckbox = new BooleanFieldEditor("pingOptIn", "Send usage statistics to Google.", this.mTop);
            this.mOptInCheckbox.setPage((DialogPage)this);
            this.mOptInCheckbox.setPreferenceStore(this.getPreferenceStore());
            this.mOptInCheckbox.load();
            return null;
        }

        protected Point doComputeSize() {
            if (this.mTop != null) {
                return this.mTop.computeSize(450, -1, true);
            }
            return super.doComputeSize();
        }

        protected void performDefaults() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.loadDefault();
            }
            super.performDefaults();
        }

        public void performApply() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.store();
            }
            super.performApply();
        }

        public boolean performOk() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.store();
            }
            return super.performOk();
        }
    }

    private static class MiscPrefs
    extends FieldEditorPreferencePage {
        public MiscPrefs() {
            super(0);
            this.setTitle("Misc");
        }

        protected void createFieldEditors() {
            IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(PrefsDialog.PREFS_TIMEOUT, "ADB connection time out (ms):", this.getFieldEditorParent());
            this.addField((FieldEditor)integerFieldEditor);
            integerFieldEditor = new IntegerFieldEditor(PrefsDialog.PREFS_PROFILER_BUFFER_SIZE_MB, "Profiler buffer size (MB):", this.getFieldEditorParent());
            this.addField((FieldEditor)integerFieldEditor);
            DirectoryFieldEditor directoryFieldEditor = new DirectoryFieldEditor("textSaveDir", "Default text save dir:", this.getFieldEditorParent());
            this.addField((FieldEditor)directoryFieldEditor);
            directoryFieldEditor = new DirectoryFieldEditor("imageSaveDir", "Default image save dir:", this.getFieldEditorParent());
            this.addField((FieldEditor)directoryFieldEditor);
            FontFieldEditor fontFieldEditor = new FontFieldEditor("textOutputFont", "Text output font:", this.getFieldEditorParent());
            this.addField((FieldEditor)fontFieldEditor);
            RadioGroupFieldEditor radioGroupFieldEditor = new RadioGroupFieldEditor(PrefsDialog.PREFS_LOG_LEVEL, "Logging Level", 1, (String[][])new String[][]{{"Verbose", Log.LogLevel.VERBOSE.getStringValue()}, {"Debug", Log.LogLevel.DEBUG.getStringValue()}, {"Info", Log.LogLevel.INFO.getStringValue()}, {"Warning", Log.LogLevel.WARN.getStringValue()}, {"Error", Log.LogLevel.ERROR.getStringValue()}, {"Assert", Log.LogLevel.ASSERT.getStringValue()}}, this.getFieldEditorParent(), true);
            this.addField((FieldEditor)radioGroupFieldEditor);
        }
    }

    private static class LogCatPrefs
    extends FieldEditorPreferencePage {
        public LogCatPrefs() {
            super(0);
            this.setTitle("Logcat");
        }

        protected void createFieldEditors() {
            if (UIThread.useOldLogCatView()) {
                RadioGroupFieldEditor radioGroupFieldEditor = new RadioGroupFieldEditor(PrefsDialog.LOGCAT_COLUMN_MODE, "Message Column Resizing Mode", 1, (String[][])new String[][]{{"Manual", PrefsDialog.LOGCAT_COLUMN_MODE_MANUAL}, {"Automatic", PrefsDialog.LOGCAT_COLUMN_MODE_AUTO}}, this.getFieldEditorParent(), true);
                this.addField((FieldEditor)radioGroupFieldEditor);
                FontFieldEditor fontFieldEditor = new FontFieldEditor(PrefsDialog.LOGCAT_FONT, "Text output font:", this.getFieldEditorParent());
                this.addField((FieldEditor)fontFieldEditor);
            } else {
                FontFieldEditor fontFieldEditor = new FontFieldEditor("logcat.view.font", "Text output font:", this.getFieldEditorParent());
                this.addField((FieldEditor)fontFieldEditor);
                IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor("logcat.messagelist.max.size", "Maximum number of logcat messages to buffer", this.getFieldEditorParent());
                this.addField((FieldEditor)integerFieldEditor);
                BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor("logcat.view.auto-scroll-lock", "Automatically enable/disable scroll lock based on the scrollbar position", this.getFieldEditorParent());
                this.addField((FieldEditor)booleanFieldEditor);
            }
        }
    }

    private static class PanelPrefs
    extends FieldEditorPreferencePage {
        public PanelPrefs() {
            super(0);
            this.setTitle("Info Panels");
        }

        protected void createFieldEditors() {
            BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor(PrefsDialog.PREFS_DEFAULT_THREAD_UPDATE, "Thread updates enabled by default", this.getFieldEditorParent());
            this.addField((FieldEditor)booleanFieldEditor);
            booleanFieldEditor = new BooleanFieldEditor(PrefsDialog.PREFS_DEFAULT_HEAP_UPDATE, "Heap updates enabled by default", this.getFieldEditorParent());
            this.addField((FieldEditor)booleanFieldEditor);
            IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(PrefsDialog.PREFS_THREAD_REFRESH_INTERVAL, "Thread status interval (seconds):", this.getFieldEditorParent());
            integerFieldEditor.setValidRange(1, 60);
            this.addField((FieldEditor)integerFieldEditor);
        }
    }

    private static class DebuggerPrefs
    extends FieldEditorPreferencePage {
        private BooleanFieldEditor mUseAdbHost;
        private StringFieldEditor mAdbHostValue;

        public DebuggerPrefs() {
            super(1);
            this.setTitle("Debugger");
        }

        protected void createFieldEditors() {
            PortFieldEditor portFieldEditor = new PortFieldEditor(PrefsDialog.PREFS_DEBUG_PORT_BASE, "Starting value for local port:", this.getFieldEditorParent());
            this.addField((FieldEditor)portFieldEditor);
            portFieldEditor = new PortFieldEditor(PrefsDialog.PREFS_SELECTED_DEBUG_PORT, "Port of Selected VM:", this.getFieldEditorParent());
            this.addField((FieldEditor)portFieldEditor);
            this.mUseAdbHost = new BooleanFieldEditor(PrefsDialog.PREFS_USE_ADBHOST, "Use ADBHOST", this.getFieldEditorParent());
            this.addField((FieldEditor)this.mUseAdbHost);
            this.mAdbHostValue = new StringFieldEditor(PrefsDialog.PREFS_ADBHOST_VALUE, "ADBHOST value:", this.getFieldEditorParent());
            this.mAdbHostValue.setEnabled(this.getPreferenceStore().getBoolean(PrefsDialog.PREFS_USE_ADBHOST), this.getFieldEditorParent());
            this.addField((FieldEditor)this.mAdbHostValue);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource().equals(this.mUseAdbHost)) {
                this.mAdbHostValue.setEnabled(this.mUseAdbHost.getBooleanValue(), this.getFieldEditorParent());
            }
        }
    }

    private static class ChangeListener
    implements IPropertyChangeListener {
        private ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            PreferenceStore preferenceStore = mStore.getPreferenceStore();
            if (string.equals(PrefsDialog.PREFS_DEBUG_PORT_BASE)) {
                DdmPreferences.setDebugPortBase((int)preferenceStore.getInt(PrefsDialog.PREFS_DEBUG_PORT_BASE));
            } else if (string.equals(PrefsDialog.PREFS_SELECTED_DEBUG_PORT)) {
                DdmPreferences.setSelectedDebugPort((int)preferenceStore.getInt(PrefsDialog.PREFS_SELECTED_DEBUG_PORT));
            } else if (string.equals(PrefsDialog.PREFS_LOG_LEVEL)) {
                DdmPreferences.setLogLevel((String)((String)propertyChangeEvent.getNewValue()));
            } else if (string.equals("textSaveDir")) {
                preferenceStore.setValue("lastTextSaveDir", (String)propertyChangeEvent.getNewValue());
            } else if (string.equals("imageSaveDir")) {
                preferenceStore.setValue("lastImageSaveDir", (String)propertyChangeEvent.getNewValue());
            } else if (string.equals(PrefsDialog.PREFS_TIMEOUT)) {
                DdmPreferences.setTimeOut((int)preferenceStore.getInt(PrefsDialog.PREFS_TIMEOUT));
            } else if (string.equals(PrefsDialog.PREFS_PROFILER_BUFFER_SIZE_MB)) {
                DdmPreferences.setProfilerBufferSizeMb((int)preferenceStore.getInt(PrefsDialog.PREFS_PROFILER_BUFFER_SIZE_MB));
            } else if (string.equals(PrefsDialog.PREFS_USE_ADBHOST)) {
                DdmPreferences.setUseAdbHost((boolean)preferenceStore.getBoolean(PrefsDialog.PREFS_USE_ADBHOST));
            } else if (string.equals(PrefsDialog.PREFS_ADBHOST_VALUE)) {
                DdmPreferences.setAdbHostValue((String)preferenceStore.getString(PrefsDialog.PREFS_ADBHOST_VALUE));
            } else {
                Log.v((String)"ddms", (String)("Preference change: " + propertyChangeEvent.getProperty() + ": '" + propertyChangeEvent.getOldValue() + "' --> '" + propertyChangeEvent.getNewValue() + "'"));
            }
        }
    }
}

