/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddms.AboutDialog;
import com.android.ddms.DeviceCommandDialog;
import com.android.ddms.PrefsDialog;
import com.android.ddms.StaticPortConfigDialog;
import com.android.ddmuilib.AllocationPanel;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.DevicePanel;
import com.android.ddmuilib.EmulatorControlPanel;
import com.android.ddmuilib.HeapPanel;
import com.android.ddmuilib.ITableFocusListener;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.InfoPanel;
import com.android.ddmuilib.NativeHeapPanel;
import com.android.ddmuilib.ScreenShotDialog;
import com.android.ddmuilib.SysinfoPanel;
import com.android.ddmuilib.TablePanel;
import com.android.ddmuilib.ThreadPanel;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.actions.ToolItemAction;
import com.android.ddmuilib.explorer.DeviceExplorer;
import com.android.ddmuilib.handler.BaseFileHandler;
import com.android.ddmuilib.handler.MethodProfilingHandler;
import com.android.ddmuilib.log.event.EventLogPanel;
import com.android.ddmuilib.logcat.LogCatPanel;
import com.android.ddmuilib.logcat.LogColors;
import com.android.ddmuilib.logcat.LogFilter;
import com.android.ddmuilib.logcat.LogPanel;
import com.android.ddmuilib.net.NetworkPanel;
import com.android.menubar.IMenuBarCallback;
import com.android.menubar.IMenuBarEnhancer;
import com.android.menubar.MenuBarEnhancer;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class UIThread
implements DevicePanel.IUiSelectionListener,
AndroidDebugBridge.IClientChangeListener {
    public static final String APP_NAME = "DDMS";
    public static final int PANEL_CLIENT_LIST = -1;
    public static final int PANEL_INFO = 0;
    public static final int PANEL_THREAD = 1;
    public static final int PANEL_HEAP = 2;
    private static final int PANEL_NATIVE_HEAP = 3;
    private static final int PANEL_ALLOCATIONS = 4;
    private static final int PANEL_SYSINFO = 5;
    private static final int PANEL_NETWORK = 6;
    private static final int PANEL_COUNT = 7;
    private static TablePanel[] mPanels = new TablePanel[7];
    private static final String[] mPanelNames = new String[]{"Info", "Threads", "VM Heap", "Native Heap", "Allocation Tracker", "Sysinfo", "Network"};
    private static final String[] mPanelTips = new String[]{"Client information", "Thread status", "VM heap status", "Native heap status", "Allocation Tracker", "Sysinfo graphs", "Network usage"};
    private static final String PREFERENCE_LOGSASH = "logSashLocation";
    private static final String PREFERENCE_SASH = "sashLocation";
    private static final String PREFS_COL_TIME = "logcat.time";
    private static final String PREFS_COL_LEVEL = "logcat.level";
    private static final String PREFS_COL_PID = "logcat.pid";
    private static final String PREFS_COL_TAG = "logcat.tag";
    private static final String PREFS_COL_MESSAGE = "logcat.message";
    private static final String PREFS_FILTERS = "logcat.filter";
    private static UIThread mInstance = new UIThread();
    private Display mDisplay;
    private DevicePanel mDevicePanel;
    private IDevice mCurrentDevice = null;
    private Client mCurrentClient = null;
    private Label mStatusLine;
    private ToolItem mTBShowThreadUpdates;
    private ToolItem mTBShowHeapUpdates;
    private ToolItem mTBHalt;
    private ToolItem mTBCauseGc;
    private ToolItem mTBDumpHprof;
    private ToolItem mTBProfiling;
    private static final String USE_OLD_LOGCAT_VIEW = System.getenv("ANDROID_USE_OLD_LOGCAT_VIEW");
    private LogPanel mLogPanel;
    private LogCatPanel mLogCatPanel;
    private ToolItemAction mCreateFilterAction;
    private ToolItemAction mDeleteFilterAction;
    private ToolItemAction mEditFilterAction;
    private ToolItemAction mExportAction;
    private ToolItemAction mClearAction;
    private ToolItemAction[] mLogLevelActions;
    private String[] mLogLevelIcons = new String[]{"v.png", "d.png", "i.png", "w.png", "e.png"};
    protected Clipboard mClipboard;
    private MenuItem mCopyMenuItem;
    private MenuItem mSelectAllMenuItem;
    private TableFocusListener mTableListener;
    private DeviceExplorer mExplorer = null;
    private Shell mExplorerShell = null;
    private EmulatorControlPanel mEmulatorPanel;
    private EventLogPanel mEventLogPanel;
    private Image mTracingStartImage;
    private Image mTracingStopImage;
    private ImageLoader mDdmUiLibLoader;

    public static boolean useOldLogCatView() {
        return USE_OLD_LOGCAT_VIEW != null;
    }

    private UIThread() {
        UIThread.mPanels[0] = new InfoPanel();
        UIThread.mPanels[1] = new ThreadPanel();
        UIThread.mPanels[2] = new HeapPanel();
        UIThread.mPanels[3] = PrefsDialog.getStore().getBoolean("native") ? (System.getenv("ANDROID_DDMS_OLD_HEAP_PANEL") != null ? new NativeHeapPanel() : new com.android.ddmuilib.heap.NativeHeapPanel(this.getStore())) : null;
        UIThread.mPanels[4] = new AllocationPanel();
        UIThread.mPanels[5] = new SysinfoPanel();
        UIThread.mPanels[6] = new NetworkPanel();
    }

    public static UIThread getInstance() {
        return mInstance;
    }

    public Display getDisplay() {
        return this.mDisplay;
    }

    public void asyncExec(Runnable runnable) {
        if (this.mDisplay != null && !this.mDisplay.isDisposed()) {
            this.mDisplay.asyncExec(runnable);
        }
    }

    public IPreferenceStore getStore() {
        return PrefsDialog.getStore();
    }

    public void runUI(String string) {
        TablePanel[] tablePanelArray;
        Display.setAppName((String)APP_NAME);
        this.mDisplay = Display.getDefault();
        Shell shell = new Shell(this.mDisplay, 1264);
        this.mDdmUiLibLoader = ImageLoader.getDdmUiLibLoader();
        shell.setImage(ImageLoader.getLoader(this.getClass()).loadImage(this.mDisplay, "ddms-128.png", 100, 50, null));
        Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput(){

            public void printAndPromptLog(final Log.LogLevel logLevel, final String string, final String string2) {
                Log.printLog((Log.LogLevel)logLevel, (String)string, (String)string2);
                UIThread.this.mDisplay.asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = UIThread.this.mDisplay.getActiveShell();
                        if (logLevel == Log.LogLevel.ERROR) {
                            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                        } else {
                            MessageDialog.openWarning((Shell)shell, (String)string, (String)string2);
                        }
                    }
                });
            }

            public void printLog(Log.LogLevel logLevel, String string, String string2) {
                Log.printLog((Log.LogLevel)logLevel, (String)string, (String)string2);
            }
        });
        ClientData.setHprofDumpHandler((ClientData.IHprofDumpHandler)new HProfHandler(shell));
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)new MethodProfilingHandler(shell));
        String string2 = string != null && string.length() != 0 ? ((tablePanelArray = new File(new File(string).getParent(), "platform-tools")).isDirectory() ? tablePanelArray.getAbsolutePath() + File.separator + "adb" : string + File.separator + "adb") : "adb";
        AndroidDebugBridge.init((boolean)true);
        AndroidDebugBridge.createBridge((String)string2, (boolean)true);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        shell.setText("Dalvik Debug Monitor");
        this.setConfirmClose(shell);
        this.createMenus(shell);
        this.createWidgets(shell);
        shell.pack();
        this.setSizeAndPosition(shell);
        shell.open();
        Log.d((String)"ddms", (String)"UI is up");
        while (!shell.isDisposed()) {
            if (this.mDisplay.readAndDispatch()) continue;
            this.mDisplay.sleep();
        }
        if (UIThread.useOldLogCatView()) {
            this.mLogPanel.stopLogCat(true);
        }
        this.mDevicePanel.dispose();
        for (TablePanel tablePanel : mPanels) {
            if (tablePanel == null) continue;
            tablePanel.dispose();
        }
        ImageLoader.dispose();
        this.mDisplay.dispose();
        Log.d((String)"ddms", (String)"UI is down");
    }

    private void setSizeAndPosition(final Shell shell) {
        shell.setMinimumSize(400, 200);
        PreferenceStore preferenceStore = PrefsDialog.getStore();
        int n = preferenceStore.getInt("shellX");
        int n2 = preferenceStore.getInt("shellY");
        int n3 = preferenceStore.getInt("shellWidth");
        int n4 = preferenceStore.getInt("shellHeight");
        Rectangle rectangle = this.mDisplay.getClientArea();
        if (n3 > rectangle.width) {
            n3 = rectangle.width;
            preferenceStore.setValue("shellWidth", rectangle.width);
        }
        if (n4 > rectangle.height) {
            n4 = rectangle.height;
            preferenceStore.setValue("shellHeight", rectangle.height);
        }
        if (n < rectangle.x) {
            n = rectangle.x;
            preferenceStore.setValue("shellX", rectangle.x);
        } else if (n >= rectangle.x + rectangle.width) {
            n = rectangle.x + rectangle.width - n3;
            preferenceStore.setValue("shellX", rectangle.x);
        }
        if (n2 < rectangle.y) {
            n2 = rectangle.y;
            preferenceStore.setValue("shellY", rectangle.y);
        } else if (n2 >= rectangle.y + rectangle.height) {
            n2 = rectangle.y + rectangle.height - n4;
            preferenceStore.setValue("shellY", rectangle.y);
        }
        shell.setBounds(n, n2, n3, n4);
        shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                Rectangle rectangle = shell.getBounds();
                PreferenceStore preferenceStore = PrefsDialog.getStore();
                preferenceStore.setValue("shellX", rectangle.x);
                preferenceStore.setValue("shellY", rectangle.y);
            }

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = shell.getBounds();
                PreferenceStore preferenceStore = PrefsDialog.getStore();
                preferenceStore.setValue("shellWidth", rectangle.width);
                preferenceStore.setValue("shellHeight", rectangle.height);
            }
        });
    }

    private void setExplorerSizeAndPosition(final Shell shell) {
        shell.setMinimumSize(400, 200);
        PreferenceStore preferenceStore = PrefsDialog.getStore();
        int n = preferenceStore.getInt("explorerShellX");
        int n2 = preferenceStore.getInt("explorerShellY");
        int n3 = preferenceStore.getInt("explorerShellWidth");
        int n4 = preferenceStore.getInt("explorerShellHeight");
        Rectangle rectangle = this.mDisplay.getClientArea();
        if (n3 > rectangle.width) {
            n3 = rectangle.width;
            preferenceStore.setValue("explorerShellWidth", rectangle.width);
        }
        if (n4 > rectangle.height) {
            n4 = rectangle.height;
            preferenceStore.setValue("explorerShellHeight", rectangle.height);
        }
        if (n < rectangle.x) {
            n = rectangle.x;
            preferenceStore.setValue("explorerShellX", rectangle.x);
        } else if (n >= rectangle.x + rectangle.width) {
            n = rectangle.x + rectangle.width - n3;
            preferenceStore.setValue("explorerShellX", rectangle.x);
        }
        if (n2 < rectangle.y) {
            n2 = rectangle.y;
            preferenceStore.setValue("explorerShellY", rectangle.y);
        } else if (n2 >= rectangle.y + rectangle.height) {
            n2 = rectangle.y + rectangle.height - n4;
            preferenceStore.setValue("explorerShellY", rectangle.y);
        }
        shell.setBounds(n, n2, n3, n4);
        shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                Rectangle rectangle = shell.getBounds();
                PreferenceStore preferenceStore = PrefsDialog.getStore();
                preferenceStore.setValue("explorerShellX", rectangle.x);
                preferenceStore.setValue("explorerShellY", rectangle.y);
            }

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = shell.getBounds();
                PreferenceStore preferenceStore = PrefsDialog.getStore();
                preferenceStore.setValue("explorerShellWidth", rectangle.width);
                preferenceStore.setValue("explorerShellHeight", rectangle.height);
            }
        });
    }

    private void setConfirmClose(Shell shell) {
    }

    private void createMenus(final Shell shell) {
        Menu menu = new Menu((Decorations)shell, 2);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("&File");
        MenuItem menuItem2 = new MenuItem(menu, 64);
        menuItem2.setText("&Edit");
        MenuItem menuItem3 = new MenuItem(menu, 64);
        menuItem3.setText("&Actions");
        MenuItem menuItem4 = new MenuItem(menu, 64);
        menuItem4.setText("&Device");
        Menu menu2 = new Menu(menu);
        menuItem.setMenu(menu2);
        Menu menu3 = new Menu(menu);
        menuItem2.setMenu(menu3);
        Menu menu4 = new Menu(menu);
        menuItem3.setMenu(menu4);
        Menu menu5 = new Menu(menu);
        menuItem4.setMenu(menu5);
        MenuItem menuItem5 = new MenuItem(menu2, 0);
        menuItem5.setText("&Static Port Configuration...");
        menuItem5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StaticPortConfigDialog staticPortConfigDialog = new StaticPortConfigDialog(shell);
                staticPortConfigDialog.open();
            }
        });
        IMenuBarEnhancer iMenuBarEnhancer = MenuBarEnhancer.setupMenu((String)APP_NAME, (Menu)menu2, (IMenuBarCallback)new IMenuBarCallback(){

            public void printError(String string, Object ... objectArray) {
                Log.e((String)"DDMS Menu Bar", (String)String.format(string, objectArray));
            }

            public void onPreferencesMenuSelected() {
                PrefsDialog.run(shell);
            }

            public void onAboutMenuSelected() {
                AboutDialog aboutDialog = new AboutDialog(shell);
                aboutDialog.open();
            }
        });
        if (iMenuBarEnhancer.getMenuBarMode() == IMenuBarEnhancer.MenuBarMode.GENERIC) {
            new MenuItem(menu2, 2);
            menuItem5 = new MenuItem(menu2, 0);
            menuItem5.setText("E&xit\tCtrl-Q");
            menuItem5.setAccelerator(0x51 | SWT.MOD1);
            menuItem5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell.close();
                }
            });
        }
        this.mCopyMenuItem = new MenuItem(menu3, 0);
        this.mCopyMenuItem.setText("&Copy\tCtrl-C");
        this.mCopyMenuItem.setAccelerator(0x43 | SWT.MOD1);
        this.mCopyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mTableListener.copy(UIThread.this.mClipboard);
            }
        });
        new MenuItem(menu3, 2);
        this.mSelectAllMenuItem = new MenuItem(menu3, 0);
        this.mSelectAllMenuItem.setText("Select &All\tCtrl-A");
        this.mSelectAllMenuItem.setAccelerator(0x41 | SWT.MOD1);
        this.mSelectAllMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mTableListener.selectAll();
            }
        });
        final MenuItem menuItem6 = new MenuItem(menu4, 0);
        menuItem6.setText("&Halt VM");
        menuItem6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mDevicePanel.killSelectedClient();
            }
        });
        final MenuItem menuItem7 = new MenuItem(menu4, 0);
        menuItem7.setText("Cause &GC");
        menuItem7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mDevicePanel.forceGcOnSelectedClient();
            }
        });
        final MenuItem menuItem8 = new MenuItem(menu4, 0);
        menuItem8.setText("&Reset adb");
        menuItem8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
                if (androidDebugBridge != null) {
                    androidDebugBridge.restart();
                }
            }
        });
        menu4.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                menuItem6.setEnabled(UIThread.this.mTBHalt.getEnabled() && UIThread.this.mCurrentClient != null);
                menuItem7.setEnabled(UIThread.this.mTBCauseGc.getEnabled() && UIThread.this.mCurrentClient != null);
                menuItem8.setEnabled(true);
            }
        });
        final MenuItem menuItem9 = new MenuItem(menu5, 0);
        menuItem9.setText("&Screen capture...\tCtrl-S");
        menuItem9.setAccelerator(0x53 | SWT.MOD1);
        menuItem9.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UIThread.this.mCurrentDevice != null) {
                    ScreenShotDialog screenShotDialog = new ScreenShotDialog(shell);
                    screenShotDialog.open(UIThread.this.mCurrentDevice);
                }
            }
        });
        new MenuItem(menu5, 2);
        final MenuItem menuItem10 = new MenuItem(menu5, 0);
        menuItem10.setText("File Explorer...");
        menuItem10.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.createFileExplorer();
            }
        });
        new MenuItem(menu5, 2);
        final MenuItem menuItem11 = new MenuItem(menu5, 0);
        menuItem11.setText("Show &process status...");
        menuItem11.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceCommandDialog deviceCommandDialog = new DeviceCommandDialog("ps -x", "ps-x.txt", shell);
                deviceCommandDialog.open(UIThread.this.mCurrentDevice);
            }
        });
        final MenuItem menuItem12 = new MenuItem(menu5, 0);
        menuItem12.setText("Dump &device state...");
        menuItem12.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceCommandDialog deviceCommandDialog = new DeviceCommandDialog("/system/bin/dumpstate /proc/self/fd/0", "device-state.txt", shell);
                deviceCommandDialog.open(UIThread.this.mCurrentDevice);
            }
        });
        final MenuItem menuItem13 = new MenuItem(menu5, 0);
        menuItem13.setText("Dump &app state...");
        menuItem13.setEnabled(false);
        menuItem13.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceCommandDialog deviceCommandDialog = new DeviceCommandDialog("dumpsys", "app-state.txt", shell);
                deviceCommandDialog.open(UIThread.this.mCurrentDevice);
            }
        });
        final MenuItem menuItem14 = new MenuItem(menu5, 0);
        menuItem14.setText("Dump &radio state...");
        menuItem14.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceCommandDialog deviceCommandDialog = new DeviceCommandDialog("cat /data/logs/radio.4 /data/logs/radio.3 /data/logs/radio.2 /data/logs/radio.1 /data/logs/radio", "radio-state.txt", shell);
                deviceCommandDialog.open(UIThread.this.mCurrentDevice);
            }
        });
        final MenuItem menuItem15 = new MenuItem(menu5, 0);
        menuItem15.setText("Run &logcat...");
        menuItem15.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceCommandDialog deviceCommandDialog = new DeviceCommandDialog("logcat '*:d jdwp:w'", "log.txt", shell);
                deviceCommandDialog.open(UIThread.this.mCurrentDevice);
            }
        });
        menu5.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                boolean bl = UIThread.this.mCurrentDevice != null;
                menuItem9.setEnabled(bl);
                menuItem10.setEnabled(bl);
                menuItem11.setEnabled(bl);
                menuItem12.setEnabled(bl);
                menuItem13.setEnabled(bl);
                menuItem14.setEnabled(bl);
                menuItem15.setEnabled(bl);
            }
        });
        shell.setMenuBar(menu);
    }

    private void createWidgets(Shell shell) {
        Color color = shell.getDisplay().getSystemColor(16);
        shell.setLayout((Layout)new GridLayout(1, false));
        final Composite composite = new Composite((Composite)shell, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        this.mStatusLine = new Label((Composite)shell, 0);
        this.mStatusLine.setLayoutData((Object)new GridData(768));
        this.mStatusLine.setText("Initializing...");
        final PreferenceStore preferenceStore = PrefsDialog.getStore();
        Composite composite2 = new Composite(composite, 0);
        final Sash sash = new Sash(composite, 256);
        sash.setBackground(color);
        Composite composite3 = new Composite(composite, 0);
        composite.setLayout((Layout)new FormLayout());
        this.createTopPanel(composite2, color);
        this.mClipboard = new Clipboard(composite.getDisplay());
        if (UIThread.useOldLogCatView()) {
            this.createBottomPanel(composite3);
        } else {
            this.createLogCatView(composite3);
        }
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)sash, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        composite2.setLayoutData((Object)formData);
        final FormData formData2 = new FormData();
        formData2.top = preferenceStore != null && preferenceStore.contains(PREFERENCE_LOGSASH) ? new FormAttachment(0, preferenceStore.getInt(PREFERENCE_LOGSASH)) : new FormAttachment(50, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)formData2);
        formData = new FormData();
        formData.top = new FormAttachment((Control)sash, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        composite3.setLayoutData((Object)formData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = sash.getBounds();
                Rectangle rectangle2 = composite.getClientArea();
                int n = rectangle2.height - rectangle.height - 100;
                event.y = Math.max(Math.min(event.y, n), 100);
                if (event.y != rectangle.y) {
                    formData2.top = new FormAttachment(0, event.y);
                    if (preferenceStore != null) {
                        preferenceStore.setValue(UIThread.PREFERENCE_LOGSASH, event.y);
                    }
                    composite.layout();
                }
            }
        });
        this.mTableListener = new TableFocusListener();
        if (UIThread.useOldLogCatView()) {
            this.mLogPanel.setTableFocusListener((ITableFocusListener)this.mTableListener);
        } else {
            this.mLogCatPanel.setTableFocusListener((ITableFocusListener)this.mTableListener);
        }
        this.mEventLogPanel.setTableFocusListener((ITableFocusListener)this.mTableListener);
        for (TablePanel tablePanel : mPanels) {
            if (tablePanel == null) continue;
            tablePanel.setTableFocusListener((ITableFocusListener)this.mTableListener);
        }
        this.mStatusLine.setText("");
    }

    private void createDevicePanelToolBar(ToolBar toolBar) {
        Display display = toolBar.getDisplay();
        this.mTBShowHeapUpdates = new ToolItem(toolBar, 32);
        this.mTBShowHeapUpdates.setImage(this.mDdmUiLibLoader.loadImage(display, "heap.png", 16, 16, null));
        this.mTBShowHeapUpdates.setToolTipText("Show heap updates");
        this.mTBShowHeapUpdates.setEnabled(false);
        this.mTBShowHeapUpdates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UIThread.this.mCurrentClient != null) {
                    boolean bl = !UIThread.this.mCurrentClient.isHeapUpdateEnabled();
                    UIThread.this.mCurrentClient.setHeapUpdateEnabled(bl);
                } else {
                    selectionEvent.doit = false;
                }
            }
        });
        this.mTBDumpHprof = new ToolItem(toolBar, 8);
        this.mTBDumpHprof.setToolTipText("Dump HPROF file");
        this.mTBDumpHprof.setEnabled(false);
        this.mTBDumpHprof.setImage(this.mDdmUiLibLoader.loadImage(display, "hprof.png", 16, 16, null));
        this.mTBDumpHprof.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mDevicePanel.dumpHprof();
                UIThread.this.enableButtons();
            }
        });
        this.mTBCauseGc = new ToolItem(toolBar, 8);
        this.mTBCauseGc.setToolTipText("Cause an immediate GC");
        this.mTBCauseGc.setEnabled(false);
        this.mTBCauseGc.setImage(this.mDdmUiLibLoader.loadImage(display, "gc.png", 16, 16, null));
        this.mTBCauseGc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mDevicePanel.forceGcOnSelectedClient();
            }
        });
        new ToolItem(toolBar, 2);
        this.mTBShowThreadUpdates = new ToolItem(toolBar, 32);
        this.mTBShowThreadUpdates.setImage(this.mDdmUiLibLoader.loadImage(display, "thread.png", 16, 16, null));
        this.mTBShowThreadUpdates.setToolTipText("Show thread updates");
        this.mTBShowThreadUpdates.setEnabled(false);
        this.mTBShowThreadUpdates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UIThread.this.mCurrentClient != null) {
                    boolean bl = !UIThread.this.mCurrentClient.isThreadUpdateEnabled();
                    UIThread.this.mCurrentClient.setThreadUpdateEnabled(bl);
                } else {
                    selectionEvent.doit = false;
                }
            }
        });
        this.mTracingStartImage = this.mDdmUiLibLoader.loadImage(display, "tracing_start.png", 16, 16, null);
        this.mTracingStopImage = this.mDdmUiLibLoader.loadImage(display, "tracing_stop.png", 16, 16, null);
        this.mTBProfiling = new ToolItem(toolBar, 8);
        this.mTBProfiling.setToolTipText("Start Method Profiling");
        this.mTBProfiling.setEnabled(false);
        this.mTBProfiling.setImage(this.mTracingStartImage);
        this.mTBProfiling.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mDevicePanel.toggleMethodProfiling();
            }
        });
        new ToolItem(toolBar, 2);
        this.mTBHalt = new ToolItem(toolBar, 8);
        this.mTBHalt.setToolTipText("Halt the target VM");
        this.mTBHalt.setEnabled(false);
        this.mTBHalt.setImage(this.mDdmUiLibLoader.loadImage(display, "halt.png", 16, 16, null));
        this.mTBHalt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mDevicePanel.killSelectedClient();
            }
        });
        toolBar.pack();
    }

    private void createTopPanel(final Composite composite, Color color) {
        final PreferenceStore preferenceStore = PrefsDialog.getStore();
        composite.setLayout((Layout)new FormLayout());
        Composite composite2 = new Composite(composite, 0);
        final Sash sash = new Sash(composite, 512);
        sash.setBackground(color);
        Composite composite3 = new Composite(composite, 0);
        this.createLeftPanel(composite2);
        this.createRightPanel(composite3);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)sash, 0);
        composite2.setLayoutData((Object)formData);
        final FormData formData2 = new FormData();
        formData2.top = new FormAttachment(0, 0);
        formData2.bottom = new FormAttachment(100, 0);
        formData2.left = preferenceStore != null && preferenceStore.contains(PREFERENCE_SASH) ? new FormAttachment(0, preferenceStore.getInt(PREFERENCE_SASH)) : new FormAttachment(0, 380);
        sash.setLayoutData((Object)formData2);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment((Control)sash, 0);
        formData.right = new FormAttachment(100, 0);
        composite3.setLayoutData((Object)formData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = sash.getBounds();
                Rectangle rectangle2 = composite.getClientArea();
                int n = rectangle2.width - rectangle.width - 60;
                event.x = Math.max(Math.min(event.x, n), 60);
                if (event.x != rectangle.x) {
                    formData2.left = new FormAttachment(0, event.x);
                    if (preferenceStore != null) {
                        preferenceStore.setValue(UIThread.PREFERENCE_SASH, event.x);
                    }
                    composite.layout();
                }
            }
        });
    }

    private void createBottomPanel(Composite composite) {
        ToolItemAction toolItemAction;
        String string;
        PreferenceStore preferenceStore = PrefsDialog.getStore();
        Display display = composite.getDisplay();
        LogColors logColors = new LogColors();
        logColors.infoColor = new Color((Device)display, 0, 127, 0);
        logColors.debugColor = new Color((Device)display, 0, 0, 127);
        logColors.errorColor = new Color((Device)display, 255, 0, 0);
        logColors.warningColor = new Color((Device)display, 255, 127, 0);
        logColors.verboseColor = new Color((Device)display, 0, 0, 0);
        LogPanel.PREFS_TIME = PREFS_COL_TIME;
        LogPanel.PREFS_LEVEL = PREFS_COL_LEVEL;
        LogPanel.PREFS_PID = PREFS_COL_PID;
        LogPanel.PREFS_TAG = PREFS_COL_TAG;
        LogPanel.PREFS_MESSAGE = PREFS_COL_MESSAGE;
        composite.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(composite, 256);
        this.mCreateFilterAction = new ToolItemAction(toolBar, 8);
        this.mCreateFilterAction.item.setToolTipText("Create Filter");
        this.mCreateFilterAction.item.setImage(this.mDdmUiLibLoader.loadImage(this.mDisplay, "add.png", 16, 16, null));
        this.mCreateFilterAction.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mLogPanel.addFilter();
            }
        });
        this.mEditFilterAction = new ToolItemAction(toolBar, 8);
        this.mEditFilterAction.item.setToolTipText("Edit Filter");
        this.mEditFilterAction.item.setImage(this.mDdmUiLibLoader.loadImage(this.mDisplay, "edit.png", 16, 16, null));
        this.mEditFilterAction.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mLogPanel.editFilter();
            }
        });
        this.mDeleteFilterAction = new ToolItemAction(toolBar, 8);
        this.mDeleteFilterAction.item.setToolTipText("Delete Filter");
        this.mDeleteFilterAction.item.setImage(this.mDdmUiLibLoader.loadImage(this.mDisplay, "delete.png", 16, 16, null));
        this.mDeleteFilterAction.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mLogPanel.deleteFilter();
            }
        });
        new ToolItem(toolBar, 2);
        Log.LogLevel[] logLevelArray = Log.LogLevel.values();
        this.mLogLevelActions = new ToolItemAction[this.mLogLevelIcons.length];
        for (int i = 0; i < this.mLogLevelActions.length; ++i) {
            string = logLevelArray[i].getStringValue();
            this.mLogLevelActions[i] = toolItemAction = new ToolItemAction(toolBar, 32);
            toolItemAction.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    for (int i = 0; i < UIThread.this.mLogLevelActions.length; ++i) {
                        ToolItemAction toolItemAction2 = UIThread.this.mLogLevelActions[i];
                        if (toolItemAction2 == toolItemAction) {
                            toolItemAction2.setChecked(true);
                            UIThread.this.mLogPanel.setCurrentFilterLogLevel(i + 2);
                            continue;
                        }
                        toolItemAction2.setChecked(false);
                    }
                }
            });
            toolItemAction.item.setToolTipText(string);
            toolItemAction.item.setImage(this.mDdmUiLibLoader.loadImage(this.mDisplay, this.mLogLevelIcons[i], 16, 16, null));
        }
        new ToolItem(toolBar, 2);
        this.mClearAction = new ToolItemAction(toolBar, 8);
        this.mClearAction.item.setToolTipText("Clear Log");
        this.mClearAction.item.setImage(this.mDdmUiLibLoader.loadImage(this.mDisplay, "clear.png", 16, 16, null));
        this.mClearAction.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mLogPanel.clear();
            }
        });
        new ToolItem(toolBar, 2);
        this.mExportAction = new ToolItemAction(toolBar, 8);
        this.mExportAction.item.setToolTipText("Export Selection As Text...");
        this.mExportAction.item.setImage(this.mDdmUiLibLoader.loadImage(this.mDisplay, "save.png", 16, 16, null));
        this.mExportAction.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIThread.this.mLogPanel.save();
            }
        });
        toolBar.pack();
        this.mLogPanel = new LogPanel(logColors, (LogPanel.ILogFilterStorageManager)new FilterStorage(), 1);
        this.mLogPanel.setActions((ICommonAction)this.mDeleteFilterAction, (ICommonAction)this.mEditFilterAction, (ICommonAction[])this.mLogLevelActions);
        String string2 = preferenceStore.getString("ddmsLogColumnMode");
        if ("auto".equals(string2)) {
            this.mLogPanel.setColumnMode(1);
        }
        if ((string = PrefsDialog.getStore().getString("ddmsLogFont")) != null) {
            try {
                toolItemAction = new FontData(string);
                this.mLogPanel.setFont(new Font((Device)display, (FontData)toolItemAction));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SWTError sWTError) {
                // empty catch block
            }
        }
        this.mLogPanel.createPanel(composite);
        this.mLogPanel.startLogCat(this.mCurrentDevice);
    }

    private void createLogCatView(Composite composite) {
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        this.mLogCatPanel = new LogCatPanel(iPreferenceStore);
        this.mLogCatPanel.createPanel(composite);
        if (this.mCurrentDevice != null) {
            this.mLogCatPanel.deviceSelected(this.mCurrentDevice);
        }
    }

    private void createLeftPanel(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(composite, 131392);
        toolBar.setLayoutData((Object)new GridData(768));
        this.createDevicePanelToolBar(toolBar);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        this.mDevicePanel = new DevicePanel(true);
        this.mDevicePanel.createPanel(composite2);
        this.mDevicePanel.addSelectionListener((DevicePanel.IUiSelectionListener)this);
    }

    private void createRightPanel(Composite composite) {
        TabItem tabItem;
        composite.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(composite, 0);
        for (int i = 0; i < mPanels.length; ++i) {
            if (mPanels[i] == null) continue;
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(mPanelNames[i]);
            tabItem.setToolTipText(mPanelTips[i]);
            tabItem.setControl(mPanels[i].createPanel((Composite)tabFolder));
        }
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Emulator Control");
        tabItem.setToolTipText("Emulator Control Panel");
        this.mEmulatorPanel = new EmulatorControlPanel();
        tabItem.setControl(this.mEmulatorPanel.createPanel((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Event Log");
        tabItem.setToolTipText("Event Log");
        Composite composite2 = new Composite((Composite)tabFolder, 0);
        tabItem.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(composite2, 256);
        toolBar.setLayoutData((Object)new GridData(768));
        ToolItemAction toolItemAction = new ToolItemAction(toolBar, 8);
        toolItemAction.item.setToolTipText("Opens the options panel");
        toolItemAction.item.setImage(this.mDdmUiLibLoader.loadImage(composite.getDisplay(), "edit.png", 16, 16, null));
        ToolItemAction toolItemAction2 = new ToolItemAction(toolBar, 8);
        toolItemAction2.item.setToolTipText("Clears the event log");
        toolItemAction2.item.setImage(this.mDdmUiLibLoader.loadImage(composite.getDisplay(), "clear.png", 16, 16, null));
        new ToolItem(toolBar, 2);
        ToolItemAction toolItemAction3 = new ToolItemAction(toolBar, 8);
        toolItemAction3.item.setToolTipText("Saves the event log");
        toolItemAction3.item.setImage(this.mDdmUiLibLoader.loadImage(composite.getDisplay(), "save.png", 16, 16, null));
        ToolItemAction toolItemAction4 = new ToolItemAction(toolBar, 8);
        toolItemAction4.item.setToolTipText("Loads an event log");
        toolItemAction4.item.setImage(this.mDdmUiLibLoader.loadImage(composite.getDisplay(), "load.png", 16, 16, null));
        ToolItemAction toolItemAction5 = new ToolItemAction(toolBar, 8);
        toolItemAction5.item.setToolTipText("Imports a bug report");
        toolItemAction5.item.setImage(this.mDdmUiLibLoader.loadImage(composite.getDisplay(), "importBug.png", 16, 16, null));
        this.mEventLogPanel = new EventLogPanel();
        this.mEventLogPanel.setActions((ICommonAction)toolItemAction, (ICommonAction)toolItemAction2, (ICommonAction)toolItemAction3, (ICommonAction)toolItemAction4, (ICommonAction)toolItemAction5);
        this.mEventLogPanel.createPanel(composite2);
    }

    private void createFileExplorer() {
        if (this.mExplorer == null) {
            this.mExplorerShell = new Shell(this.mDisplay);
            this.mExplorerShell.setLayout((Layout)new GridLayout(1, false));
            ToolBar toolBar = new ToolBar((Composite)this.mExplorerShell, 256);
            toolBar.setLayoutData((Object)new GridData(768));
            ToolItemAction toolItemAction = new ToolItemAction(toolBar, 8);
            toolItemAction.item.setToolTipText("Pull File from Device");
            Image image = this.mDdmUiLibLoader.loadImage("pull.png", this.mDisplay);
            if (image != null) {
                toolItemAction.item.setImage(image);
            } else {
                toolItemAction.item.setText("Pull");
            }
            ToolItemAction toolItemAction2 = new ToolItemAction(toolBar, 8);
            toolItemAction2.item.setToolTipText("Push file onto Device");
            image = this.mDdmUiLibLoader.loadImage("push.png", this.mDisplay);
            if (image != null) {
                toolItemAction2.item.setImage(image);
            } else {
                toolItemAction2.item.setText("Push");
            }
            ToolItemAction toolItemAction3 = new ToolItemAction(toolBar, 8);
            toolItemAction3.item.setToolTipText("Delete");
            image = this.mDdmUiLibLoader.loadImage("delete.png", this.mDisplay);
            if (image != null) {
                toolItemAction3.item.setImage(image);
            } else {
                toolItemAction3.item.setText("Delete");
            }
            ToolItemAction toolItemAction4 = new ToolItemAction(toolBar, 8);
            toolItemAction4.item.setToolTipText("New Folder");
            image = this.mDdmUiLibLoader.loadImage("add.png", this.mDisplay);
            if (image != null) {
                toolItemAction4.item.setImage(image);
            } else {
                toolItemAction4.item.setText("New Folder");
            }
            this.mExplorer = new DeviceExplorer();
            this.mExplorer.setActions((ICommonAction)toolItemAction2, (ICommonAction)toolItemAction, (ICommonAction)toolItemAction3, (ICommonAction)toolItemAction4);
            toolItemAction.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UIThread.this.mExplorer.pullSelection();
                }
            });
            toolItemAction.setEnabled(false);
            toolItemAction2.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UIThread.this.mExplorer.pushIntoSelection();
                }
            });
            toolItemAction2.setEnabled(false);
            toolItemAction3.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UIThread.this.mExplorer.deleteSelection();
                }
            });
            toolItemAction3.setEnabled(false);
            toolItemAction4.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UIThread.this.mExplorer.createNewFolderInSelection();
                }
            });
            toolItemAction4.setEnabled(false);
            Composite composite = new Composite((Composite)this.mExplorerShell, 0);
            composite.setLayoutData((Object)new GridData(1808));
            this.mExplorer.createPanel(composite);
            this.mExplorer.switchDevice(this.mCurrentDevice);
            this.mExplorerShell.addShellListener(new ShellListener(){

                public void shellActivated(ShellEvent shellEvent) {
                }

                public void shellClosed(ShellEvent shellEvent) {
                    UIThread.this.mExplorer = null;
                    UIThread.this.mExplorerShell = null;
                }

                public void shellDeactivated(ShellEvent shellEvent) {
                }

                public void shellDeiconified(ShellEvent shellEvent) {
                }

                public void shellIconified(ShellEvent shellEvent) {
                }
            });
            this.mExplorerShell.pack();
            this.setExplorerSizeAndPosition(this.mExplorerShell);
            this.mExplorerShell.open();
        } else if (this.mExplorerShell != null) {
            this.mExplorerShell.forceActive();
        }
    }

    public void setStatusLine(final String string) {
        block2: {
            try {
                this.mDisplay.asyncExec(new Runnable(){

                    public void run() {
                        UIThread.this.doSetStatusLine(string);
                    }
                });
            }
            catch (SWTException sWTException) {
                if (this.mDisplay.isDisposed()) break block2;
                throw sWTException;
            }
        }
    }

    private void doSetStatusLine(String string) {
        if (this.mStatusLine.isDisposed()) {
            return;
        }
        if (!this.mStatusLine.getText().equals(string)) {
            this.mStatusLine.setText(string);
        }
    }

    public void displayError(final String string) {
        block2: {
            try {
                this.mDisplay.syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)UIThread.this.mDisplay.getActiveShell(), (String)"Error", (String)string);
                    }
                });
            }
            catch (SWTException sWTException) {
                if (this.mDisplay.isDisposed()) break block2;
                throw sWTException;
            }
        }
    }

    private void enableButtons() {
        if (this.mCurrentClient != null) {
            this.mTBShowThreadUpdates.setSelection(this.mCurrentClient.isThreadUpdateEnabled());
            this.mTBShowThreadUpdates.setEnabled(true);
            this.mTBShowHeapUpdates.setSelection(this.mCurrentClient.isHeapUpdateEnabled());
            this.mTBShowHeapUpdates.setEnabled(true);
            this.mTBHalt.setEnabled(true);
            this.mTBCauseGc.setEnabled(true);
            ClientData clientData = this.mCurrentClient.getClientData();
            if (clientData.hasFeature("hprof-heap-dump")) {
                this.mTBDumpHprof.setEnabled(!clientData.hasPendingHprofDump());
                this.mTBDumpHprof.setToolTipText("Dump HPROF file");
            } else {
                this.mTBDumpHprof.setEnabled(false);
                this.mTBDumpHprof.setToolTipText("Dump HPROF file (not supported by this VM)");
            }
            if (clientData.hasFeature("method-trace-profiling")) {
                this.mTBProfiling.setEnabled(true);
                if (clientData.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.ON) {
                    this.mTBProfiling.setToolTipText("Stop Method Profiling");
                    this.mTBProfiling.setImage(this.mTracingStopImage);
                } else {
                    this.mTBProfiling.setToolTipText("Start Method Profiling");
                    this.mTBProfiling.setImage(this.mTracingStartImage);
                }
            } else {
                this.mTBProfiling.setEnabled(false);
                this.mTBProfiling.setImage(this.mTracingStartImage);
                this.mTBProfiling.setToolTipText("Start Method Profiling (not supported by this VM)");
            }
        } else {
            this.mTBShowThreadUpdates.setSelection(false);
            this.mTBShowThreadUpdates.setEnabled(false);
            this.mTBShowHeapUpdates.setSelection(false);
            this.mTBShowHeapUpdates.setEnabled(false);
            this.mTBHalt.setEnabled(false);
            this.mTBCauseGc.setEnabled(false);
            this.mTBDumpHprof.setEnabled(false);
            this.mTBDumpHprof.setToolTipText("Dump HPROF file");
            this.mTBProfiling.setEnabled(false);
            this.mTBProfiling.setImage(this.mTracingStartImage);
            this.mTBProfiling.setToolTipText("Start Method Profiling");
        }
    }

    public void selectionChanged(IDevice iDevice, Client client) {
        if (this.mCurrentDevice != iDevice) {
            this.mCurrentDevice = iDevice;
            for (TablePanel tablePanel : mPanels) {
                if (tablePanel == null) continue;
                tablePanel.deviceSelected(this.mCurrentDevice);
            }
            this.mEmulatorPanel.deviceSelected(this.mCurrentDevice);
            if (UIThread.useOldLogCatView()) {
                this.mLogPanel.deviceSelected(this.mCurrentDevice);
            } else {
                this.mLogCatPanel.deviceSelected(this.mCurrentDevice);
            }
            if (this.mEventLogPanel != null) {
                this.mEventLogPanel.deviceSelected(this.mCurrentDevice);
            }
            if (this.mExplorer != null) {
                this.mExplorer.switchDevice(this.mCurrentDevice);
            }
        }
        if (this.mCurrentClient != client) {
            AndroidDebugBridge.getBridge().setSelectedClient(client);
            this.mCurrentClient = client;
            for (TablePanel tablePanel : mPanels) {
                if (tablePanel == null) continue;
                tablePanel.clientSelected(this.mCurrentClient);
            }
            this.enableButtons();
        }
    }

    public void clientChanged(Client client, int n) {
        if ((n & 0x800) == 2048 && this.mCurrentClient == client) {
            this.mDisplay.asyncExec(new Runnable(){

                public void run() {
                    UIThread.this.enableButtons();
                }
            });
        }
    }

    private class HProfHandler
    extends BaseFileHandler
    implements ClientData.IHprofDumpHandler {
        public HProfHandler(Shell shell) {
            super(shell);
        }

        public void onEndFailure(final Client client, final String string) {
            UIThread.this.mDisplay.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        HProfHandler.this.displayErrorFromUiThread("Unable to create HPROF file for application '%1$s'\n\n%2$sCheck logcat for more information.", new Object[]{client.getClientData().getClientDescription(), string != null ? string + "\n\n" : ""});
                    }
                    finally {
                        UIThread.this.enableButtons();
                    }
                }
            });
        }

        public void onSuccess(final String string, final Client client) {
            UIThread.this.mDisplay.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IDevice iDevice = client.getDevice();
                    try {
                        SyncService syncService = client.getDevice().getSyncService();
                        if (syncService != null) {
                            HProfHandler.this.promptAndPull(syncService, client.getClientData().getClientDescription() + ".hprof", string, "Save HPROF file");
                        } else {
                            HProfHandler.this.displayErrorFromUiThread("Unable to download HPROF file from device '%1$s'.", new Object[]{iDevice.getSerialNumber()});
                        }
                    }
                    catch (SyncException syncException) {
                        if (!syncException.wasCanceled()) {
                            HProfHandler.this.displayErrorFromUiThread("Unable to download HPROF file from device '%1$s'.\n\n%2$s", new Object[]{iDevice.getSerialNumber(), syncException.getMessage()});
                        }
                    }
                    catch (Exception exception) {
                        HProfHandler.this.displayErrorFromUiThread("Unable to download HPROF file from device '%1$s'.", new Object[]{iDevice.getSerialNumber()});
                    }
                    finally {
                        UIThread.this.enableButtons();
                    }
                }
            });
        }

        public void onSuccess(final byte[] byArray, final Client client) {
            UIThread.this.mDisplay.asyncExec(new Runnable(){

                public void run() {
                    HProfHandler.this.promptAndSave(client.getClientData().getClientDescription() + ".hprof", byArray, "Save HPROF file");
                }
            });
        }

        protected String getDialogTitle() {
            return "HPROF Error";
        }
    }

    private class TableFocusListener
    implements ITableFocusListener {
        private ITableFocusListener.IFocusedTableActivator mCurrentActivator;

        private TableFocusListener() {
        }

        public void focusGained(ITableFocusListener.IFocusedTableActivator iFocusedTableActivator) {
            this.mCurrentActivator = iFocusedTableActivator;
            if (!UIThread.this.mCopyMenuItem.isDisposed()) {
                UIThread.this.mCopyMenuItem.setEnabled(true);
                UIThread.this.mSelectAllMenuItem.setEnabled(true);
            }
        }

        public void focusLost(ITableFocusListener.IFocusedTableActivator iFocusedTableActivator) {
            if (iFocusedTableActivator == this.mCurrentActivator) {
                iFocusedTableActivator = null;
                if (!UIThread.this.mCopyMenuItem.isDisposed()) {
                    UIThread.this.mCopyMenuItem.setEnabled(false);
                    UIThread.this.mSelectAllMenuItem.setEnabled(false);
                }
            }
        }

        public void copy(Clipboard clipboard) {
            if (this.mCurrentActivator != null) {
                this.mCurrentActivator.copy(clipboard);
            }
        }

        public void selectAll() {
            if (this.mCurrentActivator != null) {
                this.mCurrentActivator.selectAll();
            }
        }
    }

    private final class FilterStorage
    implements LogPanel.ILogFilterStorageManager {
        private FilterStorage() {
        }

        public LogFilter[] getFilterFromStore() {
            String string = PrefsDialog.getStore().getString(UIThread.PREFS_FILTERS);
            String[] stringArray = string.split("\\|");
            ArrayList<LogFilter> arrayList = new ArrayList<LogFilter>(stringArray.length);
            for (String string2 : stringArray) {
                LogFilter logFilter;
                if (string2.length() <= 0 || !(logFilter = new LogFilter()).loadFromString(string2)) continue;
                arrayList.add(logFilter);
            }
            return arrayList.toArray(new LogFilter[arrayList.size()]);
        }

        public void saveFilters(LogFilter[] logFilterArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (LogFilter logFilter : logFilterArray) {
                String string = logFilter.toString();
                stringBuilder.append(string);
                stringBuilder.append('|');
            }
            PrefsDialog.getStore().setValue(UIThread.PREFS_FILTERS, stringBuilder.toString());
        }

        public boolean requiresDefaultFilter() {
            return true;
        }
    }
}

