/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Log;
import com.android.ddmlib.NativeLibraryMapInfo;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.DdmUiPreferences;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Addr2Line {
    private static final String ANDROID_SYMBOLS_ENVVAR = "ANDROID_SYMBOLS";
    private static final String LIBRARY_NOT_FOUND_MESSAGE_FORMAT = "Unable to locate library %s on disk. Addresses mapping to this library will not be resolved. In order to fix this, set the the library search path in the UI, or set the environment variable ANDROID_SYMBOLS.";
    private static final HashMap<String, Addr2Line> sProcessCache = new HashMap();
    private static final byte[] sCrLf = new byte[]{10};
    private NativeLibraryMapInfo mLibrary;
    private Process mProcess;
    private BufferedReader mResultReader;
    private BufferedOutputStream mAddressWriter;
    private static final String DEFAULT_LIBRARY_SYMBOLS_FOLDER;
    private static List<String> mLibrarySearchPaths;

    public static void setSearchPath(String string) {
        mLibrarySearchPaths.clear();
        mLibrarySearchPaths.addAll(Arrays.asList(string.split(":")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Addr2Line getProcess(NativeLibraryMapInfo nativeLibraryMapInfo) {
        String string = nativeLibraryMapInfo.getLibraryName();
        if (string != null) {
            HashMap<String, Addr2Line> hashMap = sProcessCache;
            synchronized (hashMap) {
                Addr2Line addr2Line = sProcessCache.get(string);
                if (addr2Line == null) {
                    addr2Line = new Addr2Line(nativeLibraryMapInfo);
                    boolean bl = addr2Line.start();
                    if (bl) {
                        sProcessCache.put(string, addr2Line);
                    } else {
                        addr2Line = null;
                    }
                }
                return addr2Line;
            }
        }
        return null;
    }

    private Addr2Line(NativeLibraryMapInfo nativeLibraryMapInfo) {
        this.mLibrary = nativeLibraryMapInfo;
    }

    private String getLibraryPath(String string) {
        String string2 = DEFAULT_LIBRARY_SYMBOLS_FOLDER + string;
        if (new File(string2).exists()) {
            return string2;
        }
        for (String string3 : mLibrarySearchPaths) {
            String string4 = string3 + "/" + string;
            if (new File(string4).exists()) {
                return string4;
            }
            string4 = string3 + "/" + new File(string).getName();
            if (!new File(string4).exists()) continue;
            return string4;
        }
        return null;
    }

    private boolean start() {
        block6: {
            String string = System.getenv("ANDROID_ADDR2LINE");
            if (string == null) {
                string = DdmUiPreferences.getAddr2Line();
            }
            String[] stringArray = new String[5];
            stringArray[0] = string;
            stringArray[1] = "-C";
            stringArray[2] = "-f";
            stringArray[3] = "-e";
            String string2 = this.getLibraryPath(this.mLibrary.getLibraryName());
            if (string2 == null) {
                String string3 = String.format(LIBRARY_NOT_FOUND_MESSAGE_FORMAT, this.mLibrary.getLibraryName());
                Log.e((String)"ddm-Addr2Line", (String)string3);
                return false;
            }
            stringArray[4] = string2;
            try {
                this.mProcess = Runtime.getRuntime().exec(stringArray);
                if (this.mProcess != null) {
                    InputStreamReader inputStreamReader = new InputStreamReader(this.mProcess.getInputStream());
                    this.mResultReader = new BufferedReader(inputStreamReader);
                    this.mAddressWriter = new BufferedOutputStream(this.mProcess.getOutputStream());
                    if (this.mResultReader == null || this.mAddressWriter == null) {
                        this.mProcess.destroy();
                        this.mProcess = null;
                        return false;
                    }
                    return true;
                }
            }
            catch (IOException iOException) {
                String string4 = String.format("Error while trying to start %1$s process for library %2$s", DdmUiPreferences.getAddr2Line(), this.mLibrary);
                Log.e((String)"ddm-Addr2Line", (String)string4);
                if (this.mProcess == null) break block6;
                this.mProcess.destroy();
                this.mProcess = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            if (this.mProcess != null) {
                sProcessCache.remove(this.mLibrary);
                this.mProcess.destroy();
                this.mProcess = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll() {
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            Collection<Addr2Line> collection = sProcessCache.values();
            for (Addr2Line addr2Line : collection) {
                addr2Line.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeStackCallInfo getAddress(long l) {
        long l2 = l - this.mLibrary.getStartAddress();
        HashMap<String, Addr2Line> hashMap = sProcessCache;
        synchronized (hashMap) {
            if (this.mProcess != null) {
                String string = Long.toString(l2, 16);
                try {
                    this.mAddressWriter.write(string.getBytes());
                    this.mAddressWriter.write(sCrLf);
                    this.mAddressWriter.flush();
                    String string2 = this.mResultReader.readLine();
                    String string3 = this.mResultReader.readLine();
                    if (string2 != null && string3 != null) {
                        return new NativeStackCallInfo(l, this.mLibrary.getLibraryName(), string2, string3);
                    }
                }
                catch (IOException iOException) {
                    Log.e((String)"ddms", (String)("Error while trying to get information for addr: " + string + " in library: " + this.mLibrary));
                }
            }
        }
        return null;
    }

    static {
        String string = System.getenv(ANDROID_SYMBOLS_ENVVAR);
        DEFAULT_LIBRARY_SYMBOLS_FOLDER = string == null ? DdmUiPreferences.getSymbolDirectory() : string;
        mLibrarySearchPaths = new ArrayList<String>();
    }
}

