/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.HeapSegment;
import com.android.ddmlib.Log;
import com.android.ddmuilib.BaseHeapPanel;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.TableHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.experimental.swt.SWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeapPanel
extends BaseHeapPanel {
    private static final String PREFS_STATS_COL_TYPE = "heapPanel.col0";
    private static final String PREFS_STATS_COL_COUNT = "heapPanel.col1";
    private static final String PREFS_STATS_COL_SIZE = "heapPanel.col2";
    private static final String PREFS_STATS_COL_SMALLEST = "heapPanel.col3";
    private static final String PREFS_STATS_COL_LARGEST = "heapPanel.col4";
    private static final String PREFS_STATS_COL_MEDIAN = "heapPanel.col5";
    private static final String PREFS_STATS_COL_AVERAGE = "heapPanel.col6";
    private static final int NOT_SELECTED = 0;
    private static final int NOT_ENABLED = 1;
    private static final int ENABLED = 2;
    private static final int NUM_PALETTE_ENTRIES = HeapSegment.HeapSegmentElement.KIND_NATIVE + 2 + 1;
    private static final String[] mMapLegend = new String[NUM_PALETTE_ENTRIES];
    private static final PaletteData mMapPalette = HeapPanel.createPalette();
    private static final boolean DISPLAY_HEAP_BITMAP = false;
    private static final boolean DISPLAY_HILBERT_BITMAP = false;
    private static final int PLACEHOLDER_HILBERT_SIZE = 200;
    private static final int PLACEHOLDER_LINEAR_V_SIZE = 100;
    private static final int PLACEHOLDER_LINEAR_H_SIZE = 300;
    private static final int[] ZOOMS = new int[]{100, 50, 25};
    private static final NumberFormat sByteFormatter = NumberFormat.getInstance();
    private static final NumberFormat sLargeByteFormatter = NumberFormat.getInstance();
    private static final NumberFormat sCountFormatter = NumberFormat.getInstance();
    private Display mDisplay;
    private Composite mTop;
    private Label mUpdateStatus;
    private Table mHeapSummary;
    private Combo mDisplayMode;
    private Composite mDisplayBase;
    private StackLayout mDisplayStack;
    private Composite mStatisticsBase;
    private Table mStatisticsTable;
    private JFreeChart mChart;
    private ChartComposite mChartComposite;
    private Button mGcButton;
    private DefaultCategoryDataset mAllocCountDataSet;
    private Composite mLinearBase;
    private Label mLinearHeapImage;
    private Composite mHilbertBase;
    private Label mHilbertHeapImage;
    private Group mLegend;
    private Combo mZoom;
    private Image mHilbertImage;
    private Image mLinearImage;
    private Composite[] mLayout;
    private static final int HILBERT_DIR_N = 0;
    private static final int HILBERT_DIR_S = 1;
    private static final int HILBERT_DIR_E = 2;
    private static final int HILBERT_DIR_W = 3;

    private static PaletteData createPalette() {
        RGB[] rGBArray = new RGB[NUM_PALETTE_ENTRIES];
        rGBArray[0] = new RGB(192, 192, 192);
        HeapPanel.mMapLegend[0] = "(heap expansion area)";
        rGBArray[1] = new RGB(0, 0, 0);
        HeapPanel.mMapLegend[1] = "free";
        rGBArray[HeapSegment.HeapSegmentElement.KIND_OBJECT + 2] = new RGB(0, 0, 255);
        HeapPanel.mMapLegend[HeapSegment.HeapSegmentElement.KIND_OBJECT + 2] = "data object";
        rGBArray[HeapSegment.HeapSegmentElement.KIND_CLASS_OBJECT + 2] = new RGB(0, 255, 0);
        HeapPanel.mMapLegend[HeapSegment.HeapSegmentElement.KIND_CLASS_OBJECT + 2] = "class object";
        rGBArray[HeapSegment.HeapSegmentElement.KIND_ARRAY_1 + 2] = new RGB(255, 0, 0);
        HeapPanel.mMapLegend[HeapSegment.HeapSegmentElement.KIND_ARRAY_1 + 2] = "1-byte array (byte[], boolean[])";
        rGBArray[HeapSegment.HeapSegmentElement.KIND_ARRAY_2 + 2] = new RGB(255, 128, 0);
        HeapPanel.mMapLegend[HeapSegment.HeapSegmentElement.KIND_ARRAY_2 + 2] = "2-byte array (short[], char[])";
        rGBArray[HeapSegment.HeapSegmentElement.KIND_ARRAY_4 + 2] = new RGB(255, 255, 0);
        HeapPanel.mMapLegend[HeapSegment.HeapSegmentElement.KIND_ARRAY_4 + 2] = "4-byte array (object[], int[], float[])";
        rGBArray[HeapSegment.HeapSegmentElement.KIND_ARRAY_8 + 2] = new RGB(255, 128, 128);
        HeapPanel.mMapLegend[HeapSegment.HeapSegmentElement.KIND_ARRAY_8 + 2] = "8-byte array (long[], double[])";
        rGBArray[HeapSegment.HeapSegmentElement.KIND_UNKNOWN + 2] = new RGB(255, 0, 255);
        HeapPanel.mMapLegend[HeapSegment.HeapSegmentElement.KIND_UNKNOWN + 2] = "unknown object";
        rGBArray[HeapSegment.HeapSegmentElement.KIND_NATIVE + 2] = new RGB(64, 64, 64);
        HeapPanel.mMapLegend[HeapSegment.HeapSegmentElement.KIND_NATIVE + 2] = "non-Java object";
        return new PaletteData(rGBArray);
    }

    public void clientChanged(Client client, int n) {
        if (client == this.getCurrentClient() && ((n & 0x20) == 32 || (n & 0x40) == 64)) {
            try {
                this.mTop.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        HeapPanel.this.clientSelected();
                    }
                });
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    @Override
    public void deviceSelected() {
    }

    @Override
    public void clientSelected() {
        if (this.mTop.isDisposed()) {
            return;
        }
        Client client = this.getCurrentClient();
        Log.d((String)"ddms", (String)("HeapPanel: changed " + client));
        if (client != null) {
            ClientData clientData = client.getClientData();
            if (client.isHeapUpdateEnabled()) {
                this.mGcButton.setEnabled(true);
                this.mDisplayMode.setEnabled(true);
                this.setUpdateStatus(2);
            } else {
                this.setUpdateStatus(1);
                this.mGcButton.setEnabled(false);
                this.mDisplayMode.setEnabled(false);
            }
            this.fillSummaryTable(clientData);
            int n = this.mDisplayMode.getSelectionIndex();
            if (n == 0) {
                this.fillDetailedTable(client, false);
            }
        } else {
            this.mGcButton.setEnabled(false);
            this.mDisplayMode.setEnabled(false);
            this.fillSummaryTable(null);
            this.fillDetailedTable(null, true);
            this.setUpdateStatus(0);
        }
        this.mDisplayBase.layout();
    }

    @Override
    protected Control createControl(Composite composite) {
        this.mDisplay = composite.getDisplay();
        this.mTop = new Composite(composite, 0);
        this.mTop.setLayout((Layout)new GridLayout(1, false));
        this.mTop.setLayoutData((Object)new GridData(1808));
        this.mUpdateStatus = new Label(this.mTop, 0);
        this.setUpdateStatus(0);
        Composite composite2 = new Composite(this.mTop, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mHeapSummary = this.createSummaryTable(composite2);
        this.mGcButton = new Button(composite2, 8);
        this.mGcButton.setText("Cause GC");
        this.mGcButton.setEnabled(false);
        this.mGcButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Client client = HeapPanel.this.getCurrentClient();
                if (client != null) {
                    client.executeGarbageCollector();
                }
            }
        });
        Composite composite3 = new Composite(this.mTop, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText("Display: ");
        this.mDisplayMode = new Combo(composite3, 8);
        this.mDisplayMode.setEnabled(false);
        this.mDisplayMode.add("Stats");
        this.mDisplayBase = new Composite(this.mTop, 0);
        this.mDisplayBase.setLayoutData((Object)new GridData(1808));
        this.mDisplayStack = new StackLayout();
        this.mDisplayBase.setLayout((Layout)this.mDisplayStack);
        this.mStatisticsBase = new Composite(this.mDisplayBase, 0);
        gridLayout = new GridLayout(1, false);
        this.mStatisticsBase.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mDisplayStack.topControl = this.mStatisticsBase;
        this.mStatisticsTable = this.createDetailedTable(this.mStatisticsBase);
        this.mStatisticsTable.setLayoutData((Object)new GridData(1808));
        this.createChart();
        this.mLinearBase = new Composite(this.mDisplayBase, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mLinearBase.setLayout((Layout)gridLayout);
        this.mLinearHeapImage = new Label(this.mLinearBase, 0);
        this.mLinearHeapImage.setLayoutData((Object)new GridData());
        this.mLinearHeapImage.setImage(ImageLoader.createPlaceHolderArt(this.mDisplay, 300, 100, this.mDisplay.getSystemColor(9)));
        Composite composite4 = new Composite(this.mLinearBase, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite4.setLayout((Layout)gridLayout);
        this.createLegend(composite4);
        this.mHilbertBase = new Composite(this.mDisplayBase, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mHilbertBase.setLayout((Layout)gridLayout);
        this.mHilbertBase.pack();
        this.mLayout = new Composite[]{this.mStatisticsBase, this.mLinearBase, this.mHilbertBase};
        this.mDisplayMode.select(0);
        this.mDisplayMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = HeapPanel.this.mDisplayMode.getSelectionIndex();
                Client client = HeapPanel.this.getCurrentClient();
                if (client != null) {
                    if (n == 0) {
                        HeapPanel.this.fillDetailedTable(client, true);
                    } else {
                        HeapPanel.this.renderHeapData(client.getClientData(), n - 1, true);
                    }
                }
                ((HeapPanel)HeapPanel.this).mDisplayStack.topControl = HeapPanel.this.mLayout[n];
                HeapPanel.this.mDisplayBase.layout();
            }
        });
        this.mDisplayBase.layout();
        return this.mTop;
    }

    @Override
    public void setFocus() {
        this.mHeapSummary.setFocus();
    }

    private Table createSummaryTable(Composite composite) {
        Table table = new Table(composite, 65540);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 131072);
        tableColumn.setText("ID");
        tableColumn.pack();
        tableColumn = new TableColumn(table, 131072);
        tableColumn.setText("000.000WW");
        tableColumn.pack();
        tableColumn.setText("Heap Size");
        tableColumn = new TableColumn(table, 131072);
        tableColumn.setText("000.000WW");
        tableColumn.pack();
        tableColumn.setText("Allocated");
        tableColumn = new TableColumn(table, 131072);
        tableColumn.setText("000.000WW");
        tableColumn.pack();
        tableColumn.setText("Free");
        tableColumn = new TableColumn(table, 131072);
        tableColumn.setText("000.00%");
        tableColumn.pack();
        tableColumn.setText("% Used");
        tableColumn = new TableColumn(table, 131072);
        tableColumn.setText("000,000,000");
        tableColumn.pack();
        tableColumn.setText("# Objects");
        TableItem tableItem = new TableItem(table, 0);
        tableItem.setText("");
        return table;
    }

    private Table createDetailedTable(Composite composite) {
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        Table table = new Table(composite, 65540);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableHelper.createTableColumn(table, "Type", 16384, "4-byte array (object[], int[], float[])", PREFS_STATS_COL_TYPE, iPreferenceStore);
        TableHelper.createTableColumn(table, "Count", 131072, "00,000", PREFS_STATS_COL_COUNT, iPreferenceStore);
        TableHelper.createTableColumn(table, "Total Size", 131072, "000.000 WW", PREFS_STATS_COL_SIZE, iPreferenceStore);
        TableHelper.createTableColumn(table, "Smallest", 131072, "000.000 WW", PREFS_STATS_COL_SMALLEST, iPreferenceStore);
        TableHelper.createTableColumn(table, "Largest", 131072, "000.000 WW", PREFS_STATS_COL_LARGEST, iPreferenceStore);
        TableHelper.createTableColumn(table, "Median", 131072, "000.000 WW", PREFS_STATS_COL_MEDIAN, iPreferenceStore);
        TableHelper.createTableColumn(table, "Average", 131072, "000.000 WW", PREFS_STATS_COL_AVERAGE, iPreferenceStore);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Client client = HeapPanel.this.getCurrentClient();
                if (client != null) {
                    Map map;
                    ArrayList arrayList;
                    int n = HeapPanel.this.mStatisticsTable.getSelectionIndex();
                    TableItem tableItem = HeapPanel.this.mStatisticsTable.getItem(n);
                    if (tableItem != null && (arrayList = (ArrayList)(map = client.getClientData().getVmHeapData().getProcessedHeapMap()).get(tableItem.getData())) != null) {
                        HeapPanel.this.showChart(arrayList);
                    }
                }
            }
        });
        return table;
    }

    private void createChart() {
        this.mAllocCountDataSet = new DefaultCategoryDataset();
        this.mChart = ChartFactory.createBarChart(null, (String)"Size", (String)"Count", (CategoryDataset)this.mAllocCountDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        Font font = this.mStatisticsBase.getFont();
        FontData[] fontDataArray = font.getFontData();
        FontData fontData = fontDataArray[0];
        java.awt.Font font2 = SWTUtils.toAwtFont((Device)this.mStatisticsBase.getDisplay(), (FontData)fontData, (boolean)true);
        this.mChart.setTitle(new TextTitle("Allocation count per size", font2));
        Plot plot = this.mChart.getPlot();
        if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
            categoryItemRenderer.setBaseToolTipGenerator(new CategoryToolTipGenerator(){

                public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
                    ByteLong byteLong = (ByteLong)categoryDataset.getColumnKey(n2);
                    String string = (String)((Object)categoryDataset.getRowKey(n));
                    Number number = categoryDataset.getValue((Comparable)((Object)string), (Comparable)byteLong);
                    return String.format("%1$d %2$s of %3$d bytes", number.intValue(), string, byteLong.getValue());
                }
            });
        }
        this.mChartComposite = new ChartComposite(this.mStatisticsBase, 2048, this.mChart, 680, 420, 300, 200, 3000, 3000, true, true, true, true, false, true);
        this.mChartComposite.setLayoutData((Object)new GridData(1808));
    }

    private static String prettyByteCount(long l) {
        double d = l;
        String string = " B";
        if (d < 1024.0) {
            return sByteFormatter.format(d) + string;
        }
        d /= 1024.0;
        string = " KB";
        if (d >= 1024.0) {
            d /= 1024.0;
            string = " MB";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = " GB";
        }
        return sLargeByteFormatter.format(d) + string;
    }

    private static String approximateByteCount(long l) {
        double d = l;
        String string = "";
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "K";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "M";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "G";
        }
        return sByteFormatter.format(d) + string;
    }

    private static String addCommasToNumber(long l) {
        return sCountFormatter.format(l);
    }

    private static String fractionalPercent(long l, long l2) {
        double d = (double)l / (double)l2;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(d *= 100.0) + "%";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSummaryTable(ClientData clientData) {
        ClientData clientData2;
        if (this.mHeapSummary.isDisposed()) {
            return;
        }
        this.mHeapSummary.setRedraw(false);
        this.mHeapSummary.removeAll();
        int n = 0;
        if (clientData != null) {
            clientData2 = clientData;
            synchronized (clientData2) {
                Iterator iterator = clientData.getVmHeapIds();
                while (iterator.hasNext()) {
                    ++n;
                    Integer n2 = (Integer)iterator.next();
                    Map map = clientData.getVmHeapInfo(n2.intValue());
                    if (map == null) continue;
                    long l = (Long)map.get("sizeInBytes");
                    long l2 = (Long)map.get("bytesAllocated");
                    long l3 = (Long)map.get("objectsAllocated");
                    TableItem tableItem = new TableItem(this.mHeapSummary, 0);
                    tableItem.setText(0, n2.toString());
                    tableItem.setText(1, HeapPanel.prettyByteCount(l));
                    tableItem.setText(2, HeapPanel.prettyByteCount(l2));
                    tableItem.setText(3, HeapPanel.prettyByteCount(l - l2));
                    tableItem.setText(4, HeapPanel.fractionalPercent(l2, l));
                    tableItem.setText(5, HeapPanel.addCommasToNumber(l3));
                }
            }
        }
        if (n == 0) {
            clientData2 = new TableItem(this.mHeapSummary, 0);
            clientData2.setText("");
        }
        this.mHeapSummary.pack();
        this.mHeapSummary.setRedraw(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillDetailedTable(Client client, boolean bl) {
        Map map;
        ClientData clientData;
        if (client == null || !client.isHeapUpdateEnabled()) {
            this.mStatisticsTable.removeAll();
            this.showChart(null);
            return;
        }
        ClientData clientData2 = clientData = client.getClientData();
        synchronized (clientData2) {
            if (!this.serializeHeapData(clientData.getVmHeapData()) && !bl) {
                return;
            }
            map = clientData.getVmHeapData().getProcessedHeapMap();
        }
        int n = this.mStatisticsTable.getSelectionIndex();
        Integer n2 = null;
        if (n != -1) {
            n2 = (Integer)this.mStatisticsTable.getItem(n).getData();
        }
        this.mStatisticsTable.setRedraw(false);
        this.mStatisticsTable.removeAll();
        if (map != null) {
            int n3 = -1;
            ArrayList arrayList = null;
            Set set = map.keySet();
            int n4 = 0;
            for (Integer n5 : set) {
                ArrayList arrayList2 = (ArrayList)map.get(n5);
                if (n5.equals(n2)) {
                    n3 = n4;
                    arrayList = arrayList2;
                }
                ++n4;
                TableItem tableItem = new TableItem(this.mStatisticsTable, 0);
                tableItem.setData((Object)n5);
                tableItem.setText(0, mMapLegend[n5]);
                int n6 = arrayList2.size();
                tableItem.setText(1, HeapPanel.addCommasToNumber(n6));
                if (n6 <= 0) continue;
                tableItem.setText(3, HeapPanel.prettyByteCount(((HeapSegment.HeapSegmentElement)arrayList2.get(0)).getLength()));
                tableItem.setText(4, HeapPanel.prettyByteCount(((HeapSegment.HeapSegmentElement)arrayList2.get(n6 - 1)).getLength()));
                int n7 = n6 / 2;
                HeapSegment.HeapSegmentElement heapSegmentElement = (HeapSegment.HeapSegmentElement)arrayList2.get(n7);
                long l = heapSegmentElement.getLength();
                tableItem.setText(5, HeapPanel.prettyByteCount(l));
                long l2 = 0L;
                for (int i = 0; i < n6; ++i) {
                    heapSegmentElement = (HeapSegment.HeapSegmentElement)arrayList2.get(i);
                    l = heapSegmentElement.getLength();
                    l2 += l;
                }
                tableItem.setText(2, HeapPanel.prettyByteCount(l2));
                tableItem.setText(6, HeapPanel.prettyByteCount(l2 / (long)n6));
            }
            this.mStatisticsTable.setRedraw(true);
            if (n3 != -1) {
                this.mStatisticsTable.setSelection(n3);
                this.showChart(arrayList);
            } else {
                this.showChart(null);
            }
        } else {
            this.mStatisticsTable.setRedraw(true);
        }
    }

    private void showChart(ArrayList<HeapSegment.HeapSegmentElement> arrayList) {
        this.mAllocCountDataSet.clear();
        if (arrayList != null) {
            String string = "Alloc Count";
            long l = -1L;
            int n = 0;
            for (HeapSegment.HeapSegmentElement heapSegmentElement : arrayList) {
                if ((long)heapSegmentElement.getLength() != l) {
                    if (l != -1L) {
                        ByteLong byteLong = new ByteLong(l);
                        this.mAllocCountDataSet.addValue((double)n, (Comparable)((Object)string), (Comparable)byteLong);
                    }
                    l = heapSegmentElement.getLength();
                    n = 1;
                    continue;
                }
                ++n;
            }
            if (l != -1L) {
                ByteLong byteLong = new ByteLong(l);
                this.mAllocCountDataSet.addValue((double)n, (Comparable)((Object)string), (Comparable)byteLong);
            }
        }
    }

    private void createLegend(Composite composite) {
        this.mLegend = new Group(composite, 0);
        this.mLegend.setText(this.getLegendText(0));
        this.mLegend.setLayout((Layout)new GridLayout(2, false));
        RGB[] rGBArray = HeapPanel.mMapPalette.colors;
        for (int i = 0; i < NUM_PALETTE_ENTRIES; ++i) {
            Image image = this.createColorRect(composite.getDisplay(), rGBArray[i]);
            Label label = new Label((Composite)this.mLegend, 0);
            label.setImage(image);
            label = new Label((Composite)this.mLegend, 0);
            label.setText(mMapLegend[i]);
        }
    }

    private String getLegendText(int n) {
        int n2 = 8 * (100 / ZOOMS[n]);
        return String.format("Key (1 pixel = %1$d bytes)", n2);
    }

    private void setLegendText(int n) {
        this.mLegend.setText(this.getLegendText(n));
    }

    private Image createColorRect(Display display, RGB rGB) {
        int n = 32;
        int n2 = 16;
        Image image = new Image((Device)display, n, n2);
        GC gC = new GC((Drawable)image);
        gC.setBackground(new Color((Device)display, rGB));
        gC.fillRectangle(0, 0, n, n2);
        gC.dispose();
        return image;
    }

    private void setUpdateStatus(int n) {
        switch (n) {
            case 0: {
                this.mUpdateStatus.setText("Select a client to see heap updates");
                break;
            }
            case 1: {
                this.mUpdateStatus.setText("Heap updates are NOT ENABLED for this client");
                break;
            }
            case 2: {
                this.mUpdateStatus.setText("Heap updates will happen after every GC for this client");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.mUpdateStatus.pack();
    }

    private int nextPow2(int n) {
        for (int i = 31; i >= 0; --i) {
            if ((n & 1 << i) == 0) continue;
            if (i < 31) {
                return 1 << i + 1;
            }
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    private int zOrderData(ImageData imageData, byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = i & 1 | (i >>> 2 & 1) << 1 | (i >>> 4 & 1) << 2 | (i >>> 6 & 1) << 3 | (i >>> 8 & 1) << 4 | (i >>> 10 & 1) << 5 | (i >>> 12 & 1) << 6 | (i >>> 14 & 1) << 7 | (i >>> 16 & 1) << 8 | (i >>> 18 & 1) << 9 | (i >>> 20 & 1) << 10 | (i >>> 22 & 1) << 11 | (i >>> 24 & 1) << 12 | (i >>> 26 & 1) << 13 | (i >>> 28 & 1) << 14 | (i >>> 30 & 1) << 15;
            int n3 = (i >>> 1 & 1) << 0 | (i >>> 3 & 1) << 1 | (i >>> 5 & 1) << 2 | (i >>> 7 & 1) << 3 | (i >>> 9 & 1) << 4 | (i >>> 11 & 1) << 5 | (i >>> 13 & 1) << 6 | (i >>> 15 & 1) << 7 | (i >>> 17 & 1) << 8 | (i >>> 19 & 1) << 9 | (i >>> 21 & 1) << 10 | (i >>> 23 & 1) << 11 | (i >>> 25 & 1) << 12 | (i >>> 27 & 1) << 13 | (i >>> 29 & 1) << 14 | (i >>> 31 & 1) << 15;
            try {
                imageData.setPixel(n2, n3, (int)byArray[i]);
                if (n2 <= n) continue;
                n = n2;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("bad pixels: i " + i + ", w " + imageData.width + ", h " + imageData.height + ", x " + n2 + ", y " + n3);
                throw illegalArgumentException;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void hilbertWalk(ImageData imageData, InputStream inputStream, int n, int n2, int n3, int n4) throws IOException {
        if (n2 >= imageData.width || n3 >= imageData.height) {
            return;
        }
        if (n == 0) {
            try {
                int n5 = inputStream.read();
                if (n5 < 0) return;
                imageData.setPixel(n3, n2, n5);
                if (n3 > imageData.x) {
                    imageData.x = n3;
                }
                if (n2 <= imageData.y) return;
                imageData.y = n2;
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("bad pixels: order " + n + ", dir " + n4 + ", w " + imageData.width + ", h " + imageData.height + ", x " + n2 + ", y " + n3);
                throw illegalArgumentException;
            }
        } else {
            int n6 = 1 << --n;
            int n7 = n2 + n6;
            int n8 = n3 + n6;
            switch (n4) {
                case 2: {
                    this.hilbertWalk(imageData, inputStream, n, n2, n3, 0);
                    this.hilbertWalk(imageData, inputStream, n, n2, n8, 2);
                    this.hilbertWalk(imageData, inputStream, n, n7, n8, 2);
                    this.hilbertWalk(imageData, inputStream, n, n7, n3, 1);
                    return;
                }
                case 0: {
                    this.hilbertWalk(imageData, inputStream, n, n2, n3, 2);
                    this.hilbertWalk(imageData, inputStream, n, n7, n3, 0);
                    this.hilbertWalk(imageData, inputStream, n, n7, n8, 0);
                    this.hilbertWalk(imageData, inputStream, n, n2, n8, 3);
                    return;
                }
                case 1: {
                    this.hilbertWalk(imageData, inputStream, n, n7, n8, 3);
                    this.hilbertWalk(imageData, inputStream, n, n2, n8, 1);
                    this.hilbertWalk(imageData, inputStream, n, n2, n3, 1);
                    this.hilbertWalk(imageData, inputStream, n, n7, n3, 2);
                    return;
                }
                case 3: {
                    this.hilbertWalk(imageData, inputStream, n, n7, n8, 1);
                    this.hilbertWalk(imageData, inputStream, n, n7, n3, 3);
                    this.hilbertWalk(imageData, inputStream, n, n2, n3, 3);
                    this.hilbertWalk(imageData, inputStream, n, n2, n8, 0);
                    return;
                }
                default: {
                    throw new RuntimeException("Unexpected Hilbert direction " + n4);
                }
            }
        }
    }

    private Point hilbertOrderData(ImageData imageData, byte[] byArray) {
        int n = 0;
        for (int i = 1; i < imageData.width; i *= 2) {
            ++n;
        }
        Point point = new Point(0, 0);
        int n2 = imageData.x;
        int n3 = imageData.y;
        imageData.y = 0;
        imageData.x = 0;
        try {
            this.hilbertWalk(imageData, new ByteArrayInputStream(byArray), n, 0, 0, 2);
            point.x = imageData.x;
            point.y = imageData.y;
        }
        catch (IOException iOException) {
            System.err.println("Exception during hilbertWalk()");
            point.x = imageData.height;
            point.y = imageData.width;
        }
        imageData.x = n2;
        imageData.y = n3;
        return point;
    }

    private ImageData createHilbertHeapImage(byte[] byArray) {
        int n = (int)Math.sqrt(2097152.0);
        int n2 = n = this.nextPow2(n);
        ImageData imageData = new ImageData(n, n2, 8, mMapPalette);
        Point point = this.hilbertOrderData(imageData, byArray);
        int n3 = 100 / ZOOMS[this.mZoom.getSelectionIndex()];
        if (n3 != 1) {
            int n4 = point.x % n3;
            if (n4 != 0) {
                point.x += n3 - n4;
            }
            if ((n4 = point.y % n3) != 0) {
                point.y += n3 - n4;
            }
        }
        if (point.y < imageData.height) {
            imageData = new ImageData(imageData.width, point.y, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        }
        if (point.x < imageData.width) {
            ImageData imageData2 = new ImageData(point.x, imageData.height, imageData.depth, imageData.palette);
            int[] nArray = new int[point.x];
            for (int i = 0; i < imageData.height; ++i) {
                imageData.getPixels(0, i, point.x, nArray, 0);
                imageData2.setPixels(0, i, point.x, nArray, 0);
            }
            imageData = imageData2;
        }
        if (n3 != 1) {
            imageData = imageData.scaledTo(imageData.width / n3, imageData.height / n3);
        }
        return imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderHeapData(ClientData clientData, int n, boolean bl) {
        Image image;
        byte[] byArray;
        ClientData clientData2 = clientData;
        synchronized (clientData2) {
            if (!this.serializeHeapData(clientData.getVmHeapData()) && !bl) {
                return;
            }
            byArray = this.getSerializedData();
        }
        if (byArray != null) {
            clientData2 = n == 1 ? this.createHilbertHeapImage(byArray) : this.createLinearHeapImage(byArray, 200, mMapPalette);
            image = new Image((Device)this.mDisplay, (ImageData)clientData2);
        } else {
            int n2;
            int n3;
            if (n == 1) {
                n3 = 200;
                n2 = 200;
            } else {
                n2 = 300;
                n3 = 100;
            }
            image = new Image((Device)this.mDisplay, n2, n3);
            GC gC = new GC((Drawable)image);
            gC.setForeground(this.mDisplay.getSystemColor(3));
            gC.drawLine(0, 0, n2 - 1, n3 - 1);
            gC.dispose();
            gC = null;
        }
        if (n == 1) {
            if (this.mHilbertImage != null) {
                this.mHilbertImage.dispose();
            }
            this.mHilbertImage = image;
            this.mHilbertHeapImage.setImage(this.mHilbertImage);
            this.mHilbertHeapImage.pack(true);
            this.mHilbertBase.layout();
            this.mHilbertBase.pack(true);
        } else {
            if (this.mLinearImage != null) {
                this.mLinearImage.dispose();
            }
            this.mLinearImage = image;
            this.mLinearHeapImage.setImage(this.mLinearImage);
            this.mLinearHeapImage.pack(true);
            this.mLinearBase.layout();
            this.mLinearBase.pack(true);
        }
    }

    @Override
    protected void setTableFocusListener() {
        this.addTableToFocusListener(this.mHeapSummary);
    }

    static {
        sByteFormatter.setMinimumFractionDigits(0);
        sByteFormatter.setMaximumFractionDigits(1);
        sLargeByteFormatter.setMinimumFractionDigits(3);
        sLargeByteFormatter.setMaximumFractionDigits(3);
        sCountFormatter.setGroupingUsed(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteLong
    implements Comparable<ByteLong> {
        private long mValue;

        private ByteLong(long l) {
            this.mValue = l;
        }

        public long getValue() {
            return this.mValue;
        }

        public String toString() {
            return HeapPanel.approximateByteCount(this.mValue);
        }

        @Override
        public int compareTo(ByteLong byteLong) {
            if (this.mValue != byteLong.mValue) {
                return this.mValue < byteLong.mValue ? -1 : 1;
            }
            return 0;
        }
    }
}

