/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmuilib.TablePanel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class InfoPanel
extends TablePanel {
    private Table mTable;
    private TableColumn mCol2;
    private static final String[] mLabels = new String[]{"DDM-aware?", "App description:", "VM version:", "Process ID:", "Supports Profiling Control:", "Supports HPROF Control:"};
    private static final int ENT_DDM_AWARE = 0;
    private static final int ENT_APP_DESCR = 1;
    private static final int ENT_VM_VERSION = 2;
    private static final int ENT_PROCESS_ID = 3;
    private static final int ENT_SUPPORTS_PROFILING = 4;
    private static final int ENT_SUPPORTS_HPROF = 5;

    protected Control createControl(Composite composite) {
        this.mTable = new Table(composite, 65538);
        this.mTable.setHeaderVisible(false);
        this.mTable.setLinesVisible(false);
        TableColumn tableColumn = new TableColumn(this.mTable, 131072);
        tableColumn.setText("name");
        this.mCol2 = new TableColumn(this.mTable, 16384);
        this.mCol2.setText("PlaceHolderContentForWidth");
        for (int i = 0; i < mLabels.length; ++i) {
            TableItem tableItem = new TableItem(this.mTable, 0);
            tableItem.setText(0, mLabels[i]);
            tableItem.setText(1, "-");
        }
        tableColumn.pack();
        this.mCol2.pack();
        return this.mTable;
    }

    public void setFocus() {
        this.mTable.setFocus();
    }

    public void clientChanged(Client client, int n) {
        if (client == this.getCurrentClient() && (n & 7) == 7) {
            if (this.mTable.isDisposed()) {
                return;
            }
            this.mTable.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    InfoPanel.this.clientSelected();
                }
            });
        }
    }

    public void deviceSelected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientSelected() {
        if (this.mTable.isDisposed()) {
            return;
        }
        Client client = this.getCurrentClient();
        if (client == null) {
            for (int i = 0; i < mLabels.length; ++i) {
                TableItem tableItem = this.mTable.getItem(i);
                tableItem.setText(1, "-");
            }
        } else {
            String string;
            String string2;
            String string3;
            String string4;
            ClientData clientData;
            ClientData clientData2 = clientData = client.getClientData();
            synchronized (clientData2) {
                string4 = clientData.getClientDescription() != null ? clientData.getClientDescription() : "?";
                string3 = clientData.getVmIdentifier() != null ? clientData.getVmIdentifier() : "?";
                string2 = clientData.isDdmAware() ? "yes" : "no";
                string = clientData.getPid() != 0 ? String.valueOf(clientData.getPid()) : "?";
            }
            TableItem tableItem = this.mTable.getItem(1);
            tableItem.setText(1, string4);
            tableItem = this.mTable.getItem(2);
            tableItem.setText(1, string3);
            tableItem = this.mTable.getItem(0);
            tableItem.setText(1, string2);
            tableItem = this.mTable.getItem(3);
            tableItem.setText(1, string);
            tableItem = this.mTable.getItem(4);
            if (clientData.hasFeature("method-trace-profiling-streaming")) {
                tableItem.setText(1, "Yes");
            } else if (clientData.hasFeature("method-trace-profiling")) {
                tableItem.setText(1, "Yes (Application must be able to write on the SD Card)");
            } else {
                tableItem.setText(1, "No");
            }
            tableItem = this.mTable.getItem(5);
            if (clientData.hasFeature("hprof-heap-dump-streaming")) {
                tableItem.setText(1, "Yes");
            } else if (clientData.hasFeature("hprof-heap-dump")) {
                tableItem.setText(1, "Yes (Application must be able to write on the SD Card)");
            } else {
                tableItem.setText(1, "No");
            }
        }
        this.mCol2.pack();
    }

    protected void setTableFocusListener() {
        this.addTableToFocusListener(this.mTable);
    }
}

