/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Client;
import com.android.ddmlib.IStackTraceInfo;
import com.android.ddmuilib.TableHelper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public final class StackTracePanel {
    private static ISourceRevealer sSourceRevealer;
    private Table mStackTraceTable;
    private TableViewer mStackTraceViewer;
    private Client mCurrentClient;

    public static void setSourceRevealer(ISourceRevealer iSourceRevealer) {
        sSourceRevealer = iSourceRevealer;
    }

    public Table createPanel(Composite composite, String string, IPreferenceStore iPreferenceStore) {
        this.mStackTraceTable = new Table(composite, 65538);
        this.mStackTraceTable.setHeaderVisible(false);
        this.mStackTraceTable.setLinesVisible(false);
        TableHelper.createTableColumn(this.mStackTraceTable, "Info", 16384, "SomeLongClassName.method(android/somepackage/someotherpackage/somefile.java:99999)", string, iPreferenceStore);
        this.mStackTraceViewer = new TableViewer(this.mStackTraceTable);
        this.mStackTraceViewer.setContentProvider((IContentProvider)new StackTraceContentProvider());
        this.mStackTraceViewer.setLabelProvider((IBaseLabelProvider)new StackTraceLabelProvider());
        this.mStackTraceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                StackTraceElement stackTraceElement;
                IStructuredSelection iStructuredSelection;
                Object object;
                ISelection iSelection;
                if (sSourceRevealer != null && StackTracePanel.this.mCurrentClient != null && (iSelection = StackTracePanel.this.mStackTraceViewer.getSelection()) instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof StackTraceElement && !(stackTraceElement = (StackTraceElement)object).isNativeMethod()) {
                    sSourceRevealer.reveal(StackTracePanel.this.mCurrentClient.getClientData().getClientDescription(), stackTraceElement.getClassName(), stackTraceElement.getLineNumber());
                }
            }
        });
        return this.mStackTraceTable;
    }

    public void setViewerInput(IStackTraceInfo iStackTraceInfo) {
        this.mStackTraceViewer.setInput((Object)iStackTraceInfo);
        this.mStackTraceViewer.refresh();
    }

    public void setCurrentClient(Client client) {
        this.mCurrentClient = client;
    }

    public static interface ISourceRevealer {
        public void reveal(String var1, String var2, int var3);
    }

    private static class StackTraceLabelProvider
    implements ITableLabelProvider {
        private StackTraceLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof StackTraceElement && n == 0) {
                StackTraceElement stackTraceElement = (StackTraceElement)object;
                return "  at " + stackTraceElement.toString();
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private static class StackTraceContentProvider
    implements IStructuredContentProvider {
        private StackTraceContentProvider() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray;
            if (object instanceof IStackTraceInfo && (objectArray = ((IStackTraceInfo)object).getStackTrace()) != null) {
                return objectArray;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

