/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.TablePanel;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysinfoPanel
extends TablePanel
implements IShellOutputReceiver {
    private Label mLabel;
    private Button mFetchButton;
    private Combo mDisplayMode;
    private DefaultPieDataset mDataset;
    private DefaultCategoryDataset mBarDataSet;
    private StackLayout mStackLayout;
    private Composite mChartComposite;
    private Composite mPieChartComposite;
    private Composite mStackedBarComposite;
    private File mDataFile;
    private FileOutputStream mTempStream;
    private int mMode = 0;
    private String mGfxPackageName;
    private static final int MODE_CPU = 0;
    private static final int MODE_MEMINFO = 1;
    private static final int MODE_GFXINFO = 2;
    private static final String[] DUMP_COMMAND = new String[]{"dumpsys cpuinfo", "cat /proc/meminfo ; procrank", "dumpsys gfxinfo"};
    private static final String[] CAPTIONS = new String[]{"CPU load", "Memory usage", "Frame Render Time"};
    private static final String PROP_GFX_PROFILING = "debug.hwui.profile";

    private void generateDataset(File file) {
        if (file == null) {
            return;
        }
        try {
            BufferedReader bufferedReader = this.getBugreportReader(file);
            if (this.mMode == 0) {
                this.readCpuDataset(bufferedReader);
            } else if (this.mMode == 1) {
                this.readMeminfoDataset(bufferedReader);
            } else if (this.mMode == 2) {
                this.readGfxInfoDataset(bufferedReader);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Log.e((String)"DDMS", (Throwable)iOException);
        }
    }

    @Override
    public void deviceSelected() {
        if (this.getCurrentDevice() != null) {
            this.mFetchButton.setEnabled(true);
            this.loadFromDevice();
        } else {
            this.mFetchButton.setEnabled(false);
        }
    }

    @Override
    public void clientSelected() {
    }

    @Override
    public void setFocus() {
        this.mDisplayMode.setFocus();
    }

    private void loadFromDevice() {
        String string;
        boolean bl;
        this.clearDataSet();
        if (this.mMode == 2 && !(bl = this.isGfxProfilingEnabled())) {
            if (this.enableGfxProfiling()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"DDMS", (String)"Graphics profiling was enabled on the device.\nIt may be necessary to relaunch your application to see profile information.");
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"DDMS", (String)"Unexpected error enabling graphics profiling on device.\n");
                return;
            }
        }
        if ((string = this.getDumpsysCommand(this.mMode)) == null) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    SysinfoPanel.this.initShellOutputBuffer();
                    if (SysinfoPanel.this.mMode == 1) {
                        SysinfoPanel.this.mTempStream.write("------ MEMORY INFO ------\n".getBytes());
                    }
                    SysinfoPanel.this.getCurrentDevice().executeShellCommand(string, (IShellOutputReceiver)SysinfoPanel.this);
                }
                catch (IOException iOException) {
                    Log.e((String)"DDMS", (Throwable)iOException);
                }
                catch (TimeoutException timeoutException) {
                    Log.e((String)"DDMS", (Throwable)timeoutException);
                }
                catch (AdbCommandRejectedException adbCommandRejectedException) {
                    Log.e((String)"DDMS", (Throwable)adbCommandRejectedException);
                }
                catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
                    Log.e((String)"DDMS", (Throwable)shellCommandUnresponsiveException);
                }
            }
        }, "Sysinfo Output Collector");
        thread.start();
    }

    private boolean isGfxProfilingEnabled() {
        IDevice iDevice = this.getCurrentDevice();
        if (iDevice == null) {
            return false;
        }
        try {
            String string = iDevice.getPropertySync(PROP_GFX_PROFILING);
            return Boolean.valueOf(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean enableGfxProfiling() {
        IDevice iDevice = this.getCurrentDevice();
        if (iDevice == null) {
            return false;
        }
        try {
            iDevice.executeShellCommand("setprop debug.hwui.profile true", (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private String getDumpsysCommand(int n) {
        if (n == 2) {
            Client client = this.getCurrentClient();
            if (client == null) {
                return null;
            }
            ClientData clientData = client.getClientData();
            if (clientData == null) {
                return null;
            }
            this.mGfxPackageName = clientData.getClientDescription();
            if (this.mGfxPackageName == null) {
                return null;
            }
            return "dumpsys gfxinfo " + this.mGfxPackageName;
        }
        if (n < DUMP_COMMAND.length) {
            return DUMP_COMMAND[n];
        }
        return null;
    }

    void initShellOutputBuffer() throws IOException {
        this.mDataFile = File.createTempFile("ddmsfile", ".txt");
        this.mDataFile.deleteOnExit();
        this.mTempStream = new FileOutputStream(this.mDataFile);
    }

    public void addOutput(byte[] byArray, int n, int n2) {
        try {
            this.mTempStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            Log.e((String)"DDMS", (Throwable)iOException);
        }
    }

    public void flush() {
        if (this.mTempStream != null) {
            try {
                this.mTempStream.close();
                this.generateDataset(this.mDataFile);
                this.mTempStream = null;
                this.mDataFile = null;
            }
            catch (IOException iOException) {
                Log.e((String)"DDMS", (Throwable)iOException);
            }
        }
    }

    public boolean isCancelled() {
        return false;
    }

    @Override
    protected Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new RowLayout());
        this.mDisplayMode = new Combo(composite3, 8);
        for (String string : CAPTIONS) {
            this.mDisplayMode.add(string);
        }
        this.mDisplayMode.select(this.mMode);
        this.mDisplayMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SysinfoPanel.this.mMode = SysinfoPanel.this.mDisplayMode.getSelectionIndex();
                if (SysinfoPanel.this.mDataFile != null) {
                    SysinfoPanel.this.generateDataset(SysinfoPanel.this.mDataFile);
                } else if (SysinfoPanel.this.getCurrentDevice() != null) {
                    SysinfoPanel.this.loadFromDevice();
                }
            }
        });
        this.mFetchButton = new Button(composite3, 8);
        this.mFetchButton.setText("Update from Device");
        this.mFetchButton.setEnabled(false);
        this.mFetchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SysinfoPanel.this.loadFromDevice();
            }
        });
        this.mLabel = new Label(composite2, 0);
        this.mLabel.setLayoutData((Object)new GridData(768));
        this.mChartComposite = new Composite(composite2, 0);
        this.mChartComposite.setLayoutData((Object)new GridData(1808));
        this.mStackLayout = new StackLayout();
        this.mChartComposite.setLayout((Layout)this.mStackLayout);
        this.mPieChartComposite = this.createPieChartComposite(this.mChartComposite);
        this.mStackedBarComposite = this.createStackedBarComposite(this.mChartComposite);
        this.mStackLayout.topControl = this.mPieChartComposite;
        return composite2;
    }

    private Composite createStackedBarComposite(Composite composite) {
        this.mBarDataSet = new DefaultCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)"Per Frame Rendering Time", (String)"Frame #", (String)"Time (ms)", (CategoryDataset)this.mBarDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartComposite chartComposite = this.newChartComposite(jFreeChart, composite);
        chartComposite.setLayoutData((Object)new GridData(1808));
        return chartComposite;
    }

    private Composite createPieChartComposite(Composite composite) {
        this.mDataset = new DefaultPieDataset();
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)"", (PieDataset)this.mDataset, (boolean)false, (boolean)true, (boolean)false);
        ChartComposite chartComposite = this.newChartComposite(jFreeChart, composite);
        chartComposite.setLayoutData((Object)new GridData(1808));
        return chartComposite;
    }

    private ChartComposite newChartComposite(JFreeChart jFreeChart, Composite composite) {
        return new ChartComposite(composite, 2048, jFreeChart, 420, 420, 300, 200, 3000, 3000, true, true, true, true, false, true);
    }

    public void clientChanged(Client client, int n) {
    }

    private BufferedReader getBugreportReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    private static long parseTimeMs(String string) {
        long l = 0L;
        Pattern pattern = Pattern.compile("([\\d\\.]+)\\s*([a-z]+)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(2);
            if ("sec".equals(string2)) {
                l += (long)(Double.parseDouble(matcher.group(1)) * 1000.0);
                continue;
            }
            long l2 = Integer.parseInt(matcher.group(1));
            if ("d".equals(string2)) {
                l += l2 * 24L * 60L * 60L * 1000L;
                continue;
            }
            if ("h".equals(string2)) {
                l += l2 * 60L * 60L * 1000L;
                continue;
            }
            if ("m".equals(string2)) {
                l += l2 * 60L * 1000L;
                continue;
            }
            if ("s".equals(string2)) {
                l += l2 * 1000L;
                continue;
            }
            if (!"ms".equals(string2)) continue;
            l += l2;
        }
        return l;
    }

    private void readCpuDataset(BufferedReader bufferedReader) throws IOException {
        this.updatePieDataSet(BugReportParser.readCpuDataset(bufferedReader), "");
    }

    private void readMeminfoDataset(BufferedReader bufferedReader) throws IOException {
        this.updatePieDataSet(BugReportParser.readMeminfoDataset(bufferedReader), "PSS in kB");
    }

    private void readGfxInfoDataset(BufferedReader bufferedReader) throws IOException {
        this.updateBarChartDataSet(BugReportParser.parseGfxInfo(bufferedReader), this.mGfxPackageName == null ? "" : this.mGfxPackageName);
    }

    private void clearDataSet() {
        this.mLabel.setText("");
        this.mDataset.clear();
        this.mBarDataSet.clear();
    }

    private void updatePieDataSet(final List<BugReportParser.DataValue> list, final String string) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SysinfoPanel.this.mLabel.setText(string);
                ((SysinfoPanel)SysinfoPanel.this).mStackLayout.topControl = SysinfoPanel.this.mPieChartComposite;
                SysinfoPanel.this.mChartComposite.layout();
                for (BugReportParser.DataValue dataValue : list) {
                    SysinfoPanel.this.mDataset.setValue((Comparable)((Object)dataValue.name), dataValue.value);
                }
            }
        });
    }

    private void updateBarChartDataSet(final List<BugReportParser.GfxProfileData> list, final String string) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SysinfoPanel.this.mLabel.setText(string);
                ((SysinfoPanel)SysinfoPanel.this).mStackLayout.topControl = SysinfoPanel.this.mStackedBarComposite;
                SysinfoPanel.this.mChartComposite.layout();
                for (int i = 0; i < list.size(); ++i) {
                    BugReportParser.GfxProfileData gfxProfileData = (BugReportParser.GfxProfileData)list.get(i);
                    String string2 = Integer.toString(i);
                    SysinfoPanel.this.mBarDataSet.addValue(gfxProfileData.draw, (Comparable)((Object)"Draw"), (Comparable)((Object)string2));
                    SysinfoPanel.this.mBarDataSet.addValue(gfxProfileData.process, (Comparable)((Object)"Process"), (Comparable)((Object)string2));
                    SysinfoPanel.this.mBarDataSet.addValue(gfxProfileData.execute, (Comparable)((Object)"Execute"), (Comparable)((Object)string2));
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BugReportParser {
        public static List<GfxProfileData> parseGfxInfo(BufferedReader bufferedReader) throws IOException {
            Matcher matcher;
            Object object;
            Pattern pattern = Pattern.compile("\\s+Draw\\s+Process\\s+Execute");
            String string = null;
            while ((string = bufferedReader.readLine()) != null && !((Matcher)(object = pattern.matcher(string))).find()) {
            }
            if (string == null) {
                return Collections.emptyList();
            }
            object = Pattern.compile("(\\d*\\.\\d+)\\s+(\\d*\\.\\d+)\\s+(\\d*\\.\\d+)");
            ArrayList<GfxProfileData> arrayList = new ArrayList<GfxProfileData>(128);
            while ((string = bufferedReader.readLine()) != null && (matcher = ((Pattern)object).matcher(string)).find()) {
                double d = BugReportParser.safeParseDouble(matcher.group(1));
                double d2 = BugReportParser.safeParseDouble(matcher.group(2));
                double d3 = BugReportParser.safeParseDouble(matcher.group(3));
                arrayList.add(new GfxProfileData(d, d2, d3));
            }
            return arrayList;
        }

        public static List<DataValue> readWakelockDataset(BufferedReader bufferedReader) throws IOException {
            String string;
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
            Pattern pattern = Pattern.compile("Wake lock (\\S+): (.+) partial");
            Pattern pattern2 = Pattern.compile("Total: (.+) uptime");
            double d = 0.0;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("DUMP OF SERVICE")) {
                if (string.startsWith("Current Battery Usage Statistics")) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    double d2 = (double)SysinfoPanel.parseTimeMs(matcher.group(2)) / 1000.0;
                    arrayList.add(new DataValue(matcher.group(1), d2));
                    d -= d2;
                    continue;
                }
                matcher = pattern2.matcher(string);
                if (!matcher.find()) continue;
                d += (double)SysinfoPanel.parseTimeMs(matcher.group(1)) / 1000.0;
            }
            if (d > 0.0) {
                arrayList.add(new DataValue("Unlocked", d));
            }
            return arrayList;
        }

        public static List<DataValue> readAlarmDataset(BufferedReader bufferedReader) throws IOException {
            String string;
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
            Pattern pattern = Pattern.compile("(\\d+) alarms: Intent .*\\.([^. ]+) flags");
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("DUMP OF SERVICE")) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find()) continue;
                long l = Long.parseLong(matcher.group(1));
                String string2 = matcher.group(2);
                arrayList.add(new DataValue(string2, l));
            }
            return arrayList;
        }

        public static List<DataValue> readCpuDataset(BufferedReader bufferedReader) throws IOException {
            String string;
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
            Pattern pattern = Pattern.compile("(\\S+): (\\S+)% = (.+)% user . (.+)% kernel");
            Pattern pattern2 = Pattern.compile("(\\S+)% (\\S+): (.+)% user . (.+)% kernel");
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("Load:")) continue;
                String string2 = "";
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                boolean bl = false;
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    bl = true;
                    string2 = matcher.group(1);
                    d3 = BugReportParser.safeParseLong(matcher.group(2));
                    d = BugReportParser.safeParseLong(matcher.group(3));
                    d2 = BugReportParser.safeParseLong(matcher.group(4));
                }
                if ((matcher = pattern2.matcher(string)).find()) {
                    bl = true;
                    string2 = matcher.group(2);
                    d3 = BugReportParser.safeParseDouble(matcher.group(1));
                    d = BugReportParser.safeParseDouble(matcher.group(3));
                    d2 = BugReportParser.safeParseDouble(matcher.group(4));
                }
                if (!bl) continue;
                if ("TOTAL".equals(string2)) {
                    if (!(d3 < 100.0)) continue;
                    arrayList.add(new DataValue("Idle", 100.0 - d3));
                    continue;
                }
                if (d > 0.0) {
                    arrayList.add(new DataValue(string2 + " (user)", d));
                }
                if (d2 > 0.0) {
                    arrayList.add(new DataValue(string2 + " (kernel)", d3 - d));
                }
                if (d != 0.0 || d2 != 0.0 || !(d3 > 0.0)) continue;
                arrayList.add(new DataValue(string2, d3));
            }
            return arrayList;
        }

        private static long safeParseLong(String string) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }

        private static double safeParseDouble(String string) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }

        public static List<DataValue> readMeminfoDataset(BufferedReader bufferedReader) throws IOException {
            Object object;
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
            Pattern pattern = Pattern.compile("(\\d+) kB");
            long l = 0L;
            long l2 = 0L;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.contains("----")) continue;
                object = pattern.matcher(string);
                if (!((Matcher)object).find()) break;
                long l3 = Long.parseLong(((Matcher)object).group(1));
                if (string.startsWith("MemTotal")) {
                    l = l3;
                    continue;
                }
                if (string.startsWith("MemFree")) {
                    arrayList.add(new DataValue("Free", l3));
                    l -= l3;
                    continue;
                }
                if (string.startsWith("Slab")) {
                    arrayList.add(new DataValue("Slab", l3));
                    l -= l3;
                    continue;
                }
                if (string.startsWith("PageTables")) {
                    arrayList.add(new DataValue("PageTables", l3));
                    l -= l3;
                    continue;
                }
                if (string.startsWith("Buffers") && l3 > 0L) {
                    arrayList.add(new DataValue("Buffers", l3));
                    l -= l3;
                    continue;
                }
                if (string.startsWith("Inactive")) {
                    arrayList.add(new DataValue("Inactive", l3));
                    l -= l3;
                    continue;
                }
                if (!string.startsWith("MemFree")) continue;
                arrayList.add(new DataValue("Free", l3));
                l -= l3;
            }
            object = BugReportParser.readProcRankDataset(bufferedReader, string);
            Iterator<DataValue> iterator = object.iterator();
            while (iterator.hasNext()) {
                DataValue dataValue = iterator.next();
                if (dataValue.value > 2000.0) {
                    arrayList.add(dataValue);
                } else {
                    l2 = (long)((double)l2 + dataValue.value);
                }
                l = (long)((double)l - dataValue.value);
            }
            if (l2 > 0L) {
                arrayList.add(new DataValue("Other", l2));
            }
            if (l > 0L) {
                arrayList.add(new DataValue("Unknown", l));
            }
            return arrayList;
        }

        static List<DataValue> readProcRankDataset(BufferedReader bufferedReader, String string) throws IOException {
            String string2;
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
            if (string == null || !string.contains("PID")) {
                return arrayList;
            }
            Splitter splitter = Splitter.on((char)' ').omitEmptyStrings().trimResults();
            ArrayList arrayList2 = Lists.newArrayList((Iterable)splitter.split((CharSequence)string));
            int n = arrayList2.indexOf("Pss");
            int n2 = arrayList2.indexOf("cmdline");
            if (n == -1 || n2 == -1) {
                return arrayList;
            }
            while ((string2 = bufferedReader.readLine()) != null && (arrayList2 = Lists.newArrayList((Iterable)splitter.split((CharSequence)string2))).size() >= n2) {
                String string3 = ((String)arrayList2.get(n2)).replace("/system/bin/", "");
                String string4 = (String)arrayList2.get(n);
                if (string4.endsWith("K")) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                long l = BugReportParser.safeParseLong(string4);
                arrayList.add(new DataValue(string3, l));
            }
            return arrayList;
        }

        public static List<DataValue> readSyncDataset(BufferedReader bufferedReader) throws IOException {
            String string;
            ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("DUMP OF SERVICE")) {
                long l;
                if (!string.startsWith(" |") || string.length() <= 70) continue;
                String string2 = string.substring(3, 18).trim();
                String string3 = string.substring(61, 70).trim();
                String[] stringArray = string3.split(":");
                if (stringArray.length == 2) {
                    l = Long.parseLong(stringArray[0]) * 60L + Long.parseLong(stringArray[1]);
                    arrayList.add(new DataValue(string2, l));
                    continue;
                }
                if (string3.length() != 3) continue;
                l = Long.parseLong(stringArray[0]) * 3600L + Long.parseLong(stringArray[1]) * 60L + Long.parseLong(stringArray[2]);
                arrayList.add(new DataValue(string2, l));
            }
            return arrayList;
        }

        public static final class GfxProfileData {
            final double draw;
            final double process;
            final double execute;

            public GfxProfileData(double d, double d2, double d3) {
                this.draw = d;
                this.process = d2;
                this.execute = d3;
            }
        }

        public static final class DataValue {
            final String name;
            final double value;

            public DataValue(String string, double d) {
                this.name = string;
                this.value = d;
            }
        }
    }
}

