/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.explorer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.Panel;
import com.android.ddmuilib.SyncProgressHelper;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.console.DdmConsole;
import com.android.ddmuilib.explorer.DeviceContentProvider;
import com.android.ddmuilib.explorer.FileLabelProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DeviceExplorer
extends Panel {
    private static final String TRACE_KEY_EXT = ".key";
    private static final String TRACE_DATA_EXT = ".data";
    private static Pattern mKeyFilePattern = Pattern.compile("(.+)\\.key");
    private static Pattern mDataFilePattern = Pattern.compile("(.+)\\.data");
    public static String COLUMN_NAME = "android.explorer.name";
    public static String COLUMN_SIZE = "android.explorer.size";
    public static String COLUMN_DATE = "android.explorer.data";
    public static String COLUMN_TIME = "android.explorer.time";
    public static String COLUMN_PERMISSIONS = "android.explorer.permissions";
    public static String COLUMN_INFO = "android.explorer.info";
    private Composite mParent;
    private TreeViewer mTreeViewer;
    private Tree mTree;
    private DeviceContentProvider mContentProvider;
    private ICommonAction mPushAction;
    private ICommonAction mPullAction;
    private ICommonAction mDeleteAction;
    private ICommonAction mCreateNewFolderAction;
    private Image mFileImage;
    private Image mFolderImage;
    private Image mPackageImage;
    private Image mOtherImage;
    private IDevice mCurrentDevice;
    private String mDefaultSave;

    public void setCustomImages(Image image, Image image2, Image image3, Image image4) {
        this.mFileImage = image;
        this.mFolderImage = image2;
        this.mPackageImage = image3;
        this.mOtherImage = image4;
    }

    public void setActions(ICommonAction iCommonAction, ICommonAction iCommonAction2, ICommonAction iCommonAction3, ICommonAction iCommonAction4) {
        this.mPushAction = iCommonAction;
        this.mPullAction = iCommonAction2;
        this.mDeleteAction = iCommonAction3;
        this.mCreateNewFolderAction = iCommonAction4;
    }

    protected Control createControl(Composite composite) {
        this.mParent = composite;
        composite.setLayout((Layout)new FillLayout());
        ImageLoader imageLoader = ImageLoader.getDdmUiLibLoader();
        if (this.mFileImage == null) {
            this.mFileImage = imageLoader.loadImage("file.png", this.mParent.getDisplay());
        }
        if (this.mFolderImage == null) {
            this.mFolderImage = imageLoader.loadImage("folder.png", this.mParent.getDisplay());
        }
        if (this.mPackageImage == null) {
            this.mPackageImage = imageLoader.loadImage("android.png", this.mParent.getDisplay());
        }
        if (this.mOtherImage == null) {
            // empty if block
        }
        this.mTree = new Tree(composite, 0x10010002);
        this.mTree.setHeaderVisible(true);
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        TableHelper.createTreeColumn(this.mTree, "Name", 16384, "0000drwxrwxrwx", COLUMN_NAME, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Size", 131072, "000000", COLUMN_SIZE, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Date", 16384, "2007-08-14", COLUMN_DATE, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Time", 16384, "20:54", COLUMN_TIME, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Permissions", 16384, "drwxrwxrwx", COLUMN_PERMISSIONS, iPreferenceStore);
        TableHelper.createTreeColumn(this.mTree, "Info", 16384, "drwxrwxrwx", COLUMN_INFO, iPreferenceStore);
        this.mTreeViewer = new TreeViewer(this.mTree);
        this.mContentProvider = new DeviceContentProvider();
        this.mTreeViewer.setContentProvider((IContentProvider)this.mContentProvider);
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new FileLabelProvider(this.mFileImage, this.mFolderImage, this.mPackageImage, this.mOtherImage));
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection.isEmpty()) {
                    DeviceExplorer.this.mPullAction.setEnabled(false);
                    DeviceExplorer.this.mPushAction.setEnabled(false);
                    DeviceExplorer.this.mDeleteAction.setEnabled(false);
                    DeviceExplorer.this.mCreateNewFolderAction.setEnabled(false);
                    return;
                }
                if (iSelection instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    Object object = iStructuredSelection.getFirstElement();
                    if (object == null) {
                        return;
                    }
                    if (object instanceof FileListingService.FileEntry) {
                        DeviceExplorer.this.mPullAction.setEnabled(true);
                        DeviceExplorer.this.mPushAction.setEnabled(iStructuredSelection.size() == 1);
                        if (iStructuredSelection.size() == 1) {
                            FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)object;
                            DeviceExplorer.this.setDeleteEnabledState(fileEntry);
                            DeviceExplorer.this.mCreateNewFolderAction.setEnabled(fileEntry.isDirectory());
                        } else {
                            DeviceExplorer.this.mDeleteAction.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection;
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
                    FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)iStructuredSelection.getFirstElement();
                    String string = fileEntry.getName();
                    FileListingService.FileEntry fileEntry2 = fileEntry.getParent();
                    if (fileEntry2 == null) {
                        return;
                    }
                    Matcher matcher = mKeyFilePattern.matcher(string);
                    if (matcher.matches()) {
                        String string2 = matcher.group(1);
                        String string3 = string2 + DeviceExplorer.TRACE_DATA_EXT;
                        FileListingService.FileEntry fileEntry3 = fileEntry2.findChild(string3);
                        DeviceExplorer.this.handleTraceDoubleClick(string2, fileEntry, fileEntry3);
                    } else {
                        matcher = mDataFilePattern.matcher(string);
                        if (matcher.matches()) {
                            String string4 = matcher.group(1);
                            String string5 = string4 + DeviceExplorer.TRACE_KEY_EXT;
                            FileListingService.FileEntry fileEntry4 = fileEntry2.findChild(string5);
                            DeviceExplorer.this.handleTraceDoubleClick(string4, fileEntry4, fileEntry);
                        }
                    }
                }
            }
        });
        this.mTreeViewer.addDropSupport(3, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.mTreeViewer){

            public boolean performDrop(Object object) {
                FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)this.getCurrentTarget();
                if (fileEntry == null) {
                    return false;
                }
                if (!fileEntry.isDirectory()) {
                    fileEntry = fileEntry.getParent();
                }
                if (fileEntry == null) {
                    return false;
                }
                String[] stringArray = (String[])object;
                DeviceExplorer.this.pushFiles(stringArray, fileEntry);
                DeviceExplorer.this.refresh(fileEntry);
                return true;
            }

            public boolean validateDrop(Object object, int n, TransferData transferData) {
                if (object == null) {
                    return false;
                }
                FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)object;
                if (!fileEntry.isDirectory()) {
                    object = fileEntry.getParent();
                }
                return object != null;
            }
        });
        new Thread("Device Ls refresher"){

            public void run() {
                block3: {
                    while (true) {
                        try {
                            4.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        if (DeviceExplorer.this.mTree == null || DeviceExplorer.this.mTree.isDisposed()) break block3;
                        Display display = DeviceExplorer.this.mTree.getDisplay();
                        if (display.isDisposed()) break;
                        display.asyncExec(new Runnable(){

                            public void run() {
                                if (!DeviceExplorer.this.mTree.isDisposed()) {
                                    DeviceExplorer.this.mTreeViewer.refresh(true);
                                }
                            }
                        });
                    }
                    return;
                }
            }
        }.start();
        return this.mTree;
    }

    protected void postCreation() {
    }

    public void setFocus() {
        this.mTree.setFocus();
    }

    private void handleTraceDoubleClick(String string, FileListingService.FileEntry fileEntry, FileListingService.FileEntry fileEntry2) {
        File file;
        File file2;
        String string2;
        File file3;
        try {
            file3 = File.createTempFile(string, ".trace");
            file3.delete();
            file3.mkdir();
            string2 = file3.getAbsolutePath();
            file2 = new File(string2 + File.separator + fileEntry.getName());
            file = new File(string2 + File.separator + fileEntry2.getName());
        }
        catch (IOException iOException) {
            return;
        }
        try {
            file3 = this.mCurrentDevice.getSyncService();
            if (file3 != null) {
                SyncService.ISyncProgressMonitor iSyncProgressMonitor = SyncService.getNullProgressMonitor();
                file3.pullFile(fileEntry, file2.getAbsolutePath(), iSyncProgressMonitor);
                file3.pullFile(fileEntry2, file.getAbsolutePath(), iSyncProgressMonitor);
                String[] stringArray = new String[]{DdmUiPreferences.getTraceview(), string2 + File.separator + string};
                try {
                    final Process process = Runtime.getRuntime().exec(stringArray);
                    new Thread("Traceview output"){

                        public void run() {
                            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            try {
                                String string;
                                while ((string = bufferedReader.readLine()) != null) {
                                    DdmConsole.printErrorToConsole("Traceview: " + string);
                                }
                                process.waitFor();
                            }
                            catch (IOException iOException) {
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", fileEntry.getName(), iOException.getMessage()));
            return;
        }
        catch (SyncException syncException) {
            if (!syncException.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", fileEntry.getName(), syncException.getMessage()));
                return;
            }
        }
        catch (TimeoutException timeoutException) {
            DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: timeout", fileEntry.getName()));
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            DdmConsole.printErrorToConsole(String.format("Failed to pull %1$s: %2$s", fileEntry.getName(), adbCommandRejectedException.getMessage()));
        }
    }

    public void pullSelection() {
        String string;
        TreeItem[] treeItemArray = this.mTree.getSelection();
        String string2 = null;
        FileListingService.FileEntry fileEntry = null;
        if (treeItemArray.length == 1 && (fileEntry = (FileListingService.FileEntry)treeItemArray[0].getData()).getType() == 0) {
            string2 = fileEntry.getName();
        }
        if ((string = this.mDefaultSave) == null) {
            string = System.getProperty("user.home");
        }
        if (string2 != null) {
            FileDialog fileDialog = new FileDialog(this.mParent.getShell(), 8192);
            fileDialog.setText("Get Device File");
            fileDialog.setFileName(string2);
            fileDialog.setFilterPath(string);
            String string3 = fileDialog.open();
            if (string3 != null) {
                this.mDefaultSave = fileDialog.getFilterPath();
                this.pullFile(fileEntry, string3);
            }
        } else {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.mParent.getShell(), 8192);
            directoryDialog.setText("Get Device Files/Folders");
            directoryDialog.setFilterPath(string);
            String string4 = directoryDialog.open();
            if (string4 != null) {
                this.pullSelection(treeItemArray, string4);
            }
        }
    }

    public void pushIntoSelection() {
        TreeItem[] treeItemArray = this.mTree.getSelection();
        if (treeItemArray.length == 0) {
            return;
        }
        FileDialog fileDialog = new FileDialog(this.mParent.getShell(), 4096);
        fileDialog.setText("Put File on Device");
        FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)treeItemArray[0].getData();
        fileDialog.setFileName(fileEntry.getName());
        String string = this.mDefaultSave;
        if (string == null) {
            string = System.getProperty("user.home");
        }
        fileDialog.setFilterPath(string);
        String string2 = fileDialog.open();
        if (string2 != null) {
            String string3;
            this.mDefaultSave = fileDialog.getFilterPath();
            FileListingService.FileEntry fileEntry2 = fileEntry;
            if (fileEntry.isDirectory()) {
                string3 = fileEntry.getFullPath();
            } else {
                fileEntry2 = fileEntry.getParent();
                string3 = fileEntry2.getFullPath();
            }
            this.pushFile(string2, string3);
            this.mTreeViewer.refresh((Object)fileEntry2);
        }
    }

    public void deleteSelection() {
        TreeItem[] treeItemArray = this.mTree.getSelection();
        if (treeItemArray.length != 1) {
            return;
        }
        FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)treeItemArray[0].getData();
        final FileListingService.FileEntry fileEntry2 = fileEntry.getParent();
        String string = "rm " + fileEntry.getFullEscapedPath();
        try {
            this.mCurrentDevice.executeShellCommand(string, new IShellOutputReceiver(){

                public void addOutput(byte[] byArray, int n, int n2) {
                }

                public void flush() {
                    DeviceExplorer.this.mTreeViewer.refresh((Object)fileEntry2);
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (IOException iOException) {
        }
        catch (TimeoutException timeoutException) {
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            // empty catch block
        }
    }

    public void createNewFolderInSelection() {
        TreeItem[] treeItemArray = this.mTree.getSelection();
        if (treeItemArray.length != 1) {
            return;
        }
        final FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)treeItemArray[0].getData();
        if (fileEntry.isDirectory()) {
            InputDialog inputDialog = new InputDialog(this.mTree.getShell(), "New Folder", "Please enter the new folder name", "New Folder", new IInputValidator(){

                public String isValid(String string) {
                    if (string != null && string.length() > 0 && string.trim().length() > 0 && string.indexOf(47) == -1 && string.indexOf(92) == -1) {
                        return null;
                    }
                    return "Invalid name";
                }
            });
            inputDialog.open();
            String string = inputDialog.getValue();
            if (string != null) {
                String string2 = "mkdir " + fileEntry.getFullEscapedPath() + "/" + FileListingService.FileEntry.escape((String)string);
                try {
                    this.mCurrentDevice.executeShellCommand(string2, new IShellOutputReceiver(){

                        public boolean isCancelled() {
                            return false;
                        }

                        public void flush() {
                            DeviceExplorer.this.mTreeViewer.refresh((Object)fileEntry);
                        }

                        public void addOutput(byte[] byArray, int n, int n2) {
                            String string = byArray != null ? new String(byArray) : "";
                            Status status = new Status(4, "DeviceExplorer", 0, string, null);
                            ErrorDialog.openError((Shell)DeviceExplorer.this.mTree.getShell(), (String)"New Folder Error", (String)"New Folder Error", (IStatus)status);
                        }
                    });
                }
                catch (TimeoutException timeoutException) {
                }
                catch (AdbCommandRejectedException adbCommandRejectedException) {
                }
                catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void refresh() {
        this.mTreeViewer.refresh(true);
    }

    public void switchDevice(IDevice iDevice) {
        if (iDevice != this.mCurrentDevice) {
            this.mCurrentDevice = iDevice;
            if (!this.mTree.isDisposed()) {
                Display display = this.mTree.getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!DeviceExplorer.this.mTree.isDisposed() && DeviceExplorer.this.mCurrentDevice != null) {
                            FileListingService fileListingService = DeviceExplorer.this.mCurrentDevice.getFileListingService();
                            DeviceExplorer.this.mContentProvider.setListingService(fileListingService);
                            DeviceExplorer.this.mTreeViewer.setInput((Object)fileListingService.getRoot());
                        }
                    }
                });
            }
        }
    }

    private void refresh(final FileListingService.FileEntry fileEntry) {
        Display display = this.mTreeViewer.getTree().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                DeviceExplorer.this.mTreeViewer.refresh((Object)fileEntry);
            }
        });
    }

    private void pullSelection(TreeItem[] treeItemArray, String string) {
        try {
            final SyncService syncService = this.mCurrentDevice.getSyncService();
            if (syncService != null) {
                ArrayList<FileListingService.FileEntry> arrayList = new ArrayList<FileListingService.FileEntry>();
                for (TreeItem treeItem : treeItemArray) {
                    Object object = treeItem.getData();
                    if (!(object instanceof FileListingService.FileEntry)) continue;
                    arrayList.add((FileListingService.FileEntry)object);
                }
                TreeItem[] treeItemArray2 = arrayList.toArray(new FileListingService.FileEntry[arrayList.size()]);
                SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable((FileListingService.FileEntry[])treeItemArray2, string){
                    final /* synthetic */ FileListingService.FileEntry[] val$entryArray;
                    final /* synthetic */ String val$localDirectory;
                    {
                        this.val$entryArray = fileEntryArray;
                        this.val$localDirectory = string;
                    }

                    public void run(SyncService.ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
                        syncService.pull(this.val$entryArray, this.val$localDirectory, iSyncProgressMonitor);
                    }

                    public void close() {
                        syncService.close();
                    }
                }, "Pulling file(s) from the device", this.mParent.getShell());
            }
        }
        catch (SyncException syncException) {
            if (!syncException.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to pull selection: %1$s", syncException.getMessage()));
            }
        }
        catch (Exception exception) {
            DdmConsole.printErrorToConsole("Failed to pull selection");
            DdmConsole.printErrorToConsole(exception.getMessage());
        }
    }

    private void pullFile(final FileListingService.FileEntry fileEntry, final String string) {
        try {
            final SyncService syncService = this.mCurrentDevice.getSyncService();
            if (syncService != null) {
                SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                    public void run(SyncService.ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
                        syncService.pullFile(fileEntry, string, iSyncProgressMonitor);
                    }

                    public void close() {
                        syncService.close();
                    }
                }, String.format("Pulling %1$s from the device", fileEntry.getName()), this.mParent.getShell());
            }
        }
        catch (SyncException syncException) {
            if (!syncException.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to pull selection: %1$s", syncException.getMessage()));
            }
        }
        catch (Exception exception) {
            DdmConsole.printErrorToConsole("Failed to pull selection");
            DdmConsole.printErrorToConsole(exception.getMessage());
        }
    }

    private void pushFiles(final String[] stringArray, final FileListingService.FileEntry fileEntry) {
        try {
            final SyncService syncService = this.mCurrentDevice.getSyncService();
            if (syncService != null) {
                SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                    public void run(SyncService.ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
                        syncService.push(stringArray, fileEntry, iSyncProgressMonitor);
                    }

                    public void close() {
                        syncService.close();
                    }
                }, "Pushing file(s) to the device", this.mParent.getShell());
            }
        }
        catch (SyncException syncException) {
            if (!syncException.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to push selection: %1$s", syncException.getMessage()));
            }
        }
        catch (Exception exception) {
            DdmConsole.printErrorToConsole("Failed to push the items");
            DdmConsole.printErrorToConsole(exception.getMessage());
        }
    }

    private void pushFile(final String string, String string2) {
        try {
            final SyncService syncService = this.mCurrentDevice.getSyncService();
            if (syncService != null) {
                String[] stringArray = string.split(Pattern.quote(File.separator));
                String string3 = stringArray[stringArray.length - 1];
                final String string4 = string2 + "/" + string3;
                SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                    public void run(SyncService.ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
                        syncService.pushFile(string, string4, iSyncProgressMonitor);
                    }

                    public void close() {
                        syncService.close();
                    }
                }, String.format("Pushing %1$s to the device.", string3), this.mParent.getShell());
            }
        }
        catch (SyncException syncException) {
            if (!syncException.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to push selection: %1$s", syncException.getMessage()));
            }
        }
        catch (Exception exception) {
            DdmConsole.printErrorToConsole("Failed to push the item(s).");
            DdmConsole.printErrorToConsole(exception.getMessage());
        }
    }

    protected void setDeleteEnabledState(FileListingService.FileEntry fileEntry) {
        this.mDeleteAction.setEnabled(fileEntry.getType() == 0);
    }
}

