/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmuilib.heap.NativeHeapSnapshot;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeHeapDiffSnapshot
extends NativeHeapSnapshot {
    private long mCommonAllocationsTotalMemory;

    public NativeHeapDiffSnapshot(NativeHeapSnapshot nativeHeapSnapshot, NativeHeapSnapshot nativeHeapSnapshot2) {
        super(NativeHeapDiffSnapshot.getNewAllocations(nativeHeapSnapshot, nativeHeapSnapshot2));
        HashSet<NativeAllocationInfo> hashSet = new HashSet<NativeAllocationInfo>(nativeHeapSnapshot2.getAllocations());
        hashSet.retainAll(nativeHeapSnapshot.getAllocations());
        this.mCommonAllocationsTotalMemory = this.getTotalMemory(hashSet);
    }

    private static List<NativeAllocationInfo> getNewAllocations(NativeHeapSnapshot nativeHeapSnapshot, NativeHeapSnapshot nativeHeapSnapshot2) {
        HashSet<NativeAllocationInfo> hashSet = new HashSet<NativeAllocationInfo>(nativeHeapSnapshot.getAllocations());
        hashSet.removeAll(nativeHeapSnapshot2.getAllocations());
        return new ArrayList<NativeAllocationInfo>(hashSet);
    }

    @Override
    public String getFormattedMemorySize() {
        long l = this.getTotalSize();
        return String.format("%s bytes new + %s bytes retained = %s bytes total", this.formatMemorySize(l), this.formatMemorySize(this.mCommonAllocationsTotalMemory), this.formatMemorySize(l + this.mCommonAllocationsTotalMemory));
    }
}

