/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.heap.NativeLibraryAllocationInfo;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class NativeHeapLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private long mTotalSize;

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        if (object instanceof NativeAllocationInfo) {
            return this.getColumnTextForNativeAllocation((NativeAllocationInfo)object, n);
        }
        if (object instanceof NativeLibraryAllocationInfo) {
            return this.getColumnTextForNativeLibrary((NativeLibraryAllocationInfo)object, n);
        }
        return null;
    }

    private String getColumnTextForNativeAllocation(NativeAllocationInfo nativeAllocationInfo, int n) {
        NativeStackCallInfo nativeStackCallInfo = nativeAllocationInfo.getRelevantStackCallInfo();
        switch (n) {
            case 0: {
                return nativeStackCallInfo == null ? this.stackResolutionStatus(nativeAllocationInfo) : nativeStackCallInfo.getLibraryName();
            }
            case 1: {
                return Integer.toString(nativeAllocationInfo.getSize() * nativeAllocationInfo.getAllocationCount());
            }
            case 2: {
                return this.getPercentageString(nativeAllocationInfo.getSize() * nativeAllocationInfo.getAllocationCount(), this.mTotalSize);
            }
            case 3: {
                String string = "";
                if (!nativeAllocationInfo.isZygoteChild()) {
                    string = "Z ";
                }
                return string + Integer.toString(nativeAllocationInfo.getAllocationCount());
            }
            case 4: {
                return Integer.toString(nativeAllocationInfo.getSize());
            }
            case 5: {
                return nativeStackCallInfo == null ? this.stackResolutionStatus(nativeAllocationInfo) : nativeStackCallInfo.getMethodName();
            }
        }
        return null;
    }

    private String getColumnTextForNativeLibrary(NativeLibraryAllocationInfo nativeLibraryAllocationInfo, int n) {
        switch (n) {
            case 0: {
                return nativeLibraryAllocationInfo.getLibraryName();
            }
            case 1: {
                return Long.toString(nativeLibraryAllocationInfo.getTotalSize());
            }
            case 2: {
                return this.getPercentageString(nativeLibraryAllocationInfo.getTotalSize(), this.mTotalSize);
            }
        }
        return null;
    }

    private String getPercentageString(long l, long l2) {
        if (l2 == 0L) {
            return "";
        }
        return String.format("%.1f%%", Float.valueOf((float)(l * 100L) / (float)l2));
    }

    private String stackResolutionStatus(NativeAllocationInfo nativeAllocationInfo) {
        if (nativeAllocationInfo.isStackCallResolved()) {
            return "?";
        }
        return "Resolving...";
    }

    public void setTotalSize(long l) {
        this.mTotalSize = l;
    }
}

