/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmuilib.heap.NativeLibraryAllocationInfo;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeHeapSnapshot {
    private static final NumberFormat NUMBER_FORMATTER = NumberFormat.getInstance();
    private List<NativeAllocationInfo> mHeapAllocations;
    private List<NativeLibraryAllocationInfo> mHeapAllocationsByLibrary;
    private List<NativeAllocationInfo> mNonZygoteHeapAllocations;
    private List<NativeLibraryAllocationInfo> mNonZygoteHeapAllocationsByLibrary;
    private long mTotalSize;

    public NativeHeapSnapshot(List<NativeAllocationInfo> list) {
        this.mHeapAllocations = list;
        this.mTotalSize = this.getTotalMemory(list);
    }

    protected long getTotalMemory(Collection<NativeAllocationInfo> collection) {
        long l = 0L;
        for (NativeAllocationInfo nativeAllocationInfo : collection) {
            l += (long)(nativeAllocationInfo.getAllocationCount() * nativeAllocationInfo.getSize());
        }
        return l;
    }

    public List<NativeAllocationInfo> getAllocations() {
        return this.mHeapAllocations;
    }

    public List<NativeLibraryAllocationInfo> getAllocationsByLibrary() {
        if (this.mHeapAllocationsByLibrary != null) {
            return this.mHeapAllocationsByLibrary;
        }
        List<NativeLibraryAllocationInfo> list = NativeLibraryAllocationInfo.constructFrom(this.mHeapAllocations);
        if (this.isFullyResolved(list)) {
            this.mHeapAllocationsByLibrary = list;
        }
        return list;
    }

    private boolean isFullyResolved(List<NativeLibraryAllocationInfo> list) {
        for (NativeLibraryAllocationInfo nativeLibraryAllocationInfo : list) {
            if (!nativeLibraryAllocationInfo.getLibraryName().equals("Resolving..")) continue;
            return false;
        }
        return true;
    }

    public long getTotalSize() {
        return this.mTotalSize;
    }

    public String getFormattedMemorySize() {
        return String.format("%s bytes", this.formatMemorySize(this.getTotalSize()));
    }

    protected String formatMemorySize(long l) {
        return NUMBER_FORMATTER.format(l);
    }

    public List<NativeAllocationInfo> getNonZygoteAllocations() {
        if (this.mNonZygoteHeapAllocations != null) {
            return this.mNonZygoteHeapAllocations;
        }
        this.mNonZygoteHeapAllocations = new ArrayList<NativeAllocationInfo>();
        for (NativeAllocationInfo nativeAllocationInfo : this.mHeapAllocations) {
            if (!nativeAllocationInfo.isZygoteChild()) continue;
            this.mNonZygoteHeapAllocations.add(nativeAllocationInfo);
        }
        return this.mNonZygoteHeapAllocations;
    }

    public List<NativeLibraryAllocationInfo> getNonZygoteAllocationsByLibrary() {
        if (this.mNonZygoteHeapAllocationsByLibrary != null) {
            return this.mNonZygoteHeapAllocationsByLibrary;
        }
        List<NativeLibraryAllocationInfo> list = NativeLibraryAllocationInfo.constructFrom(this.getNonZygoteAllocations());
        if (this.isFullyResolved(list)) {
            this.mNonZygoteHeapAllocationsByLibrary = list;
        }
        return list;
    }
}

